      SUBROUTINE get_data (ng)
!
!svn $Id: get_data.F 964 2009-03-26 17:40:09Z kate $
!================================================== Hernan G. Arango ===
!  Copyright (c) 2002-2009 The ROMS/TOMS Group                         !
!    Licensed under a MIT/X style license                              !
!    See License_ROMS.txt                                              !
!=======================================================================
!                                                                      !
!  This routine reads in forcing, climatology and assimilation data    !
!  from input NetCDF files.  If there is more than one time-record,    !
!  data  is loaded  into global two-time record arrays.  The actual    !
!  interpolation is carried elsewhere.                                 !
!                                                                      !
!  Currently,  this routine is only executed in serial mode by the     !
!  main thread.                                                        !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_boundary
      USE mod_forces
      USE mod_grid
      USE mod_iounits
      USE mod_ncparam
      USE mod_parallel
      USE mod_scalars
      USE mod_sources
      USE mod_stepping
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng
!
!  Local variable declarations.
!
      logical, dimension(3) :: update =                                 &
     &         (/ .FALSE., .FALSE., .FALSE. /)
      integer :: ILB, IUB, JLB, JUB
      integer :: LBi, UBi, LBj, UBj
      integer :: i
!
!  Lower and upper bounds for nontiled boundary arrays.
!
      ILB=0
      IUB=Im(ng)+1
      JLB=0
      JUB=Jm(ng)+1
!
!  Lower and upper bounds for tiled arrays.
!
      LBi=LBOUND(GRID(ng)%h,DIM=1)
      UBi=UBOUND(GRID(ng)%h,DIM=1)
      LBj=LBOUND(GRID(ng)%h,DIM=2)
      UBj=UBOUND(GRID(ng)%h,DIM=2)
!
!-----------------------------------------------------------------------
!  Turn on input data time wall clock.
!-----------------------------------------------------------------------
!
      CALL wclock_on (ng, iNLM, 3)
!
!=======================================================================
!  Read in forcing data from FORCING NetCDF file.
!=======================================================================
!
!
!-----------------------------------------------------------------------
!  Surface wind components.
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idUair, ncFRCid(idUair,ng),             &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % UwindG(LBi,LBj,1))
      CALL get_2dfld (ng , iNLM, idVair, ncFRCid(idVair,ng),            &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % VwindG(LBi,LBj,1))
!
!-----------------------------------------------------------------------
!  Surface air pressure.
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idPair, ncFRCid(idPair,ng),             &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % PairG(LBi,LBj,1))
!
!-----------------------------------------------------------------------
!  Surface solar shortwave radiation.
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idSrad, ncFRCid(idSrad,ng),             &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % srflxG(LBi,LBj,1))
!
!-----------------------------------------------------------------------
!  Surface downwelling longwave radiation.
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idLdwn, ncFRCid(idLdwn,ng),             &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % lrflxG(LBi,LBj,1))
!
!-----------------------------------------------------------------------
!  Surface air temperature.
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idTair, ncFRCid(idTair,ng),             &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % TairG(LBi,LBj,1))
!
!-----------------------------------------------------------------------
!  Surface air humidity.
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idQair, ncFRCid(idQair,ng),             &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % HairG(LBi,LBj,1))
!
!-----------------------------------------------------------------------
!  Rain fall rate.
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idrain, ncFRCid(idrain,ng),             &
     &                nFfiles(ng), FRCname(1,ng), update(1),            &
     &                LBi, UBi, LBj, UBj, 2, 1,                         &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % rainG(LBi,LBj,1))
!
!-----------------------------------------------------------------------
!  Surface runoff rate
!-----------------------------------------------------------------------
!
      CALL get_2dfld (ng, iNLM, idRunoff, ncfrcid(idRunoff,ng),         &
     &                nFfiles(ng), frcname(1,ng),                       &
     &                update(1), LBi, UBi, LBj, UBj, 2, 1,              &
     &                GRID(ng) % rmask(LBi,LBj),                        &
     &                FORCES(ng) % runoffG(LBi,LBj,1))
!
!=======================================================================
!  Read in open boundary conditions from BOUNDARY NetCDF file.
!=======================================================================
!
      CALL get_ngfld (ng, iNLM, idZbry(iwest), ncBRYid(ng), 1,          &
     &                BRYname(ng), update(1),                           &
     &                JLB, JUB, 1, 2, 0, Mm(ng)+1, 1,                   &
     &                BOUNDARY(ng) % zetaG_west(JLB,1))
      CALL get_ngfld (ng, iNLM, idZbry(isouth), ncBRYid(ng), 1,         &
     &                BRYname(ng), update(1),                           &
     &                ILB, IUB, 1, 2, 0, Lm(ng)+1, 1,                   &
     &                BOUNDARY(ng) % zetaG_south(ILB,1))
      CALL get_ngfld (ng, iNLM, idU2bc(iwest), ncBRYid(ng), 1,          &
     &                BRYname(ng), update(1),                           &
     &                JLB, JUB, 1, 2, 0, Mm(ng)+1, 1,                   &
     &                BOUNDARY(ng) % ubarG_west(JLB,1))
      CALL get_ngfld (ng, iNLM, idV2bc(iwest), ncBRYid(ng), 1,          &
     &                BRYname(ng), update(1),                           &
     &                JLB, JUB, 1, 2, 1, Mm(ng)+1, 1,                   &
     &                BOUNDARY(ng) % vbarG_west(JLB,1))
      CALL get_ngfld (ng, iNLM, idU2bc(isouth), ncBRYid(ng), 1,         &
     &                BRYname(ng), update(1),                           &
     &                ILB, IUB, 1, 2, 1, Lm(ng)+1, 1,                   &
     &                BOUNDARY(ng) % ubarG_south(ILB,1))
      CALL get_ngfld (ng, iNLM, idV2bc(isouth), ncBRYid(ng), 1,         &
     &                BRYname(ng), update(1),                           &
     &                ILB, IUB, 1, 2, 0, Lm(ng)+1, 1,                   &
     &                BOUNDARY(ng) % vbarG_south(ILB,1))
      CALL get_ngfld (ng, iNLM, idU3bc(iwest), ncBRYid(ng), 1,          &
     &                BRYname(ng), update(1),                           &
     &                JLB, JUB, N(ng), 2, 0, Mm(ng)+1, N(ng),           &
     &                BOUNDARY(ng) % uG_west(JLB,1,1))
      CALL get_ngfld (ng, iNLM, idV3bc(iwest), ncBRYid(ng), 1,          &
     &                BRYname(ng), update(1),                           &
     &                JLB, JUB, N(ng), 2, 1, Mm(ng)+1, N(ng),           &
     &                BOUNDARY(ng) % vG_west(JLB,1,1))
      CALL get_ngfld (ng, iNLM, idU3bc(isouth), ncBRYid(ng), 1,         &
     &                BRYname(ng), update(1),                           &
     &                ILB, IUB, N(ng), 2, 1, Lm(ng)+1, N(ng),           &
     &                BOUNDARY(ng) % uG_south(ILB,1,1))
      CALL get_ngfld (ng, iNLM, idV3bc(isouth), ncBRYid(ng), 1,         &
     &                BRYname(ng), update(1),                           &
     &                ILB, IUB, N(ng), 2, 0, Lm(ng)+1, N(ng),           &
     &                BOUNDARY(ng) % vG_south(ILB,1,1))
      DO i=1,NT(ng)
        CALL get_ngfld (ng, iNLM, idTbry(iwest,i), ncBRYid(ng), 1,      &
     &                  BRYname(ng), update(1),                         &
     &                  JLB, JUB, N(ng), 2, 0, Mm(ng)+1, N(ng),         &
     &                  BOUNDARY(ng) % tG_west(JLB,1,1,i))
      END DO
      DO i=1,NT(ng)
        CALL get_ngfld (ng, iNLM, idTbry(isouth,i), ncBRYid(ng), 1,     &
     &                  BRYname(ng), update(1),                         &
     &                  ILB, IUB, N(ng), 2, 0, Lm(ng)+1, N(ng),         &
     &                  BOUNDARY(ng) % tG_south(ILB,1,1,i))
      END DO
!
!-----------------------------------------------------------------------
!  Turn off input data time wall clock.
!-----------------------------------------------------------------------
!
      CALL wclock_off (ng, iNLM, 3)
      RETURN
      END SUBROUTINE get_data
