      MODULE ice_enthalpi_mod
      implicit none
      PRIVATE
      PUBLIC ice_enthalpi
       CONTAINS
       SUBROUTINE ice_enthalpi (ng, tile)
!
!*************************************************** W. Paul Budgell ***
!  Copyright (c) 2002 ROMS/TOMS Group                                  !
!************************************************** Hernan G. Arango ***
!                                                                      !
!  This subroutine computes the ice enthalpi (ti*hi) prior to          !
!  advection.                                                          !
!***********************************************************************
!
      USE mod_param
      USE mod_ice
      implicit none
      integer, intent(in) :: ng, tile
      integer :: IminS, ImaxS, JminS, JmaxS
      integer :: LBi, UBi, LBj, UBj, LBij, UBij
!
!  Set horizontal starting and ending indices for automatic private storage
!  arrays.
!
      IminS=BOUNDS(ng)%Istr(tile)-3
      ImaxS=BOUNDS(ng)%Iend(tile)+3
      JminS=BOUNDS(ng)%Jstr(tile)-3
      JmaxS=BOUNDS(ng)%Jend(tile)+3
!
!  Determine array lower and upper bounds in the I- and J-directions.
!
      LBi=BOUNDS(ng)%LBi(tile)
      UBi=BOUNDS(ng)%UBi(tile)
      LBj=BOUNDS(ng)%LBj(tile)
      UBj=BOUNDS(ng)%UBj(tile)
!
!  Set array lower and upper bounds for MIN(I,J)- and MAX(I,J)-directions.
!
      LBij=BOUNDS(ng)%LBij
      UBij=BOUNDS(ng)%UBij
! ---------------------------------------------------------------------
!  Do our tile.
! ---------------------------------------------------------------------
      CALL ice_enthalpi_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        IminS, ImaxS, JminS, JmaxS,               &
     &                        ICE(ng)%hi,                               &
     &                        ICE(ng)%ti,                               &
     &                        ICE(ng)%enthalpi)
      RETURN
      END SUBROUTINE ice_enthalpi
      SUBROUTINE ice_enthalpi_tile (ng, tile,                           &
     &                         LBi, UBi, LBj, UBj,                      &
     &                         IminS, ImaxS, JminS, JmaxS,              &
     &                         hi, ti, enthalpi)
      USE mod_scalars
      USE mod_stepping
      USE mp_exchange_mod, ONLY : mp_exchange2d
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: IminS, ImaxS, JminS, JmaxS
      real(r8), intent(in) :: hi(LBi:,LBj:,:)
      real(r8), intent(in) :: ti(LBi:,LBj:,:)
      real(r8), intent(inout) :: enthalpi(LBi:,LBj:,:)
!
!  Local variables
!
      logical :: EWperiodic=.FALSE.
      logical :: NSperiodic=.FALSE.
      integer :: i, j
!
!-----------------------------------------------------------------------
!  Set lower and upper tile bounds and staggered variables bounds for
!  this horizontal domain partition.  Notice that if tile=-1, it will
!  set the values for the global grid.
!-----------------------------------------------------------------------
!
      integer :: Istr, IstrR, IstrT, IstrU, Iend, IendR, IendT
      integer :: Jstr, JstrR, JstrT, JstrV, Jend, JendR, JendT
!
      Istr =BOUNDS(ng)%Istr (tile)
      IstrR=BOUNDS(ng)%IstrR(tile)
      IstrT=BOUNDS(ng)%IstrT(tile)
      IstrU=BOUNDS(ng)%IstrU(tile)
      Iend =BOUNDS(ng)%Iend (tile)
      IendR=BOUNDS(ng)%IendR(tile)
      IendT=BOUNDS(ng)%IendT(tile)
      Jstr =BOUNDS(ng)%Jstr (tile)
      JstrR=BOUNDS(ng)%JstrR(tile)
      JstrT=BOUNDS(ng)%JstrT(tile)
      JstrV=BOUNDS(ng)%JstrV(tile)
      Jend =BOUNDS(ng)%Jend (tile)
      JendR=BOUNDS(ng)%JendR(tile)
      JendT=BOUNDS(ng)%JendT(tile)
      DO j=JstrR,JendR
        DO i=IstrR,IendR
          enthalpi(i,j,liold(ng)) = hi(i,j,liold(ng))*                  &
     &                                      ti(i,j,liold(ng))
          enthalpi(i,j,linew(ng)) = hi(i,j,linew(ng))*                  &
     &                                      ti(i,j,linew(ng))
          IF(hi(i,j,liold(ng)).LE.min_h(ng)) THEN
            enthalpi(i,j,liold(ng)) = 0.0_r8
          END IF
        ENDDO
      ENDDO
      CALL mp_exchange2d (ng, tile, iNLM, 2,                            &
     &                      LBi, UBi, LBj, UBj,                         &
     &                      NghostPoints, EWperiodic, NSperiodic,       &
     &                      enthalpi(:,:,liold(ng)),                    &
     &                      enthalpi(:,:,linew(ng)))
      RETURN
      END SUBROUTINE ice_enthalpi_tile
      END MODULE ice_enthalpi_mod
