      MODULE mod_boundary
!
!svn $Id: mod_boundary.F 933 2009-02-24 19:25:01Z kate $
!================================================== Hernan G. Arango ===
!  Copyright (c) 2002-2009 The ROMS/TOMS Group                         !
!    Licensed under a MIT/X style license                              !
!    See License_ROMS.txt                                              !
!=======================================================================
!                                                                      !
!  Open boundary conditions arrays:                                    !
!                                                                      !
!  zeta_west      Free-surface (m) western boundary conditions.        !
!  zetaG_west     Latest two-time snapshots of input free-surface (m)  !
!                   western boundary data.                             !
!  zeta_south     Free-surface (m) southern boundary conditions.       !
!  zetaG_south    Latest two-time snapshots of input free-surface (m)  !
!                   southern boundary data.                            !
!  ubar_west      2D u-momentum (m/s) western boundary conditions.     !
!  vbar_west      2D v-momentum (m/s) western boundary conditions.     !
!  ubarG_west     Latest two-time snapshots of input 2D u-momentum     !
!                   (m/s) western boundary data.                       !
!  vbarG_west     Latest two-time snapshots of input 2D v-momentum     !
!                   (m/s) western boundary data.                       !
!  ubar_south     2D u-momentum (m/s) southern boundary conditions.    !
!  vbar_south     2D v-momentum (m/s) southern boundary conditions.    !
!  ubarG_south    Latest two-time snapshots of input 2D u-momentum     !
!                   (m/s) southern boundary data.                      !
!  vbarG_south    Latest two-time snapshots of input 2D v-momentum     !
!                   (m/s) southern boundary data.                      !
!  u_west         3D u-momentum (m/s) western boundary conditions.     !
!  v_west         3D v-momentum (m/s) western boundary conditions.     !
!  uG_west        Latest two-time snapshots of input 3D u-momentum     !
!                   (m/s) western boundary data.                       !
!  vG_west        Latest two-time snapshots of input 3D v-momentum     !
!                   (m/s) western boundary data.                       !
!  u_south        3D u-momentum (m/s) southern boundary conditions.    !
!  v_south        3D v-momentum (m/s) southern boundary conditions.    !
!  uG_south       Latest two-time snapshots of input 3D u-momentum     !
!                   (m/s) southern boundary data.                      !
!  vG_south       Latest two-time snapshots of input 3D v-momentum     !
!                   (m/s) southern boundary data.                      !
!  t_west         Tracer (T units) western boundary conditions.        !
!  tG_west        Latest two-time snapshots of input tracer (Tunits)   !
!                   western boundary data.                             !
!  t_south        Tracer (T units) southern boundary conditions.       !
!  tG_south       Latest two-time snapshots of input tracer (Tunits)   !
!                   southern boundary data.                            !
!                                                                      !
!=======================================================================
!
        USE mod_kinds
        implicit none
        TYPE T_BOUNDARY
!
!  Nonlinear model state.
!
          real(r8), pointer :: zeta_west(:)
          real(r8), pointer :: zetaG_west(:,:)
          real(r8), pointer :: zeta_south(:)
          real(r8), pointer :: zetaG_south(:,:)
          real(r8), pointer :: ubar_west(:)
          real(r8), pointer :: vbar_west(:)
          real(r8), pointer :: ubarG_west(:,:)
          real(r8), pointer :: vbarG_west(:,:)
          real(r8), pointer :: ubar_south(:)
          real(r8), pointer :: vbar_south(:)
          real(r8), pointer :: ubarG_south(:,:)
          real(r8), pointer :: vbarG_south(:,:)
          real(r8), pointer :: u_west(:,:)
          real(r8), pointer :: v_west(:,:)
          real(r8), pointer :: uG_west(:,:,:)
          real(r8), pointer :: vG_west(:,:,:)
          real(r8), pointer :: u_south(:,:)
          real(r8), pointer :: v_south(:,:)
          real(r8), pointer :: uG_south(:,:,:)
          real(r8), pointer :: vG_south(:,:,:)
          real(r8), pointer :: t_west(:,:,:)
          real(r8), pointer :: tG_west(:,:,:,:)
          real(r8), pointer :: t_south(:,:,:)
          real(r8), pointer :: tG_south(:,:,:,:)
          real(r8), pointer :: ai_west(:)
          real(r8), pointer :: ai_east(:)
          real(r8), pointer :: ai_south(:)
          real(r8), pointer :: ai_north(:)
          real(r8), pointer :: hi_west(:)
          real(r8), pointer :: hi_east(:)
          real(r8), pointer :: hi_south(:)
          real(r8), pointer :: hi_north(:)
          real(r8), pointer :: hsn_west(:)
          real(r8), pointer :: hsn_east(:)
          real(r8), pointer :: hsn_south(:)
          real(r8), pointer :: hsn_north(:)
          real(r8), pointer :: ti_west(:)
          real(r8), pointer :: ti_east(:)
          real(r8), pointer :: ti_south(:)
          real(r8), pointer :: ti_north(:)
          real(r8), pointer :: tiG_west(:,:)
          real(r8), pointer :: tiG_east(:,:)
          real(r8), pointer :: tiG_south(:,:)
          real(r8), pointer :: tiG_north(:,:)
          real(r8), pointer :: sfwat_west(:)
          real(r8), pointer :: sfwat_east(:)
          real(r8), pointer :: sfwat_south(:)
          real(r8), pointer :: sfwat_north(:)
          real(r8), pointer :: sfwatG_west(:,:)
          real(r8), pointer :: sfwatG_east(:,:)
          real(r8), pointer :: sfwatG_south(:,:)
          real(r8), pointer :: sfwatG_north(:,:)
          real(r8), pointer :: ageice_west(:)
          real(r8), pointer :: ageice_east(:)
          real(r8), pointer :: ageice_south(:)
          real(r8), pointer :: ageice_north(:)
          real(r8), pointer :: ageiceG_west(:,:)
          real(r8), pointer :: ageiceG_east(:,:)
          real(r8), pointer :: ageiceG_south(:,:)
          real(r8), pointer :: ageiceG_north(:,:)
          real(r8), pointer :: sig11_west(:)
          real(r8), pointer :: sig11_east(:)
          real(r8), pointer :: sig11_south(:)
          real(r8), pointer :: sig11_north(:)
          real(r8), pointer :: sig11G_west(:,:)
          real(r8), pointer :: sig11G_east(:,:)
          real(r8), pointer :: sig11G_south(:,:)
          real(r8), pointer :: sig11G_north(:,:)
          real(r8), pointer :: sig22_west(:)
          real(r8), pointer :: sig22_east(:)
          real(r8), pointer :: sig22_south(:)
          real(r8), pointer :: sig22_north(:)
          real(r8), pointer :: sig22G_west(:,:)
          real(r8), pointer :: sig22G_east(:,:)
          real(r8), pointer :: sig22G_south(:,:)
          real(r8), pointer :: sig22G_north(:,:)
          real(r8), pointer :: sig12_west(:)
          real(r8), pointer :: sig12_east(:)
          real(r8), pointer :: sig12_south(:)
          real(r8), pointer :: sig12_north(:)
          real(r8), pointer :: sig12G_west(:,:)
          real(r8), pointer :: sig12G_east(:,:)
          real(r8), pointer :: sig12G_south(:,:)
          real(r8), pointer :: sig12G_north(:,:)
          real(r8), pointer :: ui_west(:)
          real(r8), pointer :: ui_east(:)
          real(r8), pointer :: ui_south(:)
          real(r8), pointer :: ui_north(:)
          real(r8), pointer :: uiG_west(:,:)
          real(r8), pointer :: uiG_east(:,:)
          real(r8), pointer :: uiG_south(:,:)
          real(r8), pointer :: uiG_north(:,:)
          real(r8), pointer :: vi_west(:)
          real(r8), pointer :: vi_east(:)
          real(r8), pointer :: vi_south(:)
          real(r8), pointer :: vi_north(:)
          real(r8), pointer :: viG_west(:,:)
          real(r8), pointer :: viG_east(:,:)
          real(r8), pointer :: viG_south(:,:)
          real(r8), pointer :: viG_north(:,:)
        END TYPE T_BOUNDARY
        TYPE (T_BOUNDARY), allocatable ::BOUNDARY(:)
      CONTAINS
      SUBROUTINE allocate_boundary (ng)
!
!=======================================================================
!                                                                      !
!  This routine initializes all variables in the module for all nested !
!  grids.  Currently, there is not parallel tiling in boundary arrays. !
!                                                                      !
!=======================================================================
!
      USE mod_param
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng
!
!-----------------------------------------------------------------------
!  Initialize module variables.
!-----------------------------------------------------------------------
!
      IF (ng.eq.1) allocate ( BOUNDARY(Ngrids) )
!
!  Nonlinear model state.
!
      allocate ( BOUNDARY(ng) % zeta_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % zetaG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % zeta_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % zetaG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % ubar_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % vbar_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ubarG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % vbarG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % ubar_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % vbar_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % ubarG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % vbarG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % u_west(0:Jm(ng)+1,N(ng)) )
      allocate ( BOUNDARY(ng) % v_west(0:Jm(ng)+1,N(ng)) )
      allocate ( BOUNDARY(ng) % uG_west(0:Jm(ng)+1,N(ng),2) )
      allocate ( BOUNDARY(ng) % vG_west(0:Jm(ng)+1,N(ng),2) )
      allocate ( BOUNDARY(ng) % u_south(0:Im(ng)+1,N(ng)) )
      allocate ( BOUNDARY(ng) % v_south(0:Im(ng)+1,N(ng)) )
      allocate ( BOUNDARY(ng) % uG_south(0:Im(ng)+1,N(ng),2) )
      allocate ( BOUNDARY(ng) % vG_south(0:Im(ng)+1,N(ng),2) )
      allocate ( BOUNDARY(ng) % t_west(0:Jm(ng)+1,N(ng),NT(ng)) )
      allocate ( BOUNDARY(ng) % tG_west(0:Jm(ng)+1,N(ng),2,NT(ng)) )
      allocate ( BOUNDARY(ng) % t_south(0:Im(ng)+1,N(ng),NT(ng)) )
      allocate ( BOUNDARY(ng) % tG_south(0:Im(ng)+1,N(ng),2,NT(ng)) )
      allocate ( BOUNDARY(ng) % ai_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ai_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ai_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % ai_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % hi_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % hi_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % hi_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % hi_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % hsn_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % hsn_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % hsn_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % hsn_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % ti_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ti_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ti_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % ti_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % tiG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % tiG_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % tiG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % tiG_north(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sfwat_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sfwat_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sfwat_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sfwat_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sfwatG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sfwatG_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sfwatG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sfwatG_north(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % ageice_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ageice_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ageice_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % ageice_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % ageiceG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % ageiceG_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % ageiceG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % ageiceG_north(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig11_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sig11_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sig11_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sig11_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sig11G_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig11G_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig11G_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig11G_north(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig22_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sig22_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sig22_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sig22_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sig22G_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig22G_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig22G_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig22G_north(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig12_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sig12_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % sig12_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sig12_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % sig12G_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig12G_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig12G_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % sig12G_north(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % ui_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ui_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % ui_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % ui_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % uiG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % uiG_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % uiG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % uiG_north(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % vi_west(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % vi_east(0:Jm(ng)+1) )
      allocate ( BOUNDARY(ng) % vi_south(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % vi_north(0:Im(ng)+1) )
      allocate ( BOUNDARY(ng) % viG_west(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % viG_east(0:Jm(ng)+1,2) )
      allocate ( BOUNDARY(ng) % viG_south(0:Im(ng)+1,2) )
      allocate ( BOUNDARY(ng) % viG_north(0:Im(ng)+1,2) )
      RETURN
      END SUBROUTINE allocate_boundary
      SUBROUTINE initialize_boundary (ng, tile, model)
!
!=======================================================================
!                                                                      !
!  This routine initialize all variables in the module using first     !
!  touch distribution policy. In shared-memory configuration, this     !
!  operation actually performs propagation of the  "shared arrays"     !
!  across the cluster, unless another policy is specified to           !
!  override the default.                                               !
!                                                                      !
!=======================================================================
!
      USE mod_param
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile, model
!
!  Local variable declarations.
!
      real(r8), parameter :: IniVal = 0.0_r8
!
!-----------------------------------------------------------------------
!  Initialize module variables.
!-----------------------------------------------------------------------
!
!  Nonlinear model state.
!
      IF ((model.eq.0).or.(model.eq.iNLM)) THEN
        IF (.true.) THEN
          BOUNDARY(ng) % zeta_west = IniVal
          BOUNDARY(ng) % zetaG_west = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % zeta_south = IniVal
          BOUNDARY(ng) % zetaG_south = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % ubar_west = IniVal
          BOUNDARY(ng) % vbar_west = IniVal
          BOUNDARY(ng) % ubarG_west = IniVal
          BOUNDARY(ng) % vbarG_west = IniVal
        END IF
!
!  Eastern boundary variables.
!
        IF (.true.) THEN
          BOUNDARY(ng) % ubar_south = IniVal
          BOUNDARY(ng) % vbar_south = IniVal
          BOUNDARY(ng) % ubarG_south = IniVal
          BOUNDARY(ng) % vbarG_south = IniVal
        END IF
!
        IF (.true.) THEN
          BOUNDARY(ng) % u_west = IniVal
          BOUNDARY(ng) % v_west = IniVal
          BOUNDARY(ng) % uG_west = IniVal
          BOUNDARY(ng) % vG_west = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % u_south = IniVal
          BOUNDARY(ng) % v_south = IniVal
          BOUNDARY(ng) % uG_south = IniVal
          BOUNDARY(ng) % vG_south = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % t_west = IniVal
          BOUNDARY(ng) % tG_west = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % t_south = IniVal
          BOUNDARY(ng) % tG_south = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % ai_west = IniVal
          BOUNDARY(ng) % hi_west = IniVal
          BOUNDARY(ng) % hsn_west = IniVal
          BOUNDARY(ng) % ti_west = IniVal
          BOUNDARY(ng) % tiG_west = IniVal
          BOUNDARY(ng) % sfwat_west = IniVal
          BOUNDARY(ng) % sfwatG_west = IniVal
          BOUNDARY(ng) % ageice_west = IniVal
          BOUNDARY(ng) % ageiceG_west = IniVal
          BOUNDARY(ng) % sig11_west = IniVal
          BOUNDARY(ng) % sig11G_west = IniVal
          BOUNDARY(ng) % sig22_west = IniVal
          BOUNDARY(ng) % sig22G_west = IniVal
          BOUNDARY(ng) % sig12_west = IniVal
          BOUNDARY(ng) % sig12G_west = IniVal
          BOUNDARY(ng) % ui_west = IniVal
          BOUNDARY(ng) % uiG_west = IniVal
          BOUNDARY(ng) % vi_west = IniVal
          BOUNDARY(ng) % viG_west = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % ai_east = IniVal
          BOUNDARY(ng) % hi_east = IniVal
          BOUNDARY(ng) % hsn_east = IniVal
          BOUNDARY(ng) % ti_east = IniVal
          BOUNDARY(ng) % tiG_east = IniVal
          BOUNDARY(ng) % sfwat_east = IniVal
          BOUNDARY(ng) % sfwatG_east = IniVal
          BOUNDARY(ng) % ageice_east = IniVal
          BOUNDARY(ng) % ageiceG_east = IniVal
          BOUNDARY(ng) % sig11_east = IniVal
          BOUNDARY(ng) % sig11G_east = IniVal
          BOUNDARY(ng) % sig22_east = IniVal
          BOUNDARY(ng) % sig22G_east = IniVal
          BOUNDARY(ng) % sig12_east = IniVal
          BOUNDARY(ng) % sig12G_east = IniVal
          BOUNDARY(ng) % ui_east = IniVal
          BOUNDARY(ng) % uiG_east = IniVal
          BOUNDARY(ng) % vi_east = IniVal
          BOUNDARY(ng) % viG_east = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % ai_south = IniVal
          BOUNDARY(ng) % hi_south = IniVal
          BOUNDARY(ng) % hsn_south = IniVal
          BOUNDARY(ng) % ti_south = IniVal
          BOUNDARY(ng) % tiG_south = IniVal
          BOUNDARY(ng) % sfwat_south = IniVal
          BOUNDARY(ng) % sfwatG_south = IniVal
          BOUNDARY(ng) % ageice_south = IniVal
          BOUNDARY(ng) % ageiceG_south = IniVal
          BOUNDARY(ng) % sig11_south = IniVal
          BOUNDARY(ng) % sig11G_south = IniVal
          BOUNDARY(ng) % sig22_south = IniVal
          BOUNDARY(ng) % sig22G_south = IniVal
          BOUNDARY(ng) % sig12_south = IniVal
          BOUNDARY(ng) % sig12G_south = IniVal
          BOUNDARY(ng) % ui_south = IniVal
          BOUNDARY(ng) % uiG_south = IniVal
          BOUNDARY(ng) % vi_south = IniVal
          BOUNDARY(ng) % viG_south = IniVal
        END IF
        IF (.true.) THEN
          BOUNDARY(ng) % ai_north = IniVal
          BOUNDARY(ng) % hi_north = IniVal
          BOUNDARY(ng) % hsn_north = IniVal
          BOUNDARY(ng) % ti_north = IniVal
          BOUNDARY(ng) % tiG_north = IniVal
          BOUNDARY(ng) % sfwat_north = IniVal
          BOUNDARY(ng) % sfwatG_north = IniVal
          BOUNDARY(ng) % ageice_north = IniVal
          BOUNDARY(ng) % ageiceG_north = IniVal
          BOUNDARY(ng) % sig11_north = IniVal
          BOUNDARY(ng) % sig11G_north = IniVal
          BOUNDARY(ng) % sig22_north = IniVal
          BOUNDARY(ng) % sig22G_north = IniVal
          BOUNDARY(ng) % sig12_north = IniVal
          BOUNDARY(ng) % sig12G_north = IniVal
          BOUNDARY(ng) % ui_north = IniVal
          BOUNDARY(ng) % uiG_north = IniVal
          BOUNDARY(ng) % vi_north = IniVal
          BOUNDARY(ng) % viG_north = IniVal
        END IF
      END IF
      RETURN
      END SUBROUTINE initialize_boundary
      END MODULE mod_boundary
