#include "cppdefs.h"
      MODULE ice_elastic_mod
#if defined ICE_MOMENTUM && defined ICE_EVP
!
!=======================================================================
!  Copyright (c) 2002 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine timesteps the ice momentum equations.
!                                                                      !
!=======================================================================
!
      implicit none

      PRIVATE
      PUBLIC ice_elastic

      CONTAINS

      SUBROUTINE ice_elastic (ng, tile)

      USE mod_param
      USE mod_grid
      USE mod_ice
      USE mod_stepping

      integer, intent(in) :: ng, tile
!
# include "tile.h"
!
# ifdef PROFILE
      CALL wclock_on (ng, iNLM, 48)
# endif
!
      CALL ice_elastic_tile (ng, tile,                                  &
     &                      LBi, UBi, LBj, UBj,                         &
     &                      IminS, ImaxS, JminS, JmaxS,                 &
     &                      liold(ng), liuol(ng), liunw(ng),            &
     &                      lieol(ng), lienw(ng),                       &
# ifdef MASKING
     &                      GRID(ng) % rmask,                           &
     &                      GRID(ng) % umask,                           &
     &                      GRID(ng) % vmask,                           &
# endif
# ifdef ICESHELF
     &                      GRID(ng) % zice,                            &
# endif
     &                      GRID(ng) % pm,                              &
     &                      GRID(ng) % pn,                              &
     &                      GRID(ng) % om_u,                            &
     &                      GRID(ng) % on_u,                            &
     &                      GRID(ng) % om_v,                            &
     &                      GRID(ng) % on_v,                            &
     &                      GRID(ng) % f,                               &
# ifdef ICE_SHOREFAST
     &                      GRID(ng) % h,                               &
# endif
     &                      ICE(ng) % ui,                               &
     &                      ICE(ng) % vi,                               &
     &                      ICE(ng) % uwater,                           &
     &                      ICE(ng) % vwater,                           &
     &                      ICE(ng) % sealev,                           &
     &                      ICE(ng) % uie,                              &
     &                      ICE(ng) % vie,                              &
     &                      ICE(ng) % ai,                               &
     &                      ICE(ng) % hi,                               &
     &                      ICE(ng) % pice,                             &
     &                      ICE(ng) % zetai,                            &
     &                      ICE(ng) % eta,                              &
     &                      ICE(ng) % sig11,                            &
     &                      ICE(ng) % sig22,                            &
     &                      ICE(ng) % sig12,                            &
     &                      ICE(ng) % tauaiu,                           &
     &                      ICE(ng) % tauaiv,                           &
     &                      ICE(ng) % chu_iw                            &
     &                      )
# ifdef PROFILE
      CALL wclock_off (ng, iNLM, 48)
# endif
      RETURN
      END SUBROUTINE ice_elastic
!
!***********************************************************************
      SUBROUTINE ice_elastic_tile (ng, tile,                            &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        IminS, ImaxS, JminS, JmaxS,               &
     &                        liold, liuol, liunw, lieol, lienw,        &
# ifdef MASKING
     &                        rmask, umask, vmask,                      &
# endif
# ifdef ICESHELF
     &                        zice,                                     &
# endif
     &                        pm, pn, om_u, on_u, om_v, on_v,           &
     &                        f,                                        &
# ifdef ICE_SHOREFAST
     &                        h,                                        &
# endif
     &                        ui, vi, uwater, vwater, sealev,           &
     &                        uie, vie,                                 &
     &                        ai, hi, pice, zetai, eta,                 &
     &                        sig11, sig22, sig12,                      &
     &                        tauaiu, tauaiv,                           &
     &                        chu_iw) 
!***********************************************************************
!

      USE mod_param
      USE mod_scalars
!
      USE uibc_mod, ONLY : uibc_tile
      USE vibc_mod, ONLY : vibc_tile
!
#if defined EW_PERIODIC || defined NS_PERIODIC
      USE exchange_2d_mod
#endif
#ifdef DISTRIBUTE
      USE mp_exchange_mod, ONLY : mp_exchange2d
#endif
!
      implicit none

!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile                    
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: IminS, ImaxS, JminS, JmaxS
      integer, intent(in) :: liold, liuol, liunw, lieol, lienw
# ifdef ASSUMED_SHAPE
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:,LBj:)
      real(r8), intent(in) :: umask(LBi:,LBj:)
      real(r8), intent(in) :: vmask(LBi:,LBj:)
#  endif
#  ifdef ICESHELF
      real(r8), intent(in) :: zice(LBi:,LBj:)
#  endif
      real(r8), intent(in) :: pm(LBi:,LBj:)
      real(r8), intent(in) :: pn(LBi:,LBj:)
      real(r8), intent(in) :: om_u(LBi:,LBj:)
      real(r8), intent(in) :: on_u(LBi:,LBj:)
      real(r8), intent(in) :: om_v(LBi:,LBj:)
      real(r8), intent(in) :: on_v(LBi:,LBj:)
      real(r8), intent(in) :: f(LBi:,LBj:)
# ifdef ICE_SHOREFAST
      real(r8), intent(in) :: h(LBi:,LBj:)
# endif
      real(r8), intent(out) :: ui(LBi:,LBj:,:)
      real(r8), intent(out) :: vi(LBi:,LBj:,:)
      real(r8), intent(in) :: uwater(LBi:,LBj:)
      real(r8), intent(in) :: vwater(LBi:,LBj:)
      real(r8), intent(in) :: sealev(LBi:,LBj:)
      real(r8), intent(inout) :: uie(LBi:,LBj:,:)
      real(r8), intent(inout) :: vie(LBi:,LBj:,:)
      real(r8), intent(in) :: ai(LBi:,LBj:,:)
      real(r8), intent(in) :: hi(LBi:,LBj:,:)
      real(r8), intent(in) :: pice(LBi:,LBj:)
      real(r8), intent(in) :: zetai(LBi:,LBj:)
      real(r8), intent(in) :: eta(LBi:,LBj:)
      real(r8), intent(in) :: sig11(LBi:,LBj:,:)
      real(r8), intent(in) :: sig22(LBi:,LBj:,:)
      real(r8), intent(in) :: sig12(LBi:,LBj:,:)
      real(r8), intent(in) :: tauaiu(LBi:,LBj:)
      real(r8), intent(in) :: tauaiv(LBi:,LBj:)
      real(r8), intent(in) :: chu_iw(LBi:,LBj:)
# else
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: umask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: vmask(LBi:UBi,LBj:UBj)
#  endif
#  ifdef ICESHELF
      real(r8), intent(in) :: zice(LBi:UBi,LBj:UBj)
#  endif
      real(r8), intent(in) :: pm(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: pn(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: om_u(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: on_u(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: om_v(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: on_v(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: f(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: ui(LBi:UBi,LBj:UBj,2)
      real(r8), intent(inout) :: vi(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in) :: uwater(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: vwater(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: sealev(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: uie(LBi:UBi,LBj:UBj,2)
      real(r8), intent(inout) :: vie(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in) :: ai(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in) :: hi(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in) :: pice(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: zetai(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: eta(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: sig11(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in) :: sig22(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in) :: sig12(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in) :: tauaiu(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: tauaiv(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: chu_iw(LBi:UBi,LBj:UBj)
#  endif

! Local variable definitions
!
# ifdef DISTRIBUTE
#  ifdef EW_PERIODIC
      logical :: EWperiodic=.TRUE.
#  else
      logical :: EWperiodic=.FALSE.
#  endif
#  ifdef NS_PERIODIC
      logical :: NSperiodic=.TRUE.
#  else
      logical :: NSperiodic=.FALSE.
#  endif
# endif
      integer :: i, j
      integer :: i1, j1, iterin

      real(r8), dimension(IminS:ImaxS,JminS:JmaxS) :: eps11
      real(r8), dimension(IminS:ImaxS,JminS:JmaxS) :: eps22
      real(r8), dimension(IminS:ImaxS,JminS:JmaxS) :: eps12

      real(r8) :: f1
      real(r8) :: f2
      real(r8) :: s1
      real(r8) :: s2
      real(r8) :: ua
      real(r8) :: va
      real(r8) :: fakt
      real(r8) :: uforce
      real(r8) :: vforce
      real(r8) :: alfa
      real(r8) :: beta
      real(r8) :: flx
      real(r8) :: dimax 
      real(r8) :: masu
      real(r8) :: masv 
      real(r8) :: chux
      real(r8) :: chuy
      real(r8) :: auf
      real(r8) :: avf
      real(r8) :: dsum
      real(r8) :: pmu
      real(r8) :: pnu
      real(r8) :: pmv
      real(r8) :: pnv
      real(r8) :: cosstang
      real(r8) :: sinstang
      real(r8) :: mfu11
      real(r8) :: mfu21
      real(r8) :: mfu12
      real(r8) :: mfu22
      real(r8) :: mfv11
      real(r8) :: mfv21
      real(r8) :: mfv12
      real(r8) :: mfv22
# ifdef ICE_SHOREFAST
      real(r8) :: hu
      real(r8) :: hv
# endif

# include "set_bounds.h"

!----------------
!
      cosstang = COS(deg2rad*stressang(ng))
      sinstang = SIN(deg2rad*stressang(ng))
! 
! Initialize fast-step velocities if beginning of cycle
!
! *** momentum equation 
!
! u-eqn
!
      DO j=Jstr,Jend
        DO i=IstrU,Iend
          uforce = 0._r8
          chux = 0.5_r8*(chu_iw(i-1,j)+chu_iw(i,j))
          masu = 0.5_r8*(hi(i,j,liold)+hi(i-1,j,liold))
          masu = max(masu,0.01_r8)
          masu = masu*rhoice(ng)
          auf = max(0.5_r8*(ai(i-1,j,liold)+ai(i,j,liold)),0.1_r8)
          pmu = 0.5_r8*(pm(i,j) + pm(i-1,j)) 
          pnu = 0.5_r8*(pn(i,j) + pn(i-1,j)) 
!
! *** forces from ice rheology x-direction 
          s1 = (sig11(i,j,lienw)-sig11(i-1,j,lienw))*pmu 
#ifdef MASKING
          IF (umask(i,j).gt.0.0_r8.and.umask(i,j+1).lt.1.0_r8) THEN
            f1 = 0.5_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw))
# ifdef ICESHELF
          ELSE IF (zice(i-1,j).eq.0.0_r8.and.zice(i,j).eq.0.0_r8.and.   &
     &             zice(i-1,j+1)+zice(i,j+1).ne.0.0_r8) THEN
            f1 = 0.5_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw))
# endif
          ELSE
            f1 = 0.25_r8*(sig12(i,j,lienw)+sig12(i,j+1,lienw)           &
     &           + sig12(i-1,j+1,lienw)+sig12(i-1,j,lienw))
          END IF
#else
# ifdef ICESHELF
          IF (zice(i-1,j).eq.0.0_r8.and.zice(i,j).eq.0.0_r8.and.        &
     &             zice(i-1,j+1)+zice(i,j+1).ne.0.0_r8) THEN
            f1 = 0.5_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw))
# endif
          f1 = 0.25_r8*(sig12(i,j,lienw)+sig12(i,j+1,lienw)             &
     &           + sig12(i-1,j+1,lienw)+sig12(i-1,j,lienw))
#endif
#ifdef MASKING
          IF (umask(i,j).gt.0.0_r8.and.umask(i,j-1).lt.1.0_r8) THEN
             f2 = 0.5_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw))
# ifdef ICESHELF
          ELSE IF (zice(i-1,j).eq.0.0_r8.and.zice(i,j).eq.0.0_r8.and.   &
     &             zice(i-1,j-1)+zice(i,j-1).ne.0.0_r8) then
             f2 = 0.5_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw))
# endif
          ELSE
             f2 = 0.25_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw)          &
     &           + sig12(i-1,j-1,lienw)+sig12(i,j-1,lienw))
          END IF
#else
          f2 = 0.25_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw)             &
     &           + sig12(i-1,j-1,lienw)+sig12(i,j-1,lienw))
#endif
!
           s2 = (f1-f2)*pnu
           uforce = (s1 + s2)*om_u(i,j)*on_u(i,j)
#undef ACTIVE
#ifdef ACTIVE
!ACTIVE
#endif
! *** wind force 
           uforce = uforce + rhoice(ng)*tauaiu(i,j)*om_u(i,j)*on_u(i,j)

! *** pressure from tilting ocean surface 
           uforce = uforce - g*(masu)*on_u(i,j)                         &
     &            *(sealev(i,j)-sealev(i-1,j))

           fakt = 0.0_r8
#ifdef MASKING
           dsum = vmask(i-1,j)+vmask(i,j)+vmask(i-1,j+1)+vmask(i,j+1)
           if (dsum.gt.0.0_r8) fakt = 1.0_r8/dsum
           mfv11 = 0.5_r8*(hi(i-1,j-1,liold)*f(i-1,j-1)+                &
     &                     hi(i-1,j,liold)*f(i-1,j))*                   &
     &                      vie(i-1,j,lieol)*vmask(i-1,j)
           mfv21 = 0.5_r8*(hi(i,j-1,liold)*f(i,j-1)+                    &
     &                     hi(i,j,liold)*f(i,j))*                       &
     &                      vie(i,j,lieol)*vmask(i,j)
           mfv12 = 0.5_r8*(hi(i-1,j,liold)*f(i-1,j)+                    &
     &                     hi(i-1,j+1,liold)*f(i-1,j+1))*               &
     &                      vie(i-1,j+1,lieol)*vmask(i-1,j+1)
           mfv22 = 0.5_r8*(hi(i,j,liold)*f(i,j)+                        &
     &                     hi(i,j+1,liold)*f(i,j+1))*                   &
     &                      vie(i,j+1,lieol)*vmask(i,j+1)
#else
           fakt = 0.25_r8
           mfv11 = 0.5_r8*(hi(i-1,j-1,liold)*f(i-1,j-1)+                &
     &                     hi(i-1,j,liold)*f(i-1,j))*                   &
     &                      vie(i-1,j,lieol)
           mfv21 = 0.5_r8*(hi(i,j-1,liold)*f(i,j-1)+                    &
     &                     hi(i,j,liold)*f(i,j))*                       &
     &                      vie(i,j,lieol)
           mfv12 = 0.5_r8*(hi(i-1,j,liold)*f(i-1,j)+                    &
     &                     hi(i-1,j+1,liold)*f(i-1,j+1))*               &
     &                      vie(i-1,j+1,lieol)
           mfv22 = 0.5_r8*(hi(i,j,liold)*f(i,j)+                        &
     &                     hi(i,j+1,liold)*f(i,j+1))*                   &
     &                      vie(i,j+1,lieol)
#endif
! *** coriolis force u
          uforce = uforce + fakt*rhoice(ng)*om_u(i,j)*on_u(i,j)*        &
     &                            (mfv11 + mfv21 + mfv12 + mfv22)
!
! *** stress from ocean current 
          uforce = uforce/(om_u(i,j)*on_u(i,j)) +                       &
     &                         auf*chux*rho0*uwater(i,j)
!
          alfa = masu + dte(ng)*auf*rho0*chux
!
!  solving the momentum equation for u
          uie(i,j,lienw) = (masu*uie(i,j,lieol) +                       &
     &                       dte(ng)*uforce)/alfa 
!
# ifdef ICE_SHOREFAST
          hu = 0.5_r8*(h(i-1,j)+h(i,j))
          IF (hu.le.15.0_r8) uie(i,j,lienw) = 0._r8
# endif
# ifdef MASKING
          uie(i,j,lienw) = umask(i,j)*uie(i,j,lienw)
# endif
# ifdef ICESHELF
          IF(zice(i-1,j)+zice(i,j).ne.0.0_r8) THEN
              uie(i,j,lienw) = 0.0_r8
          END IF
# endif
        END DO
      END DO
!
!
! *** momentum equation 
!
      DO j=JstrV,Jend
        DO i=Istr,Iend
          vforce = 0._r8
          masv = 0.5_r8*(hi(i,j,liold)+hi(i,j-1,liold))
          masv = max(masv,0.01_r8)
          masv = masv*rhoice(ng) 
          avf = max(0.5_r8*(ai(i,j-1,liold)+ai(i,j,liold)),0.1_r8)
          chuy = 0.5_r8*(chu_iw(i,j-1)+chu_iw(i,j))
          pmv = 0.5_r8*(pm(i,j) + pm(i,j-1)) 
          pnv = 0.5_r8*(pn(i,j) + pn(i,j-1)) 
!
! *** forces from ice rheology y-direction 
          s1 = (sig22(i,j,lienw) - sig22(i,j-1,lienw))*pnv
#ifdef MASKING
          IF (vmask(i,j).gt.0.0_r8.and.vmask(i+1,j).lt.1.0_r8) THEN
             f1 = 0.5_r8*(sig12(i,j,lienw)+sig12(i,j-1,lienw))
# ifdef ICESHELF
          ELSE IF (zice(i,j-1).eq.0.0_r8.and.zice(i,j).eq.0.0_r8.and.   &
     &             zice(i+1,j-1)+zice(i+1,j).ne.0.0_r8) then
             f1 = 0.5_r8*(sig12(i,j,lienw)+sig12(i,j-1,lienw))
# endif
          ELSE
             f1 = 0.25_r8*(sig12(i,j,lienw)+sig12(i+1,j,lienw)          &
     &           + sig12(i+1,j-1,lienw)+sig12(i,j-1,lienw))
          END IF
#else
          f1 = 0.25_r8*(sig12(i,j,lienw)+sig12(i+1,j,lienw)             &
     &           + sig12(i+1,j-1,lienw)+sig12(i,j-1,lienw))
#endif
#ifdef MASKING
          IF (vmask(i,j).gt.0.0_r8.and.vmask(i-1,j).lt.1.0_r8 ) THEN
             f2 = 0.5_r8*(sig12(i,j,lienw)+sig12(i,j-1,lienw))
# ifdef ICESHELF
          ELSE IF (zice(i,j-1).eq.0.0_r8.and.zice(i,j).eq.0.0_r8.and.   &
     &             zice(i-1,j-1)+zice(i-1,j).ne.0.0_r8) then
             f2 = 0.5_r8*(sig12(i,j,lienw)+sig12(i,j-1,lienw))
# endif
          ELSE
             f2 = 0.25_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw)          &
     &           + sig12(i-1,j-1,lienw)+sig12(i,j-1,lienw))
          END IF
#else
          f2 = 0.25_r8*(sig12(i,j,lienw)+sig12(i-1,j,lienw)             &
     &           + sig12(i-1,j-1,lienw)+sig12(i,j-1,lienw))
#endif
!
           s2 = (f1-f2)*pmv 
           vforce = (s1+s2)*om_v(i,j)*on_v(i,j)
#ifdef ACTIVE
!ACTIVE
#endif
! *** wind force
           vforce = vforce + rhoice(ng)*tauaiv(i,j)*om_v(i,j)*on_v(i,j)

! *** pressure from tilting ocean surface 
          vforce = vforce - g*(masv)*om_v(i,j)                          &
     &            *(sealev(i,j)-sealev(i,j-1))
!
           fakt = 0.0_r8
#ifdef MASKING
           dsum = umask(i,j-1)+umask(i+1,j-1)+umask(i,j)+umask(i+1,j)
           IF (dsum.gt.0.0_r8) fakt = 1.0_r8/dsum
           mfu11 = 0.5_r8*(hi(i-1,j-1,liold)*f(i-1,j-1)+                &
     &                     hi(i,j-1,liold)*f(i,j-1))*                   &
     &                      uie(i,j-1,lieol)*umask(i,j-1)
           mfu21 = 0.5_r8*(hi(i,j-1,liold)*f(i,j-1)+                    &
     &                     hi(i+1,j-1,liold)*f(i+1,j-1))*               &
     &                      uie(i+1,j-1,lieol)*umask(i+1,j-1)
           mfu12 = 0.5_r8*(hi(i-1,j,liold)*f(i-1,j)+                    &
     &                     hi(i,j,liold)*f(i,j))*                       &
     &                      uie(i,j,lieol)*umask(i,j)
           mfu22 = 0.5_r8*(hi(i,j,liold)*f(i,j)+                        &
     &                     hi(i+1,j,liold)*f(i+1,j))*                   &
     &                      uie(i+1,j,lieol)*umask(i+1,j)
#else
           fakt = 0.25_r8
           mfu11 = 0.5_r8*(hi(i-1,j-1,liold)*f(i-1,j-1)+                &
     &                     hi(i,j-1,liold)*f(i,j-1))*                   &
     &                      uie(i,j-1,lieol)
           mfu21 = 0.5_r8*(hi(i,j-1,liold)*f(i,j-1)+                    &
     &                     hi(i+1,j-1,liold)*f(i+1,j-1))*               &
     &                      uie(i+1,j-1,lieol)
           mfu12 = 0.5_r8*(hi(i-1,j,liold)*f(i-1,j)+                    &
     &                     hi(i,j,liold)*f(i,j))*                       &
     &                      uie(i,j,lieol)
           mfu22 = 0.5_r8*(hi(i,j,liold)*f(i,j)+                        &
     &                     hi(i+1,j,liold)*f(i+1,j))*                   &
     &                      uie(i+1,j,lieol)
#endif

! *** coriolis force v
           vforce = vforce - fakt*rhoice(ng)*om_v(i,j)*on_v(i,j)*       &
     &                            (mfu11 + mfu21 + mfu12 + mfu22)
!
! *** stress from ocean current 
           vforce = vforce/(om_v(i,j)*on_v(i,j)) +                      &
     &                         avf*chuy*rho0*vwater(i,j)
!
           alfa = masv + dte(ng)*avf*rho0*chuy
!
!  solving the momentum equation for v
           vie(i,j,lienw) = (masv*vie(i,j,lieol) +                      &
     &                       dte(ng)*vforce)/alfa 
!
# ifdef ICE_SHOREFAST
           hv = 0.5_r8*(h(i,j-1)+h(i,j))
           IF (hv.le.15.0_r8) vie(i,j,lienw) = 0._r8
# endif
# ifdef MASKING
           vie(i,j,lienw) = vmask(i,j)*vie(i,j,lienw)
# endif
# ifdef ICESHELF
          IF (zice(i,j-1)+zice(i,j).ne.0.0_r8) THEN
            vie(i,j,lienw) = 0.0_r8
          ENDIF
# endif
        END DO 
      END DO 

      CALL uibc_tile (ng, tile,                                         &
     &                          LBi, UBi, LBj, UBj, lieol, lienw, uie)
      CALL vibc_tile (ng, tile,                                         &
     &                          LBi, UBi, LBj, UBj, lieol, lienw, vie)
#if defined EW_PERIODIC || defined NS_PERIODIC
      CALL exchange_u2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        uie(:,:,lienw))
      CALL exchange_v2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        vie(:,:,lienw))
#endif
# ifdef DISTRIBUTE
      CALL mp_exchange2d (ng, tile, iNLM, 2,                            &
     &                    LBi, UBi, LBj, UBj,                           &
     &                    NghostPoints, EWperiodic, NSperiodic,         &
     &                    uie(:,:,lienw), vie(:,:,lienw))
# endif

!
! Update ice velocity
!
      IF(ievp(ng).eq.nevp(ng)) THEN
        DO j=Jstr,Jend
          DO i=IstrU,Iend
            ui(i,j,liunw) = uie(i,j,lienw)
          END DO
        END DO
        DO j=JstrV,Jend
          DO i=Istr,Iend
            vi(i,j,liunw) = vie(i,j,lienw)
          END DO
        END DO
#define ACTIVE
#ifdef ACTIVE
        IF (WESTERN_EDGE) THEN
          DO j=Jstr,Jend
            ui(1,j,liunw) = uie(1,j,lienw)
          END DO
          DO j=JstrV,Jend
            vi(0,j,liunw) = vie(0,j,lienw)
          END DO
        ENDIF
        IF (EASTERN_EDGE) THEN
          DO j=Jstr,Jend
            ui(Lm(ng)+1,j,liunw) = uie(Lm(ng)+1,j,lienw)
          END DO
          DO j=JstrV,Jend
            vi(Lm(ng)+1,j,liunw) = vie(Lm(ng)+1,j,lienw)
          END DO
        ENDIF
        IF (SOUTHERN_EDGE) THEN
          DO i=IstrU,Iend
            ui(i,0,liunw) = uie(i,0,lienw)
          END DO
          DO i=Istr,Iend
            vi(i,1,liunw) = vie(i,1,lienw)
          END DO
        ENDIF
        IF (NORTHERN_EDGE) THEN
          DO i=IstrU,Iend
            ui(i,Mm(ng)+1,liunw) = uie(i,Mm(ng)+1,lienw)
          END DO
          DO i=Istr,Iend
            vi(i,Mm(ng)+1,liunw) = vie(i,Mm(ng)+1,lienw)
          END DO
        END IF
        IF (SOUTHERN_EDGE.and.WESTERN_EDGE) THEN
          ui(1,0,liunw) = uie(1,0,lienw)
          vi(0,1,liunw) = vie(0,1,lienw)
        END IF
        IF (SOUTHERN_EDGE.and.EASTERN_EDGE) THEN
          ui(Lm(ng)+1,0,liunw) = uie(Lm(ng)+1,0,lienw)
          vi(Lm(ng)+1,1,liunw) = vie(Lm(ng)+1,1,lienw)
        END IF
        IF (NORTHERN_EDGE.and.WESTERN_EDGE) THEN
          ui(1,Mm(ng)+1,liunw) = uie(1,Mm(ng)+1,lienw)
          vi(0,Mm(ng)+1,liunw) = vie(0,Mm(ng)+1,lienw)
        END IF
        IF (NORTHERN_EDGE.and.EASTERN_EDGE) THEN
          ui(Lm(ng)+1,Mm(ng)+1,liunw) = uie(Lm(ng)+1,Mm(ng)+1,lienw)
          vi(Lm(ng)+1,Mm(ng)+1,liunw) = vie(Lm(ng)+1,Mm(ng)+1,lienw)
        END IF

!ACTIVE
#endif

!      CALL uibc_tile (ng, tile,                                        &
!     &                LBi, UBi, LBj, UBj,                              &
!     &                IminS, ImaxS, JminS, JmaxS,                      &
!     &                liuol, liunw, ui)
!      CALL vibc_tile (ng, tile,                                        &
!     &                LBi, UBi, LBj, UBj,                              &
!     &                IminS, ImaxS, JminS, JmaxS,                      &
!     &                liuol, liunw, vi)

#if defined EW_PERIODIC || defined NS_PERIODIC
      CALL exchange_u2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        ui(:,:,liunw))
      CALL exchange_v2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        vi(:,:,liunw))
#endif
# ifdef DISTRIBUTE
      CALL mp_exchange2d (ng, tile, iNLM, 2,                            &
     &                    LBi, UBi, LBj, UBj,                           &
     &                    NghostPoints, EWperiodic, NSperiodic,         &
     &                    ui(:,:,liunw), vi(:,:,liunw))
# endif
      ENDIF
!
      RETURN
      END SUBROUTINE ice_elastic_tile
#endif
      END MODULE ice_elastic_mod
