!
!=======================================================================
!                                                                      !
!  This routine sets initial conditions for biological tracer fields   !
!  using analytical expressions for line 8 in GOA for GOANPZ.                                       !
!                                                                      !
!=======================================================================
!

# undef DEPAVG      /* TEST case: set all equal to depth averaged values */

# ifdef DEPAVG
!
! Set all points equal to the same number
!
        do i=IstrR,IendR
         do j=JstrR,JendR
          do k=1,N(ng)
            t(i,j,k,1,iNO3) = 10.0_r8    !was 18    
            t(i,j,k,1,iNH4) = 0.20_r8
            t(i,j,k,1,iPhS) = 0.10_r8
            t(i,j,k,1,iPhL) = 0.10_r8
            t(i,j,k,1,iMZS) = 0.10_r8
            t(i,j,k,1,iMZL) = 0.10_r8
            t(i,j,k,1,iCop) = 2.041_r8
            t(i,j,k,1,iNCa) = 1.417_r8  ! 2.417_r8
            t(i,j,k,1,iEup) = 1.337_r8
            t(i,j,k,1,iDet) = eps
	    t(i,j,k,1,iJel) = eps
#  ifdef IRON
            t(i,j,k,1,iFe) = 0.6_r8
#  endif
          enddo

      
#  ifdef BENTHIC
       do k=1,NBL(ng)
       bt(i,j,k,1,iBen) = 9000.0_r8       !was eps
       bt(i,j,k,1,iBenDet) = 000.0_r8       !was eps
        enddo
#  endif
         enddo
        enddo
#else
!
! Make the curves.  First come parameters that are constant through 
! entire water column.
!
      deepval(iNO3) = 30.0_r8             !was 30.0_r8    
      deepval(iNH4) = eps
      deepval(iPhS) = eps
      deepval(iPhL) = eps
      deepval(iMZS) = eps
      deepval(iMZL) = eps
      deepval(iCop) = 0.00863_r8
      deepval(iNCa) = eps
      deepval(iEup) = 0.08_r8
      deepval(iDet) = eps             !was eps/60.0_r8
      deepval(iJel) = eps 
         do j=JstrR,JendR
            do i=IstrR,IendR
              do k=1,N(ng)
               t(i,j,k,1,iNO3) =09.0_r8  !was 16.0_r8
               t(i,j,k,1,iNH4) =  2.0_r8 !was 2
               t(i,j,k,1,iDet) =  eps
	       t(i,j,k,1,iJel) =  0.0003_r8
               biod(i,j,k) = -1 * ( z_r(i,j,k) + 2.5_r8 )
            enddo
#ifdef BENTHIC
           do k=1,NBL(ng)
                 bt(i,j,k,1,iBen) = 8000.0_r8    !was eps iBen
		 bt(i,j,k,1,iBenDet) = 000.0_r8    !was eps iBenDet
		 
            enddo
#endif
         enddo
      enddo
!
! PS - a combination of 2 curves: 2nd order polynomial curve to create
! a subsurface maximum at ~20 m and an exponentially decreasing curve to
! assure values aren't negative at depth.
!
!5      var1 = 25.58_r8
!5     var2 = -0.250_r8 / (5.0_r8**2)
!5     var3 =  0.008_r8 / (5.0_r8**3)
!5      var4 = 3.82_r8 * 5.0_r8
!5      var5 = 75.0_r8
!5      var6 = var5 - var4 
!5      var7 = var1 + var2*(var6**2) + var3*(var6**3)
!5      do i=IstrR,IendR
!5        do j=JstrR,JendR
!5          do k=1,N(ng)
!5            if ( biod(i,j,k) .le. var5 ) then
!5              var6 = biod(i,j,k) - var4
!5              t(i,j,k,1,iPhS) =                                         &
!5     &          var1 + var2*(var6**2) + var3*(var6**3)
!5            else
!5              t(i,j,k,1,iPhS) =                                         &
!5     &          var7 * exp( ( -1.0_r8*biod(i,j,k) + var5 ) / 5.0_r8 )
!5            endif
!5          enddo
!5        enddo
!5      enddo


!
! PL - exponentially decreasing with depth.
!
       t(i,j,k,1,iPhL) =t(i,j,k,1,iPhS)
      var1 = 8.25_r8
      var2 = 0.322_r8 / 5.0_r8
      do i=IstrR,IendR
        do j=JstrR,JendR
          do k=1,N(ng)
             t(i,j,k,1,iPhL) =t(i,j,k,1,iPhS)
            t(i,j,k,1,iPhL) = var1 * exp( -1.0_r8 * var2 * biod(i,j,k) )
	    t(i,j,k,1,iPhS) = t(i,j,k,1,iPhL) 
          enddo
        enddo
      enddo
            
!
! Microzooplankton, from Howell-Kubler, 1996
! approximated with a straight line and an exponentially decreasing
! curve to assure values aren't negative at depth.  Curves meet ~60m
!
      var1 = 3.1714_r8
      var2 = -0.1865_r8 / 5.0_r8
      var3 = 60.0_r8
      var4 = 0.5_r8
      var5 = var1 + var2 * var3
      do i=IstrR,IendR
        do j=JstrR,JendR
          do k=1,N(ng)
            if ( biod(i,j,k) .le. var3 ) then
              t(i,j,k,1,iMZL) = var1 + var2 * biod(i,j,k)
            else
              t(i,j,k,1,iMZL) = var4 +                                  &
     &          ( var5 - var4 ) * exp( ( var3 - biod(i,j,k) ) / 5.0_r8 )
            endif
            t(i,j,k,1,iMZS) = t(i,j,k,1,iMZL)
          enddo
        enddo
      enddo
!
! Pseudocalanus Copepods - from Shelikof data via Shelikof NPZ
! Step at ~ 50 m
!
      var1 = pi / 2.0_r8
!      var2 = 2.876_r8 / pi
       var2 = 0.5_r8 / pi
      var3 = 5.0_r8 / 5.0_r8
      var4 = 9.151_r8 * 5.0_r8
      do i=IstrR,IendR
        do j=JstrR,JendR
          do k=1,N(ng)
            var5 = var3 * ( biod(i,j,k) - var4 )
            t(i,j,k,1,iCop) = var1 - var2 * atan( var5 )
          enddo
        enddo
      enddo
!
! Neocalanus, from Shelikof NPZ. Step at ~ 30m
!
!g      var1 = 4.0_r8
!g      var2 = 1.3_r8
!g     var3 = 5.0_r8 / 5.0_r8
!g      var4 = 5.2_r8 * 5.0_r8
!g      var6 =200.0_r8
!g      do i=IstrR,IendR
!g        do j=JstrR,JendR
!g          do k=1,N(ng)
!set neocalanus to zero on the shelf.
!          if ( biod(i,j,k) .le. var6 ) then
!          t(i,j,k,1,iNCa) =0.0_r8
!          else
!g            var5 = var3 * ( biod(i,j,k) - var4 )
!g            t(i,j,k,1,iNCa) = var1 - var2 * atan( var5 )
!           endif
!g          enddo
!g        enddo
!g      enddo
  var1 = pi / 2.0_r8
!      var2 = 2.876_r8 / pi
       var2 = 0.5_r8 / pi
      var3 = 5.0_r8 / 5.0_r8
      var4 = 9.151_r8 * 5.0_r8
      do i=IstrR,IendR
        do j=JstrR,JendR
          do k=1,N(ng)
            var5 = var3 * ( biod(i,j,k) - var4 )
!            t(i,j,k,1,iNCa) = var1 - var2 * atan( var5 )
	    t(i,j,k,1,iNCa) =  t(i,j,k,1,iCop)
          enddo
        enddo
      enddo

!
! Euphausiids, Wild guesses. Step at ~ 30m
!
!g      var1 = 1.78_r8
!g      var2 = 0.8_r8
!g      var3 = 5.0_r8 / 5.0_r8
!g      var4 = 5.2_r8 * 5.0_r8
!g      do i=IstrR,IendR
!g        do j=JstrR,JendR
!g          do k=1,N(ng)
!g            var5 = var3 * ( biod(i,j,k) - var4)
!g            t(i,j,k,1,iEup) =  var1 - var2 * atan( var5 )
!g          enddo
!g        enddo
!g      enddo
!
 var1 = pi / 2.0_r8
  var2 = 0.5_r8 / pi
!      var2 = 2.876_r8 / pi
      var3 = 5.0_r8 / 5.0_r8
      var4 = 9.151_r8 * 5.0_r8
      do i=IstrR,IendR
        do j=JstrR,JendR
          do k=1,N(ng)
            var5 = var3 * ( biod(i,j,k) - var4 )
!            t(i,j,k,1,iEup) = var1 - var2 * atan( var5 )
             t(i,j,k,1,iEup) = 0.05_r8
          enddo
        enddo
      enddo
#  ifdef IRON
! Iron - linear from surface value to value at 100m and increase onshore
      do i=IstrR,IendR
        do j=JstrR,JendR
          var1 = MAX(0._r8,MIN(1._r8,(h(i,j)-Feinh)/(Feoffh-Feinh)))
          FeSurf = Feinlo + var1*(Feofflo-Feinlo)
          FeDeep = Feinhi + var1*(Feoffhi-Feinhi)
          var1 = (FeDeep-FeSurf) / 100._r8
          do k=1,N(ng)
            t(i,j,k,1,iFe) = MIN(FeDeep, FeSurf - z_r(i,j,k)*var1)
          enddo
        enddo
      enddo
#  endif
!
! Concentrations of everything below 100m - i.e. below
! depths where calculations are performed.  Have linear slope
! between values above and below.
! Iron deep values have already been determined.
!
      do i=IstrR,IendR
        do j=JstrR,JendR
          do k=N(ng),1,-1
            if ( biod(i,j,k) .gt. 120.0_r8 ) then       !was 120
              t(i,j,k,1,iNO3) = deepval(iNO3)
              t(i,j,k,1,iNH4) = deepval(iNH4)
              t(i,j,k,1,iPhS) = deepval(iPhS)
              t(i,j,k,1,iPhL) = deepval(iPhL)
              t(i,j,k,1,iMZS) = deepval(iMZS)
              t(i,j,k,1,iMZL) = deepval(iMZL)
              t(i,j,k,1,iCop) = deepval(iCop)
              t(i,j,k,1,iNCa) = deepval(iNCa)
              t(i,j,k,1,iEup) = deepval(iEup)
              t(i,j,k,1,iDet) = deepval(iDet)
	      t(i,j,k,1,iJel) = deepval(iJel)


            else if ( biod(i,j,k) .gt. 100.0_r8 .and.                    &
     &                biod(i,j,k) .le. 120.0_r8) then
              var1 = ( 100.0_r8 - biod(i,j,k) ) / ( 100.0_r8-120.0_r8 )
              t(i,j,k,1,iNO3) = loval(iNO3) +                           &
     &                          ( deepval(iNO3) - loval(iNO3) ) * var1
              t(i,j,k,1,iNH4) = loval(iNH4) +                           &
     &                          ( deepval(iNH4) - loval(iNH4) ) * var1
              t(i,j,k,1,iPhS) = loval(iPhS) +                           &
     &                          ( deepval(iPhS) - loval(iPhS) ) * var1
              t(i,j,k,1,iPhL) = loval(iPhL) +                           &
     &                          ( deepval(iPhL) - loval(iPhL) ) * var1
              t(i,j,k,1,iMZS) = loval(iMZS) +                           &
     &                          ( deepval(iMZS) - loval(iMZS) ) * var1
              t(i,j,k,1,iMZL) = loval(iMZL) +                           &
     &                          ( deepval(iMZL) - loval(iMZL) ) * var1
              t(i,j,k,1,iCop) = loval(iCop) +                           &
     &                          ( deepval(iCop) - loval(iCop) ) * var1
              t(i,j,k,1,iNCa) = loval(iNCa) +                           &
     &                          ( deepval(iNCa) - loval(iNCa) ) * var1
              t(i,j,k,1,iEup) = loval(iEup) +                           &
     &                          ( deepval(iEup) - loval(iEup) ) * var1
              t(i,j,k,1,iDet) = loval(iDet) +                           &
     &                          ( deepval(iDet) - loval(iDet) ) * var1
              t(i,j,k,1,iJel) = loval(iJel) +                           &
                                ( deepval(iJel) - loval(iJel) ) * var1




            else
              loval(iNO3) = t(i,j,k,1,iNO3)
              loval(iNH4) = t(i,j,k,1,iNH4)
              loval(iPhS) = t(i,j,k,1,iPhS)
              loval(iPhL) = t(i,j,k,1,iPhL)
              loval(iMZS) = t(i,j,k,1,iMZS)
              loval(iMZL) = t(i,j,k,1,iMZL)
              loval(iCop) = t(i,j,k,1,iCop)
              loval(iNCa) = t(i,j,k,1,iNCa)
              loval(iEup) = t(i,j,k,1,iEup)
              loval(iDet) = t(i,j,k,1,iDet)
	      loval(iJel) = t(i,j,k,1,iJel)



            endif
          enddo
        enddo
      enddo
# endif /* DEPAVG */
#ifdef GAK1D
!
!  This is a hack for sensitivity studies - to test warmer or cooler water
!
!      do i=IstrR,IendR
!        do j=JstrR,JendR
!          do k=1,N(ng)
!            t(i,j,k,1,itemp) = t(i,j,k,1,itemp) + 2.0_r8
!          enddo
!        enddo
!      enddo
#endif
!
! Check for size, set other time index, and periodic BC's
!
      do i=IstrR,IendR
         do j=JstrR,JendR
            do k=1,N(ng)
               DO is=1,NBT
                  itrc=idbio(is)
                  t(i,j,k,1,itrc) = MAX(t(i,j,k,1,itrc),eps)
                  t(i,j,k,2,itrc) = t(i,j,k,1,itrc)
               enddo
           enddo
        enddo
     enddo
#ifdef BENTHIC
      do i=IstrR,IendR
         do j=JstrR,JendR
            do k=1,NBL(ng)
               DO is=1,NBEN
                itrc=idben(is)
                 bt(i,j,k,1,itrc) = MAX(bt(i,j,k,1,itrc),eps)
                 bt(i,j,k,2,itrc) = bt(i,j,k,1,itrc)
		enddo
            enddo
	  enddo
      enddo
#endif
