      SUBROUTINE ana_tair (ng, tile, model)
!
!! svn $Id: ana_tair.h 588 2008-03-21 23:09:01Z kate $
!!======================================================================
!! Copyright (c) 2002-2008 The ROMS/TOMS Group                         !
!!   Licensed under a MIT/X style license                              !
!!   See License_ROMS.txt                                              !
!=======================================================================
!                                                                      !
!  This routine sets surface air temperature (degC) using an           !
!  analytical expression.                                              !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_forces
      USE mod_ncparam
!
! Imported variable declarations.
!
      integer, intent(in) :: ng, tile, model

#include "tile.h"
!
      CALL ana_tair_tile (ng, tile, model,                              &
     &                    LBi, UBi, LBj, UBj,                           &
     &                    FORCES(ng) % Tair)
!
! Set analytical header file name used.
!
      IF (Lanafile) THEN
        ANANAME(32)=__FILE__
      END IF

      RETURN
      END SUBROUTINE ana_tair
!
!***********************************************************************
      SUBROUTINE ana_tair_tile (ng, tile, model,                        &
     &                          LBi, UBi, LBj, UBj,                     &
     &                          Tair)
!***********************************************************************
!
      USE mod_param
      USE mod_scalars
!
#if defined EW_PERIODIC || defined NS_PERIODIC
      USE exchange_2d_mod, ONLY : exchange_r2d_tile
#endif
#ifdef DISTRIBUTE
      USE mp_exchange_mod, ONLY : mp_exchange2d
#endif
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile, model
      integer, intent(in) :: LBi, UBi, LBj, UBj
!
#ifdef ASSUMED_SHAPE
      real(r8), intent(out) :: Tair(LBi:,LBj:)
#else
      real(r8), intent(out) :: Tair(LBi:UBi,LBj:UBj)
#endif
!
!  Local variable declarations.
!
#ifdef DISTRIBUTE
# ifdef EW_PERIODIC
      logical :: EWperiodic=.TRUE.
# else
      logical :: EWperiodic=.FALSE.
# endif
# ifdef NS_PERIODIC
      logical :: NSperiodic=.TRUE.
# else
      logical :: NSperiodic=.FALSE.
# endif
#endif
      integer :: i, j

      integer :: iday, month, year
      real(r8) :: hour, yday , tempramp


#include "set_bounds.h"
!
!-----------------------------------------------------------------------
!  Set analytical surface air temperature (degC).
!-----------------------------------------------------------------------
!
#if defined BENCHMARK
      DO j=JstrR,JendR
        DO i=IstrR,IendR
          Tair(i,j)=4.0_r8
        END DO
      END DO
#elif defined BL_TEST
      DO j=JstrR,JendR
        DO i=IstrR,IendR
          Tair(i,j)=23.567_r8
        END DO
      END DO
#elif defined ICE_OCEAN_1D
      CALL caldate (r_date, tdays(ng), year, yday, month, iday, hour)
      DO j=JstrR,JendR
        DO i=IstrR,IendR
          Tair(i,j)=-5.0_r8 - 15.0_r8*                                  &
     &               COS(2.0_r8*pi*(yday-60.0_r8)/365.25_r8)
        END DO
      END DO
#elif defined MEDDY
      DO j=JstrR,JendR
        DO i=IstrR,IendR
          Tair(i,j)=14.0_r8
        END DO
      END DO
#elif defined NEMURO
      tempramp = 18
      CALL caldate (r_date, tdays(ng), year, yday, month, iday, hour)
      DO j=JstrR,JendR
        DO i=IstrR,IendR
          Tair(i,j)= 8.0_r8 - 5.0_r8*                                  &
     &               COS(2.0_r8*pi*(yday-60.0_r8)/365.25_r8)            &
     &         + (tempramp/10.)*((year-1998) + yday/365.25_r8)/5.0_r8
        END DO
      END DO
#else
      ana_tair.h: No values provided for Tair.
#endif
#if defined EW_PERIODIC || defined NS_PERIODIC
      CALL exchange_r2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        Tair)
#endif
#ifdef DISTRIBUTE
      CALL mp_exchange2d (ng, tile, model, 1,                           &
     &                    LBi, UBi, LBj, UBj,                           &
     &                    NghostPoints, EWperiodic, NSperiodic,         &
     &                    Tair)
#endif
      RETURN
      END SUBROUTINE ana_tair_tile
