/*
** svn $Id: bio_toy.h 141 2007-03-31 15:40:49Z arango $
*******************************************************************************
** Copyright (c) 2002-2007 The ROMS/TOMS Group                               **
**   Licensed under a MIT/X style license                                    **
**   See License_ROMS.txt                                                    **
*******************************************************************************
**
** Options one-dimensional (vertical) Biology Toy.
**
** Application flag:   1dSEBS 
** Input script:       ocean_bio_toy.in
**                     bioFasham.in, ecosim.in, npzd_Franks.in, npzd_Powell.in
*/

#define  UV_ADV          /* turn ON or OFF advection terms */
#undef  UV_C2ADVECTION  /* turn ON or OFF 2nd-order centered advection */
#undef  UV_C4ADVECTION  /* turn ON or OFF 4th-order centered advection */
#define  UV_SADVECTION   /* turn ON or OFF splines vertical advection */
#undef  UV_VIS2         /* turn ON or OFF Laplacian horizontal mixing */
#undef  UV_VIS4         /* turn ON or OFF biharmonic horizontal mixing */
#undef  UV_COR          /* turn ON or OFF Coriolis term */
#undef  UV_PSOURCE      /* turn ON or OFF point Sources/Sinks */

/*
**  Select model dynamics for TRACER equations:
**  (The default horizontal and vertical advection is 4th-order centered)
*/



#undef  TS_A4HADVECTION /* define if 4th-order Akima horiz. advection */
#undef  TS_C2HADVECTION /* define if 2nd-order centered horiz. advection */
#undef  TS_C4HADVECTION /* define if 4th-order centered horiz. advection */
#define TS_U3HADVECTION /* define if 3rd-order upstream horiz. advection */
#undef  TS_A4VADVECTION /* define if 4th-order Akima vertical advection */
#undef  TS_C2VADVECTION /* define if 2nd-order centered vertical advection */
#undef  TS_C4VADVECTION /* define if 4th-order centered vertical advection */
#define TS_SVADVECTION  /* define if splines vertical advection */
#define TS_DIF2         /* turn ON or OFF Laplacian horizontal mixing */
#undef  TS_DIF4         /* turn ON or OFF biharmonic horizontal mixing */
#undef  TS_FIXED        /* define if diagnostic run, no evolution of tracers */
#define SALINITY        /* define if using salinity */
#define NONLIN_EOS      /* define if using nonlinear equation of state */
#undef  OFFLINE_FLOATS  /* define if offline simulation of floats */
#undef  OFFLINE_BIOLOGY /* define if offline simulation of bio tracers */
#undef  QCORRECTION     /* define if net heat flux correction */
#undef  SCORRECTION     /* define if freshwater flux correction */
#define SOLAR_SOURCE    /* define solar radiation source term */
#undef  SRELAXATION     /* define if salinity relaxation as a freshwater flux*/
#undef  TS_PSOURCE      /* turn ON or OFF point Sources/Sinks */


/*
**  Select pressure gradient algorithm.  If no option is selected, the
**  pressure gradient term is computed using standard density Jacobian
**  algorithm.  Notice that there are two quartic pressure Jacobian
**  options.  They differ on how the WENO reconsicliation step is done
**  and in the monotonicity constraining algorithms.
*/


#undef  PJ_GRADP        /* Finite volume Pressure Jacobian (Lin, 1997) */
#undef  PJ_GRADPQ2      /* Quartic 2 Pressure Jacobian (Shchepetkin, 2000) */
#undef  PJ_GRADPQ4      /* Quartic 4 Pressure Jacobian (Shchepetkin, 2000) */
#define DJ_GRADPS       /* Splines density  Jacobian (Shchepetkin, 2000) */
#undef  WJ_GRADP        /* Weighted density Jacobian (Song, 1998) */

/*
**  Select surface model fluxes formutalion via atmospheric boundary
**  layer (Fairall et al, 1996).
*/

#define BULK_FLUXES     /* turn ON or OFF bulk fluxes computation */
#undef  COOL_SKIN       /* turn ON or OFF cool skin correction */
#define LONGWAVE        /* Compute net longwave radiation internally gg*/
#undef LONGWAVE_OUT /* Compute ougoing longwave radiation internally */
#define EMINUSP         /* turn ON internal calculation of E-P */

/*
**  Select options for shortwave radiation.  The shortwave radiation can be
**  computed using the global albedo equation with a cloud correction.
**  Alternatively, input shortwave radiation data computed from averaged
**  data (with snapshots greater or equal than 24 hours) can be modulated
**  by the local diurnal cycle which is a function longitude, latitude and
**  day-of-year.
*/

#define ALBEDO          /* use albedo equation for shortwave radiation */
#undef  DIURNAL_SRFLUX  /* impose shortwave radiation local diurnal cycle */

/*
**  Select model configuration:
*/

#define SOLVE3D         /* define if solving 3D primitive equations */
#undef  CURVGRID        /* define if using  curvilinear coordinate grid*/
#undef  MASKING         /* define if there is land in the domain */
#undef  BODYFORCE       /* define if applying stresses as bodyforces */
#define PROFILE         /* define if time profiling */
#define AVERAGES        /* define if writing out time-averaged data */
#define  AVERAGES_AKV    /* define if writing out time-averaged AKv */
#define  AVERAGES_AKT    /* define if writing out time-averaged AKt */
#define AVERAGES_AKS    /* define if writing out time-averaged AKs */
#define AVERAGES_FLUXES /* define if writing out time-averaged fluxes */
#undef  DIAGNOSTICS     /* define if writing out time-averaged diagnostics */
#undef  FILTERED        /* define if writing out time-filtered data */
#undef  ICESHELF        /* define if including ice shelf cavities */
#define SPHERICAL       /* define if analytical spherical grid */
#undef  STATIONS        /* define if writing out station data */
#undef  STATIONS_CGRID  /* define if extracting data at native C-grid */

/*ice options -do any of these actually do anything? I doubt it*/

# define MASKING
# define  ICE_MODEL
# define  ICE_THERMO
# define  ICE_MK
# undef   ICE_ALB_EC92
# undef   ICE_SMOOTH
# undef  ICE_MOMENTUM
# define  ICE_MOM_BULK
# define  ICE_EVP
# define  ICE_ADVECT
# define  ICE_SMOLAR
# define  ICE_UPWIND
# define  ICE_BULK_FLUXES
# define  ANA_AIOBC
# define  ANA_HIOBC
# define  ANA_HSNOBC



/*
** Lagrangian drifters options
*/

#undef  FLOATS          /* define if simulated Lagrangian drifters */
#undef  FLOAT_VWALK     /* define if vertical random walk */

/*
** Activate conservative, parabolic spline reconstruction in the
** vertical.  Notice that there also options (see above) for vertical
** advection of momentum and tracers using splines.
*/

#define SPLINES         /* turn ON or OFF parabolic splines reconstruction */

/*
**  Select analytical fields configuration: define if using any of the
**  following options.  Set the appropriate analytical expression in
**  file "analytical.F".
*/

#undef  ANA_BIOLOGY     /* analytical biology initial conditions */
#undef  ANA_BPFLUX      /* analytical bottom passive tracers fluxes */
#undef  ANA_BSEDIM      /* analytical bottom sediment grain size & density */
#define ANA_BSFLUX      /* analytical bottom salinity flux */
#define ANA_BTFLUX      /* analytical bottom temperature flux */
#define  ANA_CLOUD       /* analytical cloud fraction */
#undef  ANA_DIAG        /* Customized diagnostics */
#undef  ANA_FSOBC       /* analytical free-surface boundary conditions */

#define  ANA_GRID        /* analytical model grid set-up */

#define  ANA_HUMIDITY    /* analytical surface air humidity */

#define  ANA_INITIAL     /* analytical initial conditions */

#define  ANA_M2CLIMA     /* analytical 2D momentum climatology */
#undef  ANA_M2OBC       /* analytical 2D momentum boundary conditions */
#undef  ANA_M3CLIMA     /* analytical 3D momentum climatology */
#undef  ANA_M3OBC       /* analytical 3D momentum boundary conditions */

#define  ANA_PAIR        /* analytical surface air pressure */

#undef  ANA_PSOURCE     /* analytical point Sources/Sinks */

#define  ANA_RAIN        /* analytical rain fall rate */

#undef  ANA_SEDIMENT    /* analytical sediment initial conditions */
#undef  ANA_SMFLUX      /* analytical surface momentum stress */
#undef  ANA_SPFLUX      /* analytical surface passive tracers fluxes */
#undef  ANA_SPINNING    /* analytical time-varying rotation force */

#define ANA_SRFLUX      /* analytical surface shortwave radiation flux */

#undef  ANA_SSFLUX      /* analytical surface salinity flux */
#undef  ANA_SSH         /* analytical sea surface height */
#undef  ANA_SSS         /* analytical sea surface salinity */
#undef  ANA_SST         /* analytical SST and dQdSST */
#undef  ANA_STFLUX      /* analytical surface temperature flux */

#define  ANA_TAIR        /* analytical surface air temperature */

#undef  ANA_TCLIMA      /* analytical tracers climatology */
#undef  ANA_TOBC        /* analytical tracers boundary conditions */
#undef  ANA_VMIX        /* analytical vertical mixing coefficients */

#define  ANA_WINDS       /* analytical surface winds */

#undef  ANA_WWAVE       /* analytical wind induced waves */

/*
**  Select options for horizontal mixing of MOMENTUM:
*/

#undef  VISC_GRID       /* viscosity coefficient scaled by grid size */
#define  MIX_S_UV        /* mixing along constant S-surfaces gg */
#undef  MIX_GEO_UV      /* mixing on geopotential (constant Z) surfaces */

/*
**  Select options for horizontal mixing of TRACERS:
*/

#undef  DIFF_GRID       /* diffusion coefficient scaled by grid size */
#undef  MIX_S_TS        /* mixing along constant S-surfaces gg*/
#undef  MIX_GEO_TS      /* mixing on geopotential (constant Z) surfaces */
#define  MIX_ISO_TS      /* mixing on epineutral (constant RHO) surfaces */
 
#undef UV_LOGDRAG         /*  use to turn ON or OFF logarithmic bottom friction     */
#undef UV_LDRAG           /*  use to turn ON or OFF linear bottom friction          */
#define UV_QDRAG           /*  use to turn ON or OFF quadratic bottom friction     gg  */


/*
**  Select vertical turbulent mixing scheme for MOMENTUM and TRACERS
**  (activate only one closure):
*/

#undef  BVF_MIXING      /* Activate Brunt-Vaisala frequency mixing */
#undef  GLS_MIXING      /* Activate Generic Length-Scale mixing */
#undef  MY25_MIXING     /* Activate Mellor/Yamada Level-2.5 closure */
#define LMD_MIXING      /* Activate Large/McWilliams/Doney interior closure */

/*
**  Select options for the Generic Length-Scale closure:
**  (The default advection is third-order upstream bias, G-Scheme)
*/

#undef  N2S2_HORAVG     /* Activate horizontal smoothing of buoyancy/shear */
#undef  CANUTO_A        /* Canuto A-stability function formulation */
#undef  CANUTO_B        /* Canuto B-stability function formulation */
#undef  KANTHA_CLAYSON  /* Kantha and Clayson stability function formulation */
#undef  K_C2ADVECTION   /* turn ON or OFF 2nd-order centered advection */
#undef  K_C4ADVECTION   /* turn ON or OFF 4th-order centered advection */

/*
**  Select options for the Mellor/Yamada level 2.5 closure:
**  (The default advection is third-order upstream bias, G-Scheme)
*/

#undef  N2S2_HORAVG     /* Activate horizontal smoothing of buoyancy/shear */
#undef  KANTHA_CLAYSON  /* Kantha and Clayson stability function formulation */
#undef  K_C2ADVECTION   /* turn ON or OFF 2nd-order centered advection */
#undef  K_C4ADVECTION   /* turn ON or OFF 4th-order centered advection */

/*
**  Select options for the Large/McWilliams/Doney interior mixing:
*/

# ifdef LMD_MIXING
#define LMD_RIMIX       /* Add diffusivity due to shear instability */
#define LMD_CONVEC      /* Add convective mixing due to shear instability */
#undef  LMD_DDMIX       /* Add double-diffusive mixing */
# endif

/*
**  Select Large/McWilliams/Doney Oceanic Planetary Boundary Layer scheme
**  and its associated options: local K-Profile Parameterization (KPP)
*/

#define LMD_SKPP        /* turn ON or OFF surface boundary layer KPP mixing */
#define LMD_BKPP        /* turn ON or OFF bottom  boundary layer KPP mixing */
#define LMD_NONLOCAL    /* turn ON or OFF nonlocal transport */

/*
**  If not SPLINES, activate smoothing of Richardson number.
*/

#undef  RI_HORAVG       /* Activate horizontal smoothing */
#undef  RI_VERAVG       /* Activate vertical smoothing */

/*
**  Select options for bottom boundary layer closure.
*/

#undef  CS_BBL         /* turn ON or OFF Chris Sherwood BBL closure */
#undef  MB_BBL         /* turn ON or OFF Mainte Blaas BBL closure */
#undef  SG_BBL         /* turn ON or OFF Styles and Glenn (2000) BBL closure */
#undef  SG_ZNOT        /* activate internal computation of bottom roughness */
#undef  SG_LOGINT      /* activate logarithmic interpolation of (Ur,Vr) */

/*
**  Select lateral boundary options.  Usually, select ONE option at each
**  boundary edge for free-surface, 2D momentum, 3D momentum, and tracers.
**  The turbulent kineric energy (TKE) conditions are only activated for
**  the Mellor-Yamada 2.5 closure. If open boundary radiation conditions,
**  an additional option can be activated at each boundary edge to include
**  a passive/active nudging term with weak/strong values for outflow/inflow.
*/

#undef  SPONGE            /* activate areas of enhanced viscosity/diffusion */

#undef  EAST_VOLCONS      /* Eastern edge, enforce mass conservation */
#undef  WEST_VOLCONS      /* Western edge, enforce mass conservation */
#undef  NORTH_VOLCONS     /* Northern edge, enforce mass conservation */
#undef  SOUTH_VOLCONS     /* Southern edge, enforce mass conservation */

#define EW_PERIODIC       /* East-West periodic boundaries */
#define NS_PERIODIC       /* North-South periodic boundaries */

#undef  EASTERN_WALL      /* Eastern edge, closed wall condition */
#undef  WESTERN_WALL      /* Western edge, closed wall condition */
#undef  NORTHERN_WALL     /* Northern edge, closed wall condition */
#undef  SOUTHERN_WALL     /* Southern edge, closed wall condition */

#undef  RADIATION_2D      /* Tangential phase speed in radiation conditions */

#undef  EAST_FSCHAPMAN    /* Eastern edge, free-surface, Chapman condition */
#undef  EAST_FSGRADIENT   /* Eastern edge, free-surface, gradient condition */
#undef  EAST_FSRADIATION  /* Eastern edge, free-surface, radiation condition */
#undef  EAST_FSNUDGING    /* Eastern edge, free-surface, passive/active term */
#undef  EAST_FSCLAMPED    /* Eastern edge, free-surface, clamped condition */
#undef  EAST_M2FLATHER    /* Eastern edge, 2D momentum, Flather condition */
#undef  EAST_M2GRADIENT   /* Eastern edge, 2D momentum, gradient condition */
#undef  EAST_M2RADIATION  /* Eastern edge, 2D momentum, radiation condition */
#undef  EAST_M2NUDGING    /* Eastern edge, 2D momentum, passive/active term */
#undef  EAST_M2CLAMPED    /* Eastern edge, 2D momentum, clamped condition */
#undef  EAST_M3GRADIENT   /* Eastern edge, 3D momentum, gradient condition */
#undef  EAST_M3RADIATION  /* Eastern edge, 3D momentum, radiation condition */
#undef  EAST_M3NUDGING    /* Eastern edge, 3D momentum, passive/active term */
#undef  EAST_M3CLAMPED    /* Eastern edge, 3D momentum, clamped condition */
#undef  EAST_KGRADIENT    /* Eastern edge, TKE fields, gradient condition */
#undef  EAST_KRADIATION   /* Eastern edge, TKE fields, radiation condition */
#undef  EAST_TGRADIENT    /* Eastern edge, tracers, gradient condition */
#undef  EAST_TRADIATION   /* Eastern edge, tracers, radiation condition */
#undef  EAST_TNUDGING     /* Eastern edge, tracers, passive/active term */
#undef  EAST_TCLAMPED     /* Eastern edge, tracers, clamped condition */

#undef  WEST_FSCHAPMAN    /* Western edge, free-surface, Chapman condition */
#undef  WEST_FSGRADIENT   /* Western edge, free-surface, gradient condition */
#undef  WEST_FSRADIATION  /* Western edge, free-surface, radiation condition */
#undef  WEST_FSNUDGING    /* Western edge, free-surface, passive/active term */
#undef  WEST_FSCLAMPED    /* Western edge, free-surface, clamped condition */
#undef  WEST_M2FLATHER    /* Western edge, 2D momentum, Flather condition */
#undef  WEST_M2GRADIENT   /* Western edge, 2D momentum, gradient condition */
#undef  WEST_M2RADIATION  /* Western edge, 2D momentum, radiation condition */
#undef  WEST_M2NUDGING    /* Western edge, 2D momentum, passive/active term */
#undef  WEST_M2CLAMPED    /* Western edge, 2D momentum, clamped condition */
#undef  WEST_M3GRADIENT   /* Western edge, 3D momentum, gradient condition */
#undef  WEST_M3RADIATION  /* Western edge, 3D momentum, radiation condition */
#undef  WEST_M3NUDGING    /* Western edge, 3D momentum, passive/active term */
#undef  WEST_M3CLAMPED    /* Western edge, 3D momentum, clamped condition */
#undef  WEST_KGRADIENT    /* Western edge, TKE fields, gradient condition */
#undef  WEST_KRADIATION   /* Western edge, TKE fields, radiation condition */
#undef  WEST_TGRADIENT    /* Western edge, tracers, gradient condition */
#undef  WEST_TRADIATION   /* Western edge, tracers, radiation condition */
#undef  WEST_TNUDGING     /* Western edge, tracers, passive/active term */
#undef  WEST_TCLAMPED     /* Western edge, tracers, clamped condition */

#undef  NORTH_FSCHAPMAN   /* Northern edge, 2D momentum, Chapman condition */
#undef  NORTH_FSGRADIENT  /* Northern edge, free-surface, gradient condition */
#undef  NORTH_FSRADIATION /* Northern edge, free-surface, radiation condition*/
#undef  NORTH_FSNUDGING   /* Northern edge, free-surface, passive/active term*/
#undef  NORTH_FSCLAMPED   /* Northern edge, free-surface, clamped condition */
#undef  NORTH_M2FLATHER   /* Northern edge, 2D momentum, Flather condition */
#undef  NORTH_M2GRADIENT  /* Northern edge, 2D momentum, gradient condition */
#undef  NORTH_M2RADIATION /* Northern edge, 2D momentum, radiation condition */
#undef  NORTH_M2NUDGING   /* Northern edge, 2D momentum, passive/active term */
#undef  NORTH_M2CLAMPED   /* Northern edge, 2D momentum, clamped condition */
#undef  NORTH_M3GRADIENT  /* Northern edge, 3D momentum, gradient condition */
#undef  NORTH_M3RADIATION /* Northern edge, 3D momentum, radiation condition */
#undef  NORTH_M3NUDGING   /* Northern edge, 3D momentum, passive/active term */
#undef  NORTH_M3CLAMPED   /* Northern edge, 3D momentum, clamped condition */
#undef  NORTH_KGRADIENT   /* Northern edge, TKE fields, gradient condition */
#undef  NORTH_KRADIATION  /* Northern edge, TKE fields, radiation condition */
#undef  NORTH_TGRADIENT   /* Northern edge, tracers, gradient condition */
#undef  NORTH_TRADIATION  /* Northern edge, tracers, radiation condition */
#undef  NORTH_TNUDGING    /* Northern edge, tracers, passive/active term */
#undef  NORTH_TCLAMPED    /* Northern edge, tracers, clamped condition */

#undef  SOUTH_FSCHAPMAN   /* Southern edge, 2D momentum, Chapman condition */
#undef  SOUTH_FSGRADIENT  /* Southern edge, free-surface, gradient condition */
#undef  SOUTH_FSRADIATION /* Southern edge, free-surface, radiation condition*/
#undef  SOUTH_FSNUDGING   /* Southern edge, free-surface, passive/active term*/
#undef  SOUTH_FSCLAMPED   /* Southern edge, free-surface, clamped condition */
#undef  SOUTH_M2FLATHER   /* Southern edge, 2D momentum, Flather condition */
#undef  SOUTH_M2GRADIENT  /* Southern edge, 2D momentum, gradient condition */
#undef  SOUTH_M2RADIATION /* Southern edge, 2D momentum, radiation condition */
#undef  SOUTH_M2NUDGING   /* Southern edge, 2D momentum, passive/active term */
#undef  SOUTH_M2CLAMPED   /* Southern edge, 2D momentum, clamped condition */
#undef  SOUTH_M3GRADIENT  /* Southern edge, 3D momentum, gradient condition */
#undef  SOUTH_M3RADIATION /* Southern edge, 3D momentum, radiation condition */
#undef  SOUTH_M3NUDGING   /* Southern edge, 3D momentum, passive/active term */
#undef  SOUTH_M3CLAMPED   /* Southern edge, 3D momentum, clamped condition */
#undef  SOUTH_KGRADIENT   /* Southern edge, TKE fields, gradient condition */
#undef  SOUTH_KRADIATION  /* Southern edge, TKE fields, radiation condition */
#undef  SOUTH_TGRADIENT   /* Southern edge, tracers, gradient condition */
#undef  SOUTH_TRADIATION  /* Southern edge, tracers, radiation condition */
#undef  SOUTH_TNUDGING    /* Southern edge, tracers, passive/active term */
#undef  SOUTH_TCLAMPED    /* Southern edge, tracers, clamped condition */
/*
**  Process tidal forcing for desired tidal component, classified by
**  period.  The tidal forcing is computed for the full horizontal grid.
**  If requested, the tidal forcing is added to the processed (read and
**  time-interpolated) open boundary data. Also, if applicable, the tidal
**  forcing is added to the climatological array.                  */
#undef  SSH_TIDES       /* turn on computation of tidal elevation */
#undef  UV_TIDES        /* turn on computation of tidal currents !3! */
#undef  TIDES_ASTRO     /* tidal amplitude and phase adjustments */
#undef  ADD_FSOBC       /* Add tidal elevation to processed OBC data */    
#undef ADD_M2OBC       /* Add tidal currents  to processed OBC data !3! */ 
/*                                                                 
**  Turn ON or OFF options for reading and processing of climatological                                                               
**  fields.  The nudging of climatology data is primarily used in sponge
**  areas.
*/ 

#undef  M2CLIMATOLOGY   /* Processing of 2D momentum climatology */

#undef  M3CLIMATOLOGY   /* Processing of 3D momentum climatology */
#undef  OCLIMATOLOGY    /* Processing of omega climatology */      
#undef  TCLIMATOLOGY    /* Processing of tracer climatology */
#undef  ZCLIMATOLOGY    /* Processing of SSH climatology */        

#undef  M2CLM_NUDGING   /* Nudging of 2D momentum climatology */

#undef  M3CLM_NUDGING   /* Nudging of 3D momentum climatology */
#undef  TCLM_NUDGING    /* Nudging of tracer climatology */
#undef  ZCLM_NUDGING    /* Nudging of SSH climatology */

/*
**  Select data assimilation options. The assimilation is via OI and
**  intermittent. Nudging is continuous and observations are time-
**  interpolated. If applicable, choose only one option for each
**  field update: assimilation or nudging.
*/
#undef  ASSIMILATION_SSH   /* assimilation of SSH observations */
#undef  ASSIMILATION_SST   /* assimilation of SST observations */
#undef  ASSIMILATION_T     /* assimilation of tracer observations */
#undef  ASSIMILATION_UVsur /* assimilation of surface current observations */
#undef  ASSIMILATION_UV    /* assimilation of horizontal current observations*/
#undef  UV_BAROCLINIC      /* assimilation of only baroclinic currents */
#undef  NUDGING_SSH        /* nudging of SSH observations */
#undef  NUDGING_SST        /* nudging of SST observations */
#undef  NUDGING_T          /* nudging of tracer observations */
#undef  NUDGING_UVsur      /* nudging of surface current observations */
#undef  NUDGING_UV         /* nudging of horizontal currents observations */
#undef  RANDOM_ESPERT      /* random error subspace perturbations */
/*
**  Fasham-type biology model options.
*/

#undef  BIO_FASHAM         /* Fasham type nitrogen-based model */
#undef  CARBON             /* Add Carbon constituents */
#undef  DENITRIFICATION    /* Add denitrification processes */
#undef  BIO_SEDIMENT       /* Restore fallen material to the nutrient pool */

/*
**  Bio-optical EcoSim model options.
*/

#undef  ECOSIM             /* Bio-optical EcoSim model */

/*
**  Biological model options.
*/

#undef  NPZD1              /* Craig Lewis's 4 box model */
#undef BIO_GOANPZ         /* Sarah Hinckley's 10 box model */
#undef  PASSIVE_TRACERS    /* add 5 tracer boxes that are passive */


#define NEMURO
#define HOLLING_GRAZING
#define BIO_SEDIMENT 
#  define ANA_BIOLOGY       /* analytical biology initial conditions */
#  define ANA_BPFLUX        /* analytical bottom passive tracers fluxes */
#  define ANA_SPFLUX        /* analytical surface passive tracers fluxes */
#       undef TCLM_NUDGING    /* Nudging of tracer climatology */
#       undef  ANA_TCLIMA     /* analytical tracers climatology */
#       undef TCLIMATOLOGY   /* Processing of tracer climatology */


#if defined NPZD1 || defined BIO_GOANPZ || defined PASSIVE_TRACERS
#  undef BIOFLUX           /* sum Nitrogen fluxes between boxes */
#  define ANA_BIOLOGY       /* analytical biology initial conditions */
#  define ANA_BPFLUX        /* analytical bottom passive tracers fluxes */
#  define ANA_SPFLUX        /* analytical surface passive tracers fluxes */
#endif

#ifdef BIO_GOANPZ
#define        NEWSHADE    /* Use Craig''s formulation for self shading in PAR calc
                       Else use Sarah''s self-shading from original NPZ code */
#undef        KODIAK_IRAD /* Generate irradiance with curve matching Kodiak data
                       Else use shortwave radiation (srflx) as irradiance   */

#  undef OFFLINE_BIOLOGY   /* define if offline simulation of bio tracers */
#   if defined OFFLINE_BIOLOGY
#    define AKSCLIMATOLOGY   /* Processing of AKS climatology */
#    undef ANA_AKSCLIMA      /* Processing of AKS climatology */
#   endif
#  undef DIAPAUSE          /* Enable Neocalanus seasonal vertical migration */
#  define  IRON              /* Add iron as passive 13th tracer */
#    if defined IRON
#      if !defined OFFLINE_BIOLOGY
#       define TCLM_NUDGING    /* Nudging of tracer climatology for iron */
#       define  ANA_TCLIMA     /* analytical tracers climatology for iron */
#       define TCLIMATOLOGY   /* Processing of tracer climatology for iron */
#      endif
#    endif 
#define JELLY 
#undef STATIONARY
#undef BENTHIC /*FENNEL or BENTHIC or TRAP*/
#undef SINKVAR      /* for variable sinking rate*/
#undef DENMAN
#endif

/*
**  Sediment transport model options.
*/

#undef  SEDIMENT           /* Activate sediment transport model */

/*
**  NetCDF IO options.
*/

#undef  NO_WRITE_GRID      /* define if not writing grid arrays */
#undef  READ_WATER         /* define if only reading water points data */
#undef  WRITE_WATER        /* define if only writing water points data */
#undef  RST_SINGLE         /* define if single precision restart fields */
#undef  OUT_DOUBLE         /* define if double precision output fields */

/*
**  Flag to process 3D data level by level (2D slabs) to reduce memory
**  needs in distributed-memory configurations. This option is convinient
**  for large problems on nodes with limited memory.
*/
#undef  INLINE_2DIO        /* define if processing 3D IO level by level */

