#!/bin/bash
ENS=1000
cp ana_tair_cgoa_base.h ana_tair_cgoa_$ENS.h
cp Analytical/ana_winds_cgoa.h Analytical/ana_winds.h
cp Analytical/ana_grid_cgoa.h Analytical/ana_grid.h
cp nemuro-jerome-cgoa.in nemuro.in
while [ $ENS -le 1020 ]
do 
echo "ensemble member $ENS"

cp ana_tair_cgoa_$ENS.h Analytical/ana_tair.h

./compileitall.sh
./oceanS-norestart < ocean_nemuro_first_tenyear.in > ocean_nemuro_first_tenyear_cgoa.out

mv ocean_his_nemuro.nc /store/o2/hermann/nemuro-ens-cgoa/ocean_his_nemuro_$ENS.nc
mv ocean_avg_nemuro.nc /store/o2/hermann/nemuro-ens-cgoa/ocean_avg_nemuro_$ENS.nc
mv ocean_rst_nemuro.nc /store/o2/hermann/nemuro-ens-cgoa/ocean_rst_nemuro_$ENS.nc

  awk '{if (NR==118) printf("      %s %s %d\n",$1,$2,$3+1); else print $0}' < ana_tair_cgoa_$ENS.h > ana_tair_cgoa_`expr $ENS + 1`.h
ENS=`expr $ENS + 1`
done
exit
