      SUBROUTINE checkvars (ng, model, ncname, string, Nrec, Nvar,      &
     &                      tvarnam, get_var, have_var)
!
!svn $Id: checkvars.F 526 2008-01-29 01:06:18Z kate $
!================================================== Hernan G. Arango ===
!  Copyright (c) 2002-2008 The ROMS/TOMS Group                         !
!    Licensed under a MIT/X style license                              !
!    See License_ROMS.txt                                              !
!=======================================================================
!                                                                      !
!  This routine checks if needed state variables are available in      !
!  requested NetCDF file.                                              !
!                                                                      !
!  On Input:                                                           !
!                                                                      !
!     ng         Nested grid number.                                   !
!     model      Calling model identifier.                             !
!     ncname     NetCDF file name.                                     !
!     string     Identification string.                                !
!     Nrec       Number of time records available.                     !
!     Nvar       Size of logical switches arrays.                      !
!                                                                      !
!  On Output:                                                          !
!                                                                      !
!     tvarnam    Name of time record variable.                         !
!     get_var    Logical switches (T/F), in terms of variable ID,      !
!                  indicating state variables needed by the model.     !
!     have_var   Logical switches (T/F), in terms of variable ID,      !
!                  indicating state variables available in NetCDF      !
!                  file.                                               !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_scalars
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model, Nvar
      integer, intent(inout) :: Nrec
      character (len=*), intent(in) :: ncname
      character (len=*), intent(in) :: string
      character (len=*), intent(inout) :: tvarnam
      logical, dimension(Nvar), intent(out) :: get_var
      logical, dimension(Nvar), intent(out) :: have_var
!
!  Local variable declarations.
!
      integer :: i, itrc, nvd
      integer, dimension(4) :: Vsize
      character (len=80) :: fname
!
!-----------------------------------------------------------------------
!  Determine state variables needed and check if they are available in
!  requested NetCDF file.
!-----------------------------------------------------------------------
!
!  Inquire about the contents of input NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!
      IF (InpThread) THEN
        CALL opencdf (ng, 1, ncname, fname, N(ng), 0, Nrec, nvd, Vsize)
        IF (exit_flag.ne.NoError) RETURN
      END IF
!
!  Initialize logical switches.
!
      DO i=1,Nvar
        get_var(i)=.FALSE.
        have_var(i)=.FALSE.
      END DO
!
!  Determine state variables to read from input NetCDF file.
!
      get_var(idFsur)=.TRUE.
      get_var(idUbar)=.TRUE.
      get_var(idVbar)=.TRUE.
      get_var(idUvel)=.TRUE.
      get_var(idVvel)=.TRUE.
      DO itrc=1,NAT
        get_var(idTvar(itrc))=.TRUE.
      END DO
!
!  Scan variable list from input NetCDF and activate switches for
!  model state variables.
!
      IF (InpThread) THEN
        DO i=1,nvars
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idtime))) THEN
            tvarnam=TRIM(varnam(i))
            have_var(idtime)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idFsur))) THEN
            have_var(idFsur)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idRzet))) THEN
            have_var(idRzet)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idUbar))) THEN
            have_var(idUbar)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idRu2d))) THEN
            have_var(idRu2d)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idVbar))) THEN
            have_var(idVbar)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idRv2d))) THEN
            have_var(idRv2d)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idKhor))) THEN
            have_var(idKhor)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idKver))) THEN
            have_var(idKver)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idUvel))) THEN
            have_var(idUvel)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idRu3d))) THEN
            have_var(idRu3d)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idVvel))) THEN
            have_var(idVvel)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idRv3d))) THEN
            have_var(idRv3d)=.TRUE.
          END IF
          DO itrc=1,NT(ng)
            IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idTvar(itrc)))) THEN
              have_var(idTvar(itrc))=.TRUE.
            END IF
          END DO
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idVvis))) THEN
            have_var(idVvis)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idTdif))) THEN
            have_var(idTdif)=.TRUE.
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idSdif))) THEN
            have_var(idSdif)=.TRUE.
          END IF
        END DO
!
!  Check if model state variables are available in input NetCDF file.
!
        IF (.not.have_var(idtime)) THEN
          WRITE (stdout,10) string, TRIM(tvarnam), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idFsur).and.get_var(idFsur)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idFsur)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idRzet).and.get_var(idRzet)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idRzet)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idUbar).and.get_var(idUbar)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idUbar)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idRu2d).and.get_var(idRu2d)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idRu2d)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idVbar).and.get_var(idVbar)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idVbar)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idRv2d).and.get_var(idRv2d)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idRv2d)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idUvel).and.get_var(idUvel)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idUvel)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idRu3d).and.get_var(idRu3d)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idRu3d)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idVvel).and.get_var(idVvel)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idVvel)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        IF (.not.have_var(idRv3d).and.get_var(idRv3d)) THEN
          WRITE (stdout,10) string, TRIM(Vname(1,idRv3d)), TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
        DO itrc=1,NT(ng)
          IF (.not.have_var(idTvar(itrc)).and.                          &
     &        get_var(idTvar(itrc))) THEN
            WRITE (stdout,10) string, TRIM(Vname(1,idTvar(itrc))),      &
     &                        TRIM(ncname)
            exit_flag=2
            RETURN
          END IF
        END DO
      END IF
  10  FORMAT (/,a,'CHECKVARS  - unable to find model variable: ',a,     &
     &        /,17x,'in input NetCDF file: ',a)
      RETURN
      END SUBROUTINE checkvars
