      SUBROUTINE get_grid (ng, model)
!
!svn $Id: get_grid.F 588 2008-03-21 23:09:01Z kate $
!================================================== Hernan G. Arango ===
!  Copyright (c) 2002-2008 The ROMS/TOMS Group                         !
!    Licensed under a MIT/X style license                              !
!    See License_ROMS.txt                                              !
!=======================================================================
!                                                                      !
!  This subroutine reads grid information from GRID NetCDF file.       !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_grid
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_scalars
!
      USE exchange_2d_mod
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model
!
!  Local variable declarations.
!
      logical :: gotang = .FALSE.
      logical :: gotel = .FALSE.
      logical :: gotf = .FALSE.
      logical :: gotdm = .FALSE.
      logical :: gotdn = .FALSE.
      logical :: goth = .FALSE.
      logical :: gotlatp = .FALSE.
      logical :: gotlatr = .FALSE.
      logical :: gotlatu = .FALSE.
      logical :: gotlatv = .FALSE.
      logical :: gotlonp = .FALSE.
      logical :: gotlonr = .FALSE.
      logical :: gotlonu = .FALSE.
      logical :: gotlonv = .FALSE.
      logical :: gotpm = .FALSE.
      logical :: gotpn = .FALSE.
      logical :: gotsph = .FALSE.
      logical :: gotxl = .FALSE.
      logical :: gotxp = .FALSE.
      logical :: gotxr = .FALSE.
      logical :: gotxu = .FALSE.
      logical :: gotxv = .FALSE.
      logical :: gotyp = .FALSE.
      logical :: gotyr = .FALSE.
      logical :: gotyu = .FALSE.
      logical :: gotyv = .FALSE.
      integer :: tile, LBi, UBi, LBj, UBj
      integer :: grdangid, grdelid, grdfid, grddmid, grddnid
      integer :: grdhid, grdpmid, grdpnid
      integer :: grdlatpid, grdlatrid, grdlatuid, grdlatvid
      integer :: grdlonpid, grdlonrid, grdlonuid, grdlonvid
      integer :: grdsphid, grdxlid
      integer :: grdxpid, grdxrid, grdxuid, grdxvid
      integer :: grdypid, grdyrid, grdyuid, grdyvid
      integer :: gtype, i, nrec, nvd, status
      integer :: Vsize(4)
      integer :: nf_fread2d
      real(r8), parameter :: Fscl = 1.0_r8
      real(r8) :: Fmax, Fmin
      character (len=1 ) :: char1
      character (len=80) :: fname, ncname
!
!-----------------------------------------------------------------------
!  Inquire about the contents of grid NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!-----------------------------------------------------------------------
!
      IF (exit_flag.ne.NoError) RETURN
      ncname=GRDname(ng)
      CALL opencdf (ng, 1, ncname, fname, N(ng), 0, nrec, nvd, Vsize)
      IF (exit_flag.ne.NoError) RETURN
!
!  Set Vsize to zero to deativate interpolation of input data to model
!  grid in "nf_fread2d".
!
      DO i=1,4
        Vsize(i)=0
      END DO
!
!  Scan variable list from input NetCDF and check for grid variables.
!
      DO i=1,nvars
        IF (TRIM(varnam(i)).eq.'xl') THEN
          grdxlid=i
          gotxl=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'el') THEN
          grdelid=i
          gotel=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'spherical') THEN
          grdsphid=i
          gotsph=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'h') THEN
          grdhid=i
          goth=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'f') THEN
          grdfid=i
          gotf=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'pm') THEN
          grdpmid=i
          gotpm=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'pn') THEN
          grdpnid=i
          gotpn=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'dndx') THEN
          grddnid=i
          gotdn=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'dmde') THEN
          grddmid=i
          gotdm=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'x_psi') THEN
          grdxpid=i
          gotxp=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'x_rho') THEN
          grdxrid=i
          gotxr=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'x_u') THEN
          grdxuid=i
          gotxu=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'x_v') THEN
          grdxvid=i
          gotxv=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'y_psi') THEN
          grdypid=i
          gotyp=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'y_rho') THEN
          grdyrid=i
          gotyr=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'y_u') THEN
          grdyuid=i
          gotyu=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'y_v') THEN
          grdyvid=i
          gotyv=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lon_psi') THEN
          grdlonpid=i
          gotlonp=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lon_rho') THEN
          grdlonrid=i
          gotlonr=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lon_u') THEN
          grdlonuid=i
          gotlonu=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lon_v') THEN
          grdlonvid=i
          gotlonv=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lat_psi') THEN
          grdlatpid=i
          gotlatp=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lat_rho') THEN
          grdlatrid=i
          gotlatr=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lat_u') THEN
          grdlatuid=i
          gotlatu=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'lat_v') THEN
          grdlatvid=i
          gotlatv=.TRUE.
        ELSE IF (TRIM(varnam(i)).eq.'angle') THEN
          grdangid=i
          gotang=.TRUE.
        END IF
      END DO
!
!  Terminate execution if essential grid variables are not found.
!
      IF (.not.gotxl) THEN
        WRITE (stdout,10) 'xl', TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
      IF (.not.gotel) THEN
        WRITE (stdout,10) 'el', TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
      IF (.not.gotsph) THEN
        WRITE (stdout,10) 'spherical', TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
      IF (.not.goth) THEN
        WRITE (stdout,10) 'h', TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
      IF (.not.gotf) THEN
        WRITE (stdout,10) 'f', TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
      IF (.not.gotpm) THEN
        WRITE (stdout,10) 'pm', TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
      IF (.not.gotpn) THEN
        WRITE (stdout,10) 'pn', TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
!
!  Open grid NetCDF file for reading.
!
      IF (ncGRDid(ng).eq.-1) THEN
        status=nf90_open(TRIM(ncname), nf90_nowrite, ncGRDid(ng))
        IF (status.ne.nf90_noerr) THEN
          WRITE (stdout,20) TRIM(ncname)
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
!
!-----------------------------------------------------------------------
!  Read in grid parameters.
!-----------------------------------------------------------------------
!
!  Read in basin lengths.
!
      status=nf90_get_var(ncGRDid(ng), grdxlid, xl(ng))
      IF (status.ne.nf90_noerr) THEN
        WRITE (stdout,30) 'xl', TRIM(ncname)
        exit_flag=2
        ioerror=status
        RETURN
      END IF
      status=nf90_get_var(ncGRDid(ng), grdelid, el(ng))
      IF (status.ne.nf90_noerr) THEN
        WRITE (stdout,30) 'el', TRIM(ncname)
        exit_flag=2
        ioerror=status
        RETURN
      END IF
!
!  Read in logical switch for spherical grid configuration.
!
      status=nf90_get_var(ncGRDid(ng), grdsphid, char1)
      IF (status.ne.nf90_noerr) THEN
        WRITE (stdout,30) 'spherical', TRIM(ncname)
        exit_flag=2
        ioerror=status
        RETURN
      END IF
      IF ((char1.eq.'t').or.(char1.eq.'T')) THEN
        spherical=.TRUE.
      ELSE
        spherical=.FALSE.
      END IF
!
!-----------------------------------------------------------------------
!  Read in grid arrays.
!-----------------------------------------------------------------------
!
      tile=-1
      LBi=LBOUND(GRID(ng)%h,DIM=1)
      UBi=UBOUND(GRID(ng)%h,DIM=1)
      LBj=LBOUND(GRID(ng)%h,DIM=2)
      UBj=UBOUND(GRID(ng)%h,DIM=2)
!
!  Read in bathymetry.
!
      gtype=r2dvar
      status=nf_fread2d(ng, model, ncGRDid(ng), grdhid, 0, gtype,       &
     &                  Vsize, LBi, UBi, LBj, UBj,                      &
     &                  Fscl, hmin(ng), hmax(ng),                       &
     &                  GRID(ng) % h(LBi,LBj))
      IF (status.ne.nf90_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,30) 'h', TRIM(ncname)
        END IF
        exit_flag=2
        ioerror=status
        RETURN
      END IF
      CALL exchange_r2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        GRID(ng) % h)
!
!  Read in Coriolis parameter.
!
      gtype=r2dvar
      status=nf_fread2d(ng, model, ncGRDid(ng), grdfid, 0, gtype,       &
     &                  Vsize, LBi, UBi, LBj, UBj,                      &
     &                  Fscl, Fmin, Fmax,                               &
     &                  GRID(ng) % f(LBi,LBj))
      IF (status.ne.nf90_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,30) 'f', TRIM(ncname)
        END IF
        exit_flag=2
        ioerror=status
        RETURN
      END IF
      CALL exchange_r2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        GRID(ng) % f)
!
!  Read in coordinate transfomation metrics (m,n) associated with the
!  differential distances in XI and ETA.
!
      gtype=r2dvar
      status=nf_fread2d(ng, model, ncGRDid(ng), grdpmid, 0, gtype,      &
     &                  Vsize, LBi, UBi, LBj, UBj,                      &
     &                  Fscl, Fmin, Fmax,                               &
     &                  GRID(ng) % pm(LBi,LBj))
      IF (status.ne.nf90_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,30) 'pm', TRIM(ncname)
        END IF
        exit_flag=2
        ioerror=status
        RETURN
      END IF
      gtype=r2dvar
      status=nf_fread2d(ng, model, ncGRDid(ng), grdpnid, 0, gtype,      &
     &                  Vsize, LBi, UBi, LBj, UBj,                      &
     &                  Fscl, Fmin, Fmax,                               &
     &                  GRID(ng) % pn(LBi,LBj))
      IF (status.ne.nf90_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,30) 'pn', TRIM(ncname)
        END IF
        exit_flag=2
        ioerror=status
        RETURN
      END IF
      CALL exchange_r2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        GRID(ng) % pm)
      CALL exchange_r2d_tile (ng, tile,                                 &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        GRID(ng) % pn)
!
!  Read in (x,y) coordinates at PSI-points.
!
      IF (gotxp) THEN
        gtype=p2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdxpid, 0, gtype,    &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % xp(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'x_p', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
      IF (gotyp) THEN
        gtype=p2dvar
        status=nf_fread2d(ng, model,  ncGRDid(ng), grdypid, 0, gtype,   &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % yp(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'y_p', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
!
!  Read in (x,y) coordinates at RHO-points.
!
      IF (gotxr) THEN
        gtype=r2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdxrid, 0, gtype,    &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % xr(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'x_rho', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
      IF (gotyr) THEN
        gtype=r2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdyrid, 0, gtype,    &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % yr(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'y_rho', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
!
!  Read in (x,y) coordinates at U-points.
!
      IF (gotxu) THEN
        gtype=u2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdxuid, 0, gtype,    &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % xu(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'x_u', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
      IF (gotyu) THEN
        gtype=u2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdyuid, 0, gtype,    &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % yu(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'y_u', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
!
!  Read in (x,y) coordinates at V-points.
!
      IF (gotxv) THEN
        gtype=v2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdxvid, 0, gtype,    &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % xv(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'x_v', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
      IF (gotyv) THEN
        gtype=v2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdyvid, 0, gtype,    &
     &                    Vsize, LBi, UBi, LBj, UBj,                    &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % yv(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'y_v', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
      END IF
!
!  Read in (lon,lat) coordinates at PSI-points.
!
      IF (spherical) THEN
        IF (gotlonp) THEN
          gtype=p2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlonpid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, Fmin, Fmax,                           &
     &                      GRID(ng) % lonp(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lon_psi', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
        IF (gotlatp) THEN
          gtype=p2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlatpid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, Fmin, Fmax,                           &
     &                      GRID(ng) % latp(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lat_psi', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
      END IF
!
!  Read in (lon,lat) coordinates at RHO-points.
!
      IF (spherical) THEN
        IF (gotlonr) THEN
          gtype=r2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlonrid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, LonMin(ng), LonMax(ng),               &
     &                      GRID(ng) % lonr(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lon_rho', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
        IF (gotlatr) THEN
          gtype=r2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlatrid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, LatMin(ng), LatMax(ng),               &
     &                      GRID(ng) % latr(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lat_rho', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
      END IF
!
!  Read in (lon,lat) coordinates at U-points.
!
      IF (spherical) THEN
        IF (gotlonu) THEN
          gtype=u2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlonuid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, Fmin, Fmax,                           &
     &                      GRID(ng) % lonu(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lon_u', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
        IF (gotlatu) THEN
          gtype=u2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlatuid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, Fmin, Fmax,                           &
     &                      GRID(ng) % latu(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lat_u', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
      END IF
!
!  Read in (lon,lat) coordinates at V-points.
!
      IF (spherical) THEN
        IF (gotlonv) THEN
          gtype=v2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlonvid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, Fmin, Fmax,                           &
     &                      GRID(ng) % lonv(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lon_v', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
        IF (gotlatv) THEN
          gtype=v2dvar
          status=nf_fread2d(ng, model, ncGRDid(ng), grdlatvid, 0,       &
     &                      gtype, Vsize, LBi, UBi, LBj, UBj,           &
     &                      Fscl, Fmin, Fmax,                           &
     &                      GRID(ng) % latv(LBi,LBj))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              WRITE (stdout,30) 'lat_v', TRIM(ncname)
            END IF
            exit_flag=2
            ioerror=status
            RETURN
          END IF
        END IF
      END IF
!
!  Read in angle (radians) between XI-axis and EAST at RHO-points.
!
      IF (gotang) THEN
        gtype=r2dvar
        status=nf_fread2d(ng, model, ncGRDid(ng), grdangid, 0,          &
     &                    gtype, Vsize, LBi, UBi, LBj, UBj,             &
     &                    Fscl, Fmin, Fmax,                             &
     &                    GRID(ng) % angler(LBi,LBj))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,30) 'angle', TRIM(ncname)
          END IF
          exit_flag=2
          ioerror=status
          RETURN
        END IF
        CALL exchange_r2d_tile (ng, tile,                               &
     &                          LBi, UBi, LBj, UBj,                     &
     &                          GRID(ng) % angler)
      END IF
!
! Close GRID NetCDF file.
!
      status=nf90_close(ncGRDid(ng))
      ncGRDid(ng)=-1
!
  10  FORMAT (/,' GET_GRID - unable to find grid variable: ',a,         &
     &        /,12x,'in grid NetCDF file: ',a)
  20  FORMAT (/,' GET_GRID - unable to open grid NetCDF file: ',a)
  30  FORMAT (/,' GET_GRID - error while reading variable: ',a,         &
     &        /,12x,'in grid NetCDF file: ',a)
      RETURN
      END SUBROUTINE get_grid
