      FUNCTION nf_fread4d (ng, model, ncid, ncvarid, tindex, gtype,     &
     &                     Vsize,                                       &
     &                     LBi, UBi, LBj, UBj, LBk, UBk, LBt, UBt,      &
     &                     Ascl, Amin, Amax,                            &
     &                     A)
!
!svn $Id: nf_fread4d.F 526 2008-01-29 01:06:18Z kate $
!================================================== Hernan G. Arango ===
!  Copyright (c) 2002-2008 The ROMS/TOMS Group                         !
!    Licensed under a MIT/X style license                              !
!    See License_ROMS.txt                                              !
!=======================================================================
!                                                                      !
!  This function reads in a generic floating point 4D array from an    !
!  input NetCDF file.                                                  !
!                                                                      !
!  On Input:                                                           !
!                                                                      !
!     ng         Nested grid number.                                   !
!     model      Calling model identifier.                             !
!     ncid       NetCDF file ID.                                       !
!     ncvarid    NetCDF variable ID.                                   !
!     tindex     NetCDF time record index to read (integer).           !
!     gtype      Grid type.                                            !
!     Vsize      Variable dimensions in NetCDF file.                   !
!     LBi        I-dimension Lower bound.                              !
!     UBi        I-dimension Upper bound.                              !
!     LBj        J-dimension Lower bound.                              !
!     UBj        J-dimension Upper bound.                              !
!     LBk        K-dimension Lower bound.                              !
!     UBk        K-dimension Upper bound.                              !
!     LBt        Time-dimension Lower bound.                           !
!     UBt        Time-dimension Upper bound.                           !
!     Ascl       Factor to scale field after reading (real).           !
!     Amask      Land/Sea mask, if any (real).                         !
!                                                                      !
!  On Output:                                                          !
!                                                                      !
!     Amin       Field minimum value (real).                           !
!     Amax       Field maximum value (real).                           !
!     A          Field to read in (real).                              !
!     nf_fread4d Error flag (integer).                                 !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_ncparam
      USE mod_netcdf
      USE mod_scalars
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model, ncid, ncvarid, tindex
      integer, intent(in) :: LBi, UBi, LBj, UBj, LBk, UBk, LBt, UBt
      integer, intent(in) :: Vsize(4)
      integer, intent(in) :: gtype
      real(r8), intent(in)  :: Ascl
      real(r8), intent(out) :: Amin
      real(r8), intent(out) :: Amax
      real(r8), intent(out) :: A(LBi:UBi,LBj:UBj,LBk:UBk,LBt:UBt)
!
!  Local variable declarations.
!
      integer :: i, j, k, ic, fourth, Npts, NWpts, status, wtype
      integer :: Imin, Imax, Jmin, Jmax, Loff
      integer :: Ilen, Jlen, Klen, IJlen, MyType, Nghost
      integer, dimension(5) :: start, total
      integer :: nf_fread4d
      real(r8) :: BIG = 1.0E+35_r8
      real(r8) :: Aval
      real(r8), dimension(2+(Lm(ng)+2)*(Mm(ng)+2)*(UBk-LBk+1)) :: wrk
!
!-----------------------------------------------------------------------
!  Set starting and ending indices to process.
!-----------------------------------------------------------------------
      MyType=gtype
!
!  Set first and last grid point according to staggered C-grid
!  classification. Set loops offsets.  Notice that Nghost is set
!  to zero when processing an adjoint solution.  Therefore, the
!  ghost points will be not assigned in mp_scatter. This is the
!  correct adjoint solution reading.  The ghost points are then
!  assumed to be zero.
!
      Imin=0
      Imax=Lm(ng)+1
      Jmin=0
      Jmax=Mm(ng)+1
      MyType=gtype
      IF (model.eq.iADM) THEN
        Nghost=0
      ELSE  
        Nghost=2
      END IF
      IF ((ABS(MyType).eq.p3dvar).or.(ABS(MyType).eq.u3dvar)) THEN
        Imin=1
      END IF
      IF ((ABS(MyType).eq.p3dvar).or.(ABS(MyType).eq.v3dvar)) THEN
        Jmin=1
      END IF
      IF (LBt.eq.0) THEN
        Loff=1
      ELSE
        Loff=0
      END IF
      Ilen=Imax-Imin+1
      Jlen=Jmax-Jmin+1
      Klen=UBk-LBk+1
      IJlen=Ilen*Jlen
!
!-----------------------------------------------------------------------
!  Read in requested field and scale it.
!-----------------------------------------------------------------------
!
!  Proccess data as 3D slides.
!
      Amin=BIG
      Amax=-BIG
      DO fourth=LBt,UBt
        IF (MyType.gt.0) THEN
          start(1)=1
          total(1)=Ilen
          start(2)=1
          total(2)=Jlen
          start(3)=1
          total(3)=Klen
          start(4)=fourth+Loff
          total(4)=1
          start(5)=tindex
          total(5)=1
          Npts=IJlen*Klen
        END IF
        status=nf90_noerr
        IF (InpThread) THEN
          status=nf90_get_var(ncid, ncvarid, wrk, start, total)
          IF (status.eq.nf90_noerr) THEN
            DO i=1,Npts
              wrk(i)=Ascl*wrk(i)
              Amin=MIN(Amin,wrk(i))
              Amax=MAX(Amax,wrk(i))
            END DO
          END IF
        END IF          
        IF (status.ne.nf90_noerr) THEN
          nf_fread4d=status
          RETURN
        END IF
!
!-----------------------------------------------------------------------
!  Unpack read field.
!-----------------------------------------------------------------------
!
        IF (MyType.gt.0) THEN
          ic=0
          DO k=LBk,UBk
            DO j=Jmin,Jmax
              DO i=Imin,Imax
                ic=ic+1
                A(i,j,k,fourth)=wrk(ic)
              END DO
            END DO
          END DO
        END IF
      END DO
      nf_fread4d=status
      RETURN
      END FUNCTION nf_fread4d
