#include "cppdefs.h"
      MODULE smagorinsky_mod
#if defined UV_VIS2 && defined SMAGORINSKY

      implicit none

      PRIVATE
      PUBLIC  :: smagorinsky

      CONTAINS
!
!***********************************************************************
      SUBROUTINE smagorinsky (ng, tile)
!***********************************************************************
!
      USE mod_param
      USE mod_grid
      USE mod_mixing
      USE mod_ocean
      USE mod_stepping
!
      integer, intent(in) :: ng, tile

# include "tile.h"
!
#ifdef PROFILE
      CALL wclock_on (ng, iNLM, 30)
#endif
      CALL smagorinsky_tile (ng, tile,                                  &
     &                     LBi, UBi, LBj, UBj,                          &
     &                     nrhs(ng),                                    &
     &                     GRID(ng) % pm,                               &
     &                     GRID(ng) % pn,                               &
     &                     OCEAN(ng) % u,                               &
     &                     OCEAN(ng) % v,                               &
     &                     MIXING(ng) % visc3d_p,                       &
     &                     MIXING(ng) % visc3d_r)

# ifdef PROFILE
      CALL wclock_off (ng, iNLM, 30)
# endif
      RETURN
      END SUBROUTINE smagorinsky
!
!***********************************************************************
      SUBROUTINE smagorinsky_tile (ng, tile,                            &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           nrhs,                                  &
     &                           pm, pn, u, v, visc3d_p, visc3d_r)
!***********************************************************************
!
      USE mod_param
      USE mod_scalars

# if defined EW_PERIODIC || defined NS_PERIODIC
      USE exchange_3d_mod
# endif
# ifdef DISTRIBUTE
      USE mp_exchange_mod, ONLY : mp_exchange3d
# endif
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: nrhs

#ifdef ASSUMED_SHAPE
      real(r8), intent(in) :: pm(LBi:,LBj:)
      real(r8), intent(in) :: pn(LBi:,LBj:)
      real(r8), intent(in) :: u(LBi:,LBj:,:,:)
      real(r8), intent(in) :: v(LBi:,LBj:,:,:)
      real(r8), intent(out) :: visc3d_p(LBi:,LBj:,:)
      real(r8), intent(out) :: visc3d_r(LBi:,LBj:,:)
#else
      real(r8), intent(in) :: pm(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: pn(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: u(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(in) :: v(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(out) :: visc3d_p(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(out) :: visc3d_r(LBi:UBi,LBj:UBj,N(ng))

#endif
!
!  Local variable declarations.
!
      integer :: i, j, k
!
!---------------------------------------------------------------
!  Smagorinsky diffusivity coefficient
!
!  The POM formulation is used:
!    A = C*DX*DY*0.5*sqrt[du/dx^2 +dvdy^2 + 0.5(dvdx+dudy)^2]
!---------------------------------------------------------------
!
!      real(r8), parameter :: horcon = 0.02_r8
      real(r8), parameter :: horcon = 0.1_r8

#  include "set_bounds.h"
!
!  Viscosity at RHO points
!
!
      do k=1,N(ng)
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            visc3d_r(i,j,k)=(horcon/(pm(i,j)*pn(i,j)))                  &
     &         *SQRT( ((u(i+1,j,k,nrhs)-u(i,j,k,nrhs))*pm(i,j))**2      &
     &               +((v(i,j+1,k,nrhs)-v(i,j,k,nrhs))*pn(i,j))**2      &
     &               +0.5_r8*(0.25_r8*pn(i,j)*(                         &
     &                     u(i,j+1,k,nrhs)+u(i+1,j+1,k,nrhs)            &
     &                    -u(i,j-1,k,nrhs)-u(i+1,j-1,k,nrhs))           &
     &                   + 0.25_r8*pm(i,j)*(                            &
     &                     v(i+1,j,k,nrhs)+v(i+1,j+1,k,nrhs)            &
     &                    -v(i-1,j,k,nrhs)-v(i-1,j+1,k,nrhs)) )**2)
          enddo
        enddo
      enddo
!
! Boundary conditions
!
      if (WESTERN_EDGE) then
        do k=1,N(ng)
          do j=JstrV-1,Jend
            visc3d_r(Istr-1,j,k)=visc3d_r(Istr,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=1,N(ng)
          do j=JstrV-1,Jend
            visc3d_r(Iend+1,j,k)=visc3d_r(Iend,j,k)
          enddo
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do k=1,N(ng)
          do i=IstrU-1,Iend
            visc3d_r(i,Jstr-1,k)=visc3d_r(i,Jstr,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=1,N(ng)
          do i=IstrU-1,Iend
            visc3d_r(i,Jend+1,k)=visc3d_r(i,Jend,k)
          enddo
        enddo
      endif
!
! Corners
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N(ng)
          visc3d_r(Istr-1,Jstr-1,k)=0.5_r8*                             &
     &                          ( visc3d_r(Istr,Jstr-1,k)               &
     &                           +visc3d_r(Istr-1,Jstr,k))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N(ng)
          visc3d_r(Iend+1,Jstr-1,k)=0.5_r8*                             &
     &                          (visc3d_r(Iend,Jstr-1,k)                &
     &                          +visc3d_r(Iend+1,Jstr,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N(ng)
          visc3d_r(Istr-1,Jend+1,k)=0.5_r8*                             &
     &                          ( visc3d_r(Istr,Jend+1,k)               &
     &                           +visc3d_r(Istr-1,Jend,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N(ng)
          visc3d_r(Iend+1,Jend+1,k)=0.5_r8*                             &
     &                          ( visc3d_r(Iend,Jend+1,k)               &
     &                           +visc3d_r(Iend+1,Jend,k))
        enddo
      endif
!
!  Viscosity at PSI points
!
      do k=1,N(ng)
        do j=Jstr,JendR
          do i=Istr,IendR
            visc3d_p(i,j,k)=0.25_r8*                                    &
     &                  ( visc3d_r(i,j  ,k)+visc3d_r(i-1,j  ,k)         &
     &                   +visc3d_r(i,j-1,k)+visc3d_r(i-1,j-1,k))
          enddo
        enddo
      enddo

# if defined EW_PERIODIC || defined NS_PERIODIC
      CALL exchange_r3d_tile (ng, tile                                  &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        visc3d_r)
      CALL exchange_p3d_tile (ng, tile                                  &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        visc3d_p)
# endif
#  ifdef DISTRIBUTE
      CALL mp_exchange3d (ng, tile, iNLM, 2,                            &
     &                    LBi, UBi, LBj, UBj, 1, N(ng),                 &
     &                    NghostPoints, EWperiodic, NSperiodic,         &
     &                    visc3d_r, visc3d_p)
#  endif
      RETURN
      END SUBROUTINE smagorinsky_tile
#endif
      END MODULE smagorinsky_mod
