#include "cppdefs.h"
#ifdef FILTERED_RST
      SUBROUTINE def_filt (ng)
!
!=======================================================================
!  Copyright (c) 2002-2008 The ROMS/TOMS Group                         !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine creates filter NetCDF file, it defines its             !
!  dimensions, attributes, and variables.                              !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_filter
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_scalars
# ifdef DISTRIBUTE
      USE distribute_mod, ONLY : mp_bcasti
# endif
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng
!
!  Local variable declarations.
!
      integer, parameter :: Natt = 24

      logical :: Ldefine, got_var(NV)

      integer :: i, j, ifield, nrec, nvd3, nvd4
      integer :: recdim, status, ifile, varid

      integer :: DimIDs(28), t2dgrd(3), u2dgrd(3), v2dgrd(3)

      integer :: def_info, def_var, wrt_info

# ifdef SOLVE3D
      integer :: itrc

      integer :: b3dgrd(4), t3dgrd(4), u3dgrd(4), v3dgrd(4), w3dgrd(4)
# endif

      real(r8) :: Aval(6)

      character (len=80) :: Vinfo(Natt)
      character (len=80) :: fname, ncname
!
!=======================================================================
!  Create a new filter NetCDF file.
!=======================================================================
!
!  Activate creation of filter NetCDF file.  Create a new filter
!  file if during a restart run, the filter filename "FILname"
!  is different than the restart filename "RSTname".  I would prefer to
!  not create a new filter file during a restart run, but simply write to 
!  one assumed to have been created before, but this doesn't work yet.
!
      DO ifile = 1,nfile
        IF (exit_flag.ne.NoError) RETURN
        ncname=FILname(ifile,ng)
        Ldefine=.FALSE.
        IF (((nrrec(ng).eq.0).and.(iic(ng).eq.ntstart(ng))).or.         &
     &      ((nrrec(ng).ne.0).and.(TRIM(ncname).ne.TRIM(RSTname(ng))))) THEN
          Ldefine=.TRUE.
        END IF
!
        IF (Ldefine.and.OutThread) THEN
          status=nf90_create(TRIM(ncname), nf90_clobber,                &
     &          ncFILid(ifile,ng))
          IF (status.ne.nf90_noerr) THEN
            WRITE (stdout,10) TRIM(ncname)
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
# ifdef DISTRIBUTE
        CALL mp_bcasti (ng, iNLM, ncFILid(ifile,ng), 1)
# endif
      END DO
!
!-----------------------------------------------------------------------
!  Define the dimensions of staggered fields.
!-----------------------------------------------------------------------
!
      IF (Ldefine.and.OutThread) THEN
      DO ifile=1,nfile
        status=nf90_def_dim(ncFILid(ifile,ng),'xi_rho'  ,Lm(ng)+2,      &
     &                    DimIDs( 1))
        status=nf90_def_dim(ncFILid(ifile,ng),'xi_u'    ,Lm(ng)+1,      &
     &                    DimIDs( 2))
        status=nf90_def_dim(ncFILid(ifile,ng),'xi_v'    ,Lm(ng)+2,      &
     &                    DimIDs( 3))
        status=nf90_def_dim(ncFILid(ifile,ng),'xi_psi'  ,Lm(ng)+1,      &
     &                    DimIDs( 4))
        status=nf90_def_dim(ncFILid(ifile,ng),'eta_rho' ,Mm(ng)+2,      &
     &                    DimIDs( 5))
        status=nf90_def_dim(ncFILid(ifile,ng),'eta_u'   ,Mm(ng)+2,      &
     &                    DimIDs( 6))
        status=nf90_def_dim(ncFILid(ifile,ng),'eta_v'   ,Mm(ng)+1,      &
     &                    DimIDs( 7))
        status=nf90_def_dim(ncFILid(ifile,ng),'eta_psi' ,Mm(ng)+1,      &
     &                    DimIDs( 8))
# if defined WRITE_WATER && defined MASKING
        status=nf90_def_dim(ncFILid(ifile,ng),'xy_rho'  ,Nxyr(ng),      &
     &                    DimIDs(17))
        status=nf90_def_dim(ncFILid(ifile,ng),'xy_u'    ,Nxyu(ng),      &
     &                    DimIDs(18))
        status=nf90_def_dim(ncFILid(ifile,ng),'xy_v'    ,Nxyv(ng),      &
     &                    DimIDs(19))
# endif
# ifdef SOLVE3D
#  if defined WRITE_WATER && defined MASKING
        status=nf90_def_dim(ncFILid(ifile,ng),'xyz_rho' ,Nxyr(ng)*N(ng),&
     &                    DimIDs(20))
        status=nf90_def_dim(ncFILid(ifile,ng),'xyz_u'   ,Nxyu(ng)*N(ng),&
     &                    DimIDs(21))
        status=nf90_def_dim(ncFILid(ifile,ng),'xyz_v' ,Nxyv(ng)*N(ng),  &
     &                    DimIDs(22))
        status=nf90_def_dim(ncFILid(ifile,ng),'xyz_w' ,                 &
     &                    Nxyr(ng)*(N(ng)+1), DimIDs(23))
#  endif
        status=nf90_def_dim(ncFILid(ifile,ng),'s_rho'   ,N(ng),         &
     &                    DimIDs( 9))
        status=nf90_def_dim(ncFILid(ifile,ng),'s_w'     ,N(ng)+1,       &
     &                    DimIDs(10))
        status=nf90_def_dim(ncFILid(ifile,ng),'tracer'  ,NT(ng),        &
     &                    DimIDs(11))
# endif
        status=nf90_def_dim(ncFILid(ifile,ng),'boundary',4,             &
     &                    DimIDs(14))
        status=nf90_def_dim(ncFILid(ifile,ng),'filterLevel',            &
     &                    nf90_unlimited, DimIDs(28))
!        status=nf90_def_dim(ncFILid(ifile,ng),                            &
!     &                    TRIM(ADJUSTL(Vname(5,idtime))),               &
!     &                    nf90_unlimited,DimIDs(12))
        recdim=DimIDs(28)
      END DO
!
!  Set number of dimensions for output variables.
!
# if defined WRITE_WATER && defined MASKING
        nvd3=2
        nvd4=2
# else
        nvd3=3
        nvd4=4
# endif
!
!  Define dimension vectors for staggered tracer type variables.
!
# if defined WRITE_WATER && defined MASKING
        t2dgrd(1)=DimIDs(17)
        t2dgrd(2)=DimIDs(28)
#  ifdef SOLVE3D
        t3dgrd(1)=DimIDs(20)
        t3dgrd(2)=DimIDs(28)
#  endif
# else
        t2dgrd(1)=DimIDs( 1)
        t2dgrd(2)=DimIDs( 5)
        t2dgrd(3)=DimIDs(28)
#  ifdef SOLVE3D
        t3dgrd(1)=DimIDs( 1)
        t3dgrd(2)=DimIDs( 5)
        t3dgrd(3)=DimIDs( 9)
        t3dgrd(4)=DimIDs(28)
#  endif
# endif
!
!  Define dimension vectors for staggered u-momemtum type variables.
!
# if defined WRITE_WATER && defined MASKING
        u2dgrd(1)=DimIDs(18)
        u2dgrd(2)=DimIDs(28)
#  ifdef SOLVE3D
        u3dgrd(1)=DimIDs(21)
        u3dgrd(2)=DimIDs(28)
#  endif
# else
        u2dgrd(1)=DimIDs( 2)
        u2dgrd(2)=DimIDs( 6)
        u2dgrd(3)=DimIDs(28)
#  ifdef SOLVE3D
        u3dgrd(1)=DimIDs( 2)
        u3dgrd(2)=DimIDs( 6)
        u3dgrd(3)=DimIDs( 9)
        u3dgrd(4)=DimIDs(28)
#  endif
# endif
!
!  Define dimension vectors for staggered v-momemtum type variables.
!
# if defined WRITE_WATER && defined MASKING
        v2dgrd(1)=DimIDs(19)
        v2dgrd(2)=DimIDs(28)
#  ifdef SOLVE3D
        v3dgrd(1)=DimIDs(22)
        v3dgrd(2)=DimIDs(28)
#  endif
# else
        v2dgrd(1)=DimIDs( 3)
        v2dgrd(2)=DimIDs( 7)
        v2dgrd(3)=DimIDs(28)
#  ifdef SOLVE3D
        v3dgrd(1)=DimIDs( 3)
        v3dgrd(2)=DimIDs( 7)
        v3dgrd(3)=DimIDs( 9)
        v3dgrd(4)=DimIDs(28)
#  endif
# endif
# ifdef SOLVE3D
!
!  Define dimension vector for staggered w-momemtum type variables.
!
#  if defined WRITE_WATER && defined MASKING
        w3dgrd(1)=DimIDs(23)
        w3dgrd(2)=DimIDs(28)
#  else
        w3dgrd(1)=DimIDs( 1)
        w3dgrd(2)=DimIDs( 5)
        w3dgrd(3)=DimIDs(10)
        w3dgrd(4)=DimIDs(28)
#  endif
!
# endif
!
!  Initialize unlimited time record dimension.
!
        tFILindx(ng)=0
!
!  Initialize local information variable arrays.
!
        DO i=1,Natt
          DO j=1,80
            Vinfo(i)=' '
          END DO
        END DO
        DO i=1,5
          Aval(i)=0.0_r8
        END DO
!
!-----------------------------------------------------------------------
!  Define common variables and their attributes.
!-----------------------------------------------------------------------
      DO ifile=1,nfile
        ncname=FILname(ifile,ng)
        WRITE (stdout,50) TRIM(ncname)
!
!  Define model time as filter levels.
!
        status=nf90_def_var(ncFILid(ifile,ng),'filterLevel',NF90_INT,   &
     &                 recdim,varid)
!
!  Define time-recordless information variables.
!  For some reason, this breaks the filter restart files, so
!  disable it.
!        status=def_info(ng,ncFILid(ifile,ng),ncname,DimIDs)
!        IF (exit_flag.ne.0) RETURN
!  Define file type, in loo of whole def_info.
!
        type='ROMS/TOMS filter status file for restarts'
        status=nf90_put_att(ncFILid(ifile,ng), nf90_global, 'type',     &
     &                         LEN_TRIM(type))
!
!  Define ocean_time as scalar.
!
        Vinfo( 1)=Vname(1,idtime)
        Vinfo( 2)=Vname(2,idtime)
        IF (INT(time_ref).eq.-2) THEN
          Vinfo( 3)='seconds since 1968-05-23 00:00:00 GMT'
          Vinfo( 4)='gregorian'
        ELSE IF (INT(time_ref).eq.-1) THEN
          Vinfo( 3)='seconds since 0001-01-01 00:00:00'
          Vinfo( 4)='360_day'
        ELSE IF (INT(time_ref).eq.0) THEN
          Vinfo( 3)='seconds since 0001-01-01 00:00:00'
          Vinfo( 4)='365.25_day'
        ELSE IF (time_ref.gt.0.0_r8) THEN
          WRITE (Vinfo( 3),'(a,1x,a)') 'seconds since', TRIM(r_text)
          Vinfo( 4)='standard'
        END IF
        Vinfo(14)=Vname(4,idtime)
        status=def_var(ncFILid(ifile,ng),filVid(idtime,ng),NF_TYPE,     &
     &                 0,0,Aval,Vinfo,ncname)
!
!  Define filter counts.
!
        Vinfo( 1)='fcount'
        Vinfo( 2)=Vname(2,idtime)
        status=nf90_def_var(ncFILid(ifile,ng),'fcount',NF90_INT,        &
     &                 DimIDs(28),varid)
      END DO
!
!-----------------------------------------------------------------------
!  Define variables and their attributes to each filter file separately.
!-----------------------------------------------------------------------
!
!  Define free-surface.
!
        ncname=FILname(1,ng)
        Vinfo( 1)=Vname(1,idFsur)
        Vinfo( 2)=Vname(2,idFsur)
        Vinfo( 3)=Vname(3,idFsur)
        Vinfo(14)=Vname(4,idFsur)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idFsur,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idFsur,ng),NF_FOUT,         &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define 2D momentum in the XI-direction.
!
        Vinfo( 1)=Vname(1,idUbar)
        Vinfo( 2)=Vname(2,idUbar)
        Vinfo( 3)=Vname(3,idUbar)
        Vinfo(14)=Vname(4,idUbar)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_u'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idUbar,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idUbar,ng),NF_FOUT,         &
     &                 nvd3,u2dgrd,Aval,Vinfo,ncname)
!
!  Define 2D momentum in the ETA-direction.
!
        Vinfo( 1)=Vname(1,idVbar)
        Vinfo( 2)=Vname(2,idVbar)
        Vinfo( 3)=Vname(3,idVbar)
        Vinfo(14)=Vname(4,idVbar)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_v'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idVbar,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idVbar,ng),NF_FOUT,         &
     &                 nvd3,v2dgrd,Aval,Vinfo,ncname)
# ifdef SOLVE3D
!
!  Define 3D momentum component in the XI-direction.
!
        ncname=FILname(2,ng)
        Vinfo( 1)=Vname(1,idUvel)
        Vinfo( 2)=Vname(2,idUvel)
        Vinfo( 3)=Vname(3,idUvel)
        Vinfo(14)=Vname(4,idUvel)
        Vinfo(16)='filter level'
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_u'
#  endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idUvel,ng),r8)
        status=def_var(ncFILid(2,ng),filVid(idUvel,ng),NF_FOUT,         &
     &                 nvd4,u3dgrd,Aval,Vinfo,ncname)
!
!  Define 3D momentum component in the ETA-direction.
!
        ncname=FILname(3,ng)
        Vinfo( 1)=Vname(1,idVvel)
        Vinfo( 2)=Vname(2,idVvel)
        Vinfo( 3)=Vname(3,idVvel)
        Vinfo(14)=Vname(4,idVvel)
        Vinfo(16)='filter level'
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_v'
#  endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idVvel,ng),r8)
        status=def_var(ncFILid(3,ng),filVid(idVvel,ng),NF_FOUT,         &
     &                 nvd4,v3dgrd,Aval,Vinfo,ncname)
#  ifndef FILTRIM
!
!  Define density anomaly.
!
        ncname=FILname(7,ng)
        Vinfo( 1)=Vname(1,idDano)
        Vinfo( 2)=Vname(2,idDano)
        Vinfo( 3)=Vname(3,idDano)
        Vinfo(14)=Vname(4,idDano)
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idDano,ng),r8)
        status=def_var(ncFILid(7,ng),filVid(idDano,ng),NF_FOUT,         &
     &                 nvd4,t3dgrd,Aval,Vinfo,ncname)
!
!  Define tracer type variables.
!
        ncname=FILname(8,ng)
        DO itrc=1,NT(ng)
          Vinfo( 1)=Vname(1,idTvar(itrc))
          Vinfo( 2)=Vname(2,idTvar(itrc))
          Vinfo( 3)=Vname(3,idTvar(itrc))
          Vinfo(14)=Vname(4,idTvar(itrc))
          Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#   endif
          Vinfo(22)='coordinates'
          Aval(5)=REAL(r3dvar,r8)
          status=def_var(ncFILid(8,ng),filTid(itrc,ng),NF_FOUT,         &
     &                   nvd4,t3dgrd,Aval,Vinfo,ncname)
        END DO
!
!  Define vertical (omega) velocity.
!
        ncname=FILname(9,ng)
        Vinfo( 1)=Vname(1,idOvel)
        Vinfo( 2)=Vname(2,idOvel)
        Vinfo( 3)=Vname(3,idOvel)
        Vinfo(14)=Vname(4,idOvel)
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idOvel,ng),r8)
        status=def_var(ncFILid(9,ng),filVid(idOvel,ng),NF_FOUT,         &
     &                 nvd4,w3dgrd,Aval,Vinfo,ncname)
#  endif
#  ifdef LMD_SKPP
!
!  Define depth of surface boundary layer.
!
        ncname=FILname(1,ng)
        Vinfo( 1)=Vname(1,idHsbl)
        Vinfo( 2)=Vname(2,idHsbl)
        Vinfo( 3)=Vname(3,idHsbl)
        Vinfo(14)=Vname(4,idHsbl)
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idHsbl,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idHsbl,ng),NF_FOUT,         &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
#  endif
#  ifdef LMD_BKPP
!
!  Define depth of bottom boundary layer.
!
        Vinfo( 1)=Vname(1,idHbbl)
        Vinfo( 2)=Vname(2,idHbbl)
        Vinfo( 3)=Vname(3,idHbbl)
        Vinfo(14)=Vname(4,idHbbl)
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idHbbl,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idHbbl,ng),NF_FOUT,         &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
#  endif
#  ifdef AVERAGES_AKV
!
!  Define vertical viscosity coefficient.
!
        ncname=FILname(6,ng)
        Vinfo( 1)=Vname(1,idVvis)
        Vinfo( 2)=Vname(2,idVvis)
        Vinfo( 3)=Vname(3,idVvis)
        Vinfo(14)=Vname(4,idVvis)
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idVvis,ng),r8)
        status=def_var(ncFILid(6,ng),filVid(idVvis,ng),NF_FOUT,         &
     &                 nvd4,w3dgrd,Aval,Vinfo,ncname)
#  endif
#  ifdef AVERAGES_AKT
!
!  Define vertical diffusion coefficient for potential temperature.
!
        ncname=FILname(4,ng)
        Vinfo( 1)=Vname(1,idTdif)
        Vinfo( 2)=Vname(2,idTdif)
        Vinfo( 3)=Vname(3,idTdif)
        Vinfo(14)=Vname(4,idTdif)
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idTdif,ng),r8)
        status=def_var(ncFILid(4,ng),filVid(idTdif,ng),NF_FOUT,         &
     &                 nvd4,w3dgrd,Aval,Vinfo,ncname)
#  endif
#  ifdef AVERAGES_AKS
!
!  Define vertical diffusion coefficient for salinity.
!
        ncname=FILname(5,ng)
        Vinfo( 1)=Vname(1,idSdif)
        Vinfo( 2)=Vname(2,idSdif)
        Vinfo( 3)=Vname(3,idSdif)
        Vinfo(14)=Vname(4,idSdif)
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idSdif,ng),r8)
        status=def_var(ncFILid(5,ng),filVid(idSdif,ng),NF_FOUT,         &
     &                 nvd4,w3dgrd,Aval,Vinfo,ncname)
#  endif
#  ifdef AVERAGES_FLUXES
!
!  Define surface net heat flux.
!
        ncname=FILname(1,ng)
        Vinfo( 1)=Vname(1,idTsur(itemp))
        Vinfo( 2)=Vname(2,idTsur(itemp))
        Vinfo( 3)=Vname(3,idTsur(itemp))
        Vinfo(11)='upward flux, cooling'
        Vinfo(12)='downward flux, heating'
        Vinfo(14)=Vname(4,idTsur(itemp))
        Vinfo(16)='filter level'
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idTsur(itemp),ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idTsur(itemp),ng),NF_FOUT,  &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
#   ifdef BULK_FLUXES
!
!  Define latent heat flux.
!
        Vinfo( 1)=Vname(1,idLhea)
        Vinfo( 2)=Vname(2,idLhea)
        Vinfo( 3)=Vname(3,idLhea)
        Vinfo(11)='upward flux, cooling'
        Vinfo(12)='downward flux, heating'
        Vinfo(14)=Vname(4,idLhea)
        Vinfo(16)=Vname(1,idtime)
#    if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#    endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idLhea,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idLhea,ng),NF_FOUT,         &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define sensible heat flux.
!
        Vinfo( 1)=Vname(1,idShea)
        Vinfo( 2)=Vname(2,idShea)
        Vinfo( 3)=Vname(3,idShea)
        Vinfo(11)='upward flux, cooling'
        Vinfo(12)='downward flux, heating'
        Vinfo(14)=Vname(4,idShea)
        Vinfo(16)=Vname(1,idtime)
#    if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#    endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idShea,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idShea,ng),NF_FOUT,         &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define longwave radiation flux.
!
        Vinfo( 1)=Vname(1,idLrad)
        Vinfo( 2)=Vname(2,idLrad)
        Vinfo( 3)=Vname(3,idLrad)
        Vinfo(11)='upward flux, cooling'
        Vinfo(12)='downward flux, heating'
        Vinfo(14)=Vname(4,idLrad)
        Vinfo(16)=Vname(1,idtime)
#    if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#    endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idLrad,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idLrad,ng),NF_FOUT,         &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
#   endif
#   ifdef SHORTWAVE
!
!  Define shortwave radiation flux.
!
        Vinfo( 1)=Vname(1,idSrad)
        Vinfo( 2)=Vname(2,idSrad)
        Vinfo( 3)=Vname(3,idSrad)
        Vinfo(11)='upward flux, cooling'
        Vinfo(12)='downward flux, heating'
        Vinfo(14)=Vname(4,idSrad)
        Vinfo(16)=Vname(1,idtime)
#    if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#    endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idSrad,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idSrad,ng),NF_FOUT,         &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
!
!  Define surface u-momentum stress.
!
        Vinfo( 1)=Vname(1,idUsms)
        Vinfo( 2)=Vname(2,idUsms)
        Vinfo( 3)=Vname(3,idUsms)
        Vinfo(14)=Vname(4,idUsms)
        Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_u'
#  endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idUsms,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idUsms,ng),NF_FOUT,         &
     &                 nvd3,u2dgrd,Aval,Vinfo,ncname)
!
!  Define surface v-momentum stress.
!
        Vinfo( 1)=Vname(1,idVsms)
        Vinfo( 2)=Vname(2,idVsms)
        Vinfo( 3)=Vname(3,idVsms)
        Vinfo(14)=Vname(4,idVsms)
        Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_v'
#  endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idVsms,ng),r8)
        status=def_var(ncFILid(1,ng),filVid(idVsms,ng),NF_FOUT,         &
     &                 nvd3,v2dgrd,Aval,Vinfo,ncname)
# endif
# ifdef ICE_MODEL
!
!  Define 2D ice momentum in the XI-direction.
!
        ncname=FILname(10,ng)
        Vinfo( 1)=Vname(1,idUice)
        Vinfo( 2)=Vname(2,idUice)
        Vinfo( 3)=Vname(3,idUice)
        Vinfo(14)=Vname(4,idUice)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_u'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idUice,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idUice,ng),NF_FOUT,         &
     &                 nvd3,u2dgrd,Aval,Vinfo,ncname)
!
!  Define 2D ice momentum in the ETA-direction.
!
        Vinfo( 1)=Vname(1,idVice)
        Vinfo( 2)=Vname(2,idVice)
        Vinfo( 3)=Vname(3,idVice)
        Vinfo(14)=Vname(4,idVice)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_v'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idVice,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idVice,ng),NF_FOUT,         &
     &                 nvd3,v2dgrd,Aval,Vinfo,ncname)
!
!  Define ice concentration
!
        Vinfo( 1)=Vname(1,idAice)
        Vinfo( 2)=Vname(2,idAice)
        Vinfo( 3)=Vname(3,idAice)
        Vinfo(14)=Vname(4,idAice)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idAice,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idAice,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define ice thickness
!
        Vinfo( 1)=Vname(1,idHice)
        Vinfo( 2)=Vname(2,idHice)
        Vinfo( 3)=Vname(3,idHice)
        Vinfo(14)=Vname(4,idHice)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idHice,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idHice,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define snow thickness
!
        Vinfo( 1)=Vname(1,idHsno)
        Vinfo( 2)=Vname(2,idHsno)
        Vinfo( 3)=Vname(3,idHsno)
        Vinfo(14)=Vname(4,idHsno)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idHsno,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idHsno,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define surface melt ponds
!
        Vinfo( 1)=Vname(1,idSfwat)
        Vinfo( 2)=Vname(2,idSfwat)
        Vinfo( 3)=Vname(3,idSfwat)
        Vinfo(14)=Vname(4,idSfwat)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idSfwat,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idSfwat,ng),NF_FOUT,       &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define ice surface temperature
!
        Vinfo( 1)=Vname(1,idTice)
        Vinfo( 2)=Vname(2,idTice)
        Vinfo( 3)=Vname(3,idTice)
        Vinfo(14)=Vname(4,idTice)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idTice,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idTice,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define internal ice temperature
!
        Vinfo( 1)=Vname(1,idTimid)
        Vinfo( 2)=Vname(2,idTimid)
        Vinfo( 3)=Vname(3,idTimid)
        Vinfo(14)=Vname(4,idTimid)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idTimid,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idTimid,ng),NF_FOUT,       &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define under-ice salinity
!
        Vinfo( 1)=Vname(1,idS0mk)
        Vinfo( 2)=Vname(2,idS0mk)
        Vinfo( 3)=Vname(3,idS0mk)
        Vinfo(14)=Vname(4,idS0mk)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idS0mk,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idS0mk,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define under-ice temperature
!
        Vinfo( 1)=Vname(1,idT0mk)
        Vinfo( 2)=Vname(2,idT0mk)
        Vinfo( 3)=Vname(3,idT0mk)
        Vinfo(14)=Vname(4,idT0mk)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idT0mk,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idT0mk,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define age of ice
!
        Vinfo( 1)=Vname(1,idAgeice)
        Vinfo( 2)=Vname(2,idAgeice)
        Vinfo( 3)=Vname(3,idAgeice)
        Vinfo(14)=Vname(4,idAgeice)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idAgeice,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idAgeice,ng),NF_FOUT,       &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define sig11 component of internal ice stress
!
        Vinfo( 1)=Vname(1,idSig11)
        Vinfo( 2)=Vname(2,idSig11)
        Vinfo( 3)=Vname(3,idSig11)
        Vinfo(14)=Vname(4,idSig11)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idSig11,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idSig11,ng),NF_FOUT,       &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define sig12 component of internal ice stress
!
        Vinfo( 1)=Vname(1,idSig12)
        Vinfo( 2)=Vname(2,idSig12)
        Vinfo( 3)=Vname(3,idSig12)
        Vinfo(14)=Vname(4,idSig12)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idSig12,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idSig12,ng),NF_FOUT,       &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define sig22 component of internal ice stress
!
        Vinfo( 1)=Vname(1,idSig22)
        Vinfo( 2)=Vname(2,idSig22)
        Vinfo( 3)=Vname(3,idSig22)
        Vinfo(14)=Vname(4,idSig22)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idSig22,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idSig22,ng),NF_FOUT,       &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define ice-ocean mass flux
!
        Vinfo( 1)=Vname(1,idIomflx)
        Vinfo( 2)=Vname(2,idIomflx)
        Vinfo( 3)=Vname(3,idIomflx)
        Vinfo(14)=Vname(4,idIomflx)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idIomflx,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idIomflx,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define ice-water friction velocity
!
        Vinfo( 1)=Vname(1,idTauiw)
        Vinfo( 2)=Vname(2,idTauiw)
        Vinfo( 3)=Vname(3,idTauiw)
        Vinfo(14)=Vname(4,idTauiw)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idTauiw,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idTauiw,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
!
!  Define ice-water momentum transfer coefficient
!
        Vinfo( 1)=Vname(1,idChuiw)
        Vinfo( 2)=Vname(2,idChuiw)
        Vinfo( 3)=Vname(3,idChuiw)
        Vinfo(14)=Vname(4,idChuiw)
        Vinfo(16)='filter level'
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        Vinfo(22)='coordinates'
        Aval(5)=REAL(Iinfo(1,idChuiw,ng),r8)
        status=def_var(ncFILid(10,ng),filVid(idChuiw,ng),NF_FOUT,        &
     &                 nvd3,t2dgrd,Aval,Vinfo,ncname)
# endif
!
!-----------------------------------------------------------------------
!  Leave definition mode.
!-----------------------------------------------------------------------
!
        DO ifile=1,nfile
          status=nf90_enddef(ncFILid(ifile,ng))
        END DO
      END IF
!
!-----------------------------------------------------------------------
!  Write out time-recordless, information variables.
!  For some reason, this breaks the filter restart files, so
!  disable it.
!-----------------------------------------------------------------------
!
!      IF (Ldefine) THEN
!        DO ifile=1,nfile
!         status=wrt_info(ng, iNLM, ncFILid(ifile,ng), OutThread, ncname)
!         IF (exit_flag.ne.NoError) RETURN
!        END DO
!      END IF
!
!=======================================================================
!  Open an existing filter files, and prepare for appending data.
!=======================================================================
!
      IF (.not.Ldefine.and.OutThread) THEN
!
!  Inquire about the contents of filter NetCDF files:  Don't inquire
!  about the dimensions and variables.  Check for consistency.
!
        DO ifile=1,nfile
          ncname=FILname(ifile,ng)
          WRITE (stdout, 60) TRIM(ncname)
          ifield=0
          CALL opencdf (ng, 1, ncname, fname, N(ng), ifield, nrec)
          IF (exit_flag.ne.NoError) RETURN
!
!  Open filter files for read/write.
!
          status=nf90_open(TRIM(ncname),nf90_write,ncFILid(ifile,ng))
          IF (status.ne.nf90_noerr) THEN
            WRITE (stdout,30) TRIM(ncname)
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END DO
      END IF

#ifdef FOOOO
!
!=======================================================================
!  Open an existing restart file, check its contents, and prepare for
!  appending data.
!=======================================================================
!
      IF (.not.Ldefine.and.OutThread) THEN
!
!  Inquire about the contents of restart NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!
        ncname=FILname(ng)
        ifield=0
        CALL opencdf (ng, 1, ncname, fname, N(ng), ifield, nrec)
        IF (exit_flag.ne.NoError) RETURN
!
!  Open restart file for read/write.
!
        status=nf90_open(TRIM(ncname),nf90_write,ncFILid(ng))
        IF (status.ne.nf90_noerr) THEN
          WRITE (stdout,40) TRIM(ncname)
          exit_flag=3
          ioerror=status
          RETURN
        END IF
!
!  Initialize logical switches.
!
        DO i=1,NV
          got_var(i)=.FALSE.
        END DO
!
!  Scan variable list from input NetCDF and activate switches for
!  restart variables. Get variable IDs.
!
        DO i=1,nvars
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idtime))) THEN
            got_var(idtime)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idtime)),    &
     &                          filVid(idtime,ng))
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idFsur))) THEN
            got_var(idFsur)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idFsur)),    &
     &                          filVid(idFsur,ng))
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idUbar))) THEN
            got_var(idUbar)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idUbar)),    &
     &                          filVid(idUbar,ng))
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idVbar))) THEN
            got_var(idVbar)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idVbar)),    &
     &                          filVid(idVbar,ng))
          END IF
#ifdef SOLVE3D
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idUvel))) THEN
            got_var(idUvel)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idUvel)),    &
     &                          filVid(idUvel,ng))
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idVvel))) THEN
            got_var(idVvel)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idVvel)),    &
     &                          filVid(idVvel,ng))
          END IF
          DO itrc=1,NT(ng)
            IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idTvar(itrc)))) THEN
             got_var(idTvar(itrc))=.TRUE.
             status=nf90_inq_varid(ncFILid(ng),                         &
     &                           TRIM(Vname(1,idTvar(itrc))),           &
     &                           filTid(itrc,ng))
            END IF
          END DO
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idDano))) THEN
            got_var(idDano)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idDano)),    &
     &                          filVid(idDano,ng))
          END IF
# ifdef LMD_SKPP
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idHsbl))) THEN
            got_var(idHsbl)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idHsbl)),    &
     &                          filVid(idHsbl,ng))
          END IF
# endif
# ifdef LMD_BKPP
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idHbbl))) THEN
            got_var(idHbbl)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idHbbl)),    &
     &                          filVid(idHbbl,ng))
          END IF
# endif
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idVvis))) THEN
            got_var(idVvis)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idVvis)),    &
     &                          filVid(idVvis,ng))
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idTdif))) THEN
            got_var(idTdif)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idTdif)),    &
     &                          filVid(idTdif,ng))
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idSdif))) THEN
            got_var(idSdif)=.TRUE.
            status=nf90_inq_varid(ncFILid(ng),TRIM(Vname(1,idSdif)),    &
     &                          filVid(idSdif,ng))
          END IF
#endif
        END DO
!
!  Check if initialization variables are available in input NetCDF
!  file.
!
        IF (.not.got_var(idtime)) THEN
          WRITE (stdout,40) TRIM(Vname(1,idtime)), TRIM(ncname)
          exit_flag=3
          RETURN
        END IF
        IF (.not.got_var(idFsur)) THEN
          WRITE (stdout,40) TRIM(Vname(1,idFsur)), TRIM(ncname)
          exit_flag=3
          RETURN
        END IF
        IF (.not.got_var(idUbar)) THEN
          WRITE (stdout,40) TRIM(Vname(1,idUbar)), TRIM(ncname)
          exit_flag=3
          RETURN
        END IF
        IF (.not.got_var(idVbar)) THEN
          WRITE (stdout,40) TRIM(Vname(1,idVbar)), TRIM(ncname)
          exit_flag=3
          RETURN
        END IF
#ifdef SOLVE3D
        IF (.not.got_var(idUvel)) THEN
          WRITE (stdout,40) TRIM(Vname(1,idUvel)), TRIM(ncname)
          exit_flag=3
          RETURN
        END IF
        IF (.not.got_var(idVvel)) THEN
          WRITE (stdout,40) TRIM(Vname(1,idVvel)), TRIM(ncname)
          exit_flag=3
          RETURN
        END IF
# ifndef FILTRIM
        DO itrc=1,NT(ng)
          IF (.not.got_var(idTvar(itrc))) THEN
            WRITE (stdout,40) TRIM(Vname(1,idTvar(itrc))), TRIM(ncname)
            exit_flag=3
            RETURN
          END IF
        END DO
        IF (.not.got_var(idDano)) THEN
          WRITE (stdout,40) TRIM(Vname(1,idDano)), TRIM(ncname)
          exit_flag=3
          RETURN
        END IF
# endif
#endif
!
!  Set unlimited time record dimension to current value.
!
      tFILindx(ng)=tRSTindx(ng)
!
#endif /* FOO */


  10  FORMAT (/,' DEF_FILT - unable to create filter NetCDF file: ',a)
  20  FORMAT (1pe11.4,1x,'millimeter')
  30  FORMAT (/,' DEF_FILT - unable to open filter NetCDF file: ',a)
  40  FORMAT (/,' DEF_FILT - unable to find variable: ',a,2x,            &
     &          ' in filter NetCDF file: ',a)
  50  FORMAT (6x,'DEF_FILT  - creating filter file:   ',a)
  60  FORMAT (6x,'DEF_FILT  - inquiring filter file: ',a)
      RETURN
      END SUBROUTINE def_filt
#else
      SUBROUTINE def_filt
      RETURN
      END SUBROUTINE def_filt
#endif
