#include "cppdefs.h"
      MODULE ad_htobs_mod
#ifdef REPRESENTERS
!
!=================================================== Andrew M. Moore ===
!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine computes the adjoint observation operator,             !
!                                                                      !
!       transpose(H) * X                                               !
!                                                                      !
!  which loads the observation vector into the adjoint forcing arrays. !
!                                                                      !
!=======================================================================
!
      implicit none

      CONTAINS
!
!***********************************************************************
      SUBROUTINE ad_htobs (ng, tile, model)
!***********************************************************************
!
      USE mod_param
      USE mod_grid
      USE mod_ocean
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile, model
!
!  Local variable declarations.
!
# include "tile.h"
!
      CALL ad_htobs_tile (ng, model, Istr, Iend, Jstr, Jend,            &
     &                    LBi, UBi, LBj, UBj,                           &
# ifdef MASKING
     &                    GRID(ng) % rmask,                             &
     &                    GRID(ng) % umask,                             &
     &                    GRID(ng) % vmask,                             &
# endif
# ifdef SOLVE3D
     &                    GRID(ng) % z_r,                               &
     &                    OCEAN(ng) % f_u,                              &
     &                    OCEAN(ng) % f_v,                              &
     &                    OCEAN(ng) % f_t,                              &
# endif
     &                    OCEAN(ng) % f_ubar,                           &
     &                    OCEAN(ng) % f_vbar,                           &
     &                    OCEAN(ng) % f_zeta)
      RETURN
      END SUBROUTINE ad_htobs
!
!***********************************************************************
      SUBROUTINE ad_htobs_tile (ng, model, Istr, Iend, Jstr, Jend,      &
     &                          LBi, UBi, LBj, UBj,                     &
# ifdef MASKING
     &                          rmask, umask, vmask,                    &
# endif
# ifdef SOLVE3D
     &                          z_r,                                    &
     &                          f_u, f_v, f_t,                          &
# endif
     &                          f_ubar, f_vbar, f_zeta)
!***********************************************************************
!
      USE mod_param
      USE mod_parallel
      USE mod_fourdvar
      USE mod_iounits
      USE mod_ncparam
      USE mod_scalars
!
      USE ad_extract_obs_mod, ONLY : ad_extract_obs2d
# ifdef SOLVE3D
      USE ad_extract_obs_mod, ONLY : ad_extract_obs3d
# endif
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj
!
# ifdef ASSUMED_SHAPE
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:,LBj:)
      real(r8), intent(in) :: umask(LBi:,LBj:)
      real(r8), intent(in) :: vmask(LBi:,LBj:)
#  endif
#  ifdef SOLVE3D
      real(r8), intent(in) :: z_r(LBi:,LBj:,:)
      real(r8), intent(inout) :: f_u(LBi:,LBj:,:)
      real(r8), intent(inout) :: f_v(LBi:,LBj:,:)
      real(r8), intent(inout) :: f_t(LBi:,LBj:,:,:)
#  endif
      real(r8), intent(inout) :: f_ubar(LBi:,LBj:)
      real(r8), intent(inout) :: f_vbar(LBi:,LBj:)
      real(r8), intent(inout) :: f_zeta(LBi:,LBj:)
# else
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: umask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: vmask(LBi:UBi,LBj:UBj)
#  endif
#  ifdef SOLVE3D
      real(r8), intent(in) :: z_r(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: f_u(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: f_v(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: f_t(LBi:UBi,LBj:UBj,N(ng),NT(ng))
#  endif
      real(r8), intent(inout) :: f_ubar(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: f_vbar(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: f_zeta(LBi:UBi,LBj:UBj)
# endif
!
!  Local variable declarations.
!
      integer :: i, iobs, j
# ifdef SOLVE3D
      integer :: itrc, k
# endif
!
!-----------------------------------------------------------------------
!  Compute model minus observations adjoint misfit forcing. The
!  representer coefficients (or its approximation PSI) has been
!  already loaded into vector ADmodVal in the conjugate gradient
!  or read in.
!-----------------------------------------------------------------------
!
      IF (ProcessObs(ng)) THEN
!
!  Free-surface.
!
        IF (FOURDVAR(ng)%ObsCount(isFsur).gt.0) THEN
          DO i=LBi,UBi
            DO j=LBj,UBj
              f_zeta(i,j)=0.0_r8
            END DO
          END DO
          CALL ad_extract_obs2d (ng, model, Istr, Iend, Istr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           rILB(ng), rIUB(ng),                    &
     &                           rJLB(ng), rJUB(ng),                    &
     &                           isFsur,                                &
     &                           Mobs, 1, Mobs,                         &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs,             &
     &                           f_zeta,                                &
# ifdef MASKING
     &                           rmask,                                 &
# endif
     &                           ADmodVal)
        END IF
!
!  2D u-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isUbar).gt.0) THEN
          DO i=LBi,UBi
            DO j=LBj,UBj
              f_ubar(i,j)=0.0_r8
            END DO
          END DO
          CALL ad_extract_obs2d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           uILB(ng), uIUB(ng),                    &
     &                           uJLB(ng), uJUB(ng),                    &
     &                           isUbar,                                &
     &                           Mobs, 1, Mobs,                         &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs,             &
     &                           f_ubar,                                &
# ifdef MASKING
     &                           umask,                                 &
# endif
     &                           ADmodVal)
        END IF
!
!  2D v-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isVbar).gt.0) THEN
          DO i=LBi,UBi
            DO j=LBj,UBj
              f_vbar(i,j)=0.0_r8
            END DO
          END DO
          CALL ad_extract_obs2d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           vILB(ng), vIUB(ng),                    &
     &                           vJLB(ng), vJUB(ng),                    &
     &                           isVbar,                                &
     &                           Mobs, 1, Mobs,                         &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs,             &
     &                           f_vbar,                                &
# ifdef MASKING
     &                           vmask,                                 &
# endif
     &                           ADmodVal)
        END IF
# ifdef SOLVE3D
!
!  3D u-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isUvel).gt.0) THEN
          DO k=1,N(ng)
            DO i=LBi,UBi
              DO j=LBj,UBj
                f_u(i,j,k)=0.0_r8
              END DO
            END DO
          END DO
          CALL ad_extract_obs3d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj, 1, N(ng),          &
     &                           uILB(ng), uIUB(ng),                    &
     &                           uJLB(ng), uJUB(ng),                    &
     &                           isUvel,                                &
     &                           Mobs, 1, Mobs,                         &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs, Zobs,       &
     &                           f_u, z_r,                              &
#  ifdef MASKING
     &                           umask,                                 &
#  endif
     &                           ADmodVal)
        END IF
!
!  3D v-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isVvel).gt.0) THEN
          DO k=1,N(ng)
            DO i=LBi,UBi
              DO j=LBj,UBj
                f_v(i,j,k)=0.0_r8
              END DO
            END DO
          END DO
          CALL ad_extract_obs3d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj, 1, N(ng),          &
     &                           vILB(ng), vIUB(ng),                    &
     &                           vJLB(ng), vJUB(ng),                    &
     &                           isVvel,                                &
     &                           Mobs, 1, Mobs,                         &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs, Zobs,       &
     &                           f_v, z_r,                              &
#  ifdef MASKING
     &                           vmask,                                 &
#  endif
     &                           ADmodVal)
        END IF
!
!  Tracer type variables.
!
        DO itrc=1,NT(ng)
          IF (FOURDVAR(ng)%ObsCount(isTvar(itrc)).gt.0) THEN
            DO k=1,N(ng)
              DO i=LBi,UBi
                DO j=LBj,UBj
                  f_t(i,j,k,itrc)=0.0_r8
                END DO
              END DO
            END DO
            CALL ad_extract_obs3d (ng, model, Istr, Iend, Jstr, Jend,   &
     &                             LBi, UBi, LBj, UBj, 1, N(ng),        &
     &                             rILB(ng), rIUB(ng),                  &
     &                             rJLB(ng), rJUB(ng),                  &
     &                             isTvar(itrc),                        &
     &                             Mobs, 1, Mobs,                       &
     &                             time(ng), dt(ng),                    &
     &                             ObsType, Tobs, Xobs, Yobs, Zobs,     &
     &                             f_t(:,:,:,itrc), z_r,                &
#  ifdef MASKING
     &                             rmask,                               &
#  endif
     &                             ADmodVal)
          END IF
        END DO
# endif
        IF (SOUTH_WEST_TEST) THEN
          IF (Master) THEN
            WRITE (stdout,10) tdays(ng), NstrObs(ng), NendObs(ng),      &
     &                        iic(ng)
  10        FORMAT (3x,' AD_HTOBS    - Computed adjoint observations ', &
     &              'forcing,',t64,'t = ',f12.4,/,19x,'(Observation ',  &
     &              'records = ',i7.7,' - ',i7.7,', iic = ',i7.7,')')
          END IF
        END IF
      END IF        
      RETURN
      END SUBROUTINE ad_htobs_tile
#endif
      END MODULE ad_htobs_mod
