#include "cppdefs.h"

#if defined ADJOINT  && defined SOLVE3D       && \
   (defined LMD_SKPP || defined SOLAR_SOURCE)

      SUBROUTINE ad_lmd_swfrac_tile (ng, Istr, Iend, Jstr, Jend,        &
     &                               Zscale, Z, ad_Z, ad_swdk)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine computes the adjoint fraction of solar shortwave flux  !
!  penetrating to specified depth (times Zscale)  due to  exponential  !
!  decay in Jerlov water type.                                         !
!                                                                      !
!  On Input:                                                           !
!                                                                      !
!     Zscale   Scale factor to apply to depth array.                   !
!     Z        Vertical height (meters, negative) for                  !
!                desired solar short-wave fraction.                    !
!     ad_Z     Adjoint vertical height for                             !
!                desired solar short-wave fraction.                    !
!                                                                      !
!  On Output:                                                          !
!                                                                      !
!     ad_swdk  Adjoint shortwave (radiation) fractional decay.         !
!                                                                      !
!  Reference:                                                          !
!                                                                      !
!  Paulson, C.A., and J.J. Simpson, 1977: Irradiance meassurements     !
!     in the upper ocean, J. Phys. Oceanogr., 7, 952-956.              !
!                                                                      !
!  This routine was adapted from Bill Large 1995 code.                 !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_mixing
      USE mod_scalars
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Iend, Istr, Jend, Jstr

      real(r8), intent(in) :: Zscale

      real(r8), intent(in) :: Z(PRIVATE_2D_SCRATCH_ARRAY)

      real(r8), intent(inout) :: ad_Z(PRIVATE_2D_SCRATCH_ARRAY)
      real(r8), intent(inout) :: ad_swdk(PRIVATE_2D_SCRATCH_ARRAY)
!
!  Local variable declarations.
!
      integer :: Jindex, i, j

      real(r8) :: fac1, fac2, cff1, cff2
      real(r8) :: ad_cff1, ad_cff2
!
!-----------------------------------------------------------------------
!  Initialize adjoint private variables.
!-----------------------------------------------------------------------
!
      ad_cff1=0.0_r8
      ad_cff2=0.0_r8
!
!-----------------------------------------------------------------------
!  Use Paulson and Simpson (1977) two wavelength bands solar
!  absorption model.
!-----------------------------------------------------------------------
!
      DO j=Jstr,Jend
        DO i=Istr,Iend
          Jindex=MIXING(ng)%Jwtype(i,j)
          fac1=Zscale/lmd_mu1(Jindex)
          fac2=Zscale/lmd_mu2(Jindex)
          cff1=EXP(Z(i,j)*fac1)
          cff2=EXP(Z(i,j)*fac2)
!>        tl_swdk(i,j)=tl_cff1*lmd_r1(Jindex)+                          &
!>   &                 tl_cff2*(1.0_r8-lmd_r1(Jindex))
!>
          ad_cff1=ad_cff1+lmd_r1(Jindex)*ad_swdk(i,j)
          ad_cff2=ad_cff2+(1.0_r8-lmd_r1(Jindex))*ad_swdk(i,j)
          ad_swdk(i,j)=0.0_r8
!>        tl_cff2=fac2*tl_Z(i,j)*cff2
!>        tl_cff1=fac1*tl_Z(i,j)*cff1
!>
          ad_Z(i,j)=ad_Z(i,j)+                                          &
     &              fac1*cff1*ad_cff1+                                  &
     &              fac2*cff2*ad_cff2
          ad_cff2=0.0_r8
          ad_cff1=0.0_r8
        END DO
      END DO
      END SUBROUTINE ad_lmd_swfrac_tile
#else
      SUBROUTINE ad_lmd_swfrac
      RETURN
      END SUBROUTINE ad_lmd_swfrac
#endif

