#include "cppdefs.h"
      MODULE ad_misfit_mod
#if defined FOUR_DVAR && !defined REPRESENTERS
!
!=================================================== Andrew M. Moore ===
!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine computes the model minus observations adjoint misfit   !
!  forcing for each state variable.                                    !
!                                                                      !
!=======================================================================
!
      implicit none

      CONTAINS
!
!***********************************************************************
      SUBROUTINE ad_misfit (ng, tile, model)
!***********************************************************************
!
      USE mod_param
      USE mod_grid
      USE mod_ocean
      USE mod_stepping
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile, model
!
!  Local variable declarations.
!
# include "tile.h"
!
      CALL ad_misfit_tile (ng, model, Istr, Iend, Jstr, Jend,           &
     &                     LBi, UBi, LBj, UBj,                          &
     &                     knew(ng),                                    &
# ifdef SOLVE3D
     &                     nstp(ng),                                    &
# endif
# ifdef MASKING
     &                     GRID(ng) % rmask,                            &
     &                     GRID(ng) % umask,                            &
     &                     GRID(ng) % vmask,                            &
# endif
# ifdef SOLVE3D
     &                     GRID(ng) % z_r,                              &
     &                     OCEAN(ng) % ad_u,                            &
     &                     OCEAN(ng) % ad_v,                            &
     &                     OCEAN(ng) % ad_t,                            &
# endif
     &                     OCEAN(ng) % ad_ubar,                         &
     &                     OCEAN(ng) % ad_vbar,                         &
     &                     OCEAN(ng) % ad_zeta)
      RETURN
      END SUBROUTINE ad_misfit
!
!***********************************************************************
      SUBROUTINE ad_misfit_tile (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           knew,                                  &
# ifdef SOLVE3D
     &                           nstp,                                  &
# endif
# ifdef MASKING
     &                           rmask, umask, vmask,                   &
# endif
# ifdef SOLVE3D
     &                           z_r,                                   &
     &                           ad_u, ad_v, ad_t,                      &
# endif
     &                           ad_ubar, ad_vbar, ad_zeta)
!***********************************************************************
!
      USE mod_param
      USE mod_parallel
      USE mod_fourdvar
      USE mod_iounits
      USE mod_ncparam
      USE mod_scalars
!
      USE ad_extract_obs_mod, ONLY : ad_extract_obs2d
# ifdef SOLVE3D
      USE ad_extract_obs_mod, ONLY : ad_extract_obs3d
# endif
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: knew
# ifdef SOLVE3D
      integer, intent(in) :: nstp
# endif
!
# ifdef ASSUMED_SHAPE
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:,LBj:)
      real(r8), intent(in) :: umask(LBi:,LBj:)
      real(r8), intent(in) :: vmask(LBi:,LBj:)
#  endif
#  ifdef SOLVE3D
      real(r8), intent(in) :: z_r(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_u(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: ad_v(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: ad_t(LBi:,LBj:,:,:,:)
#  endif
      real(r8), intent(inout) :: ad_ubar(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_vbar(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_zeta(LBi:,LBj:,:)
# else
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: umask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: vmask(LBi:UBi,LBj:UBj)
#  endif
#  ifdef SOLVE3D
      real(r8), intent(in) :: z_r(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: ad_u(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(inout) :: ad_v(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(inout) :: ad_t(LBi:UBi,LBj:UBj,N(ng),3,NT(ng))
#  endif
      real(r8), intent(inout) :: ad_ubar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(inout) :: ad_vbar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(inout) :: ad_zeta(LBi:UBi,LBj:UBj,3)
# endif
!
!  Local variable declarations.
!
      integer :: iobs, kfrc
# ifdef SOLVE3D
      integer :: itrc, nfrc
# endif
!
!-----------------------------------------------------------------------
!  Compute model minus observations adjoint misfit forcing.
!-----------------------------------------------------------------------
!
      IF (ProcessObs(ng)) THEN
!
!  Compute observation scale (ObsScale). The scale factor is used for
!  screenning  or normalization of the observations. If only screening,
!  the scale is one for good observations and zero for bad observations.
!  If normalizing, the scale is terms of screenning and some specified
!  norm. In incremental 4DVAR only screenning is carried out.
!
        CALL obs_scale (ng, model)
!
!  Compute adjoint forcing terms at observation locations.
!
        DO iobs=1,Nobs(ng)
# if defined S4DVAR
          ADmodVal(iobs)=ObsScale(iobs)*ObsErr(iobs)*                   &
     &                   (NLmodVal(iobs,Ipass)-ObsVal(iobs))
# elif defined IS4DVAR
          ADmodVal(iobs)=ObsScale(iobs)*ObsErr(iobs)*                   &
     &                   (NLmodVal(iobs)+TLmodVal(iobs,Ipass)-          &
     &                    ObsVal(iobs))
# endif
        END DO
!
!  Set adjoint time index to update.
!
        IF (iic(ng).eq.1) THEN
          kfrc=knew
        ELSE
          kfrc=1
        END IF
# ifdef SOLVE3D
        nfrc=nstp
# endif
!
!  Free-surface.
!
        IF (FOURDVAR(ng)%ObsCount(isFsur).gt.0) THEN
          CALL ad_extract_obs2d (ng, model, Istr, Iend, Istr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           rILB(ng), rIUB(ng),                    &
     &                           rJLB(ng), rJUB(ng),                    &
     &                           isFsur,                                &
     &                           Mobs, 1, Nobs(ng),                     &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs,             &
     &                           ad_zeta(:,:,kfrc),                     &
# ifdef MASKING
     &                           rmask,                                 &
# endif
     &                           ADmodVal)
        END IF
!
!  2D u-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isUbar).gt.0) THEN
          CALL ad_extract_obs2d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           uILB(ng), uIUB(ng),                    &
     &                           uJLB(ng), uJUB(ng),                    &
     &                           isUbar,                                &
     &                           Mobs, 1, Nobs(ng),                     &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs,             &
     &                           ad_ubar(:,:,kfrc),                     &
# ifdef MASKING
     &                           umask,                                 &
# endif
     &                           ADmodVal)
        END IF
!
!  2D v-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isVbar).gt.0) THEN
          CALL ad_extract_obs2d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           vILB(ng), vIUB(ng),                    &
     &                           vJLB(ng), vJUB(ng),                    &
     &                           isVbar,                                &
     &                           Mobs, 1, Nobs(ng),                     &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs,             &
     &                           ad_vbar(:,:,kfrc),                     &
# ifdef MASKING
     &                           vmask,                                 &
# endif
     &                           ADmodVal)
        END IF
# ifdef SOLVE3D
!
!  3D u-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isUvel).gt.0) THEN
          CALL ad_extract_obs3d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj, 1, N(ng),          &
     &                           uILB(ng), uIUB(ng),                    &
     &                           uJLB(ng), uJUB(ng),                    &
     &                           isUvel,                                &
     &                           Mobs, 1, Nobs(ng),                     &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs, Zobs,       &
     &                           ad_u(:,:,:,nfrc),                      &
     &                           z_r,                                   &
#  ifdef MASKING
     &                           umask,                                 &
#  endif
     &                           ADmodVal)
        END IF
!
!  3D v-momentum component.
!
        IF (FOURDVAR(ng)%ObsCount(isVvel).gt.0) THEN
          CALL ad_extract_obs3d (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj, 1, N(ng),          &
     &                           vILB(ng), vIUB(ng),                    &
     &                           vJLB(ng), vJUB(ng),                    &
     &                           isVvel,                                &
     &                           Mobs, 1, Nobs(ng),                     &
     &                           time(ng), dt(ng),                      &
     &                           ObsType, Tobs, Xobs, Yobs, Zobs,       &
     &                           ad_v(:,:,:,nfrc),                      &
     &                           z_r,                                   &
#  ifdef MASKING
     &                           vmask,                                 &
#  endif
     &                           ADmodVal)
        END IF
!
!  Tracer type variables.
!
        DO itrc=1,NT(ng)
          IF (FOURDVAR(ng)%ObsCount(isTvar(itrc)).gt.0) THEN
            CALL ad_extract_obs3d (ng, model, Istr, Iend, Jstr, Jend,   &
     &                             LBi, UBi, LBj, UBj, 1, N(ng),        &
     &                             rILB(ng), rIUB(ng),                  &
     &                             rJLB(ng), rJUB(ng),                  &
     &                             isTvar(itrc),                        &
     &                             Mobs, 1, Nobs(ng),                   &
     &                             time(ng), dt(ng),                    &
     &                             ObsType, Tobs, Xobs, Yobs, Zobs,     &
     &                             ad_t(:,:,:,nfrc,itrc),               &
     &                             z_r,                                 &
#  ifdef MASKING
     &                             rmask,                               &
#  endif
     &                             ADmodVal)
          END IF
        END DO
# endif
        IF (SOUTH_WEST_TEST) THEN
          IF (Master) THEN
            WRITE (stdout,10) tdays(ng), NstrObs(ng), NendObs(ng),      &
     &                        iic(ng)
  10        FORMAT (3x,' AD_MISFIT   - Added observations misfit ',     &
     &              'forcing,',t64,'t = ',f12.4,/,19x,'(Observation ',  &
     &              'records = ',i7.7,' - ',i7.7,', iic = ',i7.7,')')
          END IF
        END IF
      END IF        
      RETURN
      END SUBROUTINE ad_misfit_tile
#endif
      END MODULE ad_misfit_mod
