      MODULE ad_smooth_mod
#if defined SMOOTH_ADM && defined ADJOINT
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine smooths requested adjoint state record with a Shapiro  !
!  filter configured as a harmonic filter (order 2).  This is used to  !
!  remove selective scales in the adjoint solution used in the  4DVAR  !
!  descent algorithm .  This is  somewhat similar to a convolution of  !
!  the diffusion operator.                                             !
!                                                                      !
!=======================================================================
!
      implicit none

      PRIVATE
      PUBLIC ad_smooth

      CONTAINS
!
!***********************************************************************
      SUBROUTINE ad_smooth (ng, tile, Lrec)
!***********************************************************************
!
      USE mod_param
      USE mod_grid
      USE mod_ocean
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile, Lrec
!
!  Local variable declarations.
!
# include "tile.h"
!
# ifdef PROFILE
      CALL wclock_on (ng, iADM, 36)
# endif
      CALL ad_smooth_tile (ng, Istr, Iend, Jstr, Jend,                  &
     &                     LBi, UBi, LBj, UBj,                          &
     &                     Lrec,                                        &
# ifdef MASKING
     &                     GRID(ng) % rmask,                            &
     &                     GRID(ng) % umask,                            &
     &                     GRID(ng) % vmask,                            &
# endif
# ifdef SOLVE3D
     &                     OCEAN(ng) % ad_t,                            &
     &                     OCEAN(ng) % ad_u,                            &
     &                     OCEAN(ng) % ad_v,                            &
# endif
     &                     OCEAN(ng) % ad_ubar,                         &
     &                     OCEAN(ng) % ad_vbar,                         &
     &                     OCEAN(ng) % ad_zeta)
# ifdef PROFILE
      CALL wclock_off (ng, iADM, 36)
# endif
      RETURN
      END SUBROUTINE ad_smooth
!
!***********************************************************************
      SUBROUTINE ad_smooth_tile (ng, model, Istr, Iend, Jstr, Jend,     &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           Lrec,
# ifdef MASKING
     &                           rmask, umask, vmask,                   &
# endif
# ifdef SOLVE3D
     &                           ad_t, ad_u, ad_v,                      &
# endif
     &                           ad_ubar, ad_vbar, ad_zeta)
!***********************************************************************
!
      USE mod_param
!
      USE shapiro_mod
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: Lrec
!
# ifdef ASSUMED_SHAPE
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:,LBj:)
      real(r8), intent(in) :: umask(LBi:,LBj:)
      real(r8), intent(in) :: vmask(LBi:,LBj:)
#  endif
#  ifdef SOLVE3D
      real(r8), intent(inout) :: ad_t(LBi:,LBj:,:,:,:)
      real(r8), intent(inout) :: ad_u(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: ad_v(LBi:,LBj:,:,:)
#  endif
      real(r8), intent(inout) :: ad_ubar(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_vbar(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_zeta(LBi:,LBj:,:)
# else
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: umask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: vmask(LBi:UBi,LBj:UBj)
#  endif
#  ifdef SOLVE3D
      real(r8), intent(inout) :: ad_t(LBi:UBi,LBj:UBj,N(ng),3,NT(ng))
      real(r8), intent(inout) :: ad_u(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(inout) :: ad_v(LBi:UBi,LBj:UBj,N(ng),2)
#  endif
      real(r8), intent(inout) :: ad_ubar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(inout) :: ad_vbar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(inout) :: ad_zeta(LBi:UBi,LBj:UBj,3)
# endif
!
!  Local variable declarations.
!
      integer :: IstrR, IendR, JstrR, JendR, IstrU, JstrV
# ifdef SOLVE3D
      integer :: itrc
# endif

# include "set_bounds.h"
!
!-----------------------------------------------------------------------
!  Smooth requested adjoint solution.
!-----------------------------------------------------------------------
!
!  Free-surface.
!
      CALL shapiro2d_tile (ng, iADM, Istr, Iend, Jstr, Jend,            &
     &                     LBi, UBi, LBj, UBj,                          &
# ifdef MASKING
     &                     rmask,                                       &
# endif
     &                     ad_zeta(:,:,Lrec))
!
!  2D momentum.
!
      CALL shapiro2d_tile (ng, iADM, IstrU, Iend, Jstr, Jend,           &
     &                     LBi, UBi, LBj, UBj,                          &
# ifdef MASKING
     &                     umask,                                       &
# endif
     &                     ad_ubar(:,:,Lrec))

      CALL shapiro2d_tile (ng, iADM, Istr, Iend, JstrV, Jend,           &
     &                     LBi, UBi, LBj, UBj,                          &
# ifdef MASKING
     &                     vmask,                                       &
# endif
     &                     ad_vbar(:,:,Lrec))
# ifdef SOLVE3D
!
!  3D momentum.
!
      CALL shapiro3d_tile (ng, iADM, IstrU, Iend, Jstr, Jend,           &
     &                     LBi, UBi, LBj, UBj, 1, N(ng),                &
#  ifdef MASKING
     &                     umask,                                       &
#  endif
     &                     ad_u(:,:,:,Lrec))

      CALL shapiro3d_tile (ng, iADM, Istr, Iend, JstrV, Jend,           &
     &                     LBi, UBi, LBj, UBj, 1, N(ng),                &
#  ifdef MASKING
     &                     vmask,                                       &
#  endif
     &                     ad_v(:,:,:,Lrec))
!
!  Tracers.
!
       DO itrc=1,NT(ng)
         CALL shapiro3d_tile (ng, iADM, Istr, Iend, Jstr, Jend,         &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
#  ifdef MASKING
     &                        rmask,                                    &
#  endif
     &                        ad_t(:,:,:,Lrec,itrc))
      END DO
# endif

      RETURN
      END SUBROUTINE ad_smooth_tile
#endif
      END MODULE ad_smooth_mod


