#include "cppdefs.h"

#ifdef EW_PERIODIC
# define I_RANGE Istr-1,Iend+1
#else
# define I_RANGE MAX(Istr-1,1),MIN(Iend+1,Lm(ng))
#endif
#ifdef NS_PERIODIC
# define J_RANGE Jstr-1,Jend+1
#else
# define J_RANGE MAX(Jstr-1,1),MIN(Jend+1,Mm(ng))
#endif

      SUBROUTINE ad_t3dmix4 (ng, tile)
!
!***********************************************************************
!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                          !
!************************************************** Hernan G. Arango ***
!                                                                      !
!  This subroutine computes adjoint horizontal biharmonic mixing       !
!  of tracers along S-coordinate levels surfaces.                      !
!                                                                      !
!***********************************************************************
!
      USE mod_param
#ifdef DIAGNOSTICS_TS
!!    USE mod_diags
#endif
      USE mod_grid
      USE mod_mixing
      USE mod_ocean
      USE mod_stepping
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile
!
!  Local variable declarations.
!
#include "tile.h"
!
#ifdef PROFILE
      CALL wclock_on (ng, iADM, 27)
#endif
      CALL ad_t3dmix4_tile (ng, Istr, Iend, Jstr, Jend,                 &
     &                      LBi, UBi, LBj, UBj,                         &
     &                      nrhs(ng), nnew(ng),                         &
#ifdef MASKING
     &                      GRID(ng) % umask,                           &
     &                      GRID(ng) % vmask,                           &
#endif
     &                      GRID(ng) % Hz,                              &
     &                      GRID(ng) % ad_Hz,                           &
     &                      GRID(ng) % pmon_u,                          &
     &                      GRID(ng) % pnom_v,                          &
     &                      GRID(ng) % pm,                              &
     &                      GRID(ng) % pn,                              &
     &                      MIXING(ng) % diff4,                         &
#ifdef DIAGNOSTICS_TS
!!   &                      DIAGS(ng) % DiaTwrk,                        &
#endif
     &                      OCEAN(ng) % t,                              &
     &                      OCEAN(ng) % ad_t)
#ifdef PROFILE
      CALL wclock_off (ng, iADM, 27)
#endif
      RETURN
      END SUBROUTINE ad_t3dmix4
!
!***********************************************************************
      SUBROUTINE ad_t3dmix4_tile (ng, Istr, Iend, Jstr, Jend,           &
     &                            LBi, UBi, LBj, UBj,                   &
     &                            nrhs, nnew,                           &
#ifdef MASKING
     &                            umask, vmask,                         &
#endif
     &                            Hz, ad_Hz,                            &
     &                            pmon_u, pnom_v, pm, pn,               &
     &                            diff4,                                &
#ifdef DIAGNOSTICS_TS
!!   &                            DiaTwrk,                              &
#endif
     &                            t, ad_t)
!***********************************************************************
!
      USE mod_param
      USE mod_scalars
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: nrhs, nnew

#ifdef ASSUMED_SHAPE
# ifdef MASKING
      real(r8), intent(in) :: umask(LBi:,LBj:)
      real(r8), intent(in) :: vmask(LBi:,LBj:)
# endif
      real(r8), intent(in) :: Hz(LBi:,LBj:,:)
      real(r8), intent(in) :: pmon_u(LBi:,LBj:)
      real(r8), intent(in) :: pnom_v(LBi:,LBj:)
      real(r8), intent(in) :: pm(LBi:,LBj:)
      real(r8), intent(in) :: pn(LBi:,LBj:)
      real(r8), intent(in) :: diff4(LBi:,LBj:,:)
      real(r8), intent(in) :: t(LBi:,LBj:,:,:,:)
# ifdef DIAGNOSTICS_TS
!!    real(r8), intent(inout) :: DiaTwrk(LBi:,LBj:,:,:,:)
# endif
      real(r8), intent(inout) :: ad_Hz(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_t(LBi:,LBj:,:,:,:)
#else
# ifdef MASKING
      real(r8), intent(in) :: umask(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: vmask(LBi:UBi,LBj:UBj)
# endif
      real(r8), intent(in) :: Hz(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(in) :: pmon_u(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: pnom_v(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: pm(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: pn(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: diff4(LBi:UBi,LBj:UBj,NT(ng))
      real(r8), intent(in) :: t(LBi:UBi,LBj:UBj,N(ng),3,NT(ng))
# ifdef DIAGNOSTICS_TS
!!    real(r8), intent(inout) :: DiaTwrk(LBi:UBi,LBj:UBj,N(ng),NT(ng),  &
!!   &                                   NDT)
# endif
      real(r8), intent(inout) :: ad_Hz(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: ad_t(LBi:UBi,LBj:UBj,N(ng),3,NT(ng))
#endif
!
!  Local variable declarations.
!
      integer :: IstrR, IendR, JstrR, JendR, IstrU, JstrV
      integer :: ILB, IUB, JLB, JUB
      integer :: i, itrc, j, k

      real(r8) :: adfac, adfac1, adfac2, ad_cff, cff

      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: FE
      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: FX
      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: LapT

      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: ad_FE
      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: ad_FX
      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: ad_LapT

#include "set_bounds.h"
!
      ILB=LBOUND(ad_FE,DIM=1)
      IUB=UBOUND(ad_FE,DIM=1)
      JLB=LBOUND(ad_FE,DIM=2)
      JUB=UBOUND(ad_FE,DIM=2)
!
!-----------------------------------------------------------------------
!  Initialize adjoint private variables.
!-----------------------------------------------------------------------
!
      ad_cff=0.0_r8

      ad_FE(ILB:IUB,JLB:JUB)=0.0_r8
      ad_FX(ILB:IUB,JLB:JUB)=0.0_r8

      ad_LapT(ILB:IUB,JLB:JUB)=0.0_r8
!
!----------------------------------------------------------------------
!  Compute adjoint horizontal biharmonic diffusion along constant
!  S-surfaces.  The biharmonic operator is computed by applying the
!  harmonic operator twice.
!----------------------------------------------------------------------
!
      DO itrc=1,NT(ng)
        DO k=1,N(ng)
!
!  Compute FX=d(LapT)/d(xi) and FE=d(LapT)/d(eta) BASIC STATE terms.
!
          DO j=J_RANGE
            DO i=I_RANGE+1
              cff=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*          &
     &            pmon_u(i,j)
#ifdef MASKING
              cff=cff*umask(i,j)
#endif
              FX(i,j)=cff*(Hz(i,j,k)+Hz(i-1,j,k))*                      &
     &                (t(i  ,j,k,nrhs,itrc)-                            &
     &                 t(i-1,j,k,nrhs,itrc))
            END DO
          END DO
          DO j=J_RANGE+1
            DO i=I_RANGE
              cff=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*          &
                  pnom_v(i,j)
#ifdef MASKING
              cff=cff*vmask(i,j)
#endif
              FE(i,j)=cff*(Hz(i,j,k)+Hz(i,j-1,k))*                      &
     &                (t(i,j  ,k,nrhs,itrc)-                            &
     &                 t(i,j-1,k,nrhs,itrc))
            END DO
          END DO
!
!  Compute first BASIC STATE harmonic operator and multiply by the
!  metrics of the second harmonic operator.
!
          DO j=J_RANGE
            DO i=I_RANGE
              cff=1.0_r8/Hz(i,j,k)
              LapT(i,j)=pm(i,j)*pn(i,j)*cff*                            &
     &                  (FX(i+1,j)-FX(i,j)+                             &
     &                   FE(i,j+1)-FE(i,j))
            END DO
          END DO
!
!  Apply boundary conditions (except periodic; closed or gradient)
!  to the first harmonic operator.
!
#ifndef EW_PERIODIC
          IF (WESTERN_EDGE) THEN
            DO j=J_RANGE
# ifdef WESTERN_WALL
              LapT(Istr-1,j)=0.0_r8
# else
              LapT(Istr-1,j)=LapT(Istr,j)
# endif
            END DO
          END IF
          IF (EASTERN_EDGE) THEN
            DO j=J_RANGE
# ifdef EASTERN_WALL
              LapT(Iend+1,j)=0.0_r8
# else
              LapT(Iend+1,j)=LapT(Iend,j)
# endif
            END DO
          END IF
#endif
#ifndef NS_PERIODIC
          IF (SOUTHERN_EDGE) THEN
            DO i=I_RANGE
# ifdef SOUTHERN_WALL
              LapT(i,Jstr-1)=0.0_r8
# else
              LapT(i,Jstr-1)=LapT(i,Jstr)
# endif
            END DO
          END IF
          IF (NORTHERN_EDGE) THEN
            DO i=I_RANGE
# ifdef NORTHERN_WALL
              LapT(i,Jend+1)=0.0_r8
# else
              LapT(i,Jend+1)=LapT(i,Jend)
# endif
            END DO
          END IF
#endif
!
!  Time-step biharmonic, S-surfaces diffusion term (m Tunits).
!
          DO j=Jstr,Jend
            DO i=Istr,Iend
#ifdef DIAGNOSTICS_TS
!!            DiaTwrk(i,j,k,itrc,iThdif)=-cff
#endif
#ifdef TS_MPDATA
!>            tl_t(i,j,k,3,itrc)=tl_t(i,j,k,nnew,itrc)
!>
              ad_t(i,j,k,nnew,itrc)=ad_t(i,j,k,nnew,itrc)+              &
     &                              ad_t(i,j,k,3,itrc)
              ad_t(i,j,k,3,itrc)=0.0_r8
#endif
!>            tl_t(i,j,k,nnew,itrc)=tl_t(i,j,k,nnew,itrc)-tl_cff
!>
              ad_cff=ad_cff-ad_t(i,j,k,nnew,itrc)
!>            tl_cff=dt(ng)*pm(i,j)*pn(i,j)*                            &
!>   &                      (tl_FX(i+1,j)-tl_FX(i,j)+                   &
!>   &                       tl_FE(i,j+1)-tl_FE(i,j))
!>
              adfac=dt(ng)*pm(i,j)*pn(i,j)*ad_cff
              ad_FX(i  ,j)=ad_FX(i  ,j)-adfac
              ad_FX(i+1,j)=ad_FX(i+1,j)+adfac
              ad_FE(i,j  )=ad_FE(i,j  )-adfac
              ad_FE(i,j+1)=ad_FE(i,j+1)+adfac
              ad_cff=0.0_r8
            END DO
          END DO
!
!  Compute ad_FE=d(ad_LapT)/d(eta) and ad_FX=d(ad_LapT)/d(xi) terms.
!
          DO j=Jstr,Jend+1
            DO i=Istr,Iend
#ifdef MASKING
!>            tl_FE(i,j)=tl_FE(i,j)*vmask(i,j)
!>
              ad_FE(i,j)=ad_FE(i,j)*vmask(i,j)
#endif
!>            tl_FE(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*   &
!>   &                   pnom_v(i,j)*                                   &
!>   &                   ((tl_Hz(i,j,k)+tl_Hz(i,j-1,k))*                &
!>   &                    (LapT(i,j)-LapT(i,j-1))+                      &
!>   &                    (Hz(i,j,k)+Hz(i,j-1,k))*                      &
!>   &                    (tl_LapT(i,j)-tl_LapT(i,j-1)))
!>
              adfac=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*        &
     &              pnom_v(i,j)*ad_FE(i,j)
              adfac1=adfac*(LapT(i,j)-LapT(i,j-1))
              adfac2=adfac*(Hz(i,j,k)+Hz(i,j-1,k))
              ad_Hz(i,j-1,k)=ad_Hz(i,j-1,k)+adfac1
              ad_Hz(i,j  ,k)=ad_Hz(i,j  ,k)+adfac1
              ad_LapT(i,j-1)=ad_LapT(i,j-1)-adfac2
              ad_LapT(i,j  )=ad_LapT(i,j  )+adfac2
              ad_FE(i,j)=0.0_r8
            END DO
          END DO
          DO j=Jstr,Jend
            DO i=Istr,Iend+1
#ifdef MASKING
!>            tl_FX(i,j)=tl_FX(i,j)*umask(i,j)
!>
              ad_FX(i,j)=ad_FX(i,j)*umask(i,j)
#endif
!>            tl_FX(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*   &
!>   &                   pmon_u(i,j)*                                   &
!>   &                   ((tl_Hz(i,j,k)+tl_Hz(i-1,j,k))*                &
!>   &                    (LapT(i,j)-LapT(i-1,j))+                      &
!>   &                    (Hz(i,j,k)+Hz(i-1,j,k))*                      &
!>   &                    (tl_LapT(i,j)-tl_LapT(i-1,j)))
!>
              adfac=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*        &
     &              pmon_u(i,j)*ad_FX(i,j)
              adfac1=adfac*(LapT(i,j)-LapT(i-1,j))
              adfac2=adfac*(Hz(i,j,k)+Hz(i-1,j,k))
              ad_Hz(i-1,j,k)=ad_Hz(i-1,j,k)+adfac1
              ad_Hz(i  ,j,k)=ad_Hz(i  ,j,k)+adfac1
              ad_LapT(i-1,j)=ad_LapT(i-1,j)-adfac2
              ad_LapT(i  ,j)=ad_LapT(i  ,j)+adfac2
              ad_FX(i,j)=0.0_r8
            END DO
          END DO
!
!  Apply boundary conditions (except periodic; closed or gradient)
!  to the first harmonic operator.
!
#ifndef NS_PERIODIC
          IF (NORTHERN_EDGE) THEN
            DO i=I_RANGE
# ifdef NORTHERN_WALL
!>            tl_LapT(i,Jend+1)=0.0_r8
!>
              ad_LapT(i,Jend+1)=0.0_r8
# else
!>            tl_LapT(i,Jend+1)=tl_LapT(i,Jend)
!>
              ad_LapT(i,Jend)=ad_LapT(i,Jend)+ad_LapT(i,Jend+1)
              ad_LapT(i,Jend+1)=0.0_r8
# endif
            END DO
          END IF
          IF (SOUTHERN_EDGE) THEN
            DO i=I_RANGE
# ifdef SOUTHERN_WALL
!>            tl_LapT(i,Jstr-1)=0.0_r8
!>
              ad_LapT(i,Jstr-1)=0.0_r8
# else
!>            tl_LapT(i,Jstr-1)=tl_LapT(i,Jstr)
!>
              ad_LapT(i,Jstr)=ad_LapT(i,Jstr)+ad_LapT(i,Jstr-1)
              ad_LapT(i,Jstr-1)=0.0_r8
# endif
            END DO
          END IF
#endif
#ifndef EW_PERIODIC
          IF (EASTERN_EDGE) THEN
            DO j=J_RANGE
# ifdef EASTERN_WALL
!>            tl_LapT(Iend+1,j)=0.0_r8
!>
              ad_LapT(Iend+1,j)=0.0_r8
# else
!>            tl_LapT(Iend+1,j)=tl_LapT(Iend,j)
!>
              ad_LapT(Iend,j)=ad_LapT(Iend,j)+ad_LapT(Iend+1,j)
              ad_LapT(Iend+1,j)=0.0_r8
# endif
            END DO
          END IF
          IF (WESTERN_EDGE) THEN
            DO j=J_RANGE
# ifdef WESTERN_WALL
!>            tl_LapT(Istr-1,j)=0.0_r8
!>
              ad_LapT(Istr-1,j)=0.0_r8
# else
!>            tl_LapT(Istr-1,j)=tl_LapT(Istr,j)
!>
              ad_LapT(Istr,j)=ad_LapT(Istr,j)+ad_LapT(Istr-1,j)
              ad_LapT(Istr-1,j)=0.0_r8
# endif
            END DO
          END IF
#endif
!
!  Compute first harmonic operator and multiply by the metrics of the
!  second harmonic operator.
!
          DO j=J_RANGE
            DO i=I_RANGE
              cff=1.0_r8/Hz(i,j,k)
!>            tl_LapT(i,j)=pm(i,j)*pn(i,j)*                             &
!>   &                     (tl_cff*                                     &
!>   &                      (FX(i+1,j)-FX(i,j)+                         &
!>   &                       FE(i,j+1)-FE(i,j))+                        &
!>   &                      cff*                                        &
!>   &                      (tl_FX(i+1,j)-tl_FX(i,j)+                   &
!>   &                       tl_FE(i,j+1)-tl_FE(i,j)))
!>
              adfac=pm(i,j)*pn(i,j)*ad_LapT(i,j)
              adfac1=cff*adfac
              ad_cff=ad_cff+                                            &
     &               adfac*(FX(i+1,j)-FX(i,j)+                          &
     &                      FE(i,j+1)-FE(i,j))
              ad_FX(i  ,j)=ad_FX(i  ,j)-adfac1
              ad_FX(i+1,j)=ad_FX(i+1,j)+adfac1
              ad_FE(i,j  )=ad_FE(i,j  )-adfac1
              ad_FE(i,j+1)=ad_FE(i,j+1)+adfac1
              ad_LapT(i,j)=0.0_r8
!>            tl_cff=-cff*cff*tl_Hz(i,j,k)
!>
              ad_Hz(i,j,k)=ad_Hz(i,j,k)-cff*cff*ad_cff              
              ad_cff=0.0_r8
            END DO
          END DO
!
!  Compute horizontal tracer flux in the ETA- and XI-directions.
!
          DO j=J_RANGE+1
            DO i=I_RANGE
              cff=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*          &
                  pnom_v(i,j)
#ifdef MASKING
              cff=cff*vmask(i,j)
#endif
!>            tl_FE(i,j)=cff*                                           &
!>   &                   ((tl_Hz(i,j,k)+tl_Hz(i,j-1,k))*                &
!>   &                    (t(i,j  ,k,nrhs,itrc)-                        &
!>   &                     t(i,j-1,k,nrhs,itrc))+                       &
!>   &                    (Hz(i,j,k)+Hz(i,j-1,k))*                      &
!>   &                    (tl_t(i,j  ,k,nrhs,itrc)-                     &
!>   &                     tl_t(i,j-1,k,nrhs,itrc)))
!>
              adfac=cff*ad_FE(i,j)
              adfac1=adfac*(t(i,j  ,k,nrhs,itrc)-                       &
     &                      t(i,j-1,k,nrhs,itrc))
              adfac2=adfac*(Hz(i,j,k)+Hz(i,j-1,k))
              ad_Hz(i,j-1,k)=ad_Hz(i,j-1,k)+adfac1
              ad_Hz(i,j  ,k)=ad_Hz(i,j  ,k)+adfac1
              ad_t(i,j-1,k,nrhs,itrc)=ad_t(i,j-1,k,nrhs,itrc)-adfac2
              ad_t(i,j  ,k,nrhs,itrc)=ad_t(i,j  ,k,nrhs,itrc)+adfac2
              ad_FE(i,j)=0.0_r8
            END DO
          END DO
          DO j=J_RANGE
            DO i=I_RANGE+1
              cff=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*          &
     &            pmon_u(i,j)
#ifdef MASKING
              cff=cff*umask(i,j)
#endif
!>            tl_FX(i,j)=cff*                                           &
!>   &                   ((tl_Hz(i,j,k)+tl_Hz(i-1,j,k))*                &
!>   &                    (t(i  ,j,k,nrhs,itrc)-                        &
!>   &                     t(i-1,j,k,nrhs,itrc))+                       &
!>   &                    (Hz(i,j,k)+Hz(i-1,j,k))*                      &
!>   &                    (tl_t(i  ,j,k,nrhs,itrc)-                     &
!>   &                     tl_t(i-1,j,k,nrhs,itrc)))
!>
              adfac=cff*ad_FX(i,j)
              adfac1=adfac*(t(i  ,j,k,nrhs,itrc)-                       &
     &                      t(i-1,j,k,nrhs,itrc))
              adfac2=adfac*(Hz(i,j,k)+Hz(i-1,j,k))
              ad_Hz(i-1,j,k)=ad_Hz(i-1,j,k)+adfac1
              ad_Hz(i  ,j,k)=ad_Hz(i  ,j,k)+adfac1
              ad_t(i-1,j,k,nrhs,itrc)=ad_t(i-1,j,k,nrhs,itrc)-adfac2
              ad_t(i  ,j,k,nrhs,itrc)=ad_t(i  ,j,k,nrhs,itrc)+adfac2
              ad_FX(i,j)=0.0_r8
            END DO
          END DO
        END DO
      END DO
#undef I_RANGE
#undef J_RANGE
      RETURN
      END SUBROUTINE ad_t3dmix4_tile
