#
# Include file for MPIF90 compiler on Linux (specifically ijet at FSL)
# -----------------------------------------------------------------
#
# ARPACK_LIBDIR  ARPACK libary directory
# FC             Name of the fortran compiler to use
# FFLAGS         Flags to the fortran compiler
# CPP            Name of the C-preprocessor
# CPPFLAGS       Flags to the C-preprocessor
# CLEAN          Name of cleaning executable after C-preprocessing
# NETCDF_INCDIR  NetCDF include directory
# NETCDF_LIBDIR  NetCDF libary directory
# LD             Program to load the objects into an executable
# LDFLAGS        Flags to the loader
# RANLIB         Name of ranlib command
# MDEPFLAGS      Flags for sfmakedepend  (-s if you keep .f files)
#
# First the defaults
#
               FC := mpif90
           FFLAGS := -FI -pad -ip -w -cm
              CPP := /misc/ihome/dobbins/bin/cpp/cpp
         CPPFLAGS := -P -DLINUX
            CLEAN := Bin/cpp_clean
               LD := $(FC)
          LDFLAGS := 
               AR := ar
          ARFLAGS := r
               RM := rm -f
           RANLIB := ranlib
             PERL := perl

        MDEPFLAGS := --cpp --fext=f90 --file=-

#
# Library locations, can be overridden by environment variables.
#

    NETCDF_INCDIR ?= /opt/netcdf-3.5.0/include
    NETCDF_LIBDIR ?= /opt/netcdf-3.5.0/lib

         CPPFLAGS += -I$(NETCDF_INCDIR)
             LIBS := -L$(NETCDF_LIBDIR) -lnetcdf

ifdef ARPACK
    ARPACK_LIBDIR ?= /opt/intelsoft/ARPACK
             LIBS += -L$(ARPACK_LIBDIR) -larpack_LINUX
endif

ifdef MPI
         CPPFLAGS += -DMPI -I/opt/mpich-1.2.5..12_i71/include
             LIBS += -I/opt/mpich-1.2.5..12_i71/lib
endif

ifdef OpenMP
         CPPFLAGS += -D_OPENMP
           FFLAGS += -openmp
endif

ifdef DEBUG
           FFLAGS += -g -check bounds
else
           FFLAGS += -O3
#           FFLAGS += -O
endif

       clean_list += ifc* work.pc*
