#include "cppdefs.h"
!!
!!================================================== Andrew M. Moore ===
!!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                         !
!!================================================= Hernan G. Arango ===
!!                                                                     !
!!  Regional Ocean Model System (ROMS) Drivers:                        !
!!                                                                     !
!!  convolution.h     ROMS/TOMS convolve an adjoint solution.          !
!!  correlation.h     ROMS?TOMS background-error correlation.          !
!!  nl_ocean.h        ROMS/TOMS nonlinear model.                       !
!!  tl_ocean.h        ROMS/TOMS tangent linear model.                  !
!!  rp_ocean.h        ROMS/TOMS representer tangent linear model.      !
!!  ad_ocean.h        ROMS/TOMS adjoint model.                         !
!!  adsen_ocean.h     ROMS/TOMS adjoint sensitivity analysis driver.   !
!!  afte_ocean.h      ROMS/TOMS adjoint finite time eigenmodes driver. !
!!  fte_ocean.h       ROMS/TOMS finite time eigenmodes driver.         !
!!  fsv_ocean.h       ROMS/TOMS forcing singular vectors driver.       !
!!  grad_ocean.h      ROMS/TOMS tangent linear and adjoint models      !
!!                      gradient test.                                 !
!!  tlcheck_ocean.h   ROMS/TOMS tangent linear model linearization     !
!!                      test.                                          !
!!  pert_ocean.h      ROMS/TOMS tangent linear and adjoint models      !
!!                      sanity test.                                   !
!!  picard_ocean.h    ROMS/TOMS Picard test for representers tangent   !
!!                      linear model.                                  ! 
!!  op_ocean.h        ROMS/TOMS optimal perturbations.                 !
!!  represeter.h      ROMS/TOMS representer matrix symmetry driver.    !
!!  s4dvar_ocean.h    ROMS/TOMS strong constraint 4DVAR assimilation.  !
!!  so_semi_ocean.h   ROMS/TOMS stochastic optimals, semi-norm.        !
!!  is4dvar_ocean.h   ROMS/TOMS Strong constraint incremental 4DVAR    !
!!                      assimilation.                                  !
!!  w4dvar_ocean.h    ROMS/TOMS weak constraint 4DVAR assimilation.    !
!!                                                                     !
!!======================================================================
!!
#if defined AD_SENSITIVITY
# include "adsen_ocean.h"
#elif defined AFT_EIGENMODES
# include "afte_ocean.h"
#elif defined CONVOLUTION
# include "convolution.h"
#elif defined CORRELATION
# include "correlation.h"
#elif defined FT_EIGENMODES
# include "fte_ocean.h"
#elif defined FORCING_SV
# include "fsv_ocean.h"
#elif defined GRADIENT_CHECK
# include "grad_ocean.h"
#elif defined OPT_PERTURBATION
# include "op_ocean.h"
#elif defined SO_SEMI
# include "so_semi_ocean.h"
#elif defined TLM_CHECK
# include "tlcheck_ocean.h"
#elif defined INNER_PRODUCT || defined SANITY_CHECK
# include "pert_ocean.h"
#elif defined PICARD_TEST
# include "picard_ocean.h"
#elif defined R_SYMMETRY
# include "symmetry.h"
#elif defined S4DVAR
# include "s4dvar_ocean.h"
#elif defined IS4DVAR
# include "is4dvar_ocean.h"
#elif defined W4DVAR
# include "w4dvar_ocean.h"
#else
# if defined TLM_DRIVER
#  include "tl_ocean.h"
# elif defined RPM_DRIVER
#  include "rp_ocean.h"
# elif defined ADM_DRIVER
#  include "ad_ocean.h"
# else
#  include "nl_ocean.h"
# endif
#endif
