/*
** Include file "globaldef.h"
***************************************** Alexander F. Shchepetkin ***
** Copyright (c) 2006 ROMS/TOMS Group, version 3.0                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** WARNING: This  file  contains  a set of  predetermined           **
**          macro definitions which are inserted into the           **
** individual files by the C-preprocessor. It is strongly           **
** recommended to NOT modify any of the definitions below.          **
**                                                                  **
**********************************************************************
*/

/*
** Set assumed-shape array switch.  Imported arrays with dummy 
** arguments that takes the shape of the actual argument passed
** to it.  If off, all the arrays are explicit-shape.  In some
** computer explicit-shape arrays slow down performacnce because
** the arrays are copied when passed by arguments.
*/

#define ASSUMED_SHAPE
#if defined G95 && defined I686
# undef ASSUMED_SHAPE
#elif defined UNICOS_SN
# undef ASSUMED_SHAPE
#endif

/*
** Set internal distributed-memory switch.
*/

#if defined MPI
# define DISTRIBUTE
#endif

/*
** Turn ON/OFF debugging switch. It avoids writing current date and
** CPP options to NetCDF file headers. This is used to compare serial
** and parallel solutions where the UNIX command "diff" is used between
** NetCDF files.  It will only tell us that the binary files are
** different or not.  Finding the parallel bug is complete different
** story.
*/

#undef  DEBUGGING

/*
** Turn ON/OFF time profiling.
*/

#define PROFILE

/*
** Set default time-averaging filter for barotropic fields.
**
*/

#ifdef SOLVE3D
# undef COSINE2
# define POWER_LAW
#endif
#ifdef CGOA_3
# define COSINE2
# undef  POWER_LAW
#endif

/*
** Turn ON/OFF switch to include/disregard the difference between
** rho0 and surface density in the computation of baroclinic pressure
** term.
*/

#define RHO_SURF

/*
** Activate bacroclinic pressure gradient response due to the
** perturbation of free-surface in the presence of stratification
** and bathymetry.
*/

#ifdef SOLVE3D
# define VAR_RHO_2D
#endif

/*
** Activate criteria for isopycnic diffusion of tracer as maximum
** density slope or minimum density stratification.  Choose only
** one option. If neither option is activated, the default criteria
** is used in the algorithm.
*/

#if defined MIX_ISO_TS && (defined TS_DIF2 || defined TS_DIF4)
# undef   MAX_SLOPE
# undef   MIN_STRAT
#endif

/*
** Turn ON/OFF double precision for real type variables and
** associated intrinsic functions.
*/

#define DOUBLE_PRECISION

/*
** Define macro for the first 2D time-step.
*/

#ifdef SOLVE3D
# define FIRST_2D_STEP iif(ng).eq.1
#else
# define FIRST_2D_STEP iic(ng).eq.ntfirst
#endif

/*
** Define global grid lower and upper bounds in the I- and
** J-directions. These values are a function of periodicity.
** They are used in both shared- and distributed-memory
** configurations.
*/

#ifdef EW_PERIODIC
# ifdef NS_PERIODIC
#  define LOWER_BOUND_I -2
#  define UPPER_BOUND_I Im(ng)+2
#  define LOWER_BOUND_J -2
#  define UPPER_BOUND_J Jm(ng)+2
# else
#  define LOWER_BOUND_I -2
#  define UPPER_BOUND_I Im(ng)+2
#  define LOWER_BOUND_J 0
#  define UPPER_BOUND_J Jm(ng)+1
# endif
#else
# ifdef NS_PERIODIC
#  define LOWER_BOUND_I 0
#  define UPPER_BOUND_I Im(ng)+1
#  define LOWER_BOUND_J -2
#  define UPPER_BOUND_J Jm(ng)+2
# else
#  define LOWER_BOUND_I 0
#  define UPPER_BOUND_I Im(ng)+1
#  define LOWER_BOUND_J 0
#  define UPPER_BOUND_J Jm(ng)+1
# endif
#endif
#define XI_DIM LOWER_BOUND_I:UPPER_BOUND_I
#define ETA_DIM LOWER_BOUND_J:UPPER_BOUND_J
#define GLOBAL_2D_ARRAY XI_DIM,ETA_DIM
#define PRIVATE_1D_SCRATCH_ARRAY Istr-3:Iend+3
#define PRIVATE_2D_SCRATCH_ARRAY Istr-3:Iend+3,Jstr-3:Jend+3

/*
** Set number of ghost-points in the halo region.
*/

#if defined TS_MPDATA || defined UV_VIS4
# define GHOST_POINTS 3
# if defined DISTRIBUTE || defined EW_PERIODIC || defined NS_PERIODIC
#   define THREE_GHOST
# endif
#else
# define GHOST_POINTS 2
#endif

/*
** Remove OpenMP directives in serial and distributed memory 
** Applications.  This definition will be used in conjunction with
** the pearl script "cpp_clean" to remove the full directive.
*/

#if !defined _OPENMP
# define OMP !
#endif

/*
** Set tile variable for distributed- or shared-memory configurations.
*/

#ifdef DISTRIBUTE
# define TILE MyRank
#else
# define TILE tile
#endif

/*
** The following definitions contain fortran logical expressions
** equivalent to the question: ''Am I the thread working on a tile
** which is adjacent to the WESTERN, EASTERN, SOUTHERN, or NORTHERN
** edges of the model domain?'' These logical expressions are used to
** update domain boundaries and corners.
*/

#define WESTERN_EDGE Istr.eq.1
#define EASTERN_EDGE Iend.eq.Lm(ng)
#define SOUTHERN_EDGE Jstr.eq.1
#define NORTHERN_EDGE Jend.eq.Mm(ng)
#define SOUTH_WEST_CORNER (Istr.eq.1).and.(Jstr.eq.1)
#define NORTH_WEST_CORNER (Istr.eq.1).and.(Jend.eq.Mm(ng))
#define SOUTH_EAST_CORNER (Iend.eq.Lm(ng)).and.(Jstr.eq.1)
#define NORTH_EAST_CORNER (Iend.eq.Lm(ng)).and.(Jend.eq.Mm(ng))

/*
** The following definitions are fortran logical expressions use
** to update global variables while avoiding mutual overlap between
** threads in shared-memory configurations.
*/

#ifdef DISTRIBUTE
# define SOUTH_WEST_TEST .true.
# define NORTH_WEST_TEST .true.
# define SOUTH_EAST_TEST .true.
# define NORTH_EAST_TEST .true.
#else
# define SOUTH_WEST_TEST (Istr.eq.1).and.(Jstr.eq.1)
# define NORTH_WEST_TEST (Istr.eq.1).and.(Jend.eq.Mm(ng))
# define SOUTH_EAST_TEST (Iend.eq.Lm(ng)).and.(Jstr.eq.1)
# define NORTH_EAST_TEST (Iend.eq.Lm(ng)).and.(Jend.eq.Mm(ng))
#endif

/*
** Choice of double/single precision for real type variables and
** associated intrinsic functions.
*/

#if (defined CRAY || defined CRAYT3E) && !defined CRAYX1
# ifdef  DOUBLE_PRECISION
#  undef  DOUBLE_PRECISION
# endif
#endif

#ifdef DOUBLE_PRECISION
# define nf_get_att_TYPE nf_get_att_double
# define nf_put_att_TYPE nf_put_att_double
# define nf_get_var1_TYPE nf_get_var1_double
# define nf_put_var1_TYPE nf_put_var1_double
# define nf_get_vara_TYPE nf_get_vara_double
# define nf_put_vara_TYPE nf_put_vara_double
# ifdef DISTRIBUTE
#  define PDNAUPD pdnaupd
#  define PDNEUPD pdneupd
#  define PDSAUPD pdsaupd
#  define PDSEUPD pdseupd
#  define PDNORM2 pdnorm2
# else
#  define DNAUPD dnaupd
#  define DNEUPD dneupd
#  define DSAUPD dsaupd
#  define DSEUPD dseupd
#  define DNRM2 dnrm2
# endif
# define DAXPY daxpy
#else
# define nf_get_att_TYPE nf_get_att_real
# define nf_put_att_TYPE nf_put_att_real
# define nf_get_var1_TYPE nf_get_var1_real
# define nf_put_var1_TYPE nf_put_var1_real
# define nf_get_vara_TYPE nf_get_vara_real
# define nf_put_vara_TYPE nf_put_vara_real
# ifdef DISTRIBUTE
#  define PDNAUPD psnaupd
#  define PDNEUPD psneupd
#  define PDSAUPD pssaupd
#  define PDSEUPD psseupd
#  define PDNORM2 psnorm2
# else
#  define DNAUPD snaupd
#  define DNEUPD sneupd
#  define DSAUPD ssaupd
#  define DSEUPD sseupd
#  define DNRM2 snrm2
# endif
#  define DAXPY saxpy
#endif

/*
** Set tangent, tl_ioms and adjoint switches.
*/

#if defined CONVOLUTION      || defined CORRELATION      || \
    defined GRADIENT_CHECK   || defined FT_EIGENMODES    || \
    defined FORCING_SV       || defined INNER_PRODUCT    || \
    defined IS4DVAR          || defined OPT_PERTURBATION || \
    defined R_SYMMETRY       || defined RPM_DRIVER       || \
    defined SANITY_CHECK     || defined TLM_CHECK        || \
    defined TLM_DRIVER       || defined W4DVAR
# define TANGENT
#endif
#if defined AD_SENSITIVITY   || defined ADM_DRIVER       || \
    defined AFT_EIGENMODES   || defined CONVOLUTION      || \
    defined CORRELATION      || defined GRADIENT_CHECK   || \
    defined FORCING_SV       || defined INNER_PRODUCT    || \
    defined IS4DVAR          || defined OPT_PERTURBATION || \
    defined R_SYMMETRY       || defined SANITY_CHECK     || \
    defined SO_SEMI          || defined S4DVAR           || \
    defined TLM_CHECK        || defined W4DVAR
# define ADJOINT
#endif
#if defined PICARD_TEST      || defined RPM_DRIVER       || \
    defined W4DVAR
# define TL_IOMS
#endif
#if !defined ANA_PERTURB                                 && \
    (defined CORRELATION     || defined SANITY_CHECK     || \
     defined R_SYMMETRY)
# define ANA_PERTURB
#endif

/*
** Turn off nonlinear model switch.
*/

#define NONLINEAR
#if defined AD_SENSITIVITY   || defined ADM_DRIVER       || \
    defined AFT_EIGENMODES   || defined FT_EIGENMODES    || \
    defined INNER_PRODUCT    || defined OPT_PERTURBATION || \
    defined PICARD_TEST      || defined SANITY_CHECK     || \
    defined SO_SEMI
# undef NONLINEAR
#endif

/*
** Set output index for multi-time levels variables.
*/

#ifdef SOLVE3D
# if defined TANGENT || defined TL_IOMS
#  define TKOUT kstp(ng)
#  define KOUT kstp(ng)
#  define NOUT nrhs(ng)
# else
#  define KOUT kstp(ng)
#  define NOUT nrhs(ng)
# endif
# ifdef ICE_MODEL
#  define IOUT linew(ng)
#  define IUOUT liunw(ng)
#  define IEOUT lienw(ng)
# endif
#else
# if defined TANGENT || defined TL_IOMS
#  define TKOUT kstp(ng)
# endif
# define KOUT knew(ng)
#endif

/*
** Set internal switch for the need of a propagator driver.
*/

#if defined AFT_EIGENMODES   || defined ENSEMBLE       || \
    defined FORCING_SV       || defined FT_EIGENMODES  || \
    defined OPT_PERTURBATION || defined PSEUDOSPECTRA  || \
    defined SO_SEMI          || defined SO_TRACE       || \
    defined STOCHASTIC_OPT
# define PROPAGATOR
#endif

/*
** Activate checkpointing switch for GST analysis.  This requires
** a modified ARPACK library for symmetric (*saupd, *seupd) and
** non-symmetric (*naupd, *neupd) drivers.
*/

#ifdef PROPAGATOR
# define CHECKPOINTING
#endif

/*
** Activate processing of forward vertical mixing.
**
*/

#if !defined FORWARD_MIXING  && \
    (defined TANGENT         || defined TL_IOMS    || \
     defined ADJOINT)        && \
    (defined LMD_MIXING      || defined GLS_MIXING || \
     defined MY25_MIXING)
# define FORWARD_MIXING
#endif

/*
** Set internal switch for all the 4DVAR schemes.
*/

#if !defined REPRESENTERS  && \
    (defined R_SYMMETRY    || defined W4DVAR       || \
     defined CONVOLUTION)
# define REPRESENTERS
#endif
#if defined CONVOLUTION    || defined CORRELATION  || \
    defined GRADIENT_CHECK || defined IS4DVAR      || \
    defined REPRESENTERS   || defined S4DVAR       || \
    defined TLM_CHECK
# define FOUR_DVAR
#endif
#if defined IS4DVAR || defined REPRESENTERS
# define BACKGROUND
#endif
#if defined GRADIENT_CHECK || defined IS4DVAR || \
    defined TLM_CHECK      || defined W4DVAR
# define TLM_OBS
#endif
#if !(defined ENERGY1_NORM || defined ENERGY2_NORM ||	\
      defined ENERGY3_NORM)
# undef N2NORM_PROFILE
#endif

/*
** Set internal weak constraint switches.
*/

#if defined REPRESENTERS
# define IMPULSE
#endif

/*
** Set in internal switch to activate computation of nonlinear
** equation of state expnasion polynomial T-derivatives.
*/

#if defined LMD_SKPP || defined LMD_BKPP || defined BULK_FLUXES || \
    defined TANGENT  || defined TL_IOMS  || defined ADJOINT
# define EOS_TDERIVATIVE
#endif

/*
** If splines, deactivate horizontal and vertical smoothing of
** Richardson number horizontally and/or vertically.
*/

#ifdef SPLINES
# if defined LMD_MIXING
#  undef RI_HORAVG
#  undef RI_VERAVG
# endif
#endif

/*
** Activate internal switch for the computation of the Brunt-Vaisala
** frequency.
*/

#if defined BVF_MIXING || defined LMD_MIXING  || defined LMD_SKPP    || \
    defined LMD_BKPP   || defined GLS_MIXING  || defined MY25_MIXING
# define BV_FREQUENCY
#endif

/*
** Activate switch for processing climatology data.
*/

#if defined OFFLINE_FLOATS || defined OFFLINE_BIOLOGY
# define ZCLIMATOLOGY
# define M2CLIMATOLOGY
# define TCLIMATOLOGY
# define M3CLIMATOLOGY
# define OCLIMATOLOGY
#endif
#if (defined  ZCLIMATOLOGY && !defined ANA_SSH)     || \
    (defined M2CLIMATOLOGY && !defined ANA_M2CLIMA) || \
    (defined  TCLIMATOLOGY && !defined ANA_TCLIMA)  || \
    (defined M3CLIMATOLOGY && !defined ANA_M3CLIMA)
# define CLM_FILE
#endif
#if defined ZCLIMATOLOGY || defined M2CLIMATOLOGY || \
    defined TCLIMATOLOGY || defined M3CLIMATOLOGY || \
    defined ZCLM_NUDGING || defined M2CLM_NUDGING || \
    defined TCLM_NUDGING || defined M3CLM_NUDGING
# define CLIMATOLOGY
#endif

/*
** Activate internal switch for bottom boundary layer closure.
*/

#if defined SSW_BBL || defined MB_BBL || defined SG_BBL
# define BBL_MODEL
#endif

/*
** Activate internal switch to set-up nudging coefficients.
*/

#if defined ZCLM_NUDGING    || defined M2CLM_NUDGING   || \
    defined TCLM_NUDGING    || defined M3CLM_NUDGING   || \
    defined WEST_FSNUDGING  || defined EAST_FSNUDGING  || \
    defined SOUTH_FSNUDGING || defined NORTH_FSNUDGING || \
    defined WEST_M2NUDGING  || defined EAST_M2NUDGING  || \
    defined SOUTH_M2NUDGING || defined NORTH_M2NUDGING || \
    defined WEST_TNUDGING   || defined EAST_TNUDGING   || \
    defined SOUTH_TNUDGING  || defined NORTH_TNUDGING  || \
    defined WEST_M3NUDGING  || defined EAST_M3NUDGING  || \
    defined SOUTH_M3NUDGING || defined NORTH_M3NUDGING
# define NUDGING_COFF
#endif

/*
** Activate internal switch for FRS
*/

#if (defined WEST_M3FRS  || defined EAST_M3FRS    || \
     defined SOUTH_M3FRS || defined NORTH_M3FRS)
# define M3FRS
#endif
#if (defined WEST_TFRS   || defined EAST_TFRS    || \
     defined SOUTH_TFRS  || defined NORTH_TFRS)
# define TFRS
#endif
#if (defined M3FRS    || defined   TFRS)
# define FRS
#endif

/*
** Activate internal switches requiring open boundary data.
*/

#if (defined WEST_M2RADIATION  && defined WEST_M2NUDGING)  || \
     defined WEST_M2FLATHER    || defined WEST_M2CLAMPED   || \
     defined WEST_M2REDUCED
# define WEST_M2OBC
#endif
#if (defined EAST_M2RADIATION  && defined EAST_M2NUDGING)  || \
     defined EAST_M2FLATHER    || defined EAST_M2CLAMPED   || \
     defined EAST_M2REDUCED
# define EAST_M2OBC
#endif
#if (defined SOUTH_M2RADIATION && defined SOUTH_M2NUDGING) || \
     defined SOUTH_M2FLATHER   || defined SOUTH_M2CLAMPED  || \
     defined SOUTH_M2REDUCED
# define SOUTH_M2OBC
#endif
#if (defined NORTH_M2RADIATION && defined NORTH_M2NUDGING) || \
     defined NORTH_M2FLATHER   || defined NORTH_M2CLAMPED  || \
     defined NORTH_M2REDUCED
# define NORTH_M2OBC
#endif

#if (defined WEST_FSRADIATION  && defined WEST_FSNUDGING)  || \
     defined WEST_M2FLATHER    || defined WEST_FSCLAMPED   || \
     defined WEST_M2REDUCED
# define WEST_FSOBC
#endif
#if (defined EAST_FSRADIATION  && defined EAST_FSNUDGING)  || \
     defined EAST_M2FLATHER    || defined EAST_FSCLAMPED   || \
     defined EAST_M2REDUCED
# define EAST_FSOBC
#endif
#if (defined SOUTH_FSRADIATION && defined SOUTH_FSNUDGING) || \
     defined SOUTH_M2FLATHER   || defined SOUTH_FSCLAMPED  || \
     defined SOUTH_M2REDUCED
# define SOUTH_FSOBC
#endif
#if (defined NORTH_FSRADIATION && defined NORTH_FSNUDGING) || \
     defined NORTH_M2FLATHER   || defined NORTH_FSCLAMPED  || \
     defined NORTH_M2REDUCED
# define NORTH_FSOBC
#endif


#if defined FSOBC_REDUCED && \
  !(defined WEST_M2REDUCED  || defined EAST_M2REDUCED  || \
    defined NORTH_M2REDUCED || defined SOUTH_M2REDUCED || \
    defined WEST_M2FLATHER  || defined EAST_M2FLATHER  || \
    defined NORTH_M2FLATHER || defined SOUTH_M2FLATHER)
# undef FSOBC_REDUCED
#endif

#if (defined WEST_M3RADIATION  && defined WEST_M3NUDGING)  || \
     defined WEST_M3CLAMPED
# define WEST_M3OBC
#endif
#if (defined EAST_M3RADIATION  && defined EAST_M3NUDGING)  || \
     defined EAST_M3CLAMPED
# define EAST_M3OBC
#endif
#if (defined SOUTH_M3RADIATION && defined SOUTH_M3NUDGING) || \
     defined SOUTH_M3CLAMPED
# define SOUTH_M3OBC
#endif
#if (defined NORTH_M3RADIATION && defined NORTH_M3NUDGING) || \
     defined NORTH_M3CLAMPED
# define NORTH_M3OBC
#endif

#if (defined WEST_TRADIATION   && defined WEST_TNUDGING)   || \
     defined WEST_TCLAMPED
# define WEST_TOBC
#endif
#if (defined EAST_TRADIATION   && defined EAST_TNUDGING)   || \
     defined EAST_TCLAMPED
# define EAST_TOBC
#endif
#if (defined SOUTH_TRADIATION  && defined SOUTH_TNUDGING)  || \
     defined SOUTH_TCLAMPED
# define SOUTH_TOBC
#endif
#if (defined NORTH_TRADIATION  && defined NORTH_TNUDGING)  || \
     defined NORTH_TCLAMPED
# define NORTH_TOBC
#endif

#ifdef ICE_MODEL
#if (defined WEST_AIRADIATION   && defined WEST_AINUDGING)   || \
     defined WEST_AICLAMPED
# define WEST_AIOBC
#endif
#if (defined EAST_AIRADIATION   && defined EAST_AINUDGING)   || \
     defined EAST_AICLAMPED
# define EAST_AIOBC
#endif
#if (defined SOUTH_AIRADIATION  && defined SOUTH_AINUDGING)  || \
     defined SOUTH_AICLAMPED
# define SOUTH_AIOBC
#endif
#if (defined NORTH_AIRADIATION  && defined NORTH_AINUDGING)  || \
     defined NORTH_AICLAMPED
# define NORTH_AIOBC
#endif

#if (defined WEST_HIRADIATION   && defined WEST_HINUDGING)   || \
     defined WEST_HICLAMPED
# define WEST_HIOBC
#endif
#if (defined EAST_HIRADIATION   && defined EAST_HINUDGING)   || \
     defined EAST_HICLAMPED
# define EAST_HIOBC
#endif
#if (defined SOUTH_HIRADIATION  && defined SOUTH_HINUDGING)  || \
     defined SOUTH_HICLAMPED
# define SOUTH_HIOBC
#endif
#if (defined NORTH_HIRADIATION  && defined NORTH_HINUDGING)  || \
     defined NORTH_HICLAMPED
# define NORTH_HIOBC
#endif

#if (defined WEST_HSNRADIATION   && defined WEST_HSNNUDGING)   || \
     defined WEST_HSNCLAMPED
# define WEST_HSNOBC
#endif
#if (defined EAST_HSNRADIATION   && defined EAST_HSNNUDGING)   || \
     defined EAST_HSNCLAMPED
# define EAST_HSNOBC
#endif
#if (defined SOUTH_HSNRADIATION  && defined SOUTH_HSNNUDGING)  || \
     defined SOUTH_HSNCLAMPED
# define SOUTH_HSNOBC
#endif
#if (defined NORTH_HSNRADIATION  && defined NORTH_HSNNUDGING)  || \
     defined NORTH_HSNCLAMPED
# define NORTH_HSNOBC
#endif

#if (defined WEST_TIRADIATION   && defined WEST_TINUDGING)   || \
     defined WEST_TICLAMPED
# define WEST_TIOBC
#endif
#if (defined EAST_TIRADIATION   && defined EAST_TINUDGING)   || \
     defined EAST_TICLAMPED
# define EAST_TIOBC
#endif
#if (defined SOUTH_TIRADIATION  && defined SOUTH_TINUDGING)  || \
     defined SOUTH_TICLAMPED
# define SOUTH_TIOBC
#endif
#if (defined NORTH_TIRADIATION  && defined NORTH_TINUDGING)  || \
     defined NORTH_TICLAMPED
# define NORTH_TIOBC
#endif

#if (defined WEST_SFWATRADIATION   && defined WEST_SFWATNUDGING)   || \
     defined WEST_SFWATCLAMPED
# define WEST_SFWATOBC
#endif
#if (defined EAST_SFWATRADIATION   && defined EAST_SFWATNUDGING)   || \
     defined EAST_SFWATCLAMPED
# define EAST_SFWATOBC
#endif
#if (defined SOUTH_SFWATRADIATION  && defined SOUTH_SFWATNUDGING)  || \
     defined SOUTH_SFWATCLAMPED
# define SOUTH_SFWATOBC
#endif
#if (defined NORTH_SFWATRADIATION  && defined NORTH_SFWATNUDGING)  || \
     defined NORTH_SFWATCLAMPED
# define NORTH_SFWATOBC
#endif

#if (defined WEST_SIG11RADIATION   && defined WEST_SIG11NUDGING)   || \
     defined WEST_SIG11CLAMPED
# define WEST_SIG11OBC
#endif
#if (defined EAST_SIG11RADIATION   && defined EAST_SIG11NUDGING)   || \
     defined EAST_SIG11CLAMPED
# define EAST_SIG11OBC
#endif
#if (defined SOUTH_SIG11RADIATION  && defined SOUTH_SIG11NUDGING)  || \
     defined SOUTH_SIG11CLAMPED
# define SOUTH_SIG11OBC
#endif
#if (defined NORTH_SIG11RADIATION  && defined NORTH_SIG11NUDGING)  || \
     defined NORTH_SIG11CLAMPED
# define NORTH_SIG11OBC
#endif

#if (defined WEST_SIG22RADIATION   && defined WEST_SIG22NUDGING)   || \
     defined WEST_SIG22CLAMPED
# define WEST_SIG22OBC
#endif
#if (defined EAST_SIG22RADIATION   && defined EAST_SIG22NUDGING)   || \
     defined EAST_SIG22CLAMPED
# define EAST_SIG22OBC
#endif
#if (defined SOUTH_SIG22RADIATION  && defined SOUTH_SIG22NUDGING)  || \
     defined SOUTH_SIG22CLAMPED
# define SOUTH_SIG22OBC
#endif
#if (defined NORTH_SIG22RADIATION  && defined NORTH_SIG22NUDGING)  || \
     defined NORTH_SIG22CLAMPED
# define NORTH_SIG22OBC
#endif

#if (defined WEST_SIG12RADIATION   && defined WEST_SIG12NUDGING)   || \
     defined WEST_SIG12CLAMPED
# define WEST_SIG12OBC
#endif
#if (defined EAST_SIG12RADIATION   && defined EAST_SIG12NUDGING)   || \
     defined EAST_SIG12CLAMPED
# define EAST_SIG12OBC
#endif
#if (defined SOUTH_SIG12RADIATION  && defined SOUTH_SIG12NUDGING)  || \
     defined SOUTH_SIG12CLAMPED
# define SOUTH_SIG12OBC
#endif
#if (defined NORTH_SIG12RADIATION  && defined NORTH_SIG12NUDGING)  || \
     defined NORTH_SIG12CLAMPED
# define NORTH_SIG12OBC
#endif

#if (defined WEST_MIRADIATION   && defined WEST_MINUDGING)   || \
     defined WEST_MICLAMPED
# define WEST_MIOBC
#endif
#if (defined EAST_MIRADIATION   && defined EAST_MINUDGING)   || \
     defined EAST_MICLAMPED
# define EAST_MIOBC
#endif
#if (defined SOUTH_MIRADIATION  && defined SOUTH_MINUDGING)  || \
     defined SOUTH_MICLAMPED
# define SOUTH_MIOBC
#endif
#if (defined NORTH_MIRADIATION  && defined NORTH_MINUDGING)  || \
     defined NORTH_MICLAMPED
# define NORTH_MIOBC
#endif
#endif

#ifdef SOLVE3D
# if defined WEST_FSOBC  || defined EAST_FSOBC  || \
     defined SOUTH_FSOBC || defined NORTH_FSOBC || \
     defined WEST_M2OBC  || defined EAST_M2OBC  || \
     defined SOUTH_M2OBC || defined NORTH_M2OBC || \
     defined WEST_M3OBC  || defined EAST_M3OBC  || \
     defined SOUTH_M3OBC || defined NORTH_M3OBC || \
     defined WEST_TOBC   || defined EAST_TOBC   || \
     defined SOUTH_TOBC  || defined NORTH_TOBC
#  define OBC
# endif
#else
# if defined WEST_FSOBC  || defined EAST_FSOBC  || \
     defined SOUTH_FSOBC || defined NORTH_FSOBC || \
     defined WEST_M2OBC  || defined EAST_M2OBC  || \
     defined SOUTH_M2OBC || defined NORTH_M2OBC
#  define OBC
# endif
#endif

/*
** Define internal flag indicating processing of input boundary
** NetCDF file.
*/

#if (!defined ANA_FSOBC && \
     (defined WEST_FSOBC  || defined EAST_FSOBC    || \
      defined SOUTH_FSOBC || defined NORTH_FSOBC)) || \
    (!defined ANA_M2OBC && \
     (defined WEST_M2OBC  || defined EAST_M2OBC    || \
      defined SOUTH_M2OBC || defined NORTH_M2OBC)) || \
    (!defined ANA_M3OBC && \
     (defined WEST_M3OBC  || defined EAST_M3OBC    || \
      defined SOUTH_M3OBC || defined NORTH_M3OBC)) || \
    (!defined ANA_TOBC && \
     (defined WEST_TOBC   || defined EAST_TOBC    || \
      defined SOUTH_TOBC  || defined NORTH_TOBC))
# define OBC_DATA
#endif

/*
** Activate internal switches for volume conservation at open boundary.
*/

#if (!defined WEST_M2OBC   && !defined WEST_M2GRADIENT) && \
      defined WEST_VOLCONS
# undef WEST_VOLCONS
#endif
#if (!defined EAST_M2OBC   && !defined EAST_M2GRADIENT) && \
      defined EAST_VOLCONS
# undef EAST_VOLCONS
#endif
#if (!defined NORTH_M2OBC   && !defined NORTH_M2GRADIENT) && \
      defined NORTH_VOLCONS
# undef NORTH_VOLCONS
#endif
#if (!defined SOUTH_M2OBC   && !defined SOUTH_M2GRADIENT) && \
      defined SOUTH_VOLCONS
# undef SOUTH_VOLCONS
#endif

#if defined WEST_VOLCONS  || defined EAST_VOLCONS  || \
    defined NORTH_VOLCONS || defined SOUTH_VOLCONS
# define OBC_VOLCONS
#endif

/*
** Activate assimilation switches.
*/

#if defined ASSIMILATION_SSH || defined ASSIMILATION_SST   || \
    defined ASSIMILATION_T   || defined ASSIMILATION_UVsur || \
    defined ASSIMILATION_UV
# define ASSIMILATION
#endif
#if defined NUDGING_SSH || defined NUDGING_SST   || \
    defined NUDGING_T   || defined NUDGING_UVsur || \
    defined NUDGING_UV
# define NUDGING
#endif

/*
** Check if it is meaningful to write out time-averaged vertical
** mixing coefficients.
*/

#if !defined LMD_MIXING && !defined MY25_MIXING && !defined GLS_MIXING
# if defined AVERAGES
#  if defined AVERAGES_AKV
#    undef AVERAGES_AKV
#  endif
#  if defined AVERAGES_AKT
#    undef AVERAGES_AKT
#  endif
#  if defined AVERAGES_AKS && !defined SALINITY
#    undef AVERAGES_AKS
#  endif
# endif
#endif

/*
** Activate internal biology option when using any type of biological
** module.
*/

#if defined BIO_FASHAM  || defined ECOSIM      || \
    defined NPZD_FRANKS || defined NPZD_POWELL || \
    defined BIO_GOANPZ  || defined POLLOCK_FOOD
# define BIOLOGY
#endif

/*
** Use AVERAGES structures to write out filtered data
 */

#ifdef FILTERED
# define AVERAGES
# undef  FILTRIM            /* define for fewer time-filtered fields */
# define FILTERED_RST       /* define if use restart files for time-filtering */
#endif

/*
** Define internal flag indicating processing of input forcing
** NetCDF file.
*/

#ifdef SOLVE3D
# ifdef BULK_FLUXES
#  ifdef ANA_SMFLUX
#   undef ANA_SMFLUX
#  endif
#  ifdef ANA_STFLUX
#   undef ANA_STFLUX
#  endif
# endif
# if !defined ANA_BTFLUX   || \
    (!defined AIR_OCEAN    && !defined BULK_FLUXES   && !defined ANA_SMFLUX) || \
    (!defined BULK_FLUXES  && !defined ANA_STFLUX)   || \
    ( defined SALINITY     && !defined ANA_SSFLUX)   || \
    ( defined BULK_FLUXES  && !defined LONGWAVE)     || \
    ( defined BULK_FLUXES  && !defined ANA_PAIR)     || \
    ( defined BULK_FLUXES  && !defined ANA_TAIR)     || \
    ( defined BULK_FLUXES  && !defined ANA_HUMIDITY) || \
    ( defined BULK_FLUXES  && !defined ANA_CLOUD)    || \
    ( defined BULK_FLUXES  && !defined ANA_RAIN)     || \
    ( defined BULK_FLUXES  && !defined ANA_SRFLUX)   || \
    ( defined LMD_SKPP     && !defined ANA_SRFLUX)   || \
    ( defined SOLAR_SOURCE && !defined ANA_SRFLUX)   || \
    ( defined BBL_MODEL    && !defined ANA_WWAVE)    || \
    ( defined BIOLOGY      && !defined ANA_SPFLUX)   || \
    ( defined BIOLOGY      && !defined ANA_BPFLUX)   || \
    ( defined SEDIMENT     && !defined ANA_SPFLUX)   || \
    ( defined SEDIMENT     && !defined ANA_BPFLUX)
#  define FRC_FILE
# endif
#else
# if !defined ANA_SMFLUX
#  define FRC_FILE
# endif
#endif
#ifdef ANA_NCEP
# undef FRC_FILE
#endif

/*
** Check analytical initial conditions options.
*/

#if defined ANA_BIOLOGY && !defined BIOLOGY
# undef ANA_BIOLOGY
#endif
#if defined ANA_PASSIVE && !defined T_PASSIVE 
# undef ANA_PASSIVE
#endif
#if defined ANA_SEDIMENT && !(defined SEDIMENT || defined BBL_MODEL) 
# undef ANA_SEDIMENT
#endif
#if  !defined ANA_INITIAL || \
    ( defined BIOLOGY     && !defined ANA_BIOLOGY)  || \
    ( defined T_PASSIVE   && !defined ANA_PASSIVE)  || \
    ( defined SEDIMENT    && !defined ANA_SEDIMENT) || \
    ( defined BBL_MODEL   && !defined ANA_SEDIMENT)
# define INI_FILE
#endif

/*
** Define internal shortwave radiation option.  Undefine analytical
** shortwave option if not needed.
*/

#if defined LMD_SKPP     || defined SOLAR_SOURCE   || \
    defined BULK_FLUXES  || defined BIOLOGY
# define SHORTWAVE
#endif
#if defined SHORTWAVE && defined NCEP_FLUXES
# undef SHORTWAVE
#endif
#if !defined SHORTWAVE   && defined ANA_SRFLUX
# undef ANA_SRFLUX
#endif
#if !defined SHORTWAVE   && defined DIURNAL_SRFLUX
# undef DIURNAL_SRFLUX
#endif

/*
** Define internal clouds option.  Undefine analytical
** shortwave option if not needed.
*/

#if (defined BULK_FLUXES && defined LONGWAVE) || defined ECOSIM || \
    (defined ANA_SRFLUX  && defined ALBEDO)
# define CLOUDS
#endif
#if !defined CLOUDS && defined ANA_CLOUD
# undef ANA_CLOUD
#endif

/*
** Check if it is meaningful to write out momentum/tracer diagnostics
** and activate internal diagnostics option.
*/

#if !defined SOLVE3D || defined TS_FIXED
# if defined DIAGNOSTICS_TS
#   undef DIAGNOSTICS_TS
# endif
#endif
#if !defined BIO_FASHAM && defined DIAGNOSTICS_BIO
#  undef DIAGNOSTICS_BIO
#endif
#if defined DIAGNOSTICS_BIO || defined DIAGNOSTICS_TS || \
    defined DIAGNOSTICS_UV
# define DIAGNOSTICS
#endif
