#include "cppdefs.h"
      MODULE mod_eclight
#if defined BIOLOGY && defined ECOSIM
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== W. Paul Bissett ====
!                                                                      !
!  The following data arrays  are the spectral atmospheric,  pigment,  !
!  and water data used to create the spectral  downwelling irradiance  !
!  at the sea surface, as well as through the water column. The above  !
!  water values are created in "ana_specir" using a derivative of the  !
!  RADTRAN  codes described in Gregg and Carder (1981).  The in-water  !
!  calculations are part of the EcoSim code (Bissett et al. 1999).     !
!                                                                      !
!  ec_wave_ab   Center wavelengths for spectral calculations (nm).     !
!  ec_Fobar     Mean extraterrestrial spectral solar irradiation.      !
!  ec_aoz       Ozone absorption coefficients.                         !
!  ec_ag        Oxygen absorption coefficients.                        !
!  ec_aw        Water vapor absorption coefficients.                   !
!  apigs        Pigment absorption coefficients.                       !
!  aDOC         CDOC absorption coefficients.                          !
!  awater       Water absorption coefficients.                         !
!  bwater       Water scattering coefficients.                         !
!                                                                      !
!  References:                                                         !
!                                                                      !
!    Bissett, W.P., J.J. Walsh, D.A. Dieterle, K.L. Carder, 1999:      !
!      Carbon cycling in the upper waters of the Sargasso Sea: I.      !
!      Numerical  simulation of  differential carbon and nitrogen      !
!      fluxes,  Deep-Sea Res., 46, 205-269.                            !
!                                                                      !
!    Bissett, W.P., K.L. Carder, J.J. Walsh, D.A. Dieterle, 1999:      !
!      Carbon cycling in the upper waters of the Sargasso Sea: II.     !
!      Numerical  simulation  of  apparent  and  inherent optical      !
!      properties, Deep-Sea Res., 46, 271-317                          !
!                                                                      !
!    Gregg, W.W. and Carder, K.L., 1990. A simple spectral solar       !
!      irradiance model for cloudless maritime atmospheres.            !
!      Limnology and Oceanography, 35(8): 1657-1675.                   !
!                                                                      !
!=======================================================================
!
      USE mod_param

      implicit none

      real(8), dimension(NBands) :: ec_wave_ab =                        &
     &(/ 4.0200e+02, 4.0700e+02, 4.1200e+02, 4.1700e+02, 4.2200e+02,    &
     &   4.2700e+02, 4.3200e+02, 4.3700e+02, 4.4200e+02, 4.4700e+02,    &
     &   4.5200e+02, 4.5700e+02, 4.6200e+02, 4.6700e+02, 4.7200e+02,    &
     &   4.7700e+02, 4.8200e+02, 4.8700e+02, 4.9200e+02, 4.9700e+02,    &
     &   5.0200e+02, 5.0700e+02, 5.1200e+02, 5.1700e+02, 5.2200e+02,    &
     &   5.2700e+02, 5.3200e+02, 5.3700e+02, 5.4200e+02, 5.4700e+02,    &
     &   5.5200e+02, 5.5700e+02, 5.6200e+02, 5.6700e+02, 5.7200e+02,    &
     &   5.7700e+02, 5.8200e+02, 5.8700e+02, 5.9200e+02, 5.9700e+02,    &
     &   6.0200e+02, 6.0700e+02, 6.1200e+02, 6.1700e+02, 6.2200e+02,    &
     &   6.2700e+02, 6.3200e+02, 6.3700e+02, 6.4200e+02, 6.4700e+02,    &
     &   6.5200e+02, 6.5700e+02, 6.6200e+02, 6.6700e+02, 6.7200e+02,    &
     &   6.7700e+02, 6.8200e+02, 6.8700e+02, 6.9200e+02, 6.9700e+02 /)

      real(8), dimension(NBands) :: ec_Fobar =                          &
     &(/ 1.7990e-01, 1.6810e-01, 1.8120e-01, 1.7150e-01, 1.7600e-01,    &
     &   1.6730e-01, 1.7270e-01, 1.8450e-01, 1.8920e-01, 1.8740e-01,    &
     &   2.0040e-01, 2.0600e-01, 2.1010e-01, 1.9660e-01, 2.0220e-01,    &
     &   1.9960e-01, 2.0540e-01, 1.7230e-01, 1.9090e-01, 2.0030e-01,    &
     &   1.8900e-01, 1.9770e-01, 1.9130e-01, 1.6880e-01, 1.8910e-01,    &
     &   1.8340e-01, 1.9480e-01, 1.8610e-01, 1.8470e-01, 1.8670e-01,    &
     &   1.8700e-01, 1.8260e-01, 1.8600e-01, 1.8440e-01, 1.8840e-01,    &
     &   1.8570e-01, 1.8660e-01, 1.8080e-01, 1.7970e-01, 1.8100e-01,    &
     &   1.7290e-01, 1.7490e-01, 1.7440e-01, 1.7050e-01, 1.7040e-01,    &
     &   1.6890e-01, 1.6540e-01, 1.6620e-01, 1.6160e-01, 1.6110e-01,    &
     &   1.6000e-01, 1.3770e-01, 1.5810e-01, 1.5500e-01, 1.5190e-01,    &
     &   1.4880e-01, 1.4660e-01, 1.4500e-01, 1.4350e-01, 1.4200e-01 /)

      real(8), dimension(NBands) :: ec_aoz =                            &
     &(/ 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   4.0000e-04, 1.3000e-03, 2.2000e-03, 2.9000e-03, 2.8000e-03,    &
     &   3.8000e-03, 6.6000e-03, 8.7000e-03, 7.5000e-03, 8.7000e-03,    &
     &   1.4300e-02, 1.9600e-02, 1.9100e-02, 1.9300e-02, 2.3900e-02,    &
     &   3.1700e-02, 4.0600e-02, 3.7700e-02, 4.0500e-02, 4.8800e-02,    &
     &   5.7600e-02, 6.6200e-02, 7.1500e-02, 7.3700e-02, 8.0100e-02,    &
     &   8.5800e-02, 9.0700e-02, 1.0030e-01, 1.1150e-01, 1.1810e-01,    &
     &   1.1930e-01, 1.1470e-01, 1.0930e-01, 1.1020e-01, 1.1880e-01,    &
     &   1.2530e-01, 1.2150e-01, 1.1500e-01, 1.0820e-01, 1.0130e-01,    &
     &   9.4500e-02, 8.7600e-02, 8.0800e-02, 7.3900e-02, 6.7200e-02,    &
     &   6.1500e-02, 5.7200e-02, 5.3000e-02, 4.8800e-02, 4.4600e-02,    &
     &   4.0400e-02, 3.6200e-02, 3.2000e-02, 2.7800e-02, 2.3800e-02 /)

      real(8), dimension(NBands) :: ec_ag =                             &
     &(/ 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   4.9000e-03, 7.8000e-03, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 8.1000e-01, 2.4800e-01, 0.0000e+00 /)

      real(8), dimension(NBands) :: ec_aw =                             &
     &(/ 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 1.4100e-02, 2.7400e-02,    &
     &   1.0600e-02, 0.0000e+00, 2.8430e-01, 6.3570e-01, 2.0190e-01,    &
     &   1.7200e-02, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   2.1000e-03, 3.1000e-03, 7.0000e-04, 0.0000e+00, 7.4300e-02,    &
     &   1.7910e-01, 8.7400e-02, 0.0000e+00, 1.5000e-03, 0.0000e+00,    &
     &   0.0000e+00, 8.0000e-04, 1.5000e-03, 1.9610e-01, 6.2070e-01 /)

      real(8), dimension(Npig,NBands) :: apigs = reshape (              &
     &(/ 1.2960e-02, 3.8300e-03, 2.0600e-02, 6.1600e-03, 1.4440e-02,    &
     &   6.3700e-04, 1.2000e-04, 1.4390e-02, 3.1800e-03, 2.1090e-02,    &
     &   6.8700e-03, 1.7770e-02, 5.5700e-04, 9.5000e-05, 1.6970e-02,    &
     &   3.2000e-03, 2.1240e-02, 7.8000e-03, 2.0870e-02, 4.9000e-04,    &
     &   8.0000e-05, 1.8990e-02, 3.5100e-03, 2.1440e-02, 8.9500e-03,    &
     &   2.4020e-02, 4.4000e-04, 8.0000e-05, 1.9300e-02, 4.0300e-03,    &
     &   2.2620e-02, 1.0230e-02, 2.8000e-02, 4.1000e-04, 8.3000e-05,    &
     &   1.9100e-02, 5.0400e-03, 2.5170e-02, 1.1670e-02, 3.3200e-02,    &
     &   3.9000e-04, 1.0200e-04, 2.1320e-02, 7.1300e-03, 2.8870e-02,    &
     &   1.3500e-02, 3.8280e-02, 3.8000e-04, 1.4000e-04, 2.5260e-02,    &
     &   1.0000e-02, 3.3740e-02, 1.5550e-02, 4.1650e-02, 3.8100e-04,    &
     &   1.7200e-04, 2.5020e-02, 1.2580e-02, 4.0180e-02, 1.7670e-02,    &
     &   4.3760e-02, 3.9300e-04, 2.3300e-04, 1.7160e-02, 1.3780e-02,    &
     &   4.9940e-02, 1.9850e-02, 4.6680e-02, 4.3100e-04, 3.1700e-04,    &
     &   7.9700e-03, 1.4790e-02, 6.1560e-02, 2.2270e-02, 5.1760e-02,    &
     &   5.0400e-04, 4.4400e-04, 2.9100e-03, 1.8230e-02, 6.9160e-02,    &
     &   2.4800e-02, 5.7260e-02, 5.9200e-04, 6.0600e-04, 1.0600e-03,    &
     &   2.5260e-02, 7.0030e-02, 2.7170e-02, 6.0060e-02, 6.8700e-04,    &
     &   7.4500e-04, 5.5000e-04, 3.2450e-02, 6.4490e-02, 2.9200e-02,    &
     &   5.8500e-02, 8.3400e-04, 9.5500e-04, 3.7000e-04, 3.3940e-02,    &
     &   5.2430e-02, 3.1090e-02, 5.4160e-02, 9.9600e-04, 1.1760e-03,    &
     &   3.0000e-04, 2.8360e-02, 3.6030e-02, 3.3160e-02, 5.0790e-02,    &
     &   1.2090e-03, 1.4620e-03, 3.0000e-04, 1.9800e-02, 2.0580e-02,    &
     &   3.5270e-02, 5.0780e-02, 1.4930e-03, 1.9760e-03, 3.0000e-04,    &
     &   1.2070e-02, 1.0520e-02, 3.6520e-02, 5.2590e-02, 1.8130e-03,    &
     &   2.5060e-03, 3.3000e-04, 6.7200e-03, 5.4200e-03, 3.6670e-02,    &
     &   5.2300e-02, 2.3880e-03, 2.5820e-03, 4.0000e-04, 3.6100e-03,    &
     &   3.3300e-03, 3.5950e-02, 4.7100e-02, 2.6910e-03, 2.0200e-03,    &
     &   4.7000e-04, 2.0600e-03, 2.3800e-03, 3.5130e-02, 3.7740e-02,    &
     &   2.7800e-03, 1.2340e-03, 5.0000e-04, 1.3200e-03, 2.1000e-03,    &
     &   3.4690e-02, 2.6710e-02, 2.7720e-03, 8.0200e-04, 5.0000e-04,    &
     &   1.0000e-03, 1.8300e-03, 3.4110e-02, 1.7010e-02, 2.8350e-03,    &
     &   6.4900e-04, 5.0000e-04, 9.0000e-04, 1.7400e-03, 3.2510e-02,    &
     &   9.9500e-03, 3.0420e-03, 6.5800e-04, 5.3000e-04, 8.3000e-04,    &
     &   1.5300e-03, 2.9670e-02, 5.5200e-03, 3.3470e-03, 7.4600e-04,    &
     &   6.5000e-04, 8.1000e-04, 1.5500e-03, 2.6040e-02, 3.0500e-03,    &
     &   3.8080e-03, 8.5000e-04, 7.7000e-04, 9.0000e-04, 1.6700e-03,    &
     &   2.2170e-02, 1.6900e-03, 4.3270e-03, 9.9300e-04, 8.9000e-04,    &
     &   1.0000e-03, 1.7600e-03, 1.8410e-02, 8.8000e-04, 4.9800e-03,    &
     &   1.0940e-03, 9.0000e-04, 1.1300e-03, 2.0400e-03, 1.5000e-02,    &
     &   5.4000e-04, 5.5900e-03, 1.1230e-03, 9.0000e-04, 1.3000e-03,    &
     &   2.3800e-03, 1.1970e-02, 2.4000e-04, 5.8680e-03, 1.0380e-03,    &
     &   9.0000e-04, 1.4300e-03, 2.6400e-03, 9.4000e-03, 7.0000e-05,    &
     &   5.5270e-03, 8.2500e-04, 9.0000e-04, 1.5900e-03, 2.8600e-03,    &
     &   7.2500e-03, 0.0000e+00, 4.3530e-03, 4.8900e-04, 9.0000e-04,    &
     &   1.6300e-03, 3.3000e-03, 5.4700e-03, 0.0000e+00, 2.3980e-03,    &
     &   2.8300e-04, 9.6000e-04, 1.7100e-03, 3.8000e-03, 4.1000e-03,    &
     &   0.0000e+00, 9.5600e-04, 1.7700e-04, 1.2000e-03, 1.8300e-03,    &
     &   4.3000e-03, 3.0700e-03, 0.0000e+00, 4.7700e-04, 8.6000e-05,    &
     &   1.5000e-03, 1.9000e-03, 5.0200e-03, 2.3000e-03, 0.0000e+00,    &
     &   2.8700e-04, 3.5000e-05, 1.8300e-03, 1.9700e-03, 6.0000e-03,    &
     &   1.7000e-03, 0.0000e+00, 1.8400e-04, 7.0000e-06, 2.1400e-03,    &
     &   2.1500e-03, 6.3000e-03, 1.2500e-03, 0.0000e+00, 1.3000e-04,    &
     &   0.0000e+00, 2.2700e-03, 2.4300e-03, 5.5400e-03, 9.0000e-04,    &
     &   0.0000e+00, 1.0000e-04, 0.0000e+00, 2.2500e-03, 2.7500e-03,    &
     &   4.3200e-03, 6.6000e-04, 0.0000e+00, 7.4000e-05, 0.0000e+00,    &
     &   2.1300e-03, 2.9000e-03, 3.4000e-03, 4.6000e-04, 0.0000e+00,    &
     &   4.7000e-05, 0.0000e+00, 2.1700e-03, 2.7500e-03, 3.0300e-03,    &
     &   3.4000e-04, 0.0000e+00, 3.0000e-05, 0.0000e+00, 2.6300e-03,    &
     &   2.5000e-03, 3.3300e-03, 1.3000e-04, 0.0000e+00, 1.0000e-05,    &
     &   0.0000e+00, 3.2500e-03, 2.3500e-03, 3.7600e-03, 5.0000e-05,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 3.8000e-03, 2.3000e-03,    &
     &   4.6300e-03, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   4.0900e-03, 2.3600e-03, 6.3500e-03, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 4.0000e-03, 2.7600e-03, 8.8800e-03,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 3.6900e-03,    &
     &   4.0500e-03, 9.5100e-03, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 3.2000e-03, 6.6600e-03, 7.2900e-03, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 2.9200e-03, 9.9500e-03,    &
     &   4.2500e-03, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    & 
     &   3.2600e-03, 1.1620e-02, 2.7600e-03, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 4.7800e-03, 9.8000e-03, 1.9500e-03,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 8.4400e-03,    &
     &   6.2100e-03, 1.3000e-03, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 1.4560e-02, 3.2300e-03, 7.1000e-04, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 1.9390e-02, 1.6300e-03,    &
     &   3.0000e-04, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   1.8810e-02, 8.1000e-04, 1.5000e-04, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 1.2820e-02, 4.0000e-04, 7.0000e-05,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 6.8500e-03,    &
     &   2.4000e-04, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 3.2700e-03, 1.0000e-04, 0.0000e+00, 0.0000e+00,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 1.2000e-03, 1.0000e-04,    &
     &   0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00/),  &
     & (/ Npig, NBands /) )

      real(8), dimension(Ndom,NBands) :: aDOC = reshape (               &
     &(/ 5.6832e+00, 6.2086e+00, 5.2989e+00, 5.4791e+00, 4.9407e+00,    &
     &   4.8353e+00, 4.6067e+00, 4.2671e+00, 4.2952e+00, 3.7657e+00,    &
     &   4.0049e+00, 3.3232e+00, 3.7341e+00, 2.9327e+00, 3.4817e+00,    &
     &   2.5881e+00, 3.2463e+00, 2.2840e+00, 3.0268e+00, 2.0156e+00,    &
     &   2.8222e+00, 1.7788e+00, 2.6314e+00, 1.5698e+00, 2.4535e+00,    &
     &   1.3853e+00, 2.2876e+00, 1.2225e+00, 2.1330e+00, 1.0789e+00,    &
     &   1.9888e+00, 9.5212e-01, 1.8543e+00, 8.4024e-01, 1.7289e+00,    &
     &   7.4151e-01, 1.6121e+00, 6.5438e-01, 1.5031e+00, 5.7749e-01,    &
     &   1.4014e+00, 5.0963e-01, 1.3067e+00, 4.4975e-01, 1.2184e+00,    &
     &   3.9690e-01, 1.1360e+00, 3.5027e-01, 1.0592e+00, 3.0911e-01,    &
     &   9.8758e-01, 2.7279e-01, 9.2082e-01, 2.4073e-01, 8.5857e-01,    &
     &   2.1245e-01, 8.0052e-01, 1.8748e-01, 7.4640e-01, 1.6545e-01,    &
     &   6.9594e-01, 1.4601e-01, 6.4889e-01, 1.2886e-01, 6.0502e-01,    &
     &   1.1371e-01, 5.6412e-01, 1.0035e-01, 5.2598e-01, 8.8561e-02,    &
     &   4.9042e-01, 7.8155e-02, 4.5726e-01, 6.8971e-02, 4.2635e-01,    &
     &   6.0867e-02, 3.9753e-01, 5.3715e-02, 3.7065e-01, 4.7403e-02,    &
     &   3.4559e-01, 4.1833e-02, 3.2223e-01, 3.6918e-02, 3.0044e-01,    &
     &   3.2580e-02, 2.8013e-01, 2.8752e-02, 2.6119e-01, 2.5373e-02,    &
     &   2.4354e-01, 2.2392e-02, 2.2707e-01, 1.9761e-02, 2.1172e-01,    &
     &   1.7439e-02, 1.9741e-01, 1.5390e-02, 1.8406e-01, 1.3581e-02,    &
     &   1.7162e-01, 1.1985e-02, 1.6001e-01, 1.0577e-02, 1.4920e-01,    &
     &   9.3343e-03, 1.3911e-01, 8.2375e-03, 1.2970e-01, 7.2695e-03,    &
     &   1.2094e-01, 6.4153e-03, 1.1276e-01, 5.6615e-03, 1.0514e-01,    &
     &   4.9963e-03, 9.8029e-02, 4.4092e-03, 9.1402e-02, 3.8911e-03/),  &
     & (/ Ndom, NBands /) )

      real(8), dimension(NBands) :: awater =                            &
     &(/ 6.0140e-03, 5.0792e-03, 4.5828e-03, 4.4464e-03, 4.6744e-03,    &
     &   4.8264e-03, 5.0492e-03, 5.7080e-03, 6.8284e-03, 8.1628e-03,    &
     &   9.5096e-03, 9.6232e-03, 9.9660e-03, 1.0232e-02, 1.0872e-02,    &
     &   1.1944e-02, 1.3036e-02, 1.4208e-02, 1.5944e-02, 1.8660e-02,    &
     &   2.2384e-02, 2.7856e-02, 3.5892e-02, 3.9952e-02, 4.1364e-02,    &
     &   4.2500e-02, 4.4312e-02, 4.6224e-02, 4.8712e-02, 5.3212e-02,    &
     &   5.8340e-02, 6.0448e-02, 6.3276e-02, 6.6488e-02, 7.2556e-02,    &
     &   8.2256e-02, 9.7328e-02, 1.1978e-01, 1.4816e-01, 1.8818e-01,    &
     &   2.3986e-01, 2.6127e-01, 2.6595e-01, 2.7042e-01, 2.7940e-01,    &
     &   2.8807e-01, 2.9693e-01, 3.0586e-01, 3.1845e-01, 3.3220e-01,    &
     &   3.5360e-01, 3.8780e-01, 4.1976e-01, 4.3396e-01, 4.4476e-01,    &
     &   4.5696e-01, 4.7460e-01, 4.9848e-01, 5.3344e-01, 5.8524e-01 /)

      real(8), dimension(NBands) :: bwater =                            &
     &(/ 7.4400e-03, 7.0400e-03, 6.6600e-03, 6.3100e-03, 5.9800e-03,    &
     &   5.6800e-03, 5.3800e-03, 5.0800e-03, 4.8200e-03, 4.6200e-03,    &
     &   4.4200e-03, 4.2200e-03, 4.0200e-03, 3.8200e-03, 3.6400e-03,    &
     &   3.4900e-03, 3.3400e-03, 3.1900e-03, 3.0600e-03, 2.9600e-03,    &
     &   2.8400e-03, 2.6900e-03, 2.5600e-03, 2.4600e-03, 2.3600e-03,    &
     &   2.2600e-03, 2.1800e-03, 2.1300e-03, 2.0600e-03, 1.9600e-03,    &
     &   1.8800e-03, 1.8300e-03, 1.7800e-03, 1.7300e-03, 1.6800e-03,    &
     &   1.6300e-03, 1.5800e-03, 1.5300e-03, 1.4800e-03, 1.4300e-03,    &
     &   1.3800e-03, 1.3300e-03, 1.2800e-03, 1.2300e-03, 1.1800e-03,    &
     &   1.1300e-03, 1.0800e-03, 1.0300e-03, 1.0000e-03, 1.0000e-03,    &
     &   9.6000e-04, 8.6000e-04, 8.0000e-04, 8.0000e-04, 7.8000e-04,    &
     &   7.3000e-04, 7.0000e-04, 7.0000e-04, 7.0000e-04, 7.0000e-04 /)

#endif

      END MODULE mod_eclight
