#include "cppdefs.h"
      MODULE mod_frs
#ifdef FRS

!
! ----------------------------------------------------
! Bjrn dlandsvik, <bjorn@imr.no>,   07 Mar 2003
! Modified by removal of external mode
! and adaption to roms 2.1        B  09 Jun 2004
!
! ----------------------------------------------------
!
! Constants:
! LB          Number of grid cells in the FRS zones
!             for the internal 3D mode
! frs_tau     Time scale for FRS, internal 3D mode
!
! Common variables:
! alphar      Alpha field, RHO-points, internal mode
! alphau      Alpha field, U-points, internal mode
! alphav      Alpha field, V-points, internal mode
!
! -----------------------------------------------------
!
      USE mod_kinds

      implicit none

      TYPE T_FRS
# ifdef TFRS
        real(r8), pointer :: alphar(:,:) 
# endif
# ifdef M3FRS
        real(r8), pointer :: alphau(:,:)
        real(r8), pointer :: alphav(:,:)
# endif 
      END TYPE T_FRS
 
      TYPE (T_FRS), allocatable :: ALPHA_FRS(:)

      CONTAINS

! ******************************************************************

      SUBROUTINE allocate_frs(ng, LBi, UBi, LBj, UBj)

      USE mod_param

!  Local variable declarations.
!
      integer, intent(in) :: ng, LBi, UBi, LBj, UBj
!
!-----------------------------------------------------------------------
!  Allocate module variables.
!-----------------------------------------------------------------------
!
      IF (ng.eq.1) allocate ( ALPHA_FRS(Ngrids) )

# ifdef TFRS
      allocate( ALPHA_FRS(ng) % alphar(LBi:UBi, LBj:UBj)  )
# endif
# ifdef M3FRS
      allocate( ALPHA_FRS(ng) % alphau(LBi:UBi, LBj:UBj)  )
      allocate( ALPHA_FRS(ng) % alphav(LBi:UBi, LBj:UBj)  )
# endif

      END SUBROUTINE allocate_frs

! *******************************************************************

      SUBROUTINE initialize_frs(ng, tile)

      USE mod_param
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile
!
!  Local variable declarations.
!
      integer :: i, j
      integer :: Imin, Imax, Jmin, Jmax

      real(r8), parameter :: IniVal = 0.0_r8
!
# include "tile.h"
!
!  Set array initialization range.
!
#ifdef _OPENMP
      IF (WESTERN_EDGE) THEN
        Imin=LBi
      ELSE
        Imin=Istr
      END IF
      IF (EASTERN_EDGE) THEN
        Imax=UBi
      ELSE
        Imax=Iend
      END IF
      IF (SOUTHERN_EDGE) THEN
        Jmin=LBj
      ELSE
        Jmin=Jstr
      END IF
      IF (NORTHERN_EDGE) THEN
        Jmax=UBj
      ELSE
        Jmax=Jend
      END IF
#else
      Imin=LBi
      Imax=UBi
      Jmin=LBj
      Jmax=UBj
#endif
!
!-----------------------------------------------------------------------
!  Initialize module variables.
!-----------------------------------------------------------------------
!
      DO i=Imin,Imax
        DO j=Jmin,Jmax
# ifdef TFRS
          ALPHA_FRS(ng) % alphar(i,j) = IniVal
# endif
# ifdef M3FRS
          ALPHA_FRS(ng) % alphau(i,j) = IniVal
          ALPHA_FRS(ng) % alphav(i,j) = IniVal
# endif
        END DO
      END DO

      END SUBROUTINE initialize_frs

#endif /* FRS */
      END MODULE mod_frs
