#include "cppdefs.h"
      MODULE mod_iounits
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
!  ADJbase     Output adjoint base file name.                          !
!  ADJname     Output adjoint file name.                               !
!  ADSname     Input adjoint sensitivity functional file.              !
!  AVGbase     Output averages base file name.                         !
!  AVGname     Output averages file name.                              !
!  BRYname     Input boundary data file name.                          !
!  CLMname     Input climatology file name.                            !
!  DIAbase     Output diagnostics base file name.                      !
!  DIAname     Output diagnostics file name.                           !
!  FILname     Output filter file name.                                !
!  FLTname     Output floats file name.                                !
!  FRCids      NetCDF ID descriptors associated with FRCname.          ! 
!  FRCname     Input forcing fields file name(s).                      !
!  FWDbase     Input forward solution base file name.                  !
!  FWDname     Input forward solution file name.                       !
!  GRDname     Input grid file name.                                   !
!  GSTname     Input/output GST analysis check pointing NetCDF file.   !
!  HISbase     Output history base file name.                          !
!  HISname     Output history file name.                               !
!  IADname     Input adjoint initial conditions file name.             !
!  INIname     Input nonlinear initial conditions file name.           !
!  IPRname     Input representer initial conditions file name.         !
!  ITLname     Input tangent linear initial conditions file name.      !
!  Iname       Physical parameters standard input script file name.    !
!  MODname     Output 4DVAR processed fields file name.                !
!  NRMname     Input/output correlations normalization file name.      !
!  OBSname     Input/output datum observations file name.              !
!  REPname     Input/output representer coefficients file name.        !
!  Rerror      Running error messages.                                 !
!  RSTname     Output restart file name.                               !
!  SSHname     Input SSH observations file name.                       !
!  SSTname     Input SST observations file name.                       !
!  TLFname     Input/output tangent linear impulse forcing file name.  !
!  TLMbase     Output tangent linear base file name.                   !
!  TLMname     Output tangent linear file name.                        !
!  TOBSname    Input tracer observations file name.                    !
!  USRname     USER input/output generic file name.                    !
!  VSURname    Input surface currents observations file name.          !
!  VOBSname    Input horizontal currents observations file name.       !
!  aparnam     Input assimilation parameters file name.                !
!  bparnam     Input biology parameters file name.                     !
!  fposnam     Input initial floats positions file name.               !
!  iparnam     Input ice parameters file name.                         !
!  ioerror     IO error flag.                                          !
!  nFfiles     Number of forcing files.                                !
!  sparnam     Input sediment transport parameters file name.          !
!  sposnam     Input station positions file name.                      !
!  STAname     Output station data file name.                          !
!  STDname     Input background-error standard deviations file name.   !
!  stdinp      Unit number for standard input (often 5).               !
!  stdout      Unit number for standard output (often 6).              !
!  usrout      Unit number for generic USER output.                    !
!  varname     Input IO variables information file name.               !
!                                                                      !
!=======================================================================
!
        USE mod_param

        implicit none

        integer, parameter :: stdinp = 5
        integer, parameter :: stdout = 6
        integer, parameter :: usrout = 10
        integer :: ioerror = 0

        integer, dimension(Ngrids) :: nFfiles

        integer, allocatable :: FRCids(:,:)

        character (len=50), dimension(6) :: Rerror =                    &
     &       (/ ' ROMS/TOMS - Blows up ................ exit_flag: ',   &
     &          ' ROMS/TOMS - Input error ............. exit_flag: ',   &
     &          ' ROMS/TOMS - Output error ............ exit_flag: ',   &
     &          ' ROMS/TOMS - IO error ................ exit_flag: ',   &
     &          ' ROMS/TOMS - Configuration error ..... exit_flag: ',   &
     &          ' ROMS/TOMS - Partition error ......... exit_flag: ' /)

        character (len=80), allocatable :: FRCname(:,:)

        character (len=80), dimension(Ngrids) :: ADJbase
        character (len=80), dimension(Ngrids) :: ADJname
        character (len=80), dimension(Ngrids) :: ADSname
        character (len=80), dimension(Ngrids) :: AVGbase
        character (len=80), dimension(Ngrids) :: AVGname
        character (len=80), dimension(Ngrids) :: BRYname
        character (len=80), dimension(Ngrids) :: CLMname
        character (len=80), dimension(Ngrids) :: DIAbase
        character (len=80), dimension(Ngrids) :: DIAname
        character (len=80), dimension(Ngrids) :: FLTname
#ifdef FILTERED_RST
        character (len=80), dimension(nfile,Ngrids) :: FILname
#endif
        character (len=80), dimension(Ngrids) :: FWDbase
        character (len=80), dimension(Ngrids) :: FWDname
        character (len=80), dimension(Ngrids) :: GRDname
        character (len=80), dimension(Ngrids) :: GSTname
        character (len=80), dimension(Ngrids) :: HISbase
        character (len=80), dimension(Ngrids) :: HISname
        character (len=80), dimension(Ngrids) :: IADname
        character (len=80), dimension(Ngrids) :: INIname
        character (len=80), dimension(Ngrids) :: IRPname
        character (len=80), dimension(Ngrids) :: ITLname
        character (len=80), dimension(Ngrids) :: MODname
        character (len=80), dimension(Ngrids) :: NRMname
        character (len=80), dimension(Ngrids) :: OBSname
        character (len=80), dimension(Ngrids) :: REPname
        character (len=80), dimension(Ngrids) :: SSHname
        character (len=80), dimension(Ngrids) :: SSTname
        character (len=80), dimension(Ngrids) :: TLFname
        character (len=80), dimension(Ngrids) :: TLMbase
        character (len=80), dimension(Ngrids) :: TLMname
        character (len=80), dimension(Ngrids) :: TOBSname
        character (len=80), dimension(Ngrids) :: VSURname
        character (len=80), dimension(Ngrids) :: VOBSname
        character (len=80), dimension(Ngrids) :: RSTname
        character (len=80), dimension(Ngrids) :: STAname
        character (len=80), dimension(Ngrids) :: STDname

        character (len=80) :: Iname
        character (len=80) :: USRname
        character (len=80) :: aparnam
        character (len=80) :: bparnam
        character (len=80) :: fposnam
	character (len=80) :: iparnam
        character (len=80) :: sparnam
        character (len=80) :: sposnam
        character (len=80) :: varname

      END MODULE mod_iounits
