#include "cppdefs.h"
#ifdef NONLINEAR
      SUBROUTINE output (ng)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This subroutine manages nonlinear model output. It creates output   !
!  NetCDF files and writes out data into NetCDF files. If requested,   !
!  it can create several history and/or time-averaged files to avoid   !
!  generating too large files during a single model run.               !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
# ifdef FILTERED
      USE mod_filter, ONLY: nfil, FIL
# endif
# ifdef FLOATS
      USE mod_floats
# endif
# ifdef FOUR_DVAR
      USE mod_fourdvar
# endif
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_scalars
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng
!
!  Local variable declarations.
!
      logical :: ldef

      integer :: ifile, lstr, status
# ifdef FILTERED_RST
      integer :: i
# endif

# ifdef PROFILE
!
!-----------------------------------------------------------------------
!  Turn on output data time wall clock.
!-----------------------------------------------------------------------
!
      CALL wclock_on (ng, iNLM, 8)
# endif
!
!-----------------------------------------------------------------------
!  If appropriate, process nonlinear history NetCDF file.
!-----------------------------------------------------------------------
!
!  Create output history NetCDF file or prepare existing file to
!  append new data to it.  Also,  notice that it is possible to
!  create several files during a single model run.
!
      IF (LdefHIS(ng)) THEN
        IF (ndefHIS(ng).gt.0) THEN
          IF (idefHIS(ng).lt.0) idefHIS(ng)=ntstart-1
          IF ((iic(ng)-1).eq.idefHIS(ng)) THEN
            idefHIS(ng)=idefHIS(ng)+ndefHIS(ng)
            IF (nHIS(ng).ne.ndefHIS(ng).and.iic(ng).eq.ntstart) THEN
              idefHIS(ng)=idefHIS(ng)+nHIS(ng)
            END IF
            NrecHIS(ng)=0
            ifile=(iic(ng)-1)/ndefHIS(ng)+1
            IF (Master) THEN
              lstr=LEN_TRIM(HISbase(ng))
              WRITE (HISname(ng),10) HISbase(ng)(1:lstr-3),ifile
  10          FORMAT (a,'_',i4.4,'.nc')
            END IF
            IF (ncHISid(ng).ne.-1) status=nf_close(ncHISid(ng))
            IF ((iic(ng).eq.ntstart).and.                               &
     &          (MOD(iic(ng)-1,ndefHIS(ng)).gt.0)) THEN
              ldef=ldefout(ng)
            ELSE
              ldef=.TRUE.
            END IF
            CALL def_his (ng, ldef)
            IF (exit_flag.ne.NoError) RETURN
            LwrtHIS(ng)=.TRUE.
!!          LdefHIS(ng)=.FALSE.
          END IF
        ELSE
          IF (iic(ng).eq.ntstart) THEN
            CALL def_his (ng, ldefout(ng))
            IF (exit_flag.ne.NoError) RETURN
            LwrtHIS(ng)=.TRUE.
            LdefHIS(ng)=.FALSE.
          END IF
        END IF
      END IF
!
!  Write out data into history NetCDF file.  Avoid writing initial
!  conditions in perturbation mode computations.
!
      IF (LwrtHIS(ng)) THEN
        IF (LwrtPER(ng)) THEN
          IF ((iic(ng).gt.ntstart).and.                                 &
     &        (MOD(iic(ng)-1,nHIS(ng)).eq.0)) THEN
            CALL wrt_his (ng)
            IF (exit_flag.ne.NoError) RETURN
          END IF
        ELSE
          IF (MOD(iic(ng)-1,nHIS(ng)).eq.0) THEN
            IF (nrrec.eq.0.or.iic(ng).ne.ntstart) CALL wrt_his (ng)
            IF (exit_flag.ne.NoError) RETURN
          END IF
        END IF
      END IF

# if defined AVERAGES && !defined ADJOINT
!
!-----------------------------------------------------------------------
!  If appropriate, process time-averaged NetCDF file.
!-----------------------------------------------------------------------
!
!  Create output time-averaged NetCDF file or prepare existing file
!  to append new data to it. Also, notice that it is possible to
!  create several files during a single model run.
!
      IF (LdefAVG(ng)) THEN
        IF (ndefAVG(ng).gt.0) THEN
          IF (idefAVG(ng).lt.0) idefAVG(ng)=ntstart-1
!!        IF (idefAVG(ng).lt.0) idefAVG(ng)=ntstart+nAVG(ng)-1
          IF ((iic(ng)-1).eq.idefAVG(ng)) THEN
            idefAVG(ng)=idefAVG(ng)+ndefAVG(ng)
            IF (nAVG(ng).ne.ndefAVG(ng).and.iic(ng).eq.ntstart) THEN
              idefAVG(ng)=idefAVG(ng)+nAVG(ng)
            END IF
            ifile=(iic(ng)-1)/ndefAVG(ng)+1
!!          ifile=(iic(ng)-nAVG(ng)-1)/ndefAVG(ng)+1
            IF (Master) THEN
              lstr=LEN_TRIM(AVGbase(ng))
              WRITE (AVGname(ng),20) AVGbase(ng)(1:lstr-3),ifile
  20          FORMAT (a,'_',i4.4,'.nc')
            END IF
            IF (ncAVGid(ng).ne.-1) status=nf_close(ncAVGid(ng))
            IF ((iic(ng).eq.ntstart).and.                               &
     &           (MOD(iic(ng)-1,ndefAVG(ng)).ne.0)) THEN
              ldef=ldefout(ng)
            ELSE
              ldef=.TRUE.
            END IF
# if defined FILTERED && !defined FILTERED_RST
!  When restarting a filtered run, there should be overlap (repeating
!  calculations for some timesteps) so there is no gap in the output
!  record. If it's time to create an output file, must assume it was
!  already created by the previous run.
            IF ((iic(ng).eq.ntstart).and.(nrrec.ne.0)) THEN
              ldef=.false.
            END IF    
# endif       
            CALL def_avg (ng, ldef)
            IF (exit_flag.ne.NoError) RETURN
            LwrtAVG(ng)=.TRUE.
!!          LdefAVG(ng)=.FALSE.
          END IF
        ELSE
          IF (iic(ng).eq.ntstart) THEN
            CALL def_avg (ng, ldefout(ng))
            IF (exit_flag.ne.NoError) RETURN
            LwrtAVG(ng)=.TRUE.
            LdefAVG(ng)=.FALSE.
          END IF
        END IF
      END IF
!
!  Write out data into time-averaged NetCDF file.
!
      IF (LwrtAVG(ng)) THEN
# if defined FILTERED && !defined FILTERED_RST  
        IF (((iic(ng)-ntstart+1).ge.nfil).and.                          &   
# else
        IF ((iic(ng).gt.ntstart).and.                                   &
# endif
     &      (MOD(iic(ng)-1,nAVG(ng)).eq.0)) THEN
          CALL wrt_avg (ng)
          IF (exit_flag.ne.NoError) RETURN
        END IF
      END IF
# endif
# ifdef DIAGNOSTICS
!
!-----------------------------------------------------------------------
!  If appropriate, process time-averaged diagnostics NetCDF file.
!-----------------------------------------------------------------------
!
!  Create output time-averaged diagnostics NetCDF file or prepare
!  existing file to append new data to it. Also, notice that it is
!  possible to create several files during a single model run.
!
      IF (LdefDIA(ng)) THEN
        IF (ndefDIA(ng).gt.0) THEN
          IF (idefDIA(ng).lt.0) idefDIA(ng)=ntstart-1
!!        IF (idefDIA(ng).lt.0) idefDIA(ng)=ntstart+nDIA(ng)-1
          IF ((iic(ng)-1).eq.idefDIA(ng)) THEN
            idefDIA(ng)=idefDIA(ng)+ndefDIA(ng)
            ifile=(iic(ng)-1)/ndefDIA(ng)+1
!!          ifile=(iic(ng)-nDIA(ng)-1)/ndefDIA(ng)+1
            IF (Master) THEN
              lstr=LEN_TRIM(DIAbase(ng))
              WRITE (DIAname(ng),30) DIAbase(ng)(1:lstr-3),ifile
  30          FORMAT (a,'_',i4.4,'.nc')
            END IF
            IF (ncDIAid(ng).ne.-1) status=nf_close(ncDIAid(ng))
            IF ((iic(ng).eq.ntstart+nDIA(ng)).and.                      &
     &           (MOD(iic(ng)-nDIA(ng)-1,ndefDIA(ng)).ne.0)) THEN
              ldef=ldefout(ng)
            ELSE
              ldef=.TRUE.
            END IF
            CALL def_diags (ng, ldef)
            IF (exit_flag.ne.NoError) RETURN
            LwrtDIA(ng)=.TRUE.
!!          LdefDIA(ng)=.FALSE.
          END IF
        ELSE
          IF (iic(ng).eq.ntstart) THEN
            CALL def_diags (ng, ldefout(ng))
            IF (exit_flag.ne.NoError) RETURN
            LwrtDIA(ng)=.TRUE.
            LdefDIA(ng)=.FALSE.
          END IF
        END IF
      END IF
!
!  Write out data into time-averaged diagnostics NetCDF file.
!
      IF (LwrtDIA(ng)) THEN
        IF ((iic(ng).gt.ntstart).and.                                   &
     &      (MOD(iic(ng)-1,nDIA(ng)).eq.0)) THEN
          CALL wrt_diags (ng)
          IF (exit_flag.ne.NoError) RETURN
        END IF
      END IF
# endif
# ifdef STATIONS
!
!-----------------------------------------------------------------------
!  If appropriate, process stations NetCDF file.
!-----------------------------------------------------------------------
!
      IF (Nstation(ng).gt.0) THEN
!
!  Create output station NetCDF file or prepare existing file to
!  append new data to it.
!
        IF (LdefSTA(ng).and.(iic(ng).eq.ntstart)) THEN
          CALL def_station (ng, ldefout(ng))
          IF (exit_flag.ne.NoError) RETURN
          LdefSTA(ng)=.FALSE.
        END IF
!
!  Write out data into stations NetCDF file.
!
        IF (MOD(iic(ng)-1,nSTA(ng)).eq.0) THEN
          CALL wrt_station (ng)
          IF (exit_flag.ne.NoError) RETURN
        END IF
      END IF
# endif
# ifdef FLOATS
!
!-----------------------------------------------------------------------
!  If appropriate, process floats NetCDF file.
!-----------------------------------------------------------------------
!
      IF (Nfloats(ng).gt.0) THEN
!
!  Create output floats NetCDF file or prepare existing file to
!  append new data to it.
!  Deactivate file creation, if a restart run.
!
!!      IF (LdefFLT(ng).and.(frrec(ng).ne.0) THEN
        IF (LdefFLT(ng)) THEN
          CALL def_floats (ng,LdefFLT(ng))
          IF (exit_flag.ne.NoError) RETURN
          LdefFLT(ng)=.FALSE.
        END IF
!
!  Write out data into floats NetCDF file.
!
        IF ((MOD(iic(ng)-1,nFLT(ng)).eq.0).and.                         &
     &      ((frrec(ng).eq.0).or.(iic(ng).ne.ntstart))) THEN
          CALL wrt_floats (ng)
          IF (exit_flag.ne.NoError) RETURN
        END IF
      END IF
# endif
!
!-----------------------------------------------------------------------
!  If appropriate, process restart NetCDF file.
!-----------------------------------------------------------------------
!
!  Create output restart NetCDF file or prepare existing file to
!  append new data to it.
!
      IF (LdefRST(ng)) THEN
        CALL def_rst (ng)
        IF (exit_flag.ne.NoError) RETURN
        LwrtRST(ng)=.TRUE.
        LdefRST(ng)=.FALSE.
#ifdef FILTERED_RST
        CALL def_filt (ng)
#endif
      END IF
!
!  Write out data into restart NetCDF file.
!
      IF (LwrtRST(ng)) THEN
        IF ((iic(ng).gt.ntstart).and.                                   &
     &      (MOD(iic(ng)-1,nRST(ng)).eq.0)) THEN
          CALL wrt_rst (ng)
          IF (exit_flag.ne.NoError) RETURN
# ifdef FILTERED_RST
          DO i=1,FIL
            CALL wrt_filt (ng, i)
          END DO
# endif
        END IF
      END IF
# ifdef FOUR_DVAR
!
!-----------------------------------------------------------------------
!  Create nonlinear model initial conditions file, if necessary. 
!-----------------------------------------------------------------------
!
!  If start of descent algorithm iterations, create initial conditions
!  file or prepare existing file to append new data to it.
!
      IF ((iic(ng).eq.ntstart).and.                                     &
     &    ((Nrun.eq.ERstr).and.(Ipass.eq.1))) THEN
        CALL def_ini (ng)
        IF (exit_flag.ne.NoError) RETURN
      END IF

#  if (defined S4DVAR || defined IS4DVAR || defined REPRESENTERS) && \
      !defined R_SYMMETRY
!
!-----------------------------------------------------------------------
!  If appropriate, process and write model state at observation
!  locations. Compute misfit (model-observations) cost function.
!-----------------------------------------------------------------------
!
      IF (((time(ng)-0.5_r8*dt(ng)).le.ObsTime(ng)).and.                &
     &    (ObsTime(ng).lt.(time(ng)+0.5_r8*dt(ng)))) THEN
        ProcessObs=.TRUE.
        CALL obs_read (ng, iNLM, .FALSE.)
        CALL obs_write (ng, iNLM)
#   ifdef S4DVAR
        CALL obs_cost (ng, iNLM)
#   endif
      ELSE
        ProcessObs=.FALSE.
      END IF
#  endif
# endif
# ifdef PROFILE
!
!-----------------------------------------------------------------------
!  Turn off output data time wall clock.
!-----------------------------------------------------------------------
!
      CALL wclock_off (ng, iNLM, 8)
# endif
      RETURN
      END SUBROUTINE output
#else
      SUBROUTINE output
      RETURN
      END SUBROUTINE output
#endif
