#include "cppdefs.h"
      SUBROUTINE biology (ng,tile)
!
!========================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine computes the biological sources and sinks and adds     !
!  then the global biological fields.                                  !
!                                                                      !
!  Gulf of Alaska model of pollock prey items, originally written in C !
!  by Sarah Hinckley, then adapted to ROMS by Carolina Parada          !                                                              !
!                                                                      !
!=======================================================================
!
#define	NEWSHADE    /* Use Craig's formulation for self shading in PAR calc 
                       Else use Sarah's self-shading from original NPZ code */
#undef	KODIAK_IRAD /* Generate irradiance with curve matching Kodiak data  
                       Else use shortwave radiation (srflx) as irradiance   */
      USE mod_param
      USE mod_forces
      USE mod_grid
      USE mod_ocean
      USE mod_stepping

      integer, intent(in) :: ng, tile

# include "tile.h"
!
#ifdef PROFILE
      CALL wclock_on (ng, iNLM, 15)
#endif
      CALL biology_tile (ng, Istr, Iend, Jstr, Jend,                    &
     &                   LBi, UBi, LBj, UBj, N(ng), NT(ng),             &
     &                   nnew(ng),                                      &
# ifdef MASKING
     &                   GRID(ng) % rmask,                              &
# endif
     &                   GRID(ng) % Hz,                                 &
     &                   GRID(ng) % z_r,                                &
     &                   GRID(ng) % z_w,                                &
     &                   FORCES(ng) % srflx,                            &
     &                   OCEAN(ng) % t)
#ifdef PROFILE
      CALL wclock_off (ng, iNLM, 15)
#endif
      RETURN
      END SUBROUTINE biology
!
!-----------------------------------------------------------------------
      SUBROUTINE biology_tile (ng, Istr, Iend, Jstr, Jend,              &
     &                         LBi, UBi, LBj, UBj, UBk, UBt,            &
     &                         nnew,                                    &
# ifdef MASKING
     &                         rmask,                                   &
# endif
     &                         Hz, z_r, z_w, srflx, t)
!-----------------------------------------------------------------------
!
      USE mod_param
      USE mod_biology
      USE mod_scalars
      USE mod_ocean
      USE mod_grid
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj, UBk, UBt
      integer, intent(in) :: nnew
!
# ifdef ASSUMED_SHAPE
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:,LBj:)
#  endif
      real(r8), intent(in) :: Hz(LBi:,LBj:,:)
      real(r8), intent(in) :: z_r(LBi:,LBj:,:)
      real(r8), intent(in) :: z_w(LBi:,LBj:,0:)
      real(r8), intent(in) :: srflx(LBi:,LBj:)
      real(r8), intent(inout) :: t(LBi:,LBj:,:,:,:)
# else
#  ifdef MASKING
      real(r8), intent(in) :: rmask(LBi:UBi,LBj:UBj)
#  endif
      real(r8), intent(in) :: Hz(LBi:UBi,LBj:UBj,UBk)
      real(r8), intent(in) :: z_r(LBi:UBi,LBj:UBj,UBk)
      real(r8), intent(in) :: z_w(LBi:UBi,LBj:UBj,0:UBk)
      real(r8), intent(in) :: srflx(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: t(LBi:UBi,LBj:UBj,UBk,3,UBt)
# endif
!
!  Local variable declarations.
!
      integer :: IstrR, IendR, JstrR, JendR, IstrU, JstrV
      integer :: i, j, k, itr, itrmx, itrc
      integer :: Iter
      integer :: iday, month, year

      real(r8) :: cff1, cff2, cff3
      real(r8) :: Drate, Pmax, NOup, NHup
      real(r8) :: dtdays
      real(r8) :: LightLim, NOLim, NHLim, IronLim
      real(r8) :: hour, yday, lat, k_phy, Dl
      
      real(r8), dimension(N(ng)) :: NO3, DNO3
      real(r8), dimension(N(ng)) :: Ph, DPh
      real(r8), dimension(N(ng)) :: PSEgg, DPSEgg
      real(r8), dimension(N(ng)) :: PSNaup, DPSNaup
      real(r8), dimension(N(ng)) :: PSCop, DPSCop
      real(r8), dimension(N(ng)) :: PSAd, DPSAd
      real(r8), dimension(N(ng)) :: NCa, DNCa
      real(r8), dimension(N(ng)) :: Eup, DEup
      real(r8), dimension(N(ng)) :: PAR, Temp, HzL
      real(r8), dimension(0:N(ng)) :: z_wL
!
      real(r8), parameter :: eps  = 1.0E-20_r8
      real(r8), parameter :: minv = 0.0E-20_r8
!
#include "set_bounds.h"
#ifdef EW_PERIODIC
# define I_RANGE Istr,Iend
#else
# define I_RANGE IstrR,IendR
#endif
#ifdef NS_PERIODIC
# define J_RANGE Jstr,Jend
#else
# define J_RANGE JstrR,JendR
#endif
!
!
! ----------------------------------------------------------------------
! Begin HORIZONTAL INDEX LOOPING
! ----------------------------------------------------------------------
! 
      DO j=J_RANGE
         DO i=I_RANGE
!
!  Extract biological variables from tracer arrays, and 
!  restrict their values to be positive definite.  Removed CVL's
!  conservation of mass correction because conflicted with SPLINES.
!  For ROMS 2.2+, convert from "flux form" to concentrations by
!  dividing by grid cell thickness.
!Here Caly added state variable for Pseudocalanus
           DO k=1,N(ng)
             NO3(k) = MAX( minv, t(i,j,k,nnew,iNO3)/Hz(i,j,k) )
             Ph(k) = MAX( minv, t(i,j,k,nnew,iPh)/Hz(i,j,k) )
             PSEgg(k) = MAX( minv, t(i,j,k,nnew,iPSEgg)/Hz(i,j,k) )
             PSNaup (k) = MAX( minv, t(i,j,k,nnew,iPSNaup)/Hz(i,j,k) )
             PSCop (k) = MAX( minv, t(i,j,k,nnew,iPSCop)/Hz(i,j,k) )
             PSAd (k) = MAX( minv, t(i,j,k,nnew,iPSAd)/Hz(i,j,k) )
             NCa(k) = MAX( minv, t(i,j,k,nnew,iNCa)/Hz(i,j,k) )
             Eup(k) = MAX( minv, t(i,j,k,nnew,iEup)/Hz(i,j,k) )
                                                                                
             DNO3(k) = 0.0_r8
             DPh(k) = 0.0_r8
             DPSEgg(k) = 0.0_r8
             DPSNaup(k) = 0.0_r8
             DPSCop(k) = 0.0_r8
             DPSAd(k) = 0.0_r8
             DNCa(k) = 0.0_r8
             DEup(k) = 0.0_r8
            END DO
! ----------------------------------------------------------------------
! End HORIZONTAL INDEX LOOPING
! ----------------------------------------------------------------------
         END DO
      END DO

      RETURN
      END SUBROUTINE biology_tile
