#include "cppdefs.h"
      MODULE set_avg_mod
#if defined AVERAGES && (!defined ADJOINT && defined NONLINEAR)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This subroutine accumulates and computes output time-averaged       !
!  fields.  Due to synchronization, the time-averaged fields are       !
!  computed in delayed mode. All averages are accumulated at the       !
!  beggining of the next time-step.                                    !
!                                                                      !
!=======================================================================
!
      implicit none

      PRIVATE
      PUBLIC :: set_avg

      CONTAINS
!
!***********************************************************************
      SUBROUTINE set_avg (ng, tile)
!***********************************************************************
!
      USE mod_param
      USE mod_average
      USE mod_forces
# ifdef SOLVE3D
      USE mod_grid
      USE mod_mixing
# endif
# ifdef ICE_MODEL
      USE mod_ice
# endif
      USE mod_ocean
      USE mod_stepping
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile
!
!  Local variable declarations.
!
# include "tile.h"
!
# ifdef PROFILE
      CALL wclock_on (ng, iNLM, 5)
# endif
      CALL set_avg_tile (ng, Istr, Iend, Jstr, Jend,                    &
     &                   LBi, UBi, LBj, UBj,                            &
     &                   KOUT,                                          &
# ifdef SOLVE3D
#  ifdef ICE_MODEL
     &                   IOUT, IUOUT,                                   &
#  endif
     &                   NOUT,                                          &
     &                   GRID(ng) % pm,                                 &
     &                   GRID(ng) % pn,                                 &
     &                   OCEAN(ng) % u,                                 &
     &                   OCEAN(ng) % v,                                 &
     &                   OCEAN(ng) % W,                                 &
     &                   OCEAN(ng) % t,                                 &
     &                   OCEAN(ng) % rho,                               &
#  ifdef LMD_SKPP
     &                   MIXING(ng) % hsbl,                             &
#  endif
#  ifdef LMD_BKPP
     &                   MIXING(ng) % hbbl,                             &
#  endif
#  ifdef ICE_MODEL
     &                   ICE(ng)%ui,                                    &
     &                   ICE(ng)%vi,                                    &
     &                   ICE(ng)%ai,                                    &
     &                   ICE(ng)%hi,                                    &
     &                   ICE(ng)%hsn,                                   &
     &                   ICE(ng)%tis,                                   &
     &                   ICE(ng)%ti,                                    &
     &                   ICE(ng)%sfwat,                                 &
     &                   ICE(ng)%io_mflux,                              &
#  endif
#  ifdef AVERAGES_AKV
     &                   MIXING(ng) % Akv,                              &
#  endif
#  if defined AVERAGES_AKT || defined AVERAGES_AKS
     &                   MIXING(ng) % Akt,                              &
#  endif
#  ifdef AVERAGES_FLUXES
     &                   FORCES(ng) % stflx,                            &
#   ifdef BULK_FLUXES
     &                   FORCES(ng) % lhflx,                            &
     &                   FORCES(ng) % shflx,                            &
     &                   FORCES(ng) % lrflx,                            &
#    ifdef EMINUSP
     &                   FORCES(ng) % evap,                             &
     &                   FORCES(ng) % rain,                             &
#    endif
#   endif
#   ifdef SHORTWAVE
     &                   FORCES(ng) % srflx,                            &
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
     &                   FORCES(ng) % sustr,                            &
     &                   FORCES(ng) % svstr,                            &
# endif
     &                   OCEAN(ng) % ubar,                              &
     &                   OCEAN(ng) % vbar,                              &
     &                   OCEAN(ng) % zeta,                              &
# ifdef SOLVE3D
     &                   AVERAGE(ng) % avgu3d,                          &
     &                   AVERAGE(ng) % avgv3d,                          &
     &                   AVERAGE(ng) % avgw3d,                          &
     &                   AVERAGE(ng) % avgt,                            &
     &                   AVERAGE(ng) % avgrho,                          &
#  ifdef LMD_SKPP
     &                   AVERAGE(ng) % avghsbl,                         &
#  endif
#  ifdef LMD_BKPP
     &                   AVERAGE(ng) % avghbbl,                         &
#  endif
#  ifdef ICE_MODEL
     &                   AVERAGE(ng) % avguice,                         &
     &                   AVERAGE(ng) % avgvice,                         &
     &                   AVERAGE(ng) % avgaice,                         &
     &                   AVERAGE(ng) % avghice,                         &
     &                   AVERAGE(ng) % avghsno,                         &
     &                   AVERAGE(ng) % avgtice,                         &
     &                   AVERAGE(ng) % avgtimid,                        &
     &                   AVERAGE(ng) % avgsfwat,                        &
     &                   AVERAGE(ng) % avgiomflx,                       &
#  endif
#  ifdef AVERAGES_AKV
     &                   AVERAGE(ng) % avgAKv,                          &
#  endif
#  ifdef AVERAGES_AKT
     &                   AVERAGE(ng) % avgAKt,                          &
#  endif
#  ifdef AVERAGES_AKS
     &                   AVERAGE(ng) % avgAKs,                          &
#  endif
#  ifdef AVERAGES_FLUXES
     &                   AVERAGE(ng) % avgstf,                          &
     &                   AVERAGE(ng) % avgswf,                          &
#   ifdef BULK_FLUXES
     &                   AVERAGE(ng) % avglhf,                          &
     &                   AVERAGE(ng) % avgshf,                          &
     &                   AVERAGE(ng) % avglrf,                          &
#    ifdef EMINUSP
     &                   AVERAGE(ng) % avgevap,                         &
     &                   AVERAGE(ng) % avgrain,                         &
#    endif
#   endif
#   ifdef SHORTWAVE
     &                   AVERAGE(ng) % avgsrf,                          &
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
     &                   AVERAGE(ng) % avgsus,                          &
     &                   AVERAGE(ng) % avgsvs,                          &
# endif
# ifdef AVERAGES_QUADRATIC
#  ifdef SOLVE3D

     &                   AVERAGE(ng) % avgUU,                           &
     &                   AVERAGE(ng) % avgUV,                           &
     &                   AVERAGE(ng) % avgVV,                           &
     &                   AVERAGE(ng) % avgUT,                           &
     &                   AVERAGE(ng) % avgVT,                           &
     &                   AVERAGE(ng) % avgTT,                           &
#  endif     
     &                   AVERAGE(ng) % avgU2,                           &
     &                   AVERAGE(ng) % avgV2,                           &
     &                   AVERAGE(ng) % avgZZ,                           &
# endif
     &                   AVERAGE(ng) % avgu2d,                          &
     &                   AVERAGE(ng) % avgv2d,                          &
     &                   AVERAGE(ng) % avgzeta)

# ifdef PROFILE
      CALL wclock_off (ng, iNLM, 5)
# endif
      RETURN
      END SUBROUTINE set_avg
!
!***********************************************************************
      SUBROUTINE set_avg_tile (ng, Istr, Iend, Jstr, Jend,              &
     &                         LBi, UBi, LBj, UBj,                      &
     &                         Kout,                                    &
# ifdef SOLVE3D
#  ifdef ICE_MODEL
     &                         Iout, Iuout,                             &
#  endif
     &                         Nout,                                    &
     &                         pm, pn,                                  &
     &                         u, v, W, t, rho,                         &
#  ifdef LMD_SKPP
     &                         hsbl,                                    &
#  endif
#  ifdef LMD_BKPP
     &                         hbbl,                                    &
#  endif
#  ifdef ICE_MODEL
     &                         ui, vi, ai, hi, hsn, tis, ti, sfwat,     &
     &                         io_mflux,                                &
#  endif
#  ifdef AVERAGES_AKV
     &                         Akv,                                     &
#  endif
#  if defined AVERAGES_AKT || defined AVERAGES_AKS
     &                         Akt,                                     &
#  endif
#  ifdef AVERAGES_FLUXES
     &                         stflx,                                   &
#   ifdef BULK_FLUXES
     &                         lhflx, shflx, lrflx,                     &
#    ifdef EMINUSP
     &                         evap, rain,                              &
#    endif
#   endif
#   ifdef SHORTWAVE
     &                         srflx,                                   &
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
     &                         sustr, svstr,                            &
# endif
     &                         ubar, vbar, zeta,                        &
# ifdef SOLVE3D
     &                         avgu3d, avgv3d, avgw3d,                  &
     &                         avgt, avgrho,                            &
#  ifdef LMD_SKPP
     &                         avghsbl,                                 &
#  endif
#  ifdef LMD_BKPP
     &                         avghbbl,                                 &
#  endif
#  ifdef ICE_MODEL
     &                         avguice, avgvice, avgaice, avghice,      &
     &                         avghsno, avgtice, avgtimid, avgsfwat,    &
     &                         avgiomflx,                               &
#  endif
#  ifdef AVERAGES_AKV
     &                         avgAKv,                                  &
#  endif
#  ifdef AVERAGES_AKT
     &                         avgAKt,                                  &
#  endif
#  ifdef AVERAGES_AKS
     &                         avgAKs,                                  &
#  endif
#  ifdef AVERAGES_FLUXES
     &                         avgstf, avgswf,                          &
#   ifdef BULK_FLUXES
     &                         avglhf, avgshf, avglrf,                  &
#    ifdef EMINUSP
     &                         avgevap, avgrain,                        &
#    endif
#   endif
#   ifdef SHORTWAVE
     &                         avgsrf,                                  &
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
     &                         avgsus, avgsvs,                          &
# endif
# ifdef AVERAGES_QUADRATIC
#  ifdef SOLVE3D
     &                         avgUU, avgUV, avgVV,                     &
     &                         avgUT, avgVT, avgTT,                     &
#  endif     
     &                         avgU2, avgV2, avgZZ,                     &
# endif
     &                         avgu2d, avgv2d, avgzeta)
!***********************************************************************
!
      USE mod_param
      USE mod_scalars
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: Kout
# ifdef SOLVE3D
#  ifdef ICE_MODEL
      integer, intent(in) :: Iout, Iuout
#  endif
      integer, intent(in) :: Nout
# endif
!
# ifdef ASSUMED_SHAPE
#  ifdef SOLVE3D
      real(r8), intent(in) :: pm(LBi:,LBj:)
      real(r8), intent(in) :: pn(LBi:,LBj:)
      real(r8), intent(in) :: u(LBi:,LBj:,:,:)
      real(r8), intent(in) :: v(LBi:,LBj:,:,:)
      real(r8), intent(in) :: W(LBi:,LBj:,0:)
      real(r8), intent(in) :: t(LBi:,LBj:,:,:,:)
      real(r8), intent(in) :: rho(LBi:,LBj:,:)
#   ifdef LMD_SKPP
      real(r8), intent(in) :: hsbl(LBi:,LBj:)
#   endif
#   ifdef LMD_BKPP
      real(r8), intent(in) :: hbbl(LBi:,LBj:)
#   endif
#   ifdef ICE_MODEL
      real(r8), intent(in) :: ui(LBi:,LBj:,:)
      real(r8), intent(in) :: vi(LBi:,LBj:,:)
      real(r8), intent(in) :: ai(LBi:,LBj:,:)
      real(r8), intent(in) :: hi(LBi:,LBj:,:)
      real(r8), intent(in) :: hsn(LBi:,LBj:,:)
      real(r8), intent(in) :: tis(LBi:,LBj:)
      real(r8), intent(in) :: ti(LBi:,LBj:,:)
      real(r8), intent(in) :: sfwat(LBi:,LBj:,:)
      real(r8), intent(in) :: io_mflux(LBi:,LBj:)
#   endif
#   ifdef AVERAGES_AKV
      real(r8), intent(in) :: Akv(LBi:,LBj:,0:)
#   endif
#   if defined AVERAGES_AKT || defined AVERAGES_AKS
      real(r8), intent(in) :: Akt(LBi:,LBj:,0:,:)
#   endif
#   ifdef AVERAGES_FLUXES
      real(r8), intent(in) :: stflx(LBi:,LBj:,:)
#    ifdef BULK_FLUXES
      real(r8), intent(in) :: lhflx(LBi:,LBj:)
      real(r8), intent(in) :: shflx(LBi:,LBj:)
      real(r8), intent(in) :: lrflx(LBi:,LBj:)
#     ifdef EMINUSP
      real(r8), intent(in) :: evap(LBi:,LBj:)
      real(r8), intent(in) :: rain(LBi:,LBj:)
#     endif
#    endif
#    ifdef SHORTWAVE
      real(r8), intent(in) :: srflx(LBi:,LBj:)
#    endif
#   endif
#  endif
#  ifdef AVERAGES_FLUXES
      real(r8), intent(in) :: sustr(LBi:,LBj:)
      real(r8), intent(in) :: svstr(LBi:,LBj:)
#  endif
      real(r8), intent(in) :: ubar(LBi:,LBj:,:)
      real(r8), intent(in) :: vbar(LBi:,LBj:,:)
      real(r8), intent(in) :: zeta(LBi:,LBj:,:)
#  ifdef SOLVE3D
      real(r8), intent(inout) :: avgu3d(LBi:,LBj:,:)
      real(r8), intent(inout) :: avgv3d(LBi:,LBj:,:)
      real(r8), intent(inout) :: avgw3d(LBi:,LBj:,0:)
      real(r8), intent(inout) :: avgt(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: avgrho(LBi:,LBj:,:)
#   ifdef LMD_SKPP
      real(r8), intent(inout) :: avghsbl(LBi:,LBj:)
#   endif
#   ifdef LMD_BKPP
      real(r8), intent(inout) :: avghbbl(LBi:,LBj:)
#   endif
#   ifdef ICE_MODEL
      real(r8), intent(inout) :: avguice(LBi:,LBj:)
      real(r8), intent(inout) :: avgvice(LBi:,LBj:)
      real(r8), intent(inout) :: avgaice(LBi:,LBj:)
      real(r8), intent(inout) :: avghice(LBi:,LBj:)
      real(r8), intent(inout) :: avghsno(LBi:,LBj:)
      real(r8), intent(inout) :: avgtice(LBi:,LBj:)
      real(r8), intent(inout) :: avgtimid(LBi:,LBj:)
      real(r8), intent(inout) :: avgsfwat(LBi:,LBj:)
      real(r8), intent(inout) :: avgiomflx(LBi:,LBj:)
#   endif
#   ifdef AVERAGES_AKV
      real(r8), intent(inout) :: avgAKv(LBi:,LBj:,0:)
#   endif
#   ifdef AVERAGES_AKT
      real(r8), intent(inout) :: avgAKt(LBi:,LBj:,0:)
#   endif
#   ifdef AVERAGES_AKS
      real(r8), intent(inout) :: avgAKs(LBi:,LBj:,0:)
#   endif
#   ifdef AVERAGES_FLUXES
      real(r8), intent(inout) :: avgstf(LBi:,LBj:)
      real(r8), intent(inout) :: avgswf(LBi:,LBj:)
#    ifdef BULK_FLUXES
      real(r8), intent(inout) :: avglhf(LBi:,LBj:)
      real(r8), intent(inout) :: avgshf(LBi:,LBj:)
      real(r8), intent(inout) :: avglrf(LBi:,LBj:)
#     ifdef EMINUSP
      real(r8), intent(inout) :: avgevap(LBi:,LBj:)
      real(r8), intent(inout) :: avgrain(LBi:,LBj:)
#     endif
#    endif
#    ifdef SHORTWAVE
      real(r8), intent(inout) :: avgsrf(LBi:,LBj:)
#    endif
#   endif
#  endif
#  ifdef AVERAGES_FLUXES
      real(r8), intent(inout) :: avgsus(LBi:,LBj:)
      real(r8), intent(inout) :: avgsvs(LBi:,LBj:)
#  endif
#  ifdef AVERAGES_QUADRATIC
#   ifdef SOLVE3D
      real(r8), intent(inout) :: avgUU(LBi:,LBj:,:)
      real(r8), intent(inout) :: avgUV(LBi:,LBj:,:)
      real(r8), intent(inout) :: avgVV(LBi:,LBj:,:)
      real(r8), intent(inout) :: avgUT(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: avgVT(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: avgTT(LBi:,LBj:,:,:)
#   endif     
      real(r8), intent(inout) :: avgU2(LBi:,LBj:)
      real(r8), intent(inout) :: avgV2(LBi:,LBj:)
      real(r8), intent(inout) :: avgZZ(LBi:,LBj:)
#  endif
      real(r8), intent(inout) :: avgu2d(LBi:,LBj:)
      real(r8), intent(inout) :: avgv2d(LBi:,LBj:)
      real(r8), intent(inout) :: avgzeta(LBi:,LBj:)

# else

#  ifdef SOLVE3D
      real(r8), intent(in) :: pm(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: pn(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: u(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(in) :: v(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(in) :: W(LBi:UBi,LBj:UBj,0:N(ng))
      real(r8), intent(in) :: t(LBi:UBi,LBj:UBj,N(ng),3,NT(ng))
      real(r8), intent(in) :: rho(LBi:UBi,LBj:UBj,N(ng))
#   ifdef LMD_SKPP
      real(r8), intent(in) :: hsbl(LBi:UBi,LBj:UBj)
#   endif
#   ifdef LMD_BKPP
      real(r8), intent(in) :: hbbl(LBi:UBi,LBj:UBj)
#   endif
#   ifdef AVERAGES_AKV
      real(r8), intent(in) :: Akv(LBi:UBi,LBj:UBj,0:N(ng))
#   endif
#   if defined AVERAGES_AKT || defined AVERAGES_AKS
      real(r8), intent(in) :: Akt(LBi:UBi,LBj:UBj,0:N(ng),NAT)
#   endif
#   ifdef AVERAGES_FLUXES
      real(r8), intent(in) :: stflx(LBi:UBi,LBj:UBj,NT(ng))
#    ifdef BULK_FLUXES
      real(r8), intent(in) :: lhflx(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: shflx(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: lrflx(LBi:UBi,LBj:UBj)
#     ifdef EMINUSP
      real(r8), intent(in) :: evap(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: rain(LBi:UBi,LBj:UBj)
#     endif
#    endif
#    ifdef SHORTWAVE
      real(r8), intent(in) :: srflx(LBi:UBi,LBj:UBj)
#    endif
#   endif
#  endif
#  ifdef AVERAGES_FLUXES
      real(r8), intent(in) :: sustr(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: svstr(LBi:UBi,LBj:UBj)
#  endif
      real(r8), intent(in) :: ubar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(in) :: vbar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(in) :: zeta(LBi:UBi,LBj:UBj,3)
#  ifdef SOLVE3D
      real(r8), intent(inout) :: avgu3d(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: avgv3d(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: avgw3d(LBi:UBi,LBj:UBj,0:N(ng))
      real(r8), intent(inout) :: avgt(LBi:UBi,LBj:UBj,N(ng),NT(ng))
      real(r8), intent(inout) :: avgrho(LBi:UBi,LBj:UBj,N(ng))
#   ifdef LMD_SKPP
      real(r8), intent(inout) :: avghsbl(LBi:UBi,LBj:UBj)
#   endif
#   ifdef LMD_BKPP
      real(r8), intent(inout) :: avghbbl(LBi:UBi,LBj:UBj)
#   endif
#   ifdef AVERAGES_AKV
      real(r8), intent(inout) :: avgAKv(LBi:UBi,LBj:UBj,0:N(ng))
#   endif
#   ifdef AVERAGES_AKT
      real(r8), intent(inout) :: avgAKt(LBi:UBi,LBj:UBj,0:N(ng))
#   endif
#   ifdef AVERAGES_AKS
      real(r8), intent(inout) :: avgAKs(LBi:UBi,LBj:UBj,0:N(ng))
#   endif
#   ifdef AVERAGES_FLUXES
      real(r8), intent(inout) :: avgstf(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgswf(LBi:UBi,LBj:UBj)
#    ifdef BULK_FLUXES
      real(r8), intent(inout) :: avglhf(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgshf(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avglrf(LBi:UBi,LBj:UBj)
#     ifdef EMINUSP
      real(r8), intent(inout) :: avgevap(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgrain(LBi:UBi,LBj:UBj)
#     endif
#    endif
#    ifdef SHORTWAVE
      real(r8), intent(inout) :: avgsrf(LBi:UBi,LBj:UBj)
#    endif
#   endif
#  endif
#  ifdef AVERAGES_FLUXES
      real(r8), intent(inout) :: avgsus(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgsvs(LBi:UBi,LBj:UBj)
#  endif
#  ifdef AVERAGES_QUADRATIC
#   ifdef SOLVE3D
      real(r8), intent(inout) :: avgUU(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: avgUV(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: avgVV(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: avgUT(LBi:UBi,LBj:UBj,N(ng),NAT)
      real(r8), intent(inout) :: avgVT(LBi:UBi,LBj:UBj,N(ng),NAT)
      real(r8), intent(inout) :: avgTT(LBi:UBi,LBj:UBj,N(ng),NAT)
#   endif     
      real(r8), intent(inout) :: avgU2(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgV2(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgZZ(LBi:UBi,LBj:UBj)
#  endif
      real(r8), intent(inout) :: avgu2d(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgv2d(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: avgzeta(LBi:UBi,LBj:UBj)
# endif
!
!  Local variable declarations.
!
      integer :: IstrR, IendR, JstrR, JendR, IstrU, JstrV
      integer :: i, itrc, j, k

      real(r8) :: fac

# include "set_bounds.h"
!
!-----------------------------------------------------------------------
! Initialize time-averaged arrays when appropriate.  Notice that
! fields are initilized twice during re-start.  However, the time-
! averaged fields are computed correctly.
!-----------------------------------------------------------------------
!
      IF (((iic(ng).gt.ntsAVG(ng)).and.                                 &
     &     (MOD(iic(ng)-1,nAVG(ng)).eq.1)).or.                          &
     &    ((nrrec.gt.0).and.(iic(ng).eq.ntstart))) THEN
!
!  Initialize 2D fields.
!
        DO j=JstrR,JendR
          DO i=IstrR,IendR
            avgzeta(i,j)=zeta(i,j,Kout)
            avgu2d (i,j)=ubar(i,j,Kout)
            avgv2d (i,j)=vbar(i,j,Kout)
# ifdef AVERAGES_QUADRATIC
            avgZZ(i,j)=zeta(i,j,Kout)*zeta(i,j,Kout)
            avgU2(i,j)=ubar(i,j,Kout)*ubar(i,j,Kout)
            avgV2(i,j)=vbar(i,j,Kout)*vbar(i,j,Kout)
# endif
# ifdef SOLVE3D
#  ifdef LMD_SKPP
            avghsbl(i,j)=hsbl(i,j)
#  endif
#  ifdef LMD_BKPP
            avghbbl(i,j)=hbbl(i,j)
#  endif
#  ifdef ICE_MODEL
            avguice(i,j)=ui(i,j,Iuout)
            avgvice(i,j)=vi(i,j,Iuout)
            avgaice(i,j)=ai(i,j,Iout)
            avghice(i,j)=hi(i,j,Iout)
            avghsno(i,j)=hsn(i,j,Iout)
            avgtice(i,j)=tis(i,j)
            avgtimid(i,j)=ti(i,j,Iout)
            avgsfwat(i,j)=sfwat(i,j,Iout)
            avgiomflx(i,j)=io_mflux(i,j)
#  endif
#  ifdef AVERAGES_FLUXES
            avgstf(i,j)=stflx(i,j,itemp)
            avgswf(i,j)=stflx(i,j,isalt)
#   ifdef BULK_FLUXES
            avglhf(i,j)=lhflx(i,j)
            avgshf(i,j)=shflx(i,j)
            avglrf(i,j)=lrflx(i,j)
#    ifdef EMINUSP
            avgevap(i,j)=evap(i,j)
            avgrain(i,j)=rain(i,j)
#    endif
#   endif
#   ifdef SHORTWAVE
            avgsrf(i,j)=srflx(i,j)
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
            avgsus(i,j)=sustr(i,j)
            avgsvs(i,j)=svstr(i,j)
# endif
          END DO
        END DO

# ifdef SOLVE3D
!
!  Initialize fields associated with 3D horizontal momentum.
!
        DO k=1,N(ng)
          DO j=JstrR,JendR
            DO i=IstrR,IendR
              avgu3d(i,j,k)=u(i,j,k,Nout)
              avgv3d(i,j,k)=v(i,j,k,Nout)
              avgrho(i,j,k)=rho(i,j,k)
#  ifdef AVERAGES_QUADRATIC
              avgUU(i,j,k)=u(i,j,k,Nout)*u(i,j,k,Nout)
              avgVV(i,j,k)=v(i,j,k,Nout)*v(i,j,k,Nout)
#  endif
            END DO
          END DO
#  ifdef AVERAGES_QUADRATIC
          DO j=Jstr,Jend
            DO i=Istr,Iend
              avgUV(i,j,k)=0.25_r8*(u(i  ,j  ,k,Nout)+                  &
     &                              u(i+1,j  ,k,Nout))*                 &
     &                             (v(i  ,j  ,k,Nout)+                  &
     &                              v(i  ,j+1,k,Nout))
            END DO
          END DO
#  endif
        END DO
!
!  Initialized fields associated with tracers.
!
        DO itrc=1,NT(ng)
          DO k=1,N(ng)
            DO j=JstrR,JendR
              DO i=IstrR,IendR
                avgt(i,j,k,itrc)=t(i,j,k,Nout,itrc)
              END DO
            END DO
          END DO
#  ifdef AVERAGES_QUADRATIC
          IF (itrc.le.NAT) THEN
            DO k=1,N(ng)
              DO j=JstrR,JendR
                DO i=IstrR,IendR
                  avgTT(i,j,k,itrc)=t(i,j,k,Nout,itrc)*                 &
     &                              t(i,j,k,Nout,itrc)
                END DO
                DO i=Istr,Iend
                  avgUT(i,j,k,itrc)=0.5_r8*u(i,j,k,Nout)*               &
     &                              (t(i-1,j,k,Nout,itrc)+              &
     &                               t(i  ,j,k,Nout,itrc))
                END DO
              END DO
              DO j=Jstr,Jend
                DO i=IstrR,IendR
                  avgVT(i,j,k,itrc)=0.5_r8*v(i,j,k,Nout)*               &
     &                              (t(i,j-1,k,Nout,itrc)+              &
     &                               t(i,j  ,k,Nout,itrc))
                END DO
              END DO
            END DO
          END IF
#  endif
        END DO
!
!  Initialize fields at W-points.
!
        DO k=0,N(ng)
          DO j=JstrR,JendR
            DO i=IstrR,IendR
              avgw3d(i,j,k)=W(i,j,k)*pm(i,j)*pn(i,j)
#  ifdef AVERAGES_AKV
              avgAKv(i,j,k)=Akv(i,j,k)
#  endif
#  ifdef AVERAGES_AKT
              avgAKt(i,j,k)=Akt(i,j,k,itemp)
#  endif
#  ifdef AVERAGES_AKS
              avgAKs(i,j,k)=Akt(i,j,k,isalt)
#  endif
            END DO
          END DO
        END DO
# endif
!
!-----------------------------------------------------------------------
!  Accumulate time-averaged fields.
!-----------------------------------------------------------------------
!
      ELSE IF (iic(ng).gt.ntsAVG(ng)) THEN
!
!  Accumulate 2D fields.
!
        DO j=JstrR,JendR
          DO i=IstrR,IendR
            avgzeta(i,j)=avgzeta(i,j)+zeta(i,j,Kout)
            avgu2d (i,j)=avgu2d (i,j)+ubar(i,j,Kout)
            avgv2d (i,j)=avgv2d (i,j)+vbar(i,j,Kout)
# ifdef AVERAGES_QUADRATIC
            avgZZ(i,j)=avgZZ(i,j)+zeta(i,j,Kout)*zeta(i,j,Kout)
            avgU2(i,j)=avgU2(i,j)+ubar(i,j,Kout)*ubar(i,j,Kout)
            avgV2(i,j)=avgU2(i,j)+vbar(i,j,Kout)*vbar(i,j,Kout)
# endif
# ifdef SOLVE3D
#  ifdef LMD_SKPP
            avghsbl(i,j)=avghsbl(i,j)+hsbl(i,j)
#  endif
#  ifdef LMD_BKPP
            avghbbl(i,j)=avghbbl(i,j)+hbbl(i,j)
#  endif
#  ifdef ICE_MODEL
            avguice(i,j)=avguice(i,j)+ui(i,j,Iuout)
            avgvice(i,j)=avgvice(i,j)+vi(i,j,Iuout)
            avgaice(i,j)=avgaice(i,j)+ai(i,j,Iout)
            avghice(i,j)=avghice(i,j)+hi(i,j,Iout)
            avghsno(i,j)=avghsno(i,j)+hsn(i,j,Iout)
            avgsfwat(i,j)=avgsfwat(i,j)+sfwat(i,j,Iout)
            avgiomflx(i,j)=avgiomflx(i,j)+io_mflux(i,j)
            avgtice(i,j)=avgtice(i,j)+tis(i,j)
            avgtimid(i,j)=avgtimid(i,j)+ti(i,j,Iout)
#  endif
#  ifdef AVERAGES_FLUXES
            avgstf(i,j)=avgstf(i,j)+stflx(i,j,itemp)
            avgswf(i,j)=avgswf(i,j)+stflx(i,j,isalt)
#   ifdef BULK_FLUXES
            avglhf(i,j)=avglhf(i,j)+lhflx(i,j)
            avgshf(i,j)=avgshf(i,j)+shflx(i,j)
            avglrf(i,j)=avglrf(i,j)+lrflx(i,j)
#    ifdef EMINUSP
            avgevap(i,j)=avgevap(i,j)+evap(i,j)
            avgrain(i,j)=avgrain(i,j)+rain(i,j)
#    endif
#   endif
#   ifdef SHORTWAVE
            avgsrf(i,j)=avgsrf(i,j)+srflx(i,j)
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
            avgsus(i,j)=avgsus(i,j)+sustr(i,j)
            avgsvs(i,j)=avgsvs(i,j)+svstr(i,j)
# endif
          END DO
        END DO

# ifdef SOLVE3D
!
!  Accumulate fields associated with 3D horizontal momentum.
!
        DO k=1,N(ng)
          DO j=JstrR,JendR
            DO i=IstrR,IendR
              avgu3d(i,j,k)=avgu3d(i,j,k)+u(i,j,k,Nout)
              avgv3d(i,j,k)=avgv3d(i,j,k)+v(i,j,k,Nout)
              avgrho(i,j,k)=avgrho(i,j,k)+rho(i,j,k)
#  ifdef AVERAGES_QUADRATIC
              avgUU(i,j,k)=avgUU(i,j,k)+u(i,j,k,Nout)*u(i,j,k,Nout)
              avgVV(i,j,k)=avgVV(i,j,k)+v(i,j,k,Nout)*v(i,j,k,Nout)
#  endif
            END DO
          END DO
#  ifdef AVERAGES_QUADRATIC
          DO j=Jstr,Jend
            DO i=Istr,Iend
              avgUV(i,j,k)=avgUV(i,j,k)+                                &
     &                     0.25_r8*(u(i  ,j  ,k,Nout)+                  &
     &                              u(i+1,j  ,k,Nout))*                 &
     &                             (v(i  ,j  ,k,Nout)+                  &
     &                              v(i  ,j+1,k,Nout))
            END DO
          END DO
#  endif
        END DO
!
!  Accumulate fields associated with tracers.
!
        DO itrc=1,NT(ng)
          DO k=1,N(ng)
            DO j=JstrR,JendR
              DO i=IstrR,IendR
                avgt(i,j,k,itrc)=avgt(i,j,k,itrc)+t(i,j,k,Nout,itrc)
              END DO
            END DO
          END DO
#  ifdef AVERAGES_QUADRATIC
          IF (itrc.le.NAT) THEN
            DO k=1,N(ng)
              DO j=JstrR,JendR
                DO i=IstrR,IendR
                  avgTT(i,j,k,itrc)=avgTT(i,j,k,itrc)+                  &
     &                              t(i,j,k,Nout,itrc)*                 &
     &                              t(i,j,k,Nout,itrc)
                END DO
                DO i=Istr,Iend
                  avgUT(i,j,k,itrc)=avgUT(i,j,k,itrc)+                  &
     &                              0.5_r8*u(i,j,k,Nout)*               &
     &                              (t(i-1,j,k,Nout,itrc)+              &
     &                               t(i  ,j,k,Nout,itrc))
                END DO
              END DO
              DO j=Jstr,Jend
                DO i=IstrR,IendR
                  avgVT(i,j,k,itrc)=avgVT(i,j,k,itrc)+                  &
     &                              0.5_r8*v(i,j,k,Nout)*               &
     &                              (t(i,j-1,k,Nout,itrc)+              &
     &                               t(i,j  ,k,Nout,itrc))
                END DO
              END DO
            END DO
          END IF
#  endif
        END DO
!
!  Accumulate fields at W-points.
!
        DO k=0,N(ng)
          DO j=JstrR,JendR
            DO i=IstrR,IendR
              avgw3d(i,j,k)=avgw3d(i,j,k)+W(i,j,k)*pm(i,j)*pn(i,j)
#  ifdef AVERAGES_AKV
              avgAKv(i,j,k)=avgAKv(i,j,k)+Akv(i,j,k)
#  endif
#  ifdef AVERAGES_AKT
              avgAKt(i,j,k)=avgAKt(i,j,k)+Akt(i,j,k,itemp)
#  endif
#  ifdef AVERAGES_AKS
              avgAKs(i,j,k)=avgAKs(i,j,k)+Akt(i,j,k,isalt)
#  endif
            END DO
          END DO
        END DO
# endif
      END IF
!
!-----------------------------------------------------------------------
!  Convert accumulated sums into time-averages, if appropriate.
!-----------------------------------------------------------------------
!
      IF ((iic(ng).gt.ntsAVG(ng)).and.                                  &
     &    (MOD(iic(ng)-1,nAVG(ng)).eq.0).and.                           &
     &    ((iic(ng).ne.ntstart).or.(nrrec.eq.0))) THEN
        fac=1.0_r8/REAL(nAVG(ng),r8)
        IF (SOUTH_WEST_TEST) THEN
          AVGtime(ng)=AVGtime(ng)+REAL(nAVG(ng),r8)*dt(ng)
        END IF
!
!  Process 2D fields.
!
        DO j=JstrR,JendR
          DO i=IstrR,IendR
            avgzeta(i,j)=fac*avgzeta(i,j)
            avgu2d (i,j)=fac*avgu2d (i,j)
            avgv2d (i,j)=fac*avgv2d (i,j)
# ifdef AVERAGES_QUADRATIC
            avgZZ(i,j)=fac*avgZZ(i,j)
            avgU2(i,j)=fac*avgU2(i,j)
            avgV2(i,j)=fac*avgU2(i,j)
# endif
# ifdef SOLVE3D
#  ifdef LMD_SKPP
            avghsbl(i,j)=fac*avghsbl(i,j)
#  endif
#  ifdef LMD_BKPP
            avghbbl(i,j)=fac*avghbbl(i,j)
#  endif
#  ifdef ICE_MODEL
            avguice(i,j)=fac*avguice(i,j)
            avgvice(i,j)=fac*avgvice(i,j)
            avgaice(i,j)=fac*avgaice(i,j)
            avghice(i,j)=fac*avghice(i,j)
            avghsno(i,j)=fac*avghsno(i,j)
            avgsfwat(i,j)=fac*avgsfwat(i,j)
            avgiomflx(i,j)=fac*avgiomflx(i,j)
            avgtice(i,j)=fac*avgtice(i,j)
            avgtimid(i,j)=fac*avgtimid(i,j)
#  endif
#  ifdef AVERAGES_FLUXES
            avgstf(i,j)=fac*avgstf(i,j)
            avgswf(i,j)=fac*avgswf(i,j)
#   ifdef BULK_FLUXES
            avglhf(i,j)=fac*avglhf(i,j)
            avgshf(i,j)=fac*avgshf(i,j)
            avglrf(i,j)=fac*avglrf(i,j)
#    ifdef EMINUSP
            avgevap(i,j)=fac*avgevap(i,j)
            avgrain(i,j)=fac*avgrain(i,j)
#    endif
#   endif
#   ifdef SHORTWAVE
            avgsrf(i,j)=fac*avgsrf(i,j)
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
            avgsus(i,j)=fac*avgsus(i,j)
            avgsvs(i,j)=fac*avgsvs(i,j)
# endif
          END DO
        END DO

# ifdef SOLVE3D
!
!  Process fields associated with 3D horizontal momentum.
!
        DO k=1,N(ng)
          DO j=JstrR,JendR
            DO i=IstrR,IendR
              avgu3d(i,j,k)=fac*avgu3d(i,j,k)
              avgv3d(i,j,k)=fac*avgv3d(i,j,k)
              avgrho(i,j,k)=fac*avgrho(i,j,k)
#  ifdef AVERAGES_QUADRATIC
              avgUU(i,j,k)=fac*avgUU(i,j,k)
              avgVV(i,j,k)=fac*avgVV(i,j,k)
#  endif
            END DO
          END DO
#  ifdef AVERAGES_QUADRATIC
          DO j=Jstr,Jend
            DO i=Istr,Iend
              avgUV(i,j,k)=fac*avgUV(i,j,k)
            END DO
          END DO
#  endif
        END DO
!
!  Process fields associated with tracers.
!
        DO itrc=1,NT(ng)
          DO k=1,N(ng)
            DO j=JstrR,JendR
              DO i=IstrR,IendR
                avgt(i,j,k,itrc)=fac*avgt(i,j,k,itrc)
              END DO
            END DO
          END DO
#  ifdef AVERAGES_QUADRATIC
          IF (itrc.le.NAT) THEN
            DO k=1,N(ng)
              DO j=JstrR,JendR
                DO i=IstrR,IendR
                  avgTT(i,j,k,itrc)=fac*avgTT(i,j,k,itrc)
                END DO
                DO i=Istr,Iend
                  avgUT(i,j,k,itrc)=fac*avgUT(i,j,k,itrc)
                END DO
              END DO
              DO j=Jstr,Jend
                DO i=IstrR,IendR
                  avgVT(i,j,k,itrc)=fac*avgVT(i,j,k,itrc)
                END DO
              END DO
            END DO
          END IF
#  endif
        END DO
!
!  Process fields at W-points.
!
        DO k=0,N(ng)
          DO j=JstrR,JendR
            DO i=IstrR,IendR
              avgw3d(i,j,k)=fac*avgw3d(i,j,k)
#  ifdef AVERAGES_AKV
              avgAKv(i,j,k)=fac*avgAKv(i,j,k)
#  endif
#  ifdef AVERAGES_AKT
              avgAKt(i,j,k)=fac*avgAKt(i,j,k)
#  endif
#  ifdef AVERAGES_AKS
              avgAKs(i,j,k)=fac*avgAKs(i,j,k)
#  endif
            END DO
          END DO
        END DO
# endif
      END IF

      RETURN
      END SUBROUTINE set_avg_tile
#endif
      END MODULE set_avg_mod
