#include "cppdefs.h"
      MODULE ad_ini_gather_mod
#if defined ADJOINT && defined SOLVE3D
!
!=================================================== Andrew M. Moore ===
!  Copyright (c) 2002 ROMS/TOMS Adjoint Group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This subroutine gathers the model state contributions from the      !
!  initialization step.                                                !
!                                                                      !
!  The initialization scheme for the model is as follows:              !
!                                                                      !
!  (1) Set initial conditions to the following state variable at       !
!      time level 1:                                                   !
!                                                                      !
!        zeta(i,j,1)                                                   !
!           u(i,j,k,1)                                                 !
!           v(i,j,k,1)                                                 !
!           t(i,j,k,1,:)                                               !
!                                                                      !
!  (2) Impose boundary conditions of zeta, u, v, t.                    !
!  (3) Since the initial free-surface is known, set time-filtered      !
!      free-surface (Zt_avg1) to that value and compute level          !
!      thicknesses (Hz) with a call to "set_depth".                    !
!  (4) Compute the initial conditions for barotropic momentum,         !
!      ubar(i,j,1) and vbar(i,j,1), using the vertically integrated    !
!      initial u and v.                                                !
!  (5) Note that in "rhs3d", zeta(i,j,1) and zeta(i,j,2) are           !
!      overwritten by "Zt_avg1".                                       !
!                                                                      !
!=======================================================================
!
      implicit none

      PRIVATE
      PUBLIC  :: ad_ini_gather

      CONTAINS
!
!***********************************************************************
      SUBROUTINE ad_ini_gather (ng, tile)
!***********************************************************************
!
      USE mod_param
      USE mod_coupling
      USE mod_grid
      USE mod_ocean
      USE mod_stepping
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, tile
!
!  Local variable declarations.
!
# include "tile.h"
!
      CALL ad_ini_gather_tile (ng, Istr, Iend, Jstr, Jend,              &
     &                         LBi, UBi, LBj, UBj,                      &
     &                         krhs(ng), kstp(ng), knew(ng),            &
     &                         nstp(ng), nnew(ng),                      &
     &                         GRID(ng) % h,                            &
     &                         GRID(ng) % ad_h,                         &
# ifdef ICESHELF
     &                         GRID(ng) % zice,                         &
# endif
# if defined SEDIMENT && defined SED_MORPH
     &                         OCEAN(ng) % ad_bed,                      &
     &                         GRID(ng) % ad_bed_thick0,                &
# endif
     &                         OCEAN(ng) % zeta,                        &
     &                         COUPLING(ng) % Zt_avg1,                  &
     &                         COUPLING(ng) % ad_Zt_avg1,               &
     &                         GRID(ng) % ad_Hz,                        &
     &                         GRID(ng) % ad_z_r,                       &
     &                         GRID(ng) % ad_z_w,                       &
     &                         OCEAN(ng) % ad_t,                        &
     &                         OCEAN(ng) % ad_u,                        &
     &                         OCEAN(ng) % ad_v,                        &
     &                         OCEAN(ng) % ad_ubar,                     &
     &                         OCEAN(ng) % ad_vbar,                     &
     &                         OCEAN(ng) % ad_zeta)
      RETURN
      END SUBROUTINE ad_ini_gather
!
!***********************************************************************
      SUBROUTINE ad_ini_gather_tile (ng, Istr, Iend, Jstr, Jend,        &
     &                               LBi, UBi, LBj, UBj,                &
     &                               krhs, kstp, knew,                  &
     &                               nstp, nnew,                        &
     &                               h, ad_h,                           &      
# ifdef ICESHELF
     &                               zice,                              &
# endif
# if defined SEDIMENT && defined SED_MORPH
     &                               ad_bed, ad_bed_thick0,             &
# endif
     &                               zeta,                              &
     &                               Zt_avg1, ad_Zt_avg1,               &
     &                               ad_Hz, ad_z_r, ad_z_w,             &
     &                               ad_t, ad_u, ad_v,                  &
     &                               ad_ubar, ad_vbar, ad_zeta)
!***********************************************************************
!
      USE mod_param
      USE mod_scalars
!
# if defined EW_PERIODIC || defined NS_PERIODIC || defined DISTRIBUTE
      USE ad_exchange_2d_mod
      USE ad_exchange_3d_mod
# endif
      USE ad_set_depth_mod, ONLY : ad_set_depth_tile

      USE ad_t3dbc_mod, ONLY : ad_t3dbc_tile
      USE ad_u3dbc_mod, ONLY : ad_u3dbc_tile
      USE ad_v3dbc_mod, ONLY : ad_v3dbc_tile

      USE ad_zetabc_mod, ONLY : ad_zetabc_tile
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: krhs, kstp, knew
      integer, intent(in) :: nstp, nnew
!
# ifdef ASSUMED_SHAPE
      real(r8), intent(in) :: h(LBi:,LBj:)
      real(r8), intent(in) :: zeta(LBi:,LBj:,:)
      real(r8), intent(in) :: Zt_avg1(LBi:,LBj:)
#  ifdef ICESHELF
      real(r8), intent(in) :: zice(LBi:,LBj:)
#  endif
#  if defined SEDIMENT && defined SED_MORPH
      real(r8), intent(in) :: ad_bed(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: ad_bed_thick0(LBi:,LBj:)
#  endif
      real(r8), intent(inout) :: ad_h(LBi:,LBj:)
      real(r8), intent(inout) :: ad_Hz(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_Zt_avg1(LBi:,LBj:)
      real(r8), intent(inout) :: ad_z_r(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_z_w(LBi:,LBj:,0:)

      real(r8), intent(inout) :: ad_t(LBi:,LBj:,:,:,:)
      real(r8), intent(inout) :: ad_u(LBi:,LBj:,:,:)
      real(r8), intent(inout) :: ad_v(LBi:,LBj:,:,:)

      real(r8), intent(inout) :: ad_ubar(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_vbar(LBi:,LBj:,:)
      real(r8), intent(inout) :: ad_zeta(LBi:,LBj:,:)
# else
      real(r8), intent(in) :: h(LBi:UBi,LBj:UBj)
      real(r8), intent(in) :: zeta(LBi:UBi,LBj:UBj,3)
      real(r8), intent(in) :: Zt_avg1(LBi:UBi,LBj:UBj)
#  ifdef ICESHELF
      real(r8), intent(in) :: zice(LBi:UBi,LBj:UBj)
#  endif
#  if defined SEDIMENT && defined SED_MORPH
      real(r8), intent(in) :: ad_bed(LBi:UBi,LBj:UBj,Nbed,MBEDP)
      real(r8), intent(inout) :: ad_bed_thick0(LBi:UBi,LBj:UBj)
#  endif
      real(r8), intent(inout) :: ad_h(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: ad_Hz(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: ad_Zt_avg1(LBi:UBi,LBj:UBj)
      real(r8), intent(inout) :: ad_z_r(LBi:UBi,LBj:UBj,N(ng))
      real(r8), intent(inout) :: ad_z_w(LBi:UBi,LBj:UBj,0:N(ng))

      real(r8), intent(inout) :: ad_t(LBi:UBi,LBj:UBj,N(ng),3,NT(ng))
      real(r8), intent(inout) :: ad_u(LBi:UBi,LBj:UBj,N(ng),2)
      real(r8), intent(inout) :: ad_v(LBi:UBi,LBj:UBj,N(ng),2)

      real(r8), intent(inout) :: ad_ubar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(inout) :: ad_vbar(LBi:UBi,LBj:UBj,3)
      real(r8), intent(inout) :: ad_zeta(LBi:UBi,LBj:UBj,3)
# endif
!
!  Local variable declarations.
!
      integer :: itrc 
!
!-----------------------------------------------------------------------
!  Call adjoint initialisation routines in REVERSE order. This must be
!  done for ALL routines that are called that involve adjoint model
!  variables.
!-----------------------------------------------------------------------
!
!  Compute model depths and thicknesses.
!
      CALL ad_set_depth_tile (ng, Istr, Iend, Jstr, Jend,               &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        ad_zeta,                                  &
     &                        h, ad_h,                                  &
# ifdef ICESHELF
     &                        zice,                                     &
# endif
# if defined SEDIMENT && defined SED_MORPH
     &                        ad_bed, ad_bed_thick0,                    &
# endif
     &                        Zt_avg1, ad_Zt_avg1,                      &
     &                        ad_Hz, ad_z_r, ad_z_w)
!
!  Gather lateral boundary contributions for the state fields associated
!  with the initialisation.
!
# if defined EW_PERIODIC || defined NS_PERIODIC || defined DISTRIBUTE2
      CALL ad_exchange_r2d_tile (ng, iADM, Istr, Iend, Jstr, Jend,      &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           NghostPoints,                          &
     &                           ad_zeta(:,:,kstp))
      CALL ad_exchange_r2d_tile (ng, iADM, Istr, Iend, Jstr, Jend,      &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           NghostPoints,                          &
     &                           ad_zeta(:,:,knew))

      CALL ad_exchange_v3d_tile (ng, iADM, Istr, Iend, Jstr, Jend,      &
     &                           LBi, UBi, LBj, UBj, 1, N(ng),          &
     &                           NghostPoints,                          &
     &                           ad_v(:,:,:,nstp))
      CALL ad_exchange_u3d_tile (ng, iADM, Istr, Iend, Jstr, Jend,      &
     &                           LBi, UBi, LBj, UBj, 1, N(ng),          &
     &                           NghostPoints,                          &
     &                           ad_u(:,:,:,nstp))
      DO itrc=1,NT(ng)
        CALL ad_exchange_r3d_tile (ng, iADM, Istr, Iend, Jstr, Jend,    &
     &                             LBi, UBi, LBj, UBj, 1, N(ng),        &
     &                             NghostPoints,                        &
     &                             ad_t(:,:,:,nstp,itrc))
      END DO
# endif
!
!  Gather non-periodic lateral boundary contributions for the 3D state
!  fields associated with the initialisation.
!
!   HGA:  Check the order here for nstp and nnew.  The F77 code was
!         using only nstp.
!
      CALL ad_v3dbc_tile (ng, Istr, Iend, Jstr, Jend,                   &
     &                    LBi, UBi, LBj, UBj, N(ng),                    &
     &                    nstp, nnew,                                   &
     &                    ad_v)
      CALL ad_u3dbc_tile (ng, Istr, Iend, Jstr, Jend,                   &
     &                    LBi, UBi, LBj, UBj, N(ng),                    &
     &                    nstp, nnew,                                   &
     &                    ad_u)
      DO itrc=1,NT(ng)
        CALL ad_t3dbc_tile (ng, Istr, Iend, Jstr, Jend, itrc,           &
     &                      LBi, UBi, LBj, UBj, N(ng), NT(ng),          &
     &                      nstp, nnew,                                 &
     &                      ad_t)
      END DO
!
!  Gather non-periodic lateral boundary contributions for the 2D state
!  fields associated with the initialisation.
!
!  HGA:  Check the index to update here. The F77 code update first
!        kstp and then knew.

      CALL ad_zetabc_tile (ng, Istr, Iend, Jstr, Jend,                  &
     &                     LBi, UBi, LBj, UBj,                          &
     &                     krhs, kstp, kstp,                            &
     &                     zeta, ad_zeta)
      CALL ad_zetabc_tile (ng, Istr, Iend, Jstr, Jend,                  &
     &                     LBi, UBi, LBj, UBj,                          &
     &                     krhs, kstp, knew,                            &
     &                     zeta, ad_zeta)
      RETURN
      END SUBROUTINE ad_ini_gather_tile
#endif
      END MODULE ad_ini_gather_mod
