MODULE nrtype
      INTEGER, PARAMETER :: I4B = SELECTED_INT_KIND(9)
      INTEGER, PARAMETER :: I2B = SELECTED_INT_KIND(4)
      INTEGER, PARAMETER :: I1B = SELECTED_INT_KIND(2)
      INTEGER, PARAMETER :: SP = KIND(1.0)
      INTEGER, PARAMETER :: DP = KIND(1.0D0)
      INTEGER, PARAMETER :: SPC = KIND((1.0,1.0))
      INTEGER, PARAMETER :: DPC = KIND((1.0D0,1.0D0))
      INTEGER, PARAMETER :: LGT = KIND(.true.)
      REAL(SP), PARAMETER :: PI=3.141592653589793238462643383279502884197_sp
      REAL(SP), PARAMETER :: PIO2=1.57079632679489661923132169163975144209858_sp
      REAL(SP), PARAMETER :: TWOPI=6.283185307179586476925286766559005768394_sp
      REAL(SP), PARAMETER :: SQRT2=1.41421356237309504880168872420969807856967_sp
      REAL(SP), PARAMETER :: EULER=0.5772156649015328606065120900824024310422_sp
      REAL(DP), PARAMETER :: PI_D=3.141592653589793238462643383279502884197_dp
      REAL(DP), PARAMETER :: PIO2_D=1.57079632679489661923132169163975144209858_dp
      REAL(DP), PARAMETER :: TWOPI_D=6.283185307179586476925286766559005768394_dp
      TYPE sprs2_sp
            INTEGER(I4B) :: n,len
            REAL(SP), DIMENSION(:), POINTER :: val
            INTEGER(I4B), DIMENSION(:), POINTER :: irow
            INTEGER(I4B), DIMENSION(:), POINTER :: jcol
      END TYPE sprs2_sp
      TYPE sprs2_dp
            INTEGER(I4B) :: n,len
            REAL(DP), DIMENSION(:), POINTER :: val
            INTEGER(I4B), DIMENSION(:), POINTER :: irow
            INTEGER(I4B), DIMENSION(:), POINTER :: jcol
      END TYPE sprs2_dp
END MODULE nrtype


      SUBROUTINE gasdev_s (harvest)
!
!=======================================================================
!                                                                      !
!  This routine returns in a normally distributed deviate (scalar)     !
!  with zero mean and unit variance, using  RAN1  as the source of     !
!  uniform deviates.                                                   !
!                                                                      !
!=======================================================================
!
!  Imported variable declarations.
!
      real(r8), intent(out) :: harvest
!
!  Local variable declarations.
!
      logical, save :: gaus_stored = .FALSE.

      real(r8) :: rsq, v1, v2

      real(r8), save :: g
!
!-----------------------------------------------------------------------
!  Get a Gaussian distributed deviated with zero mean and unit variance.
!-----------------------------------------------------------------------
!
      IF (gaus_stored) THEN
        harvest=g
        gaus_stored=.FALSE.
      ELSE
        DO
          call ran1 (v1)
          call ran1 (v2)
          v1=2.0_r8*v1-1.0_r8
          v2=2.0_r8*v2-1.0_r8
          rsq=v1*v1+v2*v2
          IF ((rsq.gt.0.0_r8).and.(rsq.lt.1.0_r8)) EXIT
        END DO
        rsq=SQRT(-2.0_r8*LOG(rsq)/rsq)
        harvest=v1*rsq
        g=v2*rsq
        gaus_stored=.TRUE.
      END IF
      RETURN
      END SUBROUTINE gasdev_s

      SUBROUTINE gasdev_v (harvest)
!
!=======================================================================
!                                                                      !
!  This routine returns in a normally distributed deviate (vector)     !
!  with zero mean and unit variance, using  RAN1  as the source of     !
!  uniform deviates.                                                   !
!                                                                      !
!=======================================================================
!
!  Imported variable declarations.
!
      real(r8), dimension(:), intent(out) :: harvest
!
!  Local variable declarations.
!
      logical, save :: gaus_stored=.false.

      logical, dimension(SIZE(harvest)) :: mask

      integer(i4) :: m, n, ng, nn
      integer(i4), save :: last_allocated = 0

      real(r8), dimension(size(harvest)) :: rsq, v1, v2

      real(r8), allocatable, dimension(:), save :: g
!
!-----------------------------------------------------------------------
!  Get a Gaussian distributed deviated with zero mean and unit variance.
!-----------------------------------------------------------------------
!
      n=SIZE(harvest)
      IF (n.ne.last_allocated) THEN
        IF (last_allocated.ne.0) deallocate(g)
        allocate (g(n))
        last_allocated=n
        gaus_stored=.FALSE.
      END IF
      IF (gaus_stored) THEN
        harvest=g
        gaus_stored=.FALSE.
      ELSE
        ng=1
        DO
          IF (ng.gt.n) EXIT
          call ran1 (v1(ng:n))
          call ran1 (v2(ng:n))
          v1(ng:n)=2.0_r8*v1(ng:n)-1.0_r8
          v2(ng:n)=2.0_r8*v2(ng:n)-1.0_r8
          rsq(ng:n)=v1(ng:n)**2+v2(ng:n)**2
          mask(ng:n)=((rsq(ng:n).gt.0.0_r8).and.rsq(ng:n).lt.1.0_r8)
          call array_copy (pack(v1(ng:n),mask(ng:n)),v1(ng:),nn,m)
          v2(ng:ng+nn-1)=PACK(v2(ng:n),mask(ng:n))
          rsq(ng:ng+nn-1)=PACK(rsq(ng:n),mask(ng:n))
          ng=ng+nn
        END DO
        rsq=SQRT(-2.0_r8*LOG(rsq)/rsq)
        harvest=v1*rsq
        g=v2*rsq
        gaus_stored=.TRUE.
      END IF
      RETURN
      END SUBROUTINE gasdev_v

	SUBROUTINE ran1_s(harvest)
	USE nrtype
	USE ran_state, ONLY: K4B,amm,lenran,ran_init, &
		iran0,jran0,kran0,nran0,mran0,rans
	IMPLICIT NONE
	REAL(SP), INTENT(OUT) :: harvest
	if (lenran < 1) call ran_init(1)
	rans=iran0-kran0
	if (rans < 0) rans=rans+2147483579_k4b
	iran0=jran0
	jran0=kran0
	kran0=rans
	nran0=ieor(nran0,ishft(nran0,13))
	nran0=ieor(nran0,ishft(nran0,-17))
	nran0=ieor(nran0,ishft(nran0,5))
	if (nran0 == 1) nran0=270369_k4b
	mran0=ieor(mran0,ishft(mran0,5))
	mran0=ieor(mran0,ishft(mran0,-13))
	mran0=ieor(mran0,ishft(mran0,6))
	rans=ieor(nran0,rans)+mran0
	harvest=amm*merge(rans,not(rans), rans<0 )
	END SUBROUTINE ran1_s

	SUBROUTINE ran1_v(harvest)
	USE nrtype
	USE ran_state, ONLY: K4B,amm,lenran,ran_init, &
		iran,jran,kran,nran,mran,ranv
	IMPLICIT NONE
	REAL(SP), DIMENSION(:), INTENT(OUT) :: harvest
	INTEGER(K4B) :: n
	n=size(harvest)
	if (lenran < n+1) call ran_init(n+1)
	ranv(1:n)=iran(1:n)-kran(1:n)
	where (ranv(1:n) < 0) ranv(1:n)=ranv(1:n)+2147483579_k4b
	iran(1:n)=jran(1:n)
	jran(1:n)=kran(1:n)
	kran(1:n)=ranv(1:n)
	nran(1:n)=ieor(nran(1:n),ishft(nran(1:n),13))
	nran(1:n)=ieor(nran(1:n),ishft(nran(1:n),-17))
	nran(1:n)=ieor(nran(1:n),ishft(nran(1:n),5))
	where (nran(1:n) == 1) nran(1:n)=270369_k4b
	mran(1:n)=ieor(mran(1:n),ishft(mran(1:n),5))
	mran(1:n)=ieor(mran(1:n),ishft(mran(1:n),-13))
	mran(1:n)=ieor(mran(1:n),ishft(mran(1:n),6))
	ranv(1:n)=ieor(nran(1:n),ranv(1:n))+mran(1:n)
	harvest=amm*merge(ranv(1:n),not(ranv(1:n)), ranv(1:n)<0 )
	END SUBROUTINE ran1_v

	SUBROUTINE ran1_s(harvest)
	USE nrtype
	USE ran_state, ONLY: K4B,amm,lenran,ran_init, &
		iran0,jran0,kran0,nran0,mran0,rans
	IMPLICIT NONE
	REAL(SP), INTENT(OUT) :: harvest
	if (lenran < 1) call ran_init(1)
	rans=iran0-kran0
	if (rans < 0) rans=rans+2147483579_k4b
	iran0=jran0
	jran0=kran0
	kran0=rans
	nran0=ieor(nran0,ishft(nran0,13))
	nran0=ieor(nran0,ishft(nran0,-17))
	nran0=ieor(nran0,ishft(nran0,5))
	if (nran0 == 1) nran0=270369_k4b
	mran0=ieor(mran0,ishft(mran0,5))
	mran0=ieor(mran0,ishft(mran0,-13))
	mran0=ieor(mran0,ishft(mran0,6))
	rans=ieor(nran0,rans)+mran0
	harvest=amm*merge(rans,not(rans), rans<0 )
	END SUBROUTINE ran1_s

	SUBROUTINE ran1_v(harvest)
	USE nrtype
	USE ran_state, ONLY: K4B,amm,lenran,ran_init, &
		iran,jran,kran,nran,mran,ranv
	IMPLICIT NONE
	REAL(SP), DIMENSION(:), INTENT(OUT) :: harvest
	INTEGER(K4B) :: n
	n=size(harvest)
	if (lenran < n+1) call ran_init(n+1)
	ranv(1:n)=iran(1:n)-kran(1:n)
	where (ranv(1:n) < 0) ranv(1:n)=ranv(1:n)+2147483579_k4b
	iran(1:n)=jran(1:n)
	jran(1:n)=kran(1:n)
	kran(1:n)=ranv(1:n)
	nran(1:n)=ieor(nran(1:n),ishft(nran(1:n),13))
	nran(1:n)=ieor(nran(1:n),ishft(nran(1:n),-17))
	nran(1:n)=ieor(nran(1:n),ishft(nran(1:n),5))
	where (nran(1:n) == 1) nran(1:n)=270369_k4b
	mran(1:n)=ieor(mran(1:n),ishft(mran(1:n),5))
	mran(1:n)=ieor(mran(1:n),ishft(mran(1:n),-13))
	mran(1:n)=ieor(mran(1:n),ishft(mran(1:n),6))
	ranv(1:n)=ieor(nran(1:n),ranv(1:n))+mran(1:n)
	harvest=amm*merge(ranv(1:n),not(ranv(1:n)), ranv(1:n)<0 )
	END SUBROUTINE ran1_v



MODULE ran_state
      USE nrtype
      IMPLICIT NONE
      INTEGER, PARAMETER :: K4B=selected_int_kind(9)
      INTEGER(K4B), PARAMETER :: hg=huge(1_K4B), hgm=-hg, hgng=hgm-1
      INTEGER(K4B), SAVE :: lenran=0, seq=0
      INTEGER(K4B), SAVE :: iran0,jran0,kran0,nran0,mran0,rans
      INTEGER(K4B), DIMENSION(:,:), POINTER, SAVE :: ranseeds
      INTEGER(K4B), DIMENSION(:), POINTER, SAVE :: iran,jran,kran, &
            nran,mran,ranv
      REAL(SP), SAVE :: amm
      INTERFACE ran_hash
            MODULE PROCEDURE ran_hash_s, ran_hash_v
      END INTERFACE
CONTAINS
!BL
      SUBROUTINE ran_init(length)
      USE nrtype; USE nrutil, ONLY : arth,nrerror,reallocate
      IMPLICIT NONE
      INTEGER(K4B), INTENT(IN) :: length
      INTEGER(K4B) :: new,j,hgt
      if (length < lenran) RETURN
      hgt=hg
      if (hg /= 2147483647) call nrerror('ran_init: arith assump 1 fails')
      if (hgng >= 0)        call nrerror('ran_init: arith assump 2 fails')
      if (hgt+1 /= hgng)    call nrerror('ran_init: arith assump 3 fails')
      if (not(hg) >= 0)     call nrerror('ran_init: arith assump 4 fails')
      if (not(hgng) < 0)    call nrerror('ran_init: arith assump 5 fails')
      if (hg+hgng >= 0)     call nrerror('ran_init: arith assump 6 fails')
      if (not(-1_k4b) < 0)  call nrerror('ran_init: arith assump 7 fails')
      if (not(0_k4b) >= 0)  call nrerror('ran_init: arith assump 8 fails')
      if (not(1_k4b) >= 0)  call nrerror('ran_init: arith assump 9 fails')
      if (lenran > 0) then
            ranseeds=>reallocate(ranseeds,length,5)
            ranv=>reallocate(ranv,length-1)
            new=lenran+1
      else
            allocate(ranseeds(length,5))
            allocate(ranv(length-1))
            new=1
            amm=nearest(1.0_r8,-1.0_r8)/hgng
            if (amm*hgng >= 1.0 .or. amm*hgng <= 0.0) &
                  call nrerror('ran_init: arth assump 10 fails')
      end if
      ranseeds(new:,1)=seq
      ranseeds(new:,2:5)=spread(arth(new,1,size(ranseeds(new:,1))),2,4)
      do j=1,4
            call ran_hash(ranseeds(new:,j),ranseeds(new:,j+1))
      end do
      where (ranseeds(new:,1:3) < 0) &
            ranseeds(new:,1:3)=not(ranseeds(new:,1:3))
      where (ranseeds(new:,4:5) == 0) ranseeds(new:,4:5)=1
      if (new == 1) then
            iran0=ranseeds(1,1)
            jran0=ranseeds(1,2)
            kran0=ranseeds(1,3)
            mran0=ranseeds(1,4)
            nran0=ranseeds(1,5)
            rans=nran0
      end if
      if (length > 1) then
            iran => ranseeds(2:,1)
            jran => ranseeds(2:,2)
            kran => ranseeds(2:,3)
            mran => ranseeds(2:,4)
            nran => ranseeds(2:,5)
            ranv = nran
      end if
      lenran=length
      END SUBROUTINE ran_init
!BL
      SUBROUTINE ran_deallocate
      if (lenran > 0) then
            deallocate(ranseeds,ranv)
            nullify(ranseeds,ranv,iran,jran,kran,mran,nran)
            lenran = 0
      end if
      END SUBROUTINE ran_deallocate
!BL
      SUBROUTINE ran_seed(sequence,size,put,get)
      IMPLICIT NONE
      INTEGER, OPTIONAL, INTENT(IN) :: sequence
      INTEGER, OPTIONAL, INTENT(OUT) :: size
      INTEGER, DIMENSION(:), OPTIONAL, INTENT(IN) :: put
      INTEGER, DIMENSION(:), OPTIONAL, INTENT(OUT) :: get
      if (present(size)) then
            size=5*lenran
      else if (present(put)) then
            if (lenran == 0) RETURN
            ranseeds=reshape(put,shape(ranseeds))
            where (ranseeds(:,1:3) < 0) ranseeds(:,1:3)=not(ranseeds(:,1:3))
            where (ranseeds(:,4:5) == 0) ranseeds(:,4:5)=1
            iran0=ranseeds(1,1)
            jran0=ranseeds(1,2)
            kran0=ranseeds(1,3)
            mran0=ranseeds(1,4)
            nran0=ranseeds(1,5)
      else if (present(get)) then
            if (lenran == 0) RETURN
            ranseeds(1,1:5)=(/ iran0,jran0,kran0,mran0,nran0 /)
            get=reshape(ranseeds,shape(get))
      else if (present(sequence)) then
            call ran_deallocate
            seq=sequence
      end if
      END SUBROUTINE ran_seed
!BL
      SUBROUTINE ran_hash_s(il,ir)
      IMPLICIT NONE
      INTEGER(K4B), INTENT(INOUT) :: il,ir
      INTEGER(K4B) :: is,j
      do j=1,4
            is=ir
            ir=ieor(ir,ishft(ir,5))+1422217823
            ir=ieor(ir,ishft(ir,-16))+1842055030
            ir=ieor(ir,ishft(ir,9))+80567781
            ir=ieor(il,ir)
            il=is
      end do
      END SUBROUTINE ran_hash_s
!BL
      SUBROUTINE ran_hash_v(il,ir)
      IMPLICIT NONE
      INTEGER(K4B), DIMENSION(:), INTENT(INOUT) :: il,ir
      INTEGER(K4B), DIMENSION(size(il)) :: is
      INTEGER(K4B) :: j
      do j=1,4
            is=ir
            ir=ieor(ir,ishft(ir,5))+1422217823
            ir=ieor(ir,ishft(ir,-16))+1842055030
            ir=ieor(ir,ishft(ir,9))+80567781
            ir=ieor(il,ir)
            il=is
      end do
      END SUBROUTINE ran_hash_v
END MODULE ran_state

