#include "cppdefs.h"
      MODULE ice_smoother_mod
#if defined ICE_THERMO && defined ICE_SMOOTH
!
!============================================== W. Paul Budgell =======!
!  Copyright (c) 2002 ROMS/TOMS Group                                  !
!============================================== Hernan G. Arango ======!
!                                                                      !
!  Smooth the stflx field using a low-order Shapiro filter.            !
!  Return the smoothed version in the stflx_wk variable.               !
!                                                                      !
!======================================================================!
!
      implicit none

      PRIVATE
      PUBLIC ice_smoother

      CONTAINS

      SUBROUTINE ice_smoother (ng, tile)

      USE mod_param
# ifdef MASKING
      USE mod_grid
# endif
      USE mod_ice
      USE mod_forces
      USE mod_stepping

      implicit none

      integer, intent(in) :: ng, tile

# include "tile.h"

      CALL ice_smoother_tile (ng, Istr, Iend, Jstr, Jend,               &
     &                      LBi, UBi, LBj, UBj,                         &
# ifdef MASKING
     &                      GRID(ng) % rmask,                           &
# endif
     &                      FORCES(ng) % stflx,                         &
     &                      ICE(ng) % stflx_wk)
!
      RETURN
      END SUBROUTINE ice_smoother
!
!***********************************************************************
      SUBROUTINE ice_smoother_tile (ng, Istr, Iend, Jstr, Jend,         &
     &                        LBi, UBi, LBj, UBj,                       &
# ifdef MASKING
     &                        rmask,                                    &
# endif
     &                        stflx, stflx_wk)
!***********************************************************************
!

      USE mod_param
      USE mod_scalars
!
      USE bc_2d_mod, ONLY : bc_r2d_tile
# ifdef DISTRIBUTE
      USE mp_exchange_mod, ONLY : mp_exchange2d
# endif
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj

# ifdef ASSUMED_SHAPE
#  ifdef MASKING
      real(r8), intent(in), dimension(LBi:,LBj:) :: rmask
#  endif
      real(r8), intent(in) :: stflx(LBi:,LBj:,:)
      real(r8), intent(out) :: stflx_wk(LBi:,LBj:,:)
# else
#  ifdef MASKING
      real(r8), intent(in), dimension(LBi:UBi,LBj:UBj) :: rmask
#  endif
      real(r8), intent(in) :: stflx(LBi:UBi,LBj:UBj,2)
      real(r8), intent(out) :: stflx_wk(LBi:UBi,LBj:UBj,2)
# endif

! Local variable definitions
!
# ifdef DISTRIBUTE
#  ifdef EW_PERIODIC
      logical :: EWperiodic=.TRUE.
#  else
      logical :: EWperiodic=.FALSE.
#  endif
#  ifdef NS_PERIODIC
      logical :: NSperiodic=.TRUE.
#  else
      logical :: NSperiodic=.FALSE.
#  endif
# endif
      integer :: IstrR, IendR, JstrR, JendR, IstrU, JstrV
      integer :: i, j, k, it
      integer, parameter :: nits = 1

      real(r8) :: smfac
      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: a
      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: b

#include "set_bounds.h"
!
      DO k=1,2
!
#  ifdef EW_PERIODIC
#   define I_RANGE Istr-1,Iend+2
#  else
#   define I_RANGE MAX(Istr-1,0),MIN(Iend+2,Lm(ng)+1)
#  endif
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr-1,Jend+2
#  else
#   define J_RANGE MAX(Jstr-1,0),MIN(Jend+2,Mm(ng)+1)
#  endif
      do j=J_RANGE
        do i=I_RANGE
          a(i,j)=stflx(i,j,k)
          b(i,j)=stflx(i,j,k)
        enddo
      enddo
#undef I_RANGE
#undef J_RANGE
      do it=1,nits
#  ifdef EW_PERIODIC
#   define I_RANGE Istr-1,Iend+2
#  else
#   define I_RANGE MAX(Istr-1,1),MIN(Iend+2,Lm(ng))
#  endif
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr-1,Jend+2
#  else
#   define J_RANGE MAX(Jstr-1,1),MIN(Jend+2,Mm(ng))
#  endif
        do j=J_RANGE
          do i=I_RANGE
            smfac=rmask(i+1,j)+rmask(i,j-1)+rmask(i-1,j)+rmask(i,j+1)
            if(rmask(i,j).gt.0..and.smfac.gt.0.) then
              b(i,j)=a(i,j)+(.5/smfac)                                  &
     &               *(a(i+1,j)*rmask(i+1,j)+a(i,j-1)*rmask(i,j-1)      &
     &                +a(i-1,j)*rmask(i-1,j)+a(i,j+1)*rmask(i,j+1)      &
     &                -smfac*a(i,j))
            endif
          enddo
        enddo
#undef I_RANGE
#undef J_RANGE
#  ifdef EW_PERIODIC
#   define I_RANGE Istr-1,Iend+2
#  else
#   define I_RANGE MAX(Istr-1,0),MIN(Iend+2,Lm(ng)+1)
#  endif
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr-1,Jend+2
#  else
#   define J_RANGE MAX(Jstr-1,0),MIN(Jend+2,Mm(ng)+1)
#  endif
        do j=J_RANGE
          do i=I_RANGE
            a(i,j)=b(i,j)
          enddo
        enddo
#undef I_RANGE
#undef J_RANGE

      enddo

      do j=Jstr,Jend
        do i=Istr,Iend
          stflx_wk(i,j,k) = a(i,j)
        enddo
      enddo

      ENDDO
!
        CALL bc_r2d_tile (ng, Istr, Iend, Jstr, Jend,                   &
     &                     LBi, UBi, LBj, UBj, stflx_wk(:,:,isalt))
        CALL bc_r2d_tile (ng, Istr, Iend, Jstr, Jend,                   &
     &                     LBi, UBi, LBj, UBj, stflx_wk(:,:,itemp))
#ifdef DISTRIBUTE
      CALL mp_exchange2d (ng, iNLM, 2, Istr, Iend, Jstr, Jend,          &
     &                    LBi, UBi, LBj, UBj,                           &
     &                    NghostPoints, EWperiodic, NSperiodic,         &
     &                    stflx_wk(:,:,isalt), stflx_wk(:,:,itemp))
#endif
!
      RETURN
      END SUBROUTINE ice_smoother_tile
#endif
      END MODULE ice_smoother_mod
