#include "cppdefs.h"
      MODULE tibc_mod
#ifdef ICE_MODEL
!***********************************************************************
!  Compute the lateral boundary conditions on the internal ice
!  temperature.
!***********************************************************************

      implicit none

      PRIVATE
      PUBLIC tibc_tile

      CONTAINS
!
!***********************************************************************
      SUBROUTINE tibc (ng, tile)
!***********************************************************************
!
      USE mod_param
      USE mod_ice
      USE mod_stepping
!
      integer, intent(in) :: ng, tile

# include "tile.h"
!
      CALL tibc_tile (ng, Istr, Iend, Jstr, Jend,                       &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           liold(ng), linew(ng),                  &
     &                           ICE(ng) % ui,                          &
     &                           ICE(ng) % vi,                          &
     &                           ICE(ng) % ti)
      RETURN
      END SUBROUTINE tibc

!
!***********************************************************************
      SUBROUTINE tibc_tile (ng, Istr, Iend, Jstr, Jend,                 &
     &                           LBi, UBi, LBj, UBj,                    &
     &                           liold, linew,                          &
     &                           ui, vi, ti)
!***********************************************************************
!
      USE mod_param
      USE mod_boundary
      USE mod_grid
      USE mod_scalars

      implicit none

!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Iend, Istr, Jend, Jstr
      integer, intent(in) :: LBi, UBi, LBj, UBj
      integer, intent(in) :: liold, linew

# ifdef ASSUMED_SHAPE_DBG
      real(r8), intent(in)    :: ui(LBi:,LBj:,:)
      real(r8), intent(in)    :: vi(LBi:,LBj:,:)
      real(r8), intent(inout) :: ti(LBi:,LBj:,:)
# else
      real(r8), intent(in)    :: ui(LBi:UBi,LBj:UBj,2)
      real(r8), intent(in)    :: vi(LBi:UBi,LBj:UBj,2)
      real(r8), intent(inout) :: ti(LBi:UBi,LBj:UBj,2)
# endif

!
!  Local variable declarations.
!
      integer :: IstrR, IendR, JstrR, JendR, IstrU, JstrV
      integer :: i, j, know

      real(r8), dimension(PRIVATE_2D_SCRATCH_ARRAY) :: grad

#include "set_bounds.h"
!
!-----------------------------------------------------------------------
!  Set time-indices
!-----------------------------------------------------------------------
!
        know=liold

#ifndef EW_PERIODIC
!
!-----------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!-----------------------------------------------------------------------
!
      IF (WESTERN_EDGE) THEN

# ifdef WEST_TICLAMPED
!
!  Western edge, clamped boundary condition.
!
        DO j=Jstr,Jend
          IF(ui(1,j,linew).ge.0._r8) THEN
             ti(0,j,linew)=BOUNDARY(ng)%ti_west(j)
#  ifdef MASKING
             ti(0,j,linew)=ti(0,j,linew)*                               &
     &                   GRID(ng)%rmask(0,j)
#  endif
          ELSE
             ti(0,j,linew)=ti(1,j,liold)
#  ifdef MASKING
             ti(0,j,linew)=ti(0,j,linew)*                               &
     &                   GRID(ng)%rmask(0,j)
#  endif
          ENDIF
        END DO
# elif defined WEST_TIGRADIENT
!
!  Western edge, gradient boundary condition.
!
        DO j=Jstr,Jend
          ti(0,j,linew)=ti(1,j,linew)
#  ifdef MASKING
          ti(0,j,linew)=ti(0,j,linew)*                                  &
     &                   GRID(ng)%rmask(0,j)
#  endif
        END DO
# else
!
!  Western edge, closed boundary condition.
!
        DO j=Jstr,Jend
          ti(0,j,linew)=ti(1,j,linew)
#  ifdef MASKING
          ti(0,j,linew)=ti(0,j,linew)*                                  &
     &                   GRID(ng)%rmask(0,j)
#  endif
        END DO
# endif
      END IF
!
!-----------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!-----------------------------------------------------------------------
!
      IF (EASTERN_EDGE) THEN

# ifdef EAST_TICLAMPED
!
!  Eastern edge, clamped boundary condition.
!
        DO j=Jstr,Jend
          IF(ui(Lm(ng)+1,j,linew).le.0._r8) THEN
             ti(Lm(ng)+1,j,linew)=BOUNDARY(ng)%ti_east(j)
#  ifdef MASKING
             ti(Lm(ng)+1,j,linew)=ti(Lm(ng)+1,j,linew)*                 &
     &                          GRID(ng)%rmask(Lm(ng)+1,j)
#  endif
          ELSE
             ti(Lm(ng)+1,j,linew)=ti(Lm(ng),j,liold)
#  ifdef MASKING
             ti(Lm(ng)+1,j,linew)=ti(Lm(ng)+1,j,linew)*                 &
     &                          GRID(ng)%rmask(Lm(ng)+1,j)
#  endif
          ENDIF
        END DO
# elif defined EAST_TIGRADIENT
!
!  Eastern edge, gradient boundary condition.
!
        DO j=Jstr,Jend
          ti(Lm(ng)+1,j,linew)=ti(Lm(ng),j,linew)
#  ifdef MASKING
          ti(Lm(ng)+1,j,linew)=ti(Lm(ng)+1,j,linew)*                    &
     &                          GRID(ng)%rmask(Lm(ng)+1,j)
#  endif
        END DO
# else
!
!  Eastern edge, closed boundary condition.
!
        DO j=Jstr,Jend
          ti(Lm(ng)+1,j,linew)=ti(Lm(ng),j,linew)
#  ifdef MASKING
          ti(Lm(ng)+1,j,linew)=ti(Lm(ng)+1,j,linew)*                    &
     &                          GRID(ng)%rmask(Lm(ng)+1,j)
#  endif
        END DO
# endif
      END IF
#endif
#ifndef NS_PERIODIC
!
!-----------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!-----------------------------------------------------------------------
!
      IF (SOUTHERN_EDGE) THEN

# ifdef SOUTH_TICLAMPED
!
!  Southern edge, clamped boundary condition.
!
        DO i=Istr,Iend
          IF(vi(i,1,linew).ge.0._r8) THEN
             ti(i,0,linew)=BOUNDARY(ng)%ti_south(i)
#  ifdef MASKING
             ti(i,0,linew)=ti(i,0,linew)*                               &
     &                   GRID(ng)%rmask(i,0)
#  endif
          ELSE
             ti(i,0,linew)=ti(i,1,liold)
#  ifdef MASKING
             ti(i,0,linew)=ti(i,0,linew)*                               &
     &                   GRID(ng)%rmask(i,0)
#  endif
          ENDIF
        END DO
# elif defined SOUTH_TIGRADIENT
!
!  Southern edge, gradient boundary condition.
!
        DO i=Istr,Iend
          ti(i,0,linew)=ti(i,1,linew)
#  ifdef MASKING
          ti(i,0,linew)=ti(i,0,linew)*                                  &
     &                   GRID(ng)%rmask(i,0)
#  endif
        END DO
# else
!
!  Southern edge, closed boundary condition.
!
        DO i=Istr,Iend
          ti(i,0,linew)=ti(i,1,linew)
#  ifdef MASKING
          ti(i,0,linew)=ti(i,0,linew)*                                  &
     &                   GRID(ng)%rmask(i,0)
#  endif
        END DO
# endif
      END IF
!
!-----------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!-----------------------------------------------------------------------
!
      IF (NORTHERN_EDGE) THEN

# ifdef NORTH_TICLAMPED
!
!  Northern edge, clamped boundary condition.
!
        DO i=Istr,Iend
          IF(vi(i,Mm(ng)+1,linew).le.0._r8) THEN
             ti(i,Mm(ng)+1,linew)=BOUNDARY(ng)%ti_north(i)
#  ifdef MASKING
             ti(i,Mm(ng)+1,linew)=ti(i,Mm(ng)+1,linew)*                 &
     &                          GRID(ng)%rmask(i,Mm(ng)+1)
#  endif
          ELSE
             ti(i,Mm(ng)+1,linew)=ti(i,Mm(ng),liold)
#  ifdef MASKING
             ti(i,Mm(ng)+1,linew)=ti(i,Mm(ng)+1,linew)*                 &
     &                          GRID(ng)%rmask(i,Mm(ng)+1)
#  endif
          ENDIF
        END DO
# elif defined NORTH_TIGRADIENT
!
!  Northern edge, gradient boundary condition.
!
        DO i=Istr,Iend
          ti(i,Mm(ng)+1,linew)=ti(i,Mm(ng),linew)
#  ifdef MASKING
          ti(i,Mm(ng)+1,linew)=ti(i,Mm(ng)+1,linew)*                    &
     &                          GRID(ng)%rmask(i,Mm(ng)+1)
#  endif
        END DO
# else
!
!  Northern edge, closed boundary condition.
!
        DO i=Istr,Iend
          ti(i,Mm(ng)+1,linew)=ti(i,Mm(ng),linew)
#  ifdef MASKING
          ti(i,Mm(ng)+1,linew)=ti(i,Mm(ng)+1,linew)*                    &
     &                          GRID(ng)%rmask(i,Mm(ng)+1)
#  endif
        END DO
# endif
      END IF
#endif
#if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!-----------------------------------------------------------------------
!  Boundary corners.
!-----------------------------------------------------------------------
!
      IF (SOUTHERN_EDGE.and.WESTERN_EDGE) THEN
        ti(0,0,linew)=0.5_r8*(ti(1,0,linew)+                            &
     &                         ti(0,1,linew))
      END IF
      IF (SOUTHERN_EDGE.and.EASTERN_EDGE) THEN
        ti(Lm(ng)+1,0,linew)=0.5_r8*(ti(Lm(ng)+1,1,linew)+              &
     &                                ti(Lm(ng)  ,0,linew))
      END IF
      IF (NORTHERN_EDGE.and.WESTERN_EDGE) THEN
        ti(0,Mm(ng)+1,linew)=0.5_r8*(ti(0,Mm(ng)  ,linew)+              &
     &                                ti(1,Mm(ng)+1,linew))
      END IF
      IF (NORTHERN_EDGE.and.EASTERN_EDGE) THEN
        ti(Lm(ng)+1,Mm(ng)+1,linew)=0.5_r8*                             &
     &             (ti(Lm(ng)+1,Mm(ng)  ,linew)+                        &
     &              ti(Lm(ng)  ,Mm(ng)+1,linew))
      END IF
#endif
      RETURN
      END SUBROUTINE tibc_tile
#endif

      END MODULE tibc_mod
