#include "cppdefs.h"
#if (defined TANGENT || defined TL_IOMS) && defined FOUR_DVAR
      SUBROUTINE tl_wrt_ini (ng, Tindex, OutRec)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine writes tangent linear initial conditions into tangent  !
!  linear initial NetCDF file.                                         !
!                                                                      !
!  On Input:                                                           !
!                                                                      !
!     ng         Nested grid number.                                   !
!     Tindex     State variables time index to write.                  !
!     OutRec     NetCDF file unlimited dimension record to write.      !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_fourdvar
      USE mod_grid
      USE mod_iounits
      USE mod_mixing
      USE mod_ncparam
      USE mod_netcdf
      USE mod_ocean
      USE mod_scalars
# if defined SEDIMENT || defined BBL_MODEL
      USE mod_sediment
# endif
      USE mod_stepping
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, Tindex, OutRec
!
!  Local variable declarations.
!
      integer :: LBi, UBi, LBj, UBj
      integer :: gfactor, gtype, i, itrc, status, varid

      integer :: nf_fwrite2d
# ifdef SOLVE3D
      integer :: nf_fwrite3d
# endif
      integer, dimension(2) :: start, total

      real(r8) :: scale

      character (len=15) :: string
!
      LBi=LBOUND(GRID(ng)%h,DIM=1)
      UBi=UBOUND(GRID(ng)%h,DIM=1)
      LBj=LBOUND(GRID(ng)%h,DIM=2)
      UBj=UBOUND(GRID(ng)%h,DIM=2)
!
!-----------------------------------------------------------------------
!  Write out tangent linear initial conditions.
!-----------------------------------------------------------------------
!
      IF (exit_flag.ne.NoError) RETURN
!
!  Set grid type factor to write full (gfactor=1) fields or water
!  points (gfactor=-1) fields only.
!
# if defined WRITE_WATER && defined MASKING
        gfactor=-1
# else
        gfactor=1
# endif
!
!  Write out model time (s).
!
      IF (OutThread) THEN
        status=nf_put_var1_TYPE(ncITLid(ng), itlVid(idtime,ng),         &
     &                          OutRec, time(ng))
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,10) TRIM(Vname(1,idtime)), OutRec
          exit_flag=3
          ioerror=status
          RETURN
        END IF
      END IF
!
!  Write out cost function gradient norm.
!
      IF ((Ipass.eq.1).and.OutThread) THEN
        start(1)=1
        total(1)=NstateVar(ng)+1
        start(2)=Nrun
        total(2)=1
        status=nf_inq_varid(ncINIid(ng),'cost_gradient',varid)
        IF (status.eq.nf_noerr) THEN
          status=nf_put_vara_TYPE(ncINIid(ng),varid,start,total,        &
     &                            FOURDVAR(ng)%CostGrad(0))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'cost_gradient', Nrun
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
        status=nf_inq_varid(ncITLid(ng),'cost_gradient',varid)
        IF (status.eq.nf_noerr) THEN
          status=nf_put_vara_TYPE(ncITLid(ng),varid,start,total,        &
     &                            FOURDVAR(ng)%CostGrad(0))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'cost_gradient', Nrun
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
      END IF
!
!  Write out model minus observations misfit cost function value to
!  both nonlinear and tangent linear initial file.
!
      IF ((Ipass.eq.1).and.OutThread) THEN
        start(1)=1
        total(1)=NstateVar(ng)+1
        start(2)=Nrun
        total(2)=1
        status=nf_inq_varid(ncINIid(ng),'cost_function',varid)
        IF (status.eq.nf_noerr) THEN
          status=nf_put_vara_TYPE(ncINIid(ng),varid,start,total,        &
     &                            FOURDVAR(ng)%ObsCost(0))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'cost_function', Nrun
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
        status=nf_inq_varid(ncITLid(ng),'cost_function',varid)
        IF (status.eq.nf_noerr) THEN
          status=nf_put_vara_TYPE(ncITLid(ng),varid,start,total,        &
     &                            FOURDVAR(ng)%ObsCost(0))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'cost_function', Nrun
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
      END IF
!
!  Write out model minus background misfit cost function value to
!  both nonlinear and tangent linear initial file.
!
      IF ((Ipass.eq.1).and.OutThread) THEN
        start(1)=1
        total(1)=NstateVar(ng)+1
        start(2)=Nrun
        total(2)=1
        status=nf_inq_varid(ncINIid(ng),'back_function',varid)
        IF (status.eq.nf_noerr) THEN
          status=nf_put_vara_TYPE(ncINIid(ng),varid,start,total,        &
     &                            FOURDVAR(ng)%BackCost(0))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'back_function', Nrun
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
        status=nf_inq_varid(ncITLid(ng),'back_function',varid)
        IF (status.eq.nf_noerr) THEN
          status=nf_put_vara_TYPE(ncITLid(ng),varid,start,total,        &
     &                            FOURDVAR(ng)%BackCost(0))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'back_function', Nrun
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
      END IF
!
!  Write out free-surface (m)
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_fwrite2d(ng, iTLM, ncITLid(ng), itlVid(idFsur,ng),      &
     &                   OutRec, gtype,                                 &
     &                   LBi, UBi, LBj, UBj, scale,                     &
# ifdef MASKING
     &                   GRID(ng) % rmask(LBi,LBj),                     &
# endif
     &                   OCEAN(ng) % tl_zeta(LBi,LBj,Tindex))
      IF (status.ne.nf_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,10) TRIM(Vname(1,idFsur)), OutRec
        END IF
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out 2D momentum component (m/s) in the XI-direction.
!
      scale=1.0_r8
      gtype=gfactor*u2dvar
      status=nf_fwrite2d(ng, iTLM, ncITLid(ng), itlVid(idUbar,ng),      &
     &                   OutRec, gtype,                                 &
     &                   LBi, UBi, LBj, UBj, scale,                     &
# ifdef MASKING
     &                   GRID(ng) % umask(LBi,LBj),                     &
# endif
     &                   OCEAN(ng) % tl_ubar(LBi,LBj,Tindex))
      IF (status.ne.nf_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,10) TRIM(Vname(1,idUbar)), OutRec
        END IF
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out 2D momentum component (m/s) in the ETA-direction.
!
      scale=1.0_r8
      gtype=gfactor*v2dvar
      status=nf_fwrite2d(ng, iTLM, ncITLid(ng), itlVid(idVbar,ng),      &
     &                   OutRec, gtype,                                 &
     &                   LBi, UBi, LBj, UBj, scale,                     &
# ifdef MASKING
     &                   GRID(ng) % vmask(LBi,LBj),                     &
# endif
     &                   OCEAN(ng) % tl_vbar(LBi,LBj,Tindex))
      IF (status.ne.nf_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,10) TRIM(Vname(1,idVbar)), OutRec
        END IF
        exit_flag=3
        ioerror=status
        RETURN
      END IF
# ifdef SOLVE3D
!
!  Write out 3D momentum component (m/s) in the XI-direction.
!
      scale=1.0_r8
      gtype=gfactor*u3dvar
      status=nf_fwrite3d(ng, iTLM, ncITLid(ng), itlVid(idUvel,ng),      &
     &                   OutRec, gtype,                                 &
     &                   LBi, UBi, LBj, UBj, 1, N(ng), scale,           &
#  ifdef MASKING
     &                   GRID(ng) % umask(LBi,LBj),                     &
#  endif
     &                   OCEAN(ng) % tl_u(LBi,LBj,1,Tindex))
      IF (status.ne.nf_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,10) TRIM(Vname(1,idUvel)), OutRec
        END IF
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out 3D momentum component (m/s) in the ETA-direction.
!
      scale=1.0_r8
      gtype=gfactor*v3dvar
      status=nf_fwrite3d(ng, iTLM, ncITLid(ng), itlVid(idVvel,ng),      &
     &                   OutRec, gtype,                                 &
     &                   LBi, UBi, LBj, UBj, 1, N(ng), scale,           &
#  ifdef MASKING
     &                   GRID(ng) % vmask(LBi,LBj),                     &
#  endif
     &                   OCEAN(ng) % tl_v(LBi,LBj,1,Tindex))
      IF (status.ne.nf_noerr) THEN
        IF (Master) THEN
          WRITE (stdout,10) TRIM(Vname(1,idVvel)), OutRec
        END IF
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out tracer type variables.
!
      DO itrc=1,NT(ng)
        scale=1.0_r8
        gtype=gfactor*r3dvar
        status=nf_fwrite3d(ng, iTLM, ncITLid(ng), itlTid(itrc,ng),      &
     &                     OutRec, gtype,                               &
     &                     LBi, UBi, LBj, UBj, 1, N(ng), scale,         &
#  ifdef MASKING
     &                     GRID(ng) % rmask(LBi,LBj),                   &
#  endif
     &                     OCEAN(ng) % tl_t(LBi,LBj,1,Tindex,itrc))
        IF (status.ne.nf_noerr) THEN
          IF (Master) THEN
            WRITE (stdout,10) TRIM(Vname(1,idTvar(itrc))), OutRec
          END IF
          exit_flag=3
          ioerror=status
          RETURN
        END IF
      END DO
# endif
!
!-----------------------------------------------------------------------
!  Synchronize tangent linear initial NetCDF file to disk to allow other
!  processes to access data immediately after it is written.
!-----------------------------------------------------------------------
!
      IF (OutThread) THEN
        status=nf_sync(ncITLid(ng))
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,20)
          exit_flag=3
          ioerror=status
          RETURN
        END IF
        IF (OutRec.eq.1) THEN
          string='initial  fields'
        ELSE IF (OutRec.eq.2) THEN
          string='v-increments   '
        ELSE IF (OutRec.eq.3) THEN
          string='v-increments   '
        END IF
# ifdef SOLVE3D
        WRITE (stdout,30) string, Nrun, Tindex, Tindex, OutRec
# else
        WRITE (stdout,30) string, Nrun, Tindex, OutRec
# endif
      END IF
!
  10  FORMAT (/,' TL_WRT_INI - error while writing variable: ',a,/,11x,    &
     &        'into tangent initial NetCDF file for time record: ',i4)
  20  FORMAT (/,' TL_WRT_INI - unable to synchronize tangent initial',     &
     &        ' NetCDF to disk.')
# ifdef SOLVE3D
  30  FORMAT (3x,'TL_WRT_INI   - wrote ',a,' (Iter=',i4.4,', Index=',i1,   &
     &        ',',i1,', Rec=',i4.4,')')
# else
  30  FORMAT (3x,'TL_WRT_INI   - wrote ',a,' (Iter=',i4.4,', Index=',i1,   &
     &        ', Rec=',i4.4,')')
# endif
      RETURN
      END SUBROUTINE tl_wrt_ini
#else
      SUBROUTINE tl_wrt_ini
      RETURN
      END SUBROUTINE tl_wrt_ini
#endif
