#include "cppdefs.h"
      SUBROUTINE close_io
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
! This subroutine flushes and closes all IO files.                     !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_scalars
#if defined BIOFLUX
      USE mod_biology
#endif
!
      implicit none
!
!  Local variable declarations.
!
      integer :: MyError, ng, status

#if defined BIOFLUX
      integer :: i, j
      real(r8) :: dtdays
!
!---------------------------------------------------------------------
!  Write biological fluxes to standard out.
!---------------------------------------------------------------------
!
      
      WRITE (stdout,*) ' '
      WRITE (stdout,*) ' '
      WRITE (stdout,134) ' Cumulative biological fluxes'
      DO ng=1,Ngrids
        IF (Master) THEN
# ifdef BIO_GOANPZ
!         Scale fluxes by maximum
          xi = 0.0_r8
          DO i = itemp,iDet
            DO j = itemp,iDet
              xi = MAX(xi, bflx(i,j))
            END DO
          END DO
          xi = 10.0_r8/xi
          WRITE (stdout,134) ' To  :  From:'
          WRITE (stdout,131) 'NO3','NH4','PhS','PhL','MZS','MZL','Cop', &
     &                      'NCa','Eup','Det'
          WRITE (stdout,132) 'NO3 : ', (xi*bflx(i,iNO3), i=iNO3,IDet)
          WRITE (stdout,132) 'NH4 : ', (xi*bflx(i,iNH4), i=iNO3,IDet)
          WRITE (stdout,132) 'PhS : ', (xi*bflx(i,iPhS), i=iNO3,IDet)
          WRITE (stdout,132) 'PhL : ', (xi*bflx(i,iPhL), i=iNO3,IDet)
          WRITE (stdout,132) 'MZS : ', (xi*bflx(i,iMZS), i=iNO3,IDet)
          WRITE (stdout,132) 'MZL : ', (xi*bflx(i,iMZL), i=iNO3,IDet)
          WRITE (stdout,132) 'Cop : ', (xi*bflx(i,iCop), i=iNO3,IDet)
          WRITE (stdout,132) 'NCa : ', (xi*bflx(i,iNCa), i=iNO3,IDet)
          WRITE (stdout,132) 'Eup : ', (xi*bflx(i,iEup), i=iNO3,IDet)
          WRITE (stdout,132) 'Det : ', (xi*bflx(i,iDet), i=iNO3,IDet)
          WRITE (stdout,133) 'pred: ', (xi*bflx(i,itemp), i=iCop,iEup)
          WRITE (stdout,*) ' '
 131  FORMAT ('BIOFLUX  ',7x,10a6)      
 132  FORMAT ('BIOFLUX  ',a7,10f6.1)      
 133  FORMAT ('BIOFLUX  ',a7,36x,3f6.1)      
 134  FORMAT ('BIOFLUX  ',a)      
# endif
        END IF
      END DO
#endif
!
!-----------------------------------------------------------------------
!  Close output NetCDF files. Set file indices to closed state.
!-----------------------------------------------------------------------
!
      DO ng=1,Ngrids
# if defined OFFLINE_FLOATS || defined OFFLINE_BIOLOGY
!
!  Report the name of the climatology file so it can be used in the
!  next run, if restarted.
!
        WRITE (stdout,230) TRIM(CLMname(ng))
 230    FORMAT (/,' MULTICLM_INFO : ',a)
# endif
        IF (ncRSTid(ng).ne.-1) THEN
          status=nf_close(ncRSTid(ng))
          ncRSTid(ng)=-1
        END IF
        IF (ncHISid(ng).ne.-1) THEN
          status=nf_close(ncHISid(ng))
          ncHISid(ng)=-1
        END IF
#ifdef ADJOINT
        IF (ncADJid(ng).ne.-1) THEN
          status=nf_close(ncADJid(ng))
          ncADJid(ng)=-1
        END IF
#endif
#ifdef TANGENT
        IF (ncTLMid(ng).ne.-1) THEN
          status=nf_close(ncTLMid(ng))
          ncTLMid(ng)=-1
        END IF
#endif
#ifdef AVERAGES
        IF (ncAVGid(ng).ne.-1) THEN
          status=nf_close(ncAVGid(ng))
          ncAVGid=-1
        END IF
#endif
#ifdef FLOATS
        IF (ncFLTid(ng).ne.-1) THEN
          status=nf_close(ncFLTid(ng))
          ncFLTid(ng)=-1
        END IF
#endif
#if defined FORWARD_READ || defined FORWARD_WRITE
        IF (ncFWDid(ng).ne.-1) THEN
          status=nf_close(ncFWDid(ng))
          ncFWDid(ng)=-1
        END IF
#endif
!
!  Report number of time records written.
!
        IF (Master) THEN
          WRITE (stdout,10) ng
          IF (NrecHIS(ng).gt.0) THEN
            WRITE (stdout,20) 'HISTORY', NrecHIS(ng)
          END IF
          IF (NrecRST(ng).gt.0) THEN
            IF (LcycleRST(ng)) THEN
              IF (NrecRST(ng).gt.1) THEN
                NrecRST(ng)=2
              ELSE
                NrecRST(ng)=1
              END IF
            END IF
            WRITE (stdout,20) 'RESTART', NrecRST(ng)
          END IF
#ifdef ADJOINT
          IF (NrecADJ(ng).gt.0) THEN
            WRITE (stdout,20) 'ADJOINT', NrecADJ(ng)
          END IF
#endif
#ifdef TANGENT
          IF (NrecTLM(ng).gt.0) THEN
            WRITE (stdout,20) 'TANGENT', NrecTLM(ng)
          END IF
#endif
#ifdef AVERAGES
          IF (NrecAVG(ng).gt.0) THEN
            WRITE (stdout,20) 'AVERAGE', NrecAVG(ng)
          END IF
#endif
#ifdef FILTERED_RST
          IF (NrecFIL(ng).gt.0) THEN
            WRITE (stdout,20) 'FILTER RESTART' , NrecFIL(ng)
          END IF
#endif
#ifdef STATIONS
          IF (NrecSTA(ng).gt.0) THEN
            WRITE (stdout,20) 'STATION', NrecSTA(ng)
          END IF
#endif
        END IF
      END DO
!
!-----------------------------------------------------------------------
!  If applicable, report internal exit errors.
!-----------------------------------------------------------------------
!
      IF (Master.and.blowup.ne.0) THEN
        WRITE (stdout,50)
      END IF
      IF (exit_flag.eq.NoError) THEN
#ifndef NO_DATE_STAMP
        CALL get_date (date_str)
#endif
        IF (Master) WRITE (stdout,40) TRIM(date_str)
      ELSE IF (exit_flag.eq.1) THEN
        IF (Master) WRITE (stdout,50)
      ELSE IF (exit_flag.eq.2) THEN
        IF (Master) WRITE (stdout,60) nf_strerror(ioerror)
      ELSE IF (exit_flag.eq.3) THEN
        IF (Master) WRITE (stdout,70) nf_strerror(ioerror)
      ELSE IF (exit_flag.eq.4) THEN
        IF (Master) WRITE (stdout,80) nf_strerror(ioerror)
      ELSE IF (exit_flag.eq.5) THEN
        IF (Master) WRITE (stdout,90)
      ELSE IF (exit_flag.eq.6) THEN
        IF (Master) WRITE (stdout,100)
      ELSE IF (exit_flag.eq.7) THEN
        IF (Master) WRITE (stdout,110)
      END IF
!
 10   FORMAT (/,' ROMS/TOMS - Output NetCDF summary for Grid ',         &
     &        i2.2,':')
 20   FORMAT (13x,'number of time records written in ',                 &
     &        a,' file = ',i8.8)
 40   FORMAT (/,' ROMS/TOMS: DONE... ',a)
 50   FORMAT (/,' MAIN: Abnormal termination: BLOWUP.')
 60   FORMAT (/,' ERROR: Abnormal termination: NetCDF INPUT.',/,        &
     &          ' REASON: ',a)
 70   FORMAT (/,' ERROR: Abnormal termination: NetCDF OUTPUT.',/,       &
     &          ' REASON: ',a)
 80   FORMAT (/,' ERROR: OPENCDF - Can not open NetCDF file.',/,        &
     &          ' REASON: ',a)
 90   FORMAT (/,' ERROR: CHECKDEFS - Illegal model configuration.')
100   FORMAT (/,' ERROR: PARAM - Illegal domain partition.')
110   FORMAT (/,' ERROR: INP_PAR - Illegal input parameter.')

      RETURN
      END SUBROUTINE close_io
