#include "cppdefs.h"
#ifdef FOUR_DVAR
      SUBROUTINE def_mod (ng)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Adjoint Group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine create 4DVAR output NetCDF which contains model fields !
!  processed at observations points.                                   !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_fourdvar
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_scalars
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng
!
!  Local variable declarations.
!
      logical, dimension(NV) :: got_var(NV)

      integer, parameter :: Natt = 23

      integer :: datumDim, recordDim
      integer :: i, j, nvd, recdim, status, varid
      integer :: Vsize(4), vardim(2)

      integer :: def_var

      real(r8) :: Aval(5)

      character (len=80) :: Vinfo(Natt)
      character (len=80) :: ncname
!
!-----------------------------------------------------------------------
!  Set and report file name.
!-----------------------------------------------------------------------
!
      IF (exit_flag.ne.NoError) RETURN
      ncname=MODname(ng)
!
      IF (Master) THEN
        IF (LdefMOD(ng)) THEN
          WRITE (stdout,10) TRIM(ncname)
        ELSE
          WRITE (stdout,20) TRIM(ncname)
        END IF
      END IF
!
!  Initialize local information variable arrays.
!
        DO i=1,Natt
          DO j=1,80
            Vinfo(i)(j:j)=' '
          END DO
        END DO
        DO i=1,5
          Aval(i)=0.0_r8
        END DO
!
!=======================================================================
!  Create a new 4DVAR model data NetCDF file.
!=======================================================================
!
      ncname=MODname(ng)
      IF (LdefMOD(ng).and.OutThread) THEN
        status=nf_create(TRIM(ncname),nf_clobber,ncMODid(ng))
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(ncname)
          exit_flag=3
          ioerror=status
          RETURN
        END IF
      END IF
!
!-----------------------------------------------------------------------
!  Define dimensions.
!-----------------------------------------------------------------------
!
      IF (LdefMOD(ng).and.OutThread) THEN
        status=nf_def_dim(ncMODid(ng),'record',2         ,recordDim)
        status=nf_def_dim(ncMODid(ng),'datum' ,Ndatum(ng),datumDim)
!
!-----------------------------------------------------------------------
!  Define variables and their attributes.
!-----------------------------------------------------------------------

# ifdef REPRESENTERS
!
!  Outer and inner loop contours.
!
        Vinfo( 1)='outer'
        Vinfo( 2)='outer loop counter'
        status=def_var(ncMODid(ng),varid,nf_int,0,0,Aval,Vinfo,ncname)

        Vinfo( 1)='inner'
        Vinfo( 2)='inner loop counter'
        status=def_var(ncMODid(ng),varid,nf_int,0,0,Aval,Vinfo,ncname)
!
!  Define conjugate gradient norms
!
        Vinfo( 1)='cg_gamma'
        Vinfo( 2)='conjugate gradient gamma norm'
        status=def_var(ncMODid(ng),varid,NF_FRST,0,0,Aval,Vinfo,ncname)

        Vinfo( 1)='cg_sigma'
        Vinfo( 2)='conjugate gradient sigma norm'
        status=def_var(ncMODid(ng),varid,NF_FRST,0,0,Aval,Vinfo,ncname)

        Vinfo( 1)='cg_rnorm'
        Vinfo( 2)='conjugate gradient right-hand-side norm'
        status=def_var(ncMODid(ng),varid,NF_FRST,0,0,Aval,Vinfo,ncname)
# endif
!
!  Nonlinear model at observation points.
!
        haveNLmod(ng)=.FALSE.
        Vinfo( 1)=Vname(1,idNLmo)
        Vinfo( 2)=Vname(2,idNLmo)
# ifdef S4DVAR
        vardim(1)=datumDim
        vardim(2)=recordDim
        status=def_var(ncMODid(ng),modVid(idNLmo,ng),NF_FRST,           &
     &                 2,vardim,Aval,Vinfo,ncname)
# else
        status=def_var(ncMODid(ng),modVid(idNLmo,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)
# endif
# if defined IS4DVAR || defined REPRESENTERS
!
!  Tangent linear or representer model at observation points.
!
        haveTLmod(ng)=.FALSE.
        Vinfo( 1)=Vname(1,idTLmo)
        Vinfo( 2)=Vname(2,idTLmo)
#  ifdef IS4DVAR
        vardim(1)=datumDim
        vardim(2)=recordDim
        status=def_var(ncMODid(ng),modVid(idTLmo,ng),NF_FRST,           &
     &                 2,vardim,Aval,Vinfo,ncname)
#  else
        status=def_var(ncMODid(ng),modVid(idTLmo,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)
#  endif
# endif
# ifdef REPRESENTERS
!
!  Representer coeficients (or their approximation PSI) at observation
!  points.
!
        Vinfo( 1)=Vname(1,idRepC)
        Vinfo( 2)=Vname(2,idRepC)
        status=def_var(ncMODid(ng),modVid(idRepC,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)
!
!  Conjugate gradient vectors.
!
        Vinfo( 1)=Vname(1,idCG_P)
        Vinfo( 2)=Vname(2,idCG_P)
        status=def_var(ncMODid(ng),modVid(idCG_P,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)

        Vinfo( 1)=Vname(1,idCG_R)
        Vinfo( 2)=Vname(2,idCG_R)
        status=def_var(ncMODid(ng),modVid(idCG_R,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)

        Vinfo( 1)=Vname(1,idCG_S)
        Vinfo( 2)=Vname(2,idCG_S)
        status=def_var(ncMODid(ng),modVid(idCG_S,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)

        Vinfo( 1)=Vname(1,idCG_V)
        Vinfo( 2)=Vname(2,idCG_V)
        status=def_var(ncMODid(ng),modVid(idCG_V,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)
       
        Vinfo( 1)=Vname(1,idCG_X)
        Vinfo( 2)=Vname(2,idCG_X)
        status=def_var(ncMODid(ng),modVid(idCG_X,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)

        Vinfo( 1)=Vname(1,idCG_Z)
        Vinfo( 2)=Vname(2,idCG_Z)
        status=def_var(ncMODid(ng),modVid(idCG_Z,ng),NF_FRST,           &
     &                 1,datumDim,Aval,Vinfo,ncname)
# endif
!
!-----------------------------------------------------------------------
!  Leave definition mode.
!-----------------------------------------------------------------------
!
        status=nf_enddef(ncMODid(ng))
      END IF
!
!=======================================================================
!  Open an existing 4DVAR file and check its contents.
!=======================================================================
!
      IF (.not.LdefMOD(ng).and.Master) THEN
        CALL opencdf (ng, 1, MODname(ng), ncname, N(ng), 0, recdim, nvd, &
     &                Vsize)
        IF (exit_flag.ne.NoError) RETURN
!
!  Initialize logical switches.
!
        DO i=1,NV
          got_var(i)=.FALSE.
        END DO
!
!  Scan variable list from observation NetCDF and activate switches for
!  required variables.
!
        DO i=1,nvars
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idNLmo))) THEN
            got_var(idNLmo)=.TRUE.
            haveNLmod(ng)=.TRUE.
            modVid(idNLmo,ng)=i
          END IF
# if defined IS4DVAR || defined REPRESENTERS
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idTLmo))) THEN
            got_var(idTLmo)=.TRUE.
            haveTLmod(ng)=.TRUE.
            modVid(idTLmo,ng)=i
          END IF
# endif
# ifdef REPRESENTERS
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idRepC))) THEN
            got_var(idRepC)=.TRUE.
            haveADmod(ng)=.TRUE.
            modVid(idRepC,ng)=i
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idCG_P))) THEN
            got_var(idCG_P)=.TRUE.
            modVid(idCG_P,ng)=i
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idCG_R))) THEN
            got_var(idCG_R)=.TRUE.
            modVid(idCG_R,ng)=i
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idCG_S))) THEN
            got_var(idCG_S)=.TRUE.
            modVid(idCG_S,ng)=i
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idCG_V))) THEN
            got_var(idCG_V)=.TRUE.
            modVid(idCG_V,ng)=i
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idCG_X))) THEN
            got_var(idCG_X)=.TRUE.
            modVid(idCG_X,ng)=i
          END IF
          IF (TRIM(varnam(i)).eq.TRIM(Vname(1,idCG_Z))) THEN
            got_var(idCG_Z)=.TRUE.
            modVid(idCG_Z,ng)=i
          END IF
# endif
        END DO
!
!  Check if needed variables are available.
!
        IF (.not.got_var(idNLmo)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idNLmo)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
# if defined IS4DVAR || defined REPRESENTERS
        IF (.not.got_var(idTLmo)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idTLmo)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
# endif
# ifdef REPRESENTERS
        IF (.not.got_var(idRepC)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idRepC)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
        IF (.not.got_var(idCG_P)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idCG_P)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
        IF (.not.got_var(idCG_R)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idCG_R)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
        IF (.not.got_var(idCG_S)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idCG_S)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
        IF (.not.got_var(idCG_V)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idCG_V)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
        IF (.not.got_var(idCG_X)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idCG_X)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
        IF (.not.got_var(idCG_Z)) THEN
          WRITE (stdout,30) TRIM(Vname(1,idCG_Z)), TRIM(MODname(ng))
          exit_flag=2
          RETURN
        END IF
# endif
      END IF

  10  FORMAT (/,6x,'DEF_MOD   - creating 4DVAR model data file: ', a)
  20  FORMAT (/,6x,'DEF_MOD   - inquiring 4DVAR model data file: ', a)
  30  FORMAT (/,' DEF_MOD - unable to find 4DVAR variable: ',a,         &
     &        /,11x,'in input NetCDF file: ',a)

      RETURN
      END SUBROUTINE def_mod
#else
      SUBROUTINE def_mod
      RETURN
      END SUBROUTINE def_mod
#endif
