#include "cppdefs.h"
#ifdef FILTERED_RST
      SUBROUTINE get_filter (ng, filterLevel)
!
!=======================================================================
!  Copyright (c) 2002  ROMS/TOMS Group                                 !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This subroutine reads in primitive variables initial conditions     !
!  from an initial, restart, or history NetCDF file.                   !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_filter
      USE mod_grid
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_ocean
      USE mod_scalars

# if (defined EW_PERIODIC || defined NS_PERIODIC) && !defined DISTRIBUTE
!
      USE exchange_2d_mod
#  ifdef SOLVE3D
      USE exchange_3d_mod
#  endif
# endif
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, filterLevel
!
!  Local variable declarations.
!
      logical, dimension(NV) :: got_var

      integer :: LBi, UBi, LBj, UBj
      integer :: gtype, i, ifield, itrc, ifile, ifil
      integer :: nvatts, nrec, status, tindx, varid, vartype
      integer :: Vsize(4)

      integer :: nf_fread2d, nf_fread3d

      real(r8), parameter :: Fscl = 1.0_r8

      real(r8) :: Fmax, Fmin, Tmax, time_scale, tmptime(Ngrids)

      character (len=15) attnam, tvarnam
      character (len=40) tunits
      character (len=80) fname, ncname
!
!-----------------------------------------------------------------------
!  Don't inquire about the contents of input NetCDF file,
!  the dimensions and variables, since multiple files
!-----------------------------------------------------------------------
!
      tindx = filterLevel
      ncname=FILname(1,ng)
      LBi=LBOUND(GRID(ng)%h,DIM=1)
      UBi=UBOUND(GRID(ng)%h,DIM=1)
      LBj=LBOUND(GRID(ng)%h,DIM=2)
      UBj=UBOUND(GRID(ng)%h,DIM=2)
!
!  Set Vsize to zero to deativate interpolation of input data to model
!  grid in "nf_fread2d" and "nf_fread3d".
!
      DO i=1,4
        Vsize(i)=0
      END DO
!
!-----------------------------------------------------------------------
!  Read initial conditions from input NetCDF file.
!-----------------------------------------------------------------------
!
!
!  Open input NetCDF file.
!
      DO ifile = 1,nfile
        ncname=FILname(ifile,ng)
        status=nf_open(TRIM(ncname), nf_nowrite, ncFILid(ifile,ng))
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,20) TRIM(ncname)
          exit_flag=2
          RETURN
        END IF
      END DO
      IF (InpThread) THEN
        WRITE (stdout,90) 'Read filter restart values,', tindx
      END IF
!
!  Get the status of filter sums.
!
      status=nf_inq_varid(ncFILid(1,ng), 'fcount', varid)
      status=nf_get_vara_int(ncFILid(1,ng), varid, tindx, 1,            &
     &                       fcount(tindx))
!      print *, 'GET_FILTER fcount = ', fcount
!
!  Read in free-surface (m).
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idFsur)), varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
# ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
# endif
     &                FILTER(ng) % filzeta(LBi,LBj,tindx))
      IF (InpThread) THEN
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(Vname(1,idFsur)), tindx, TRIM(ncname)
          exit_flag=2
          RETURN
        ELSE
          WRITE (stdout,100) TRIM(Vname(2,idFsur)), Fmin, Fmax
        END IF
      END IF
!
!  Read in 2D momentum component (m/s) in the XI-direction.
!
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idUbar)), varid)
      gtype=vflag(varid)*u2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
# ifdef MASKING
     &                GRID(ng) % umask(LBi,LBj),                        &
# endif
     &                FILTER(ng) % filu2d(LBi,LBj,tindx))
      IF (InpThread) THEN
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(Vname(1,idUbar)), tindx, TRIM(ncname)
          exit_flag=2
          RETURN
        ELSE
          WRITE (stdout,100) TRIM(Vname(2,idUbar)), Fmin, Fmax
        END IF
      END IF
!
!  Read in 2D momentum component (m/s) in the ETA-direction.
!
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idVbar)), varid)
      gtype=vflag(varid)*v2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
# ifdef MASKING
     &                GRID(ng) % vmask(LBi,LBj),                        &
# endif
     &                FILTER(ng) % filv2d(LBi,LBj,tindx))
      IF (InpThread) THEN
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(Vname(1,idVbar)), tindx, TRIM(ncname)
          exit_flag=2
          RETURN
        ELSE
          WRITE (stdout,100) TRIM(Vname(2,idVbar)), Fmin, Fmax
        END IF
      END IF
# ifdef SOLVE3D
!
!  Read in 3D momentum component (m/s) in the XI-direction.
!
      ncname=FILname(2,ng)
      status=nf_inq_varid(ncFILid(2,ng), TRIM(Vname(1,idUvel)), varid)
      gtype=vflag(varid)*u3dvar
      status=nf_fread3d(ng, iNLM, ncFILid(2,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj, 1, N(ng),              &
     &                Fscl, Fmin, Fmax,                                 &
#  ifdef MASKING
     &                GRID(ng) % umask(LBi,LBj),                        &
#  endif
     &                FILTER(ng) % filu3d(LBi,LBj,1,tindx))
      IF (InpThread) THEN
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(Vname(1,idUvel)), tindx, TRIM(ncname)
          exit_flag=2
          RETURN
        ELSE
          WRITE (stdout,100) TRIM(Vname(2,idUvel)), Fmin, Fmax
        END IF
      END IF
!
!  Read in 3D momentum component (m/s) in the ETA-direction.
!
      ncname=FILname(3,ng)
      status=nf_inq_varid(ncFILid(3,ng), TRIM(Vname(1,idVvel)), varid)
      gtype=vflag(varid)*v3dvar
      status=nf_fread3d(ng, iNLM, ncFILid(3,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj, 1, N(ng),              &
     &                Fscl, Fmin, Fmax,                                 &
#  ifdef MASKING
     &                GRID(ng) % vmask(LBi,LBj),                        &
#  endif
     &                FILTER(ng) % filv3d(LBi,LBj,1,tindx))
      IF (InpThread) THEN
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(Vname(1,idVvel)), tindx, TRIM(ncname)
          exit_flag=2
          RETURN
        ELSE
          WRITE (stdout,100) TRIM(Vname(2,idVvel)), Fmin, Fmax
        END IF
      END IF
#  ifndef FILTRIM
!
!  Read in density anomaly.
!
      ncname=FILname(7,ng)
      status=nf_inq_varid(ncFILid(7,ng), TRIM(Vname(1,idDano)), varid)
      gtype=vflag(varid)*r3dvar
      status=nf_fread3d(ng, iNLM, ncFILid(7,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj, 1, N(ng),              &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filrho(LBi,LBj,1,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idDano)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
!
!  Read in tracer type variables.
!
      ncname=FILname(8,ng)
#   if defined ANA_BIOLOGY || defined ANA_SEDIMENT
      DO itrc=1,NAT
#   else
      DO itrc=1,NT(ng)
#   endif
        status=nf_inq_varid(ncFILid(8,ng), TRIM(Vname(1,idTvar(itrc))), &
     &                      varid)
        gtype=vflag(varid)*r3dvar
        status=nf_fread3d(ng, iNLM, ncFILid(8,ng), varid, tindx, gtype, &
     &                  Vsize, LBi, UBi, LBj, UBj, 1, N(ng),            &
     &                  Fscl, Fmin, Fmax,                               &
#   ifdef MASKING
     &                  GRID(ng) % rmask(LBi,LBj),                      &
#   endif
     &                  FILTER(ng) % filt(LBi,LBj,1,itrc,tindx))
        IF (InpThread) THEN
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,30) TRIM(Vname(1,idTvar(itrc))), tindx,       &
     &                        TRIM(ncname)
            exit_flag=2
            RETURN
          ELSE
            WRITE (stdout,100) TRIM(Vname(2,idTvar(itrc))), Fmin, Fmax
          END IF
        END IF
      END DO
!
!  Read in vertical (omega) velocity.
!
      ncname=FILname(9,ng)
      status=nf_inq_varid(ncFILid(9,ng), TRIM(Vname(1,idOvel)), varid)
      gtype=vflag(varid)*w3dvar
      status=nf_fread3d(ng, iNLM, ncFILid(9,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj, 0, N(ng),              &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filw3d(LBi,LBj,0,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idOvel)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#  endif
#  ifdef LMD_SKPP
!
!  Read in depth of surface boundary layer.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idHsbl)), varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filhsbl(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idHsbl)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#  endif
#  ifdef LMD_BKPP
!
!  Read in depth of bottom boundary layer.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idHbbl)), varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filhbbl(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idHbbl)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_AKV
!
!  Read in vertical viscosity coefficient.
!
      ncname=FILname(6,ng)
      status=nf_inq_varid(ncFILid(6,ng), TRIM(Vname(1,idVvis)), varid)
      gtype=vflag(varid)*w3dvar
      status=nf_fread3d(ng, iNLM, ncFILid(6,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj, 0, N(ng),              &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filAKv(LBi,LBj,0,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idVvis)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_AKT
!
!  Read in vertical diffusion coefficient for potential temperature.
!
      ncname=FILname(4,ng)
      status=nf_inq_varid(ncFILid(4,ng), TRIM(Vname(1,idTdif)), varid)
      gtype=vflag(varid)*w3dvar
      status=nf_fread3d(ng, iNLM, ncFILid(4,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj, 0, N(ng),              &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filAKt(LBi,LBj,0,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idTdif)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_AKS
!
!  Read in vertical diffusion coefficient for salinity.
!
      ncname=FILname(5,ng)
      status=nf_inq_varid(ncFILid(5,ng), TRIM(Vname(1,idSdif)), varid)
      gtype=vflag(varid)*w3dvar
      status=nf_fread3d(ng, iNLM, ncFILid(5,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj, 0, N(ng),              &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filAKs(LBi,LBj,0,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idSdif)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_FLUXES
!
!  Read in surface net heat flux.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idTsur(itemp))),  &
     &                    varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filstf(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idTsur(itemp))), tindx,          &
     &                         TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#   ifdef BULK_FLUXES
!
!  Read in latent heat flux.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idLhea)), varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % fillhf(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idLhea)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
!
!  Read in sensible heat flux.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idShea)), varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filshf(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idShea)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
!
!  Read in longwave radiation flux.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idLrad)), varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % fillrf(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idLrad)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#   endif
#   ifdef SHORTWAVE
!
!  Read in shortwave radiation flux.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idSrad)), varid)
      gtype=vflag(varid)*r2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % rmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filsrf(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idSrad)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
!
!  Read in surface u-momentum stress.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idUsms)), varid)
      gtype=vflag(varid)*u2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % umask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filsus(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idUsms)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
!
!  Read in surface v-momentum stress.
!
      ncname=FILname(1,ng)
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idVsms)), varid)
      gtype=vflag(varid)*v2dvar
      status=nf_fread2d(ng, iNLM, ncFILid(1,ng), varid, tindx, gtype,   &
     &                Vsize, LBi, UBi, LBj, UBj,                        &
     &                Fscl, Fmin, Fmax,                                 &
#   ifdef MASKING
     &                GRID(ng) % vmask(LBi,LBj),                        &
#   endif
     &                FILTER(ng) % filsvs(LBi,LBj,tindx))
      IF (InpThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,30) TRIM(Vname(1,idVsms)), tindx, TRIM(ncname)
        exit_flag=2
        RETURN
      END IF
# endif

# ifdef FOO
! Don't think I need this because these are just running sums, and aren't
! used dynamically
# if (defined EW_PERIODIC || defined NS_PERIODIC) && !defined DISTRIBUTE
!
!-----------------------------------------------------------------------
!  Set periodic boundary conditions.
!-----------------------------------------------------------------------
!
      CALL exchange_r2d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filzeta(:,:,tindx))
      CALL exchange_u2d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filu2d(:,:,tindx))
      CALL exchange_v2d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filv2d(:,:,tindx))
#  ifdef SOLVE3D
      CALL exchange_u3d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filu3d(:,:,:,tindx))
      CALL exchange_v3d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filv3d(:,:,:,tindx))

#   ifndef FILTRIM
#    if defined ANA_BIOL0GY || defined ANA_SEDIMENT
      DO itrc=1,NAT
#    else
      DO itrc=1,NT(ng)
#    endif
        CALL exchange_r3d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),         &
     &                          LBi, UBi, LBj, UBj, 1, N(ng),           &
     &                          NghostPoints,                           &
     &                          FILTER(ng) % filt(:,:,:,itrc,tindx))
      END DO

      CALL exchange_w3d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj, 0, N(ng),             &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filw3d(:,:,:,tindx))
#   endif
#   ifdef LMD_SKPP
      CALL exchange_r2d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filhsbl(:,:,tindx))
#   endif
#   ifdef LMD_BKPP
      CALL exchange_r2d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filhbbl(:,:,tindx))
#   endif
#   ifdef AVERAGES_AKV
      CALL exchange_w3d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj, 0, N(ng),             &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filAKv(:,:,:,tindx))
#   endif
#   ifdef AVERAGES_AKT
      CALL exchange_w3d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj, 0, N(ng),             &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filAKt(:,:,:,tindx))
#   endif
#   ifdef AVERAGES_AKS
      CALL exchange_w3d_tile (ng, iNLM, 1, Lm(ng), 1, Mm(ng),           &
     &                        LBi, UBi, LBj, UBj, 0, N(ng),             &
     &                        NghostPoints,                             &
     &                        FILTER(ng) % filAKs(:,:,:,tindx))
#   endif
#   ifdef AVERAGES_FLUXES
#    ifdef BULK_FLUXES
#    endif
#    ifdef SHORTWAVE
#    endif
#   endif
#  endif
#  ifdef AVERAGES_FLUXES
#  endif
# endif
# endif

!
!  Close input NetCDF file.
!
      DO ifile=1,nfile
        status=nf_close(ncFILid(ifile,ng))
      END DO
      IF (Master) WRITE (stdout,80) tindx
!
  10  FORMAT (/,' GET_FILTER - unable to find model variable: ',a,      &
     &        /,15x,'in filter NetCDF file: ',a)
  20  FORMAT (/,' GET_FILTER - unable to open filter NetCDF file: ',a)
  30  FORMAT (/,' GET_FILTER - error while reading variable: ',a,2x,    &
     &        'at time record = ',i3,/,15x,'in filter NetCDF file: ',a)
  40  FORMAT (/,' GET_FILTER - requested filter time record = ',i3,/,   &
     &        15x,'not found in input NetCDF: ',a,/,                    &
     &        15x,'number of available records = ',i3)
  50  FORMAT (/,' GET_FILTER - error while reading attribute: ',a)
  60  FORMAT (/,' GET_FILTER - error while inquiring attributes for',   &
     &          ' variable: ',a)
  70  FORMAT (/,' GET_FILTER - cannot inquire about time variable in',  &
     &          ' filter NetCDF file: ',a)
  80  FORMAT (' GET_FILTER - Processed filter fields,',                 &
     &        t48,'filterLevel = ',i3)
  90  FORMAT (6x,'GET_FILTER - ',a,t64,'t = ',i12)
 100  FORMAT (16x,'- ',a,/,19x,'(Min = ',1p,e15.8,                      &
     &        ' Max = ',1p,e15.8,')')
      RETURN
      END SUBROUTINE get_filter
#else
      SUBROUTINE get_filter
      RETURN
      END SUBROUTINE get_filter
#endif
