#include "cppdefs.h"
      SUBROUTINE get_varcoords (ng, model, ncid, ncvarid,               &
     &                          Nx, Ny, Xmin, Xmax, X, Ymin, Ymax, Y,   &
     &                          rectangular)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine reads the spatial positions of any NetCDF variable     !
!  having the attribute  "coordinates",  as specified by CF rules.     !
!  For example, in CDL syntax:                                         !
!                                                                      !
!       float my_var(time, lat, lon) ;                                 !
!               my_var:long_name = "my variable long name" ;           !
!               my_var:units = "my variable units" ;                   !
!               my_var:coordinates = "lon lat" ;                       !
!               my_var:time = "my_var_time" ;                          !
!                                                                      !
!  Notice that the associated coordinate names "lon" and "lat" are     !
!  separated by a single blank space.  Both "lon" and "lat" can be     !
!  1D or 2D arrays. If 1D array, the positions are rectangular and     !
!  and full 2D arrays are filled with the same values.                 !
!                                                                      !
!  It also determines the rectangular switch  which indicates that     !
!  the spatial positions have a plaid distribution.                    !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_grid
      USE mod_iounits
      USE mod_netcdf
      USE mod_scalars
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model, ncid, ncvarid
      integer, intent(in) :: Nx, Ny

      logical, intent(out) :: rectangular

      real(r8), intent(out) :: Xmin, Xmax, Ymin, Ymax

      real(r8), intent(out) :: X(Nx,Ny)
      real(r8), intent(out) :: Y(Nx,Ny)
!
!  Local variable declarations
!
      integer :: i, ic, j, jc
      integer :: alen, atype, blank, ndims, status, varid

      integer, dimension(2) :: start, total

      real(r8), dimension(Ny) :: wrk

      character (len=20) :: name, Xname, Yname
      character (len=40) :: text
!
!-----------------------------------------------------------------------
!  Get coarse variable coordinates.
!-----------------------------------------------------------------------
!
!  Get names of variable coordinates.
!
      IF (InpThread) THEN
        status=nf_inq_att(ncid, ncvarid, 'coordinates', atype, alen)
        IF (status.eq.nf_noerr) THEN
          status=nf_get_att_text(ncid, ncvarid, 'coordinates',          &
     &                           text(1:alen))
          IF (status.eq.nf_noerr) THEN
            blank=INDEX(text(1:alen),' ')
            Xname=text(1:blank-1)
            Yname=text(blank+1:alen)
          ELSE
            status=nf_inq_varname (ncid, ncvarid, name)
            WRITE (stdout,10) 'coordinates', TRIM(name)
            exit_flag=4
            ioerror=status
            RETURN
          END IF       
        ELSE
          WRITE (stdout,20) 'coordinates', TRIM(name)
          exit_flag=4
          ioerror=status
          RETURN
        END IF
        rectangular=.FALSE.
!
!  Read in X-coordinates.
!
        status=nf_inq_varid(ncid, TRIM(Xname), varid)
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(Xname)
          exit_flag=4
          ioerror=status
        END IF
        status=nf_inq_varndims(ncid, varid, ndims)
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,40) TRIM(Xname)
          exit_flag=4
          ioerror=status
        END IF
        IF (ndims.eq.1) THEN
          start(1)=1
          total(1)=Nx
        ELSE
          start(1)=1
          total(1)=Nx
          start(2)=1
          total(2)=Ny
        END IF        
        status=nf_get_vara_TYPE(ncid, varid, start, total, X(1,1))
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,50) TRIM(Xname)
          exit_flag=4
          ioerror=status
        END IF
        IF (ndims.eq.1) THEN
          rectangular=.TRUE.
          jc=0
          DO j=1,Ny
            DO i=1,Nx
              X(i,j)=X(i,1)
            END DO
          END DO
        ELSE
          jc=1
          DO j=2,Ny
            IF (X(1,j).eq.X(1,1)) THEN
              jc=jc+1
            END IF
          END DO
        END IF
!
!  Read in Y-coordinates.
!
        status=nf_inq_varid(ncid, TRIM(Yname), varid)
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,30) TRIM(Yname)
          exit_flag=4
          ioerror=status
        END IF
        status=nf_inq_varndims(ncid, varid, ndims)
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,40) TRIM(Yname)
          exit_flag=4
          ioerror=status
        END IF
        IF (ndims.eq.1) THEN
          start(1)=1
          total(1)=Ny
          status=nf_get_vara_TYPE(ncid, varid, start, total, wrk)
        ELSE
          start(1)=1
          total(1)=Nx
          start(2)=1
          total(2)=Ny
          status=nf_get_vara_TYPE(ncid, varid, start, total, Y)
        END IF        
        IF (status.ne.nf_noerr) THEN
          WRITE (stdout,50) TRIM(Yname)
          exit_flag=4
          ioerror=status
        END IF
        IF (ndims.eq.1) THEN
          rectangular=.TRUE.
          ic=0
          DO j=1,Ny
            DO i=1,Nx
              Y(i,j)=wrk(j)
            END DO
          END DO
        ELSE
          ic=1
          DO i=2,Nx
            IF (Y(i,j).eq.Y(1,1)) THEN
              ic=ic+1
            END IF
          END DO
        END IF
!
!  Determine "rectangular" switch.
!
        IF (((ic.ne.0).and.(ic.eq.Nx)).and.                             &
     &      ((jc.ne.0).and.(jc.eq.Ny))) THEN
          rectangular=.TRUE.
        END IF
!
!  Determine minimum and maximum positions.
!
        Xmin=1.0E+35_r8
        Xmax=-1.0E+35_r8
        Ymin=1.0E+35_r8
        Ymax=-1.0E+35_r8
        DO j=1,Ny
          DO i=1,Nx
            Xmin=MIN(Xmin,X(i,j))
            Xmax=MAX(Xmax,X(i,j))
            Ymin=MIN(Ymin,Y(i,j))
            Ymax=MAX(Ymax,Y(i,j))
          END DO
        END DO
      END IF

 10   FORMAT (/,' GET_VARCOORDS - error while reading attribute: ', a,  &
     &          ' for variable: ', a)
 20   FORMAT (/,' GET_VARCOORDS - error while inquiring attribute: ',   &
     &        a,' for variable: ', a)
 30   FORMAT (/,' GET_VARCOORDS - cannot inquire ID for variable: ', a)
 40   FORMAT (/,' GET_VARCOORDS - error while inquiring dimensions',    &
     &          ' for variable: ', a)
 50   FORMAT (/,' GET_VARCOORDS - error while reading variable: ', a)

      RETURN
      END SUBROUTINE get_varcoords
