#include "cppdefs.h"
#ifdef FOUR_DVAR
      SUBROUTINE obs_write (ng, model)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS adjoint group                          !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine interpolates nonlinear (background) and/or tangent     !
!  linear model (increments)  state at observations location  when     !
!  appropriate.                                                        !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_fourdvar
      USE mod_grid
      USE mod_iounits
      USE mod_ncparam
      USE mod_netcdf
      USE mod_ocean
      USE mod_scalars
      USE mod_stepping
!  
      USE extract_obs_mod, ONLY : extract_obs2d
# ifdef SOLVE3D
      USE extract_obs_mod, ONLY : extract_obs3d
# endif
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, model
!
!  Local variable declarations.
!
      logical :: load_Zobs = .FALSE.

      integer, dimension(2) ::  start, total

      integer :: IstrR, IendR, JstrR, JendR, IstrU, JstrV
      integer :: LBi, UBi, LBj, UBj
      integer :: Istr, Iend, Jstr, Jend
# ifdef DISTRIBUTE
      integer :: Itile, Jtile
# endif
      integer :: Mstr, Mend, Irec, iobs, itrc, iweight, status

      real(r8), parameter :: IniVal = 0.0_r8

      character (len=50) :: string
!
      LBi=LBOUND(GRID(ng)%h,DIM=1)
      UBi=UBOUND(GRID(ng)%h,DIM=1)
      LBj=LBOUND(GRID(ng)%h,DIM=2)
      UBj=UBOUND(GRID(ng)%h,DIM=2)
!
!-----------------------------------------------------------------------
!  Interpolate model state at observation locations.
!-----------------------------------------------------------------------
!
      IF (ProcessObs(ng)) THEN
!
!  Get physical non-overlapping horizontal tile bounds.
!
# ifdef DISTRIBUTE
        CALL get_tile (ng, TILE, Itile, Jtile, Istr, Iend, Jstr, Jend)
# else
        Istr=1
        Iend=Lm(ng)
        Jstr=1
        Jend=Mm(ng)
# endif
# include "set_bounds.h"
# ifndef REPRESENTERS
!
!  Some entries are not computed in the extraction routine.  Set values
!  to zero to avoid problems when writing non initialized values.
!
        IF (wrtNLmod(ng)) THEN
          DO iobs=1,Mobs
#  ifdef S4DVAR
            NLmodVal(iobs,Irec)=IniVal
#  else
            NLmodVal(iobs)=IniVal
#  endif
          END DO
        END IF
#  ifdef TLM_OBS
        IF (wrtTLmod(ng).or.wrtRPmod(ng)) THEN
          DO iobs=1,Mobs
#   ifdef IS4DVAR
            TLmodVal(iobs,Ipass)=IniVal
#   else
            TLmodVal(iobs)=IniVal
#   endif
          END DO
        END IF
#  endif
# endif
!
!  Set starting index of obervation vectors for reading.  In weak
!  constraint, the entire observation data is loaded. Otherwise,
!  only the observartion for the current time window are loaded
!  and started from vector index one.
!
#  ifdef REPRESENTERS
      Mstr=NstrObs(ng)
      Mend=NendObs(ng)
#  else
      Mstr=1
      Mend=Nobs(ng)
#  endif
!
!  Free-surface observations.
!
        IF (wrtNLmod(ng).and.                                           &
     &      (FOURDVAR(ng)%ObsCount(isFsur).gt.0)) THEN
          CALL extract_obs2d (ng, IstrR, IendR, JstrR, JendR,           &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        rILB(ng), rIUB(ng),                       &
     &                        rJLB(ng), rJUB(ng),                       &
     &                        isFsur,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs,                &
     &                        OCEAN(ng)%zeta(:,:,KOUT),                 &
# ifdef MASKING
     &                        GRID(ng)%rmask,                           &
# endif
# ifdef S4DVAR
     &                        NLmodVal(:,Ipass))
# else
     &                        NLmodVal)
# endif
        END IF
# ifdef TLM_OBS
        IF ((wrtTLmod(ng).or.(wrtRPmod(ng))).and.                       &
     &      (FOURDVAR(ng)%ObsCount(isFsur).gt.0)) THEN
          CALL extract_obs2d (ng, IstrR, IendR, JstrR, JendR,           &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        rILB(ng), rIUB(ng),                       &
     &                        rJLB(ng), rJUB(ng),                       &
     &                        isFsur,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs,                &
     &                        OCEAN(ng)%tl_zeta(:,:,KOUT),              &
#  ifdef MASKING
     &                        GRID(ng)%rmask,                           &
#  endif
#  ifdef IS4DVAR
     &                        TLmodVal(:,Ipass))
#  else
     &                        TLmodVal)
#  endif
        END IF
# endif
!
!  Vertically integrated u-velocity observations.
!
        IF (wrtNLmod(ng).and.                                           &
     &      (FOURDVAR(ng)%ObsCount(isUbar).gt.0)) THEN
          CALL extract_obs2d (ng, Istr, IendR, JstrR, JendR,            &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        uILB(ng), uIUB(ng),                       &
     &                        uJLB(ng), uJUB(ng),                       &
     &                        isUbar,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs,                &
     &                        OCEAN(ng)%ubar(:,:,KOUT),                 &
# ifdef MASKING
     &                        GRID(ng)%umask,                           &
# endif
# ifdef S4DVAR
     &                        NLmodVal(:,Ipass))
# else
     &                        NLmodVal)
# endif
        END IF
# ifdef TLM_OBS
        IF ((wrtTLmod(ng).or.(wrtRPmod(ng))).and.                       &
     &      (FOURDVAR(ng)%ObsCount(isUbar).gt.0)) THEN
          CALL extract_obs2d (ng, Istr, IendR, JstrR, JendR,            &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        uILB(ng), uIUB(ng),                       &
     &                        uJLB(ng), uJUB(ng),                       &
     &                        isUbar,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs,                &
     &                        OCEAN(ng)%tl_ubar(:,:,KOUT),              &
#  ifdef MASKING
     &                        GRID(ng)%umask,                           &
#  endif
#  ifdef IS4DVAR
     &                        TLmodVal(:,Ipass))
#  else
     &                        TLmodVal)
#  endif
        END IF
# endif
!
!  Vertically integrated v-velocity observations.
!
        IF (wrtNLmod(ng).and.                                           &
     &      (FOURDVAR(ng)%ObsCount(isVbar).gt.0)) THEN
          CALL extract_obs2d (ng, IstrR, IendR, Jstr, JendR,            &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        vILB(ng), vIUB(ng),                       &
     &                        vJLB(ng), vJUB(ng),                       &
     &                        isVbar,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs,                &
     &                        OCEAN(ng)%vbar(:,:,KOUT),                 &
# ifdef MASKING
     &                        GRID(ng)%vmask,                           &
# endif
# ifdef S4DVAR
     &                        NLmodVal(:,Ipass))
# else
     &                        NLmodVal)
# endif
        END IF
# ifdef TLM_OBS
        IF ((wrtTLmod(ng).or.(wrtRPmod(ng))).and.                       &
     &      (FOURDVAR(ng)%ObsCount(isVbar).gt.0)) THEN
          CALL extract_obs2d (ng, IstrR, IendR, Jstr, JendR,            &
     &                        LBi, UBi, LBj, UBj,                       &
     &                        vILB(ng), vIUB(ng),                       &
     &                        vJLB(ng), vJUB(ng),                       &
     &                        isVbar,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs,                &
     &                        OCEAN(ng)%tl_vbar(:,:,KOUT),              &
#  ifdef MASKING
     &                        GRID(ng)%vmask,                           &
#  endif
#  ifdef IS4DVAR
     &                        TLmodVal(:,Ipass))
#  else
     &                        TLmodVal)
#  endif
        END IF
# endif

# ifdef SOLVE3D
!
!  3D u-velocity observations.
!
        IF (wrtNLmod(ng).and.                                           &
     &      (FOURDVAR(ng)%ObsCount(isUvel).gt.0)) THEN
          load_Zobs=.TRUE.
          CALL extract_obs3d (ng, Istr, IendR, JstrR, JendR,            &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        uILB(ng), uIUB(ng),                       &
     &                        uJLB(ng), uJUB(ng),                       &
     &                        isUvel,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs, Zobs,          &
     &                        OCEAN(ng)%u(:,:,:,NOUT),                  &
     &                        GRID(ng)%z_r,                             &
#  ifdef MASKING
     &                        GRID(ng)%umask,                           &
#  endif
#  ifdef S4DVAR
     &                        NLmodVal(:,Ipass))
#  else
     &                        NLmodVal)
#  endif
        END IF
#  ifdef TLM_OBS
        IF ((wrtTLmod(ng).or.(wrtRPmod(ng))).and.                       &
     &      (FOURDVAR(ng)%ObsCount(isUvel).gt.0)) THEN
          load_Zobs=.TRUE.
          CALL extract_obs3d (ng, Istr, IendR, JstrR, JendR,            &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        uILB(ng), uIUB(ng),                       &
     &                        uJLB(ng), uJUB(ng),                       &
     &                        isUvel,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs, Zobs,          &
     &                        OCEAN(ng)%tl_u(:,:,:,NOUT),               &
     &                        GRID(ng)%z_r,                             &
#   ifdef MASKING
     &                        GRID(ng)%umask,                           &
#   endif
#   ifdef IS4DVAR
     &                        TLmodVal(:,Ipass))
#   else
     &                        TLmodVal)
#   endif
        END IF
#  endif
!
!  3D v-velocity observations.
!
        IF (wrtNLmod(ng).and.                                           &
     &      (FOURDVAR(ng)%ObsCount(isVvel).gt.0)) THEN
          load_Zobs=.TRUE.
          CALL extract_obs3d (ng, IstrR, IendR, Jstr, JendR,            &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        vILB(ng), vIUB(ng),                       &
     &                        vJLB(ng), vJUB(ng),                       &
     &                        isVvel,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs, Zobs,          &
     &                        OCEAN(ng)%v(:,:,:,NOUT),                  &
     &                        GRID(ng)%z_r,                             &
#  ifdef MASKING
     &                        GRID(ng)%vmask,                           &
#  endif
#  ifdef S4DVAR
     &                        NLmodVal(:,Ipass))
#  else
     &                        NLmodVal)
#  endif
        END IF
#  ifdef TLM_OBS
        IF ((wrtTLmod(ng).or.(wrtRPmod(ng))).and.                       &
     &      (FOURDVAR(ng)%ObsCount(isVvel).gt.0)) THEN
          load_Zobs=.TRUE.
          CALL extract_obs3d (ng, IstrR, IendR, Jstr, JendR,            &
     &                        LBi, UBi, LBj, UBj, 1, N(ng),             &
     &                        vILB(ng), vIUB(ng),                       &
     &                        vJLB(ng), vJUB(ng),                       &
     &                        isVvel,                                   &
     &                        Mobs, Mstr, Mend,                         &
     &                        time(ng), dt(ng),                         &
     &                        ObsType, Tobs, Xobs, Yobs, Zobs,          &
     &                        OCEAN(ng)%tl_v(:,:,:,NOUT),               &
     &                        GRID(ng)%z_r,                             &
#   ifdef MASKING
     &                        GRID(ng)%vmask,                           &
#   endif
#   ifdef IS4DVAR
     &                        TLmodVal(:,Ipass))
#   else
     &                        TLmodVal)
#   endif
        END IF
#  endif
!
!  Tracer type observations.
!
        DO itrc=1,NT(ng)
          IF (wrtNLmod(ng).and.                                         &
     &        (FOURDVAR(ng)%ObsCount(isTvar(itrc)).gt.0)) THEN
            load_Zobs=.TRUE.
            CALL extract_obs3d (ng, IstrR, IendR, JstrR, JendR,         &
     &                          LBi, UBi, LBj, UBj, 1, N(ng),           &
     &                          rILB(ng), rIUB(ng),                     &
     &                          rJLB(ng), rJUB(ng),                     &
     &                          isTvar(itrc),                           &
     &                          Mobs, Mstr, Mend,                       &
     &                          time(ng), dt(ng),                       &
     &                          ObsType, Tobs, Xobs, Yobs, Zobs,        &
     &                          OCEAN(ng)%t(:,:,:,NOUT,itrc),           &
     &                          GRID(ng)%z_r,                           &
#  ifdef MASKING
     &                          GRID(ng)%rmask,                         &
#  endif
#  ifdef S4DVAR
     &                          NLmodVal(:,Ipass))
#  else
     &                          NLmodVal)
#  endif
          END IF
#  ifdef TLM_OBS
          IF ((wrtTLmod(ng).or.(wrtRPmod(ng))).and.                     &
     &        (FOURDVAR(ng)%ObsCount(isTvar(itrc)).gt.0)) THEN
            load_Zobs=.TRUE.
            CALL extract_obs3d (ng, IstrR, IendR, JstrR, JendR,         &
     &                          LBi, UBi, LBj, UBj, 1, N(ng),           &
     &                          rILB(ng), rIUB(ng),                     &
     &                          rJLB(ng), rJUB(ng),                     &
     &                          isTvar(itrc),                           &
     &                          Mobs, Mstr, Mend,                       &
     &                          time(ng), dt(ng),                       &
     &                          ObsType, Tobs, Xobs, Yobs, Zobs,        &
     &                          OCEAN(ng)%tl_t(:,:,:,NOUT,itrc),        &
     &                          GRID(ng)%z_r,                           &
#   ifdef MASKING
     &                          GRID(ng)%rmask,                         &
#   endif
#   ifdef IS4DVAR
     &                          TLmodVal(:,Ipass))
#   else
     &                          TLmodVal)
#   endif
          END IF
#  endif
        END DO
# endif

# ifdef DISTRIBUTE
!
!-----------------------------------------------------------------------
!  Collect all extracted data.
!-----------------------------------------------------------------------
!
        IF (wrtNLmod(ng)) THEN 
          CALL mp_collect (ng, model, Mobs, IniVal,                     &
#  ifdef S4DVAR
     &                     NLmodVal(1,Irec))
#  else
     &                     NLmodVal)
#  endif
        END IF
#  ifdef TLM_OBS
        IF (wrtTLmod(ng).or.wrtRPmod(ng)) THEN 
          CALL mp_collect (ng, model, Mobs, IniVal,                     &
#   ifdef IS4DVAR
     &                     TLmodVal(1,Ipass))
#   else
     &                     TLmodVal)
#   endif
        END IF
#  endif
!!      IF (load_Zobs) THEN                ! HGA: I need figure out this
!!        CALL mp_collect (ng, model, Nobs(ng) IniVal, Zobs) 
!!      END IF
# endif
!
!-----------------------------------------------------------------------
!  Write out data into output 4DVAR NetCDF file.
!-----------------------------------------------------------------------
!
!  Nonlinear model or first guess (background) state at observation
!  locations.
!
        IF (OutThread.and.wrtNLmod(ng)) THEN 
# ifdef S4DVAR
          start(1)=NstrObs(ng)
          total(1)=Nobs(ng)
          start(2)=Irec
          total(2)=1
          status=nf_put_vara_TYPE(ncMODid(ng),modVid(idNLmo,ng),        &
     &                            start,total,NLmodVal(1,Irec))
# else
          start(1)=NstrObs(ng)
          total(1)=Nobs(ng)
          status=nf_put_vara_TYPE(ncMODid(ng),modVid(idNLmo,ng),        &
     &                            start,total,NLmodVal(Mstr))
# endif
          IF (status.ne.nf_noerr) then
            WRITE (stdout,10) TRIM(Vname(1,idNLmo)), TRIM(MODname(ng))
            exit_flag=3
            ioerror=status
            RETURN
          END IF
          haveNLmod(ng)=.TRUE.
        END IF

# ifdef TLM_OBS
!
!  Tangent linear model state increments at observation locations.
!
        IF (OutThread.and.(wrtTLmod(ng).or.wrtRPmod(ng))) THEN 
#  ifdef IS4DVAR
          start(1)=NstrObs(ng)
          total(1)=Nobs(ng)
          start(2)=Ipass
          total(2)=1
          status=nf_put_vara_TYPE(ncMODid(ng),modVid(idTLmo,ng),        &
     &                            start,total,TLmodVal(1,Ipass))
#  else
          start(1)=NstrObs(ng)
          total(1)=Nobs(ng)
          status=nf_put_vara_TYPE(ncMODid(ng),modVid(idTLmo,ng),        &
     &                            start,total,TLmodVal(Mstr))
#  endif
          IF (status.ne.nf_noerr) then
            WRITE (stdout,10) TRIM(Vname(1,idTLmo)), TRIM(MODname(ng))
            exit_flag=3
            ioerror=status
            RETURN
          END IF
          haveTLmod(ng)=.TRUE.
        END IF
# endif
# ifdef SOLVE3D
!
!  Write Z-location of observation in grid coordinates, if applicable.
!  This values are needed elsewhere when using the interpolation
!  weight matrix.  Recall that the depth of observations can be in
!  meters or grid coordinates.  Recall that since the model levels
!  evolve in time, the fractional level coordinate is unknow during
!  the processing of the observations.
!  
        IF (OutThread.and.load_Zobs) THEN
          start(1)=NstrObs(ng)
          total(1)=Nobs(ng)
          status=nf_put_vara_TYPE(ncOBSid(ng),obsVid(idObsZ,ng),        &
     &                            start,total,Zobs(Mstr))
          IF (status.ne.nf_noerr) then
            WRITE (stdout,10) TRIM(Vname(1,idObsZ)), TRIM(OBSname(ng))
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
# endif
        IF (wrtNLmod(ng)) THEN
# ifdef IS4DVAR
          string='Wrote background state at observation locations,  '
# else
          string='Wrote NLM state at observation locations,         '
# endif
# ifdef TLM_OBS
#  ifdef REPRESENTERS
        ELSE IF (wrtTLmod(ng)) THEN
          string='Wrote TLM state at observation locations,         '
        ELSE IF (wrtRPmod(ng)) THEN
          string='Wrote RPM state at observation locations,         '
#  else
        ELSE IF (wrtTLmod(ng)) THEN
          string='Wrote TLM increments at observation locations,    '
#  endif
# endif
        END IF
        IF (Master) THEN
          IF (wrtNLmod(ng).or.wrtTLmod(ng).or.wrtRPmod(ng)) THEN
             WRITE (stdout,30) TRIM(string), NstrObs(ng), NendObs(ng)
          END IF
        END IF
!
!-----------------------------------------------------------------------
!  Synchronize observations NetCDF file to disk.
!-----------------------------------------------------------------------
!
        IF (OutThread) THEN
          IF (load_Zobs) THEN
            status=nf_sync(ncOBSid(ng))
            IF (status.ne.nf_noerr) THEN
              WRITE (stdout,20)
              exit_flag=3
              ioerror=status
              RETURN
            END IF
          END IF
          IF (wrtNLmod(ng).or.wrtTLmod(ng).or.wrtRPmod(ng)) THEN
            status=nf_sync(ncMODid(ng))
            IF (status.ne.nf_noerr) THEN
              WRITE (stdout,20)
              exit_flag=3
              ioerror=status
              RETURN
            END IF
          END IF
        END IF
      END IF
!
  10  FORMAT (/,' OBS_WRITE - error while writing variable: ',a,/,      &
     &        11x,'into observation NetCDF: ',a)
  20  FORMAT (/,' OBS_WRITE - unable to synchronize observations',      &
     &        1x,'NetCDF file to disk.')
  30  FORMAT (1x,a,' datum = ',i7.7,' - ',i7.7,/)

      RETURN
      END SUBROUTINE obs_write
#else
      SUBROUTINE obs_write
      RETURN
      END SUBROUTINE obs_write
#endif
