#include "cppdefs.h"
#ifdef FILTERED_RST
      SUBROUTINE wrt_filt (ng, filterLevel)
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
!  This routine writes fields into filter restart NetCDF files.        !
!                                                                      !
!=======================================================================
!
      USE mod_param
      USE mod_parallel
      USE mod_filter
      USE mod_grid
      USE mod_iounits
      USE mod_mixing
      USE mod_ncparam
      USE mod_netcdf
      USE mod_ocean
      USE mod_scalars
      USE mod_stepping
!
      implicit none
!
!  Imported variable declarations.
!
      integer, intent(in) :: ng, filterLevel
!
!  Local variable declarations.
!
      integer :: LBi, UBi, LBj, UBj
      integer :: gfactor, gtype, i, itrc, status, ifile, varid

      integer :: nf_fwrite2d, nf_fwrite3d

      real(r8) :: scale
!
      LBi=LBOUND(GRID(ng)%h,DIM=1)
      UBi=UBOUND(GRID(ng)%h,DIM=1)
      LBj=LBOUND(GRID(ng)%h,DIM=2)
      UBj=UBOUND(GRID(ng)%h,DIM=2)
!
!-----------------------------------------------------------------------
!  Write out restart fields.
!-----------------------------------------------------------------------
!
      IF (exit_flag.ne.NoError) RETURN
!
!  Set grid type factor to write full (gfactor=1) fields or water
!  points (gfactor=-1) fields only.
!
# if defined WRITE_WATER && defined MASKING
        gfactor=-1
# else
        gfactor=1
# endif
!
!  Set time record index.
!
      tFILindx(ng)=filterLevel
      NrecFIL(ng)=NrecFIL(ng)+1
!
!  Write out model time (s).
!
      DO ifile=1,nfile
        IF (OutThread) THEN
          status=nf_inq_varid(ncFILid(ifile,ng), TRIM('filterLevel'),   &
     &                        varid)
          status=nf_put_var1_int(ncFILid(ifile,ng), varid,             &
     &                            tFILindx(ng), tFILindx(ng))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'filterLevel', tFILindx(ng)
            exit_flag=3
            ioerror=status
            RETURN
          END IF
          status=nf_inq_varid(ncFILid(ifile,ng), TRIM('ocean_time'),    &
     &                        varid)
          status=nf_put_var1_TYPE(ncFILid(ifile,ng), varid, 1,          &
     &                            time(ng))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'ocean_time', tFILindx(ng)
            exit_flag=3
            ioerror=status
            RETURN
          END IF
          status=nf_inq_varid(ncFILid(ifile,ng), TRIM('fcount'), varid)
          status=nf_put_var1_int(ncFILid(ifile,ng), varid,              &
     &                           tFILindx(ng), fcount(tFILindx(ng)) )
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,10) 'fcount', tFILindx(ng)
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END IF
      END DO
!
!  Write out free-surface (m)
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idFsur)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
# ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
# endif
     &                 FILTER(ng) % filzeta(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idFsur)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out 2D momentum component (m/s) in the XI-direction.
!
      scale=1.0_r8
      gtype=gfactor*u2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idUbar)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
# ifdef MASKING
     &                 GRID(ng) % umask(LBi,LBj),                       &
# endif
     &                 FILTER(ng) % filu2d(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idUbar)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out 2D momentum component (m/s) in the ETA-direction.
!
      scale=1.0_r8
      gtype=gfactor*v2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idVbar)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
# ifdef MASKING
     &                 GRID(ng) % vmask(LBi,LBj),                       &
# endif
     &                 FILTER(ng) % filv2d(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idVbar)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
# ifdef SOLVE3D
!
!  Write out 3D momentum component (m/s) in the XI-direction.
!
      scale=1.0_r8
      gtype=gfactor*u3dvar
      status=nf_inq_varid(ncFILid(2,ng), TRIM(Vname(1,idUvel)), varid)
      status=nf_fwrite3d(ng, iNLM, ncFILid(2,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, 1, N(ng), scale,             &
#  ifdef MASKING
     &                 GRID(ng) % umask(LBi,LBj),                       &
#  endif
     &                 FILTER(ng) % filu3d(LBi,LBj,1,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idUvel)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out 3D momentum component (m/s) in the ETA-direction.
!
      scale=1.0_r8
      gtype=gfactor*v3dvar
      status=nf_inq_varid(ncFILid(3,ng), TRIM(Vname(1,idVvel)), varid)
      status=nf_fwrite3d(ng, iNLM, ncFILid(3,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, 1, N(ng), scale,             &
#  ifdef MASKING
     &                 GRID(ng) % vmask(LBi,LBj),                       &
#  endif
     &                 FILTER(ng) % filv3d(LBi,LBj,1,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idVvel)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#  ifndef FILTRIM
!
!  Write out density anomaly.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_inq_varid(ncFILid(7,ng), TRIM(Vname(1,idDano)), varid)
      status=nf_fwrite3d(ng, iNLM, ncFILid(7,ng), filVid(idDano,ng),    &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, 1, N(ng), scale,             &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filrho(LBi,LBj,1,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idDano)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out tracer type variables.
!
      DO itrc=1,NT(ng)
        scale=1.0_r8
        gtype=gfactor*r3dvar
        status=nf_fwrite3d(ng, iNLM, ncFILid(8,ng), filTid(itrc,ng),    &
     &                   tFILindx(ng), gtype,                           &
     &                   LBi, UBi, LBj, UBj, 1, N(ng), scale,           &
#   ifdef MASKING
     &                   GRID(ng) % rmask(LBi,LBj),                     &
#   endif
     &                   FILTER(ng) % filt(LBi,LBj,1,itrc,tFILindx(ng)))
        IF (OutThread.and.(status.ne.nf_noerr)) THEN
          WRITE (stdout,10) TRIM(Vname(1,idTvar(itrc))), tFILindx(ng)
          exit_flag=3
          ioerror=status
          RETURN
        END IF
      END DO
!
!  Write out vertical (omega) velocity
!
      scale=1.0_r8
      gtype=gfactor*w3dvar
      status=nf_inq_varid(ncFILid(9,ng), TRIM(Vname(1,idOvel)), varid)
      status=nf_fwrite3d(ng, iNLM, ncFILid(9,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, 0, N(ng), scale,             &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filw3d(LBi,LBj,0,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idOvel)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#  endif
#  ifdef LMD_SKPP
!
!  Write out depth of surface boundary layer.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idHsbl)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filhsbl(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idHsbl)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#  endif
#  ifdef LMD_BKPP
!
!  Write out depth of bottom boundary layer.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idHbbl)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filhbbl(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idHbbl)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_AKV
!
!  Write out vertical viscosity coefficient.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_inq_varid(ncFILid(6,ng), TRIM(Vname(1,idVvis)), varid)
      status=nf_fwrite3d(ng, iNLM, ncFILid(6,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, 0, N(ng), scale,             &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filAKv(LBi,LBj,0,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idVvis)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_AKT
!
!  Write out vertical diffusion coefficient for potential temperature.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_inq_varid(ncFILid(4,ng), TRIM(Vname(1,idTdif)), varid)
      status=nf_fwrite3d(ng, iNLM, ncFILid(4,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, 0, N(ng), scale,             &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filAKt(LBi,LBj,0,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idTdif)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_AKS
!
!  Write out vertical diffusion coefficient for salinity.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_inq_varid(ncFILid(5,ng), TRIM(Vname(1,idSdif)), varid)
      status=nf_fwrite3d(ng, iNLM, ncFILid(5,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, 0, N(ng), scale,             &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filAKs(LBi,LBj,0,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idSdif)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#  endif
#  ifdef AVERAGES_FLUXES
!
!  Write out surface net heat flux.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idTsur(itemp))),  &
     &                    varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#   ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#   endif
     &                 FILTER(ng) % filstf(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idTsur(itemp))), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#   ifdef BULK_FLUXES
!
!  Write out latent heat flux.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idLhea)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#    ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#    endif
     &                 FILTER(ng) % fillhf(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idLhea)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out sensible heat flux.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idShea)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#    ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#    endif
     &                 FILTER(ng) % filshf(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idShea)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out longwave radiation flux.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idLrad)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#    ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#    endif
     &                 FILTER(ng) % fillrf(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idLrad)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#   endif
#   ifdef SHORTWAVE
!
!  Write out shortwave radiation flux.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idSrad)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#    ifdef MASKING
     &                 GRID(ng) % rmask(LBi,LBj),                       &
#    endif
     &                 FILTER(ng) % filsrf(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idSrad)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
#   endif
#  endif
# endif
# ifdef AVERAGES_FLUXES
!
!  Write out surface u-momentum stress.
!
      scale=1.0_r8
      gtype=gfactor*u2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idUsms)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#  ifdef MASKING
     &                 GRID(ng) % umask(LBi,LBj),                       &
#  endif
     &                 FILTER(ng) % filsus(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idUsms)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
!
!  Write out surface v-momentum stress.
!
      scale=1.0_r8
      gtype=gfactor*v2dvar
      status=nf_inq_varid(ncFILid(1,ng), TRIM(Vname(1,idVsms)), varid)
      status=nf_fwrite2d(ng, iNLM, ncFILid(1,ng), varid,                &
     &                 tFILindx(ng), gtype,                             &
     &                 LBi, UBi, LBj, UBj, scale,                       &
#  ifdef MASKING
     &                 GRID(ng) % vmask(LBi,LBj),                       &
#  endif
     &                 FILTER(ng) % filsvs(LBi,LBj,tFILindx(ng)))
      IF (OutThread.and.(status.ne.nf_noerr)) THEN
        WRITE (stdout,10) TRIM(Vname(1,idVsms)), tFILindx(ng)
        exit_flag=3
        ioerror=status
        RETURN
      END IF
# endif
!
!  Synchronize history NetCDF file to disk.
!
      IF (OutThread) THEN
        DO ifile=1,nfile
          status=nf_sync(ncFILid(ifile,ng))
          IF (status.ne.nf_noerr) THEN
            WRITE (stdout,20)
            exit_flag=3
            ioerror=status
            RETURN
          END IF
        END DO
        WRITE (stdout,30) tFILindx(ng)
      END IF
!
  10  FORMAT (/,' WRT_FILT  - error while writing variable: ',a,/,11x,  &
     &        'into filter NetCDF file for time record: ',i4)
  20  FORMAT (/,' WRT_FILT  - unable to synchronize filter NetCDF to ', &
     &        'disk.')
  30  FORMAT (6x,'WRT_FILT  - wrote filter fields into time ',          &
     &        'record =',t72,i7.7)
      RETURN
      END SUBROUTINE wrt_filt
#else
      SUBROUTINE wrt_filt
      RETURN
      END SUBROUTINE wrt_filt
#endif
