/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.PIVAPIException;
import com.activcard.java.lang.SystemAccess;
import interfaces.PIVReturnCodes;

public class PivApiWrapper
implements PIVReturnCodes {
    public PivApiWrapper() throws PIVAPIException {
        try {
            SystemAccess.getInstance().loadLibrary("aijnipiv");
        }
        catch (Exception exception) {
            System.out.println("JNIPIVAPI loadLibrary Exception in PivApiWrapper class");
            throw new PIVAPIException(32, "Native Dll access error Exception = " + exception.toString());
        }
    }

    public String getStringErrorCode(int n) {
        switch (n) {
            case 32: {
                return "PIV_UNABLE_TO_LOAD_WRAPPER";
            }
            case 0: {
                return "PIV_OK";
            }
            case 1: {
                return "PIV_CONNECTION_DESCRIPTION_MALFORMED";
            }
            case 2: {
                return "PIV_CONNECTION_FAILURE";
            }
            case 3: {
                return "PIV_CONNECTION_LOCKED";
            }
            case 5: {
                return "PIV_INVALID_CARD_HANDLE";
            }
            case 6: {
                return "PIV_CARD_APPLICATION_NOT_FOUND";
            }
            case 7: {
                return "PIV_AUTHENTICATOR_MALFORMED";
            }
            case 8: {
                return "PIV_AUTHENTICATION_FAILURE";
            }
            case 9: {
                return "PIV_INVALID_OID";
            }
            case 10: {
                return "PIV_DATA_OBJECT_NOT_FOUND";
            }
            case 11: {
                return "PIV_SECURITY_CONDITIONS_NOT_SATISFIED";
            }
            case 13: {
                return "PIV_INVALID_KEYREF_OR_ALGORITHM";
            }
            case 15: {
                return "PIV_INPUT_BYTES_MALFORMED";
            }
            case 16: {
                return "PIV_INSUFFICIENT_CARD_RESOURCE";
            }
            case 19: {
                return "PIV_UNSUPPORTED_CRYPTOGRAPHIC_MECHANISM";
            }
            case 22: {
                return "PIV_CARD_READER_ERROR";
            }
            case 20: {
                return "PIV_INSUFFICIENT_BUFFER";
            }
        }
        return "Unknown error";
    }

    public native long pivConnect(boolean var1, byte[] var2) throws PIVAPIException;

    public native void pivDisconnect(long var1) throws PIVAPIException;

    public native void pivLogIntoCardApplication(long var1, byte[] var3) throws PIVAPIException;

    public native byte[] pivSelectCardApplication(long var1, byte[] var3) throws PIVAPIException;

    public native void pivLogoutOfCardApplication(long var1) throws PIVAPIException;

    public native byte[] pivGetData(long var1, String var3) throws PIVAPIException;

    public native byte[] pivCrypt(long var1, byte var3, byte var4, byte[] var5) throws PIVAPIException;

    public native void pivPutData(long var1, String var3, byte[] var4) throws PIVAPIException;

    public native byte[] pivGenerateKeyPair(long var1, byte var3, byte var4) throws PIVAPIException;
}

