/*
 * Decompiled with CFR 0.152.
 */
package com.activcard.java.lang;

import com.activcard.java.lang.SystemAccess;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;

public class IESystem
extends SystemAccess {
    public IESystem() {
        SystemAccess.setDefault(this);
    }

    public void loadLibrary(String string) throws Exception {
        if (string == null) {
            throw new NullPointerException();
        }
        PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Exception(unsatisfiedLinkError.toString());
        }
    }

    public void loadLibrary(String string, String string2) throws Exception {
        if (string == null || string.length() == 0) {
            this.loadLibrary(string2);
        } else {
            if (string2 == null) {
                throw new NullPointerException();
            }
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            String string3 = string + System.mapLibraryName(string2);
            try {
                System.load(string3);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new Exception(unsatisfiedLinkError.toString());
            }
        }
    }

    public void enableLoadLibrary() {
        PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
    }

    public void activateSystemPermission() {
        PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
    }
}

