/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.prefs.PreferenceChangeListener;
import ucar.util.prefs.ui.PersistenceManager;

public class PersistentBean
implements PersistenceManager {
    private BeanMap beanMap;
    private boolean debugBean = false;
    static /* synthetic */ Class class$java$lang$Object;

    public PersistentBean(Object bean) {
        this.beanMap = new BeanMap(bean);
    }

    public Object getObject(String name) {
        return this.beanMap.getObject(name);
    }

    public void putObject(String name, Object value) {
        this.beanMap.putObject(name, value);
    }

    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
    }

    public String get(String key, String def) {
        Object value = this.getObject(key);
        return value == null ? def : value.toString();
    }

    public void put(String key, String value) {
        this.putObject(key, value);
    }

    public double getDouble(String key, double def) {
        Object value = this.getObject(key);
        return value == null ? def : ((Number)value).doubleValue();
    }

    public void putDouble(String key, double value) {
        this.putObject(key, new Double(value));
    }

    public boolean getBoolean(String key, boolean def) {
        Object value = this.getObject(key);
        return value == null ? def : (Boolean)value;
    }

    public void putBoolean(String key, boolean value) {
        this.putObject(key, new Boolean(value));
    }

    public int getInt(String key, int def) {
        Object value = this.getObject(key);
        return value == null ? def : ((Number)value).intValue();
    }

    public void putInt(String key, int value) {
        this.putObject(key, new Integer(value));
    }

    public long getLong(String key, long def) {
        Object value = this.getObject(key);
        return value == null ? def : ((Number)value).longValue();
    }

    public void putLong(String key, long value) {
        this.putObject(key, new Long(value));
    }

    public List getList(String key, List def) {
        Object value = this.getObject(key);
        return value == null ? def : (List)value;
    }

    public void putList(String key, List value) {
        this.putObject(key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PropertyMap {
        private static boolean debugBeanParser = false;
        private static boolean debugBeanParserDetail = false;
        private static HashMap parsers = new HashMap();
        private LinkedHashMap properties = new LinkedHashMap();

        static PropertyMap getParser(Class beanClass) {
            PropertyMap parser = (PropertyMap)parsers.get(beanClass);
            if (null == parser) {
                parser = new PropertyMap(beanClass);
                parsers.put(beanClass, parser);
            }
            return parser;
        }

        PropertyMap(Class beanClass) {
            int i;
            BeanInfo info = null;
            try {
                info = Introspector.getBeanInfo(beanClass, class$java$lang$Object == null ? (class$java$lang$Object = PersistentBean.class$("java.lang.Object")) : class$java$lang$Object);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            if (debugBeanParser) {
                System.out.println("Bean " + beanClass.getName());
            }
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (i = 0; i < pds.length; ++i) {
                PropertyDescriptor prop = pds[i];
                Class<?> propClass = prop.getPropertyType();
                if (prop.getReadMethod() == null) continue;
                this.properties.put(prop.getName(), prop);
                if (!debugBeanParser) continue;
                System.out.println(" read/write property " + prop.getName() + " " + propClass.getName() + " prim= " + propClass.isPrimitive());
            }
            if (debugBeanParserDetail) {
                System.out.println(" Properties:");
                for (i = 0; i < pds.length; ++i) {
                    String name = pds[i].getName();
                    Class<?> type = pds[i].getPropertyType();
                    Method rm = pds[i].getReadMethod();
                    Method wm = pds[i].getWriteMethod();
                    System.out.println("  " + name + " " + type.getName() + " read= " + rm + " write= " + wm + " " + pds[i].isPreferred());
                    System.out.println("     displayname= " + pds[i].getDisplayName());
                }
            }
        }

        Iterator getProperties() {
            return this.properties.values().iterator();
        }

        PropertyDescriptor findProperty(String name) {
            return (PropertyDescriptor)this.properties.get(name);
        }
    }

    private class ProxyProp {
        private PropertyDescriptor prop;
        private BeanMap nested;
        private String childrenName;

        ProxyProp(PropertyDescriptor prop, BeanMap nested, String childrenName) {
            this.prop = prop;
            this.nested = nested;
            this.childrenName = childrenName;
        }
    }

    private class BeanMap {
        private Object bean;
        private PropertyMap pmap;
        private HashMap beanMaps = new HashMap();
        private Object[] args = new Object[1];

        BeanMap(Object bean) {
            this.bean = bean;
            this.pmap = PropertyMap.getParser(bean.getClass());
        }

        private void checkExist(String name) {
            PropertyDescriptor prop = this.pmap.findProperty(name);
            if (prop != null) {
                return;
            }
            int pos = name.indexOf(".");
            if (pos < 0) {
                throw new IllegalArgumentException("PersistentBean: no property named " + name);
            }
            String parentName = name.substring(0, pos);
            String childrenName = name.substring(pos + 1);
            prop = this.pmap.findProperty(parentName);
            if (prop == null) {
                throw new IllegalArgumentException("PersistentBean: no property named " + parentName);
            }
            BeanMap nested = (BeanMap)this.beanMaps.get(parentName);
            if (nested == null) {
                Object bean = this.getObject(parentName);
                if (bean == null) {
                    bean = this.createObject(prop);
                    this.putObject(parentName, bean);
                }
                nested = new BeanMap(bean);
                this.beanMaps.put(parentName, nested);
            }
        }

        private ProxyProp getPropertyDescriptor(String name) {
            PropertyDescriptor prop = this.pmap.findProperty(name);
            if (prop != null) {
                return new ProxyProp(prop, null, null);
            }
            int pos = name.indexOf(".");
            if (pos < 0) {
                throw new IllegalArgumentException("PersistentBean: no property named " + name);
            }
            String parentName = name.substring(0, pos);
            String childrenName = name.substring(pos + 1);
            prop = this.pmap.findProperty(parentName);
            if (prop == null) {
                throw new IllegalArgumentException("PersistentBean: no property named " + parentName);
            }
            BeanMap nested = (BeanMap)this.beanMaps.get(parentName);
            if (nested == null) {
                Object bean = this.getObject(parentName);
                if (bean == null) {
                    bean = this.createObject(prop);
                    this.putObject(parentName, bean);
                }
                nested = new BeanMap(bean);
                this.beanMaps.put(parentName, nested);
            }
            return new ProxyProp(null, nested, childrenName);
        }

        private Object createObject(PropertyDescriptor prop) {
            Class<?> propClass = prop.getPropertyType();
            try {
                return propClass.newInstance();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                throw new IllegalArgumentException("PersistentBean error createObject: " + prop.getName() + " " + ee.getMessage());
            }
        }

        public Object getObject(String name) {
            ProxyProp proxy;
            if (PersistentBean.this.debugBean) {
                System.out.println("PersistentBean read " + name);
            }
            if ((proxy = this.getPropertyDescriptor(name)).prop == null) {
                return proxy.nested.getObject(proxy.childrenName);
            }
            PropertyDescriptor prop = proxy.prop;
            Object value = null;
            try {
                Method m = prop.getReadMethod();
                if (m == null) {
                    System.out.println("PersistentBean no read method for: " + name);
                    return null;
                }
                value = m.invoke(this.bean, null);
            }
            catch (InvocationTargetException ee) {
                System.out.println("PersistentBean error read: " + name + " " + ee.getCause());
                ee.getCause().printStackTrace();
            }
            catch (Exception ee) {
                System.out.println("PersistentBean error read: " + name + " " + ee);
                ee.printStackTrace();
            }
            return value;
        }

        public void putObject(String name, Object value) {
            ProxyProp proxy;
            if (PersistentBean.this.debugBean) {
                System.out.println("PersistentBean write " + name + " = " + value + " " + value.getClass().getName());
            }
            if ((proxy = this.getPropertyDescriptor(name)).prop == null) {
                proxy.nested.putObject(proxy.childrenName, value);
                return;
            }
            PropertyDescriptor prop = proxy.prop;
            this.args[0] = value;
            try {
                Method m = prop.getWriteMethod();
                if (m == null) {
                    System.out.println("PersistentBean no write method for: " + name);
                    return;
                }
                m.invoke(this.bean, this.args);
            }
            catch (InvocationTargetException ee) {
                System.out.println("PersistentBean error write: " + name + " " + ee.getCause());
                ee.getCause().printStackTrace();
            }
            catch (Exception ee) {
                System.out.println("PersistentBean error write: " + name + " " + ee);
                ee.printStackTrace();
            }
        }
    }
}

