/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.convert;

public abstract class Convert {
    protected static final int LO = 0;
    protected static final int HI = 1;
    protected int outputStyle = 0;
    protected double[] range = new double[]{-1.0, 1.0};
    protected String units = new String("");
    protected String[] recognizedUnits;

    public String getUnits() {
        return this.units;
    }

    public void setRange(double d, double d2) throws IllegalArgumentException {
        if (d2 < d) {
            System.out.println("Convert:setRange(" + d + "," + d2 + ") -- swapping lo and hi limits");
            this.range[0] = d2;
            this.range[1] = d;
        } else {
            this.range[0] = d;
            this.range[1] = d2;
        }
    }

    public double getRange(int n) {
        return this.range[n];
    }

    public double[] getRange() {
        double[] dArray = new double[]{this.range[0], this.range[1]};
        return dArray;
    }

    public void setUnits(String string) throws IllegalArgumentException {
        this.units = new String(this.unitTest(string));
    }

    public abstract double toDouble(String var1) throws IllegalArgumentException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Convert:range = [" + this.range[0] + ", " + this.range[1] + "]");
        return stringBuffer.toString();
    }

    public abstract String toString(double var1) throws IllegalArgumentException;

    public double getNearestValue(double d) {
        try {
            return this.rangeTest(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            d = d < this.range[0] ? this.range[0] : this.range[1];
            System.out.println("Convert:getNearestValue(" + d + "): " + illegalArgumentException + ", returning " + d);
            return d;
        }
    }

    public double getNearestValue(double d, int n) {
        try {
            return this.rangeTest(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Convert:getNearestValue(" + d + "," + n + "): " + illegalArgumentException + ", returning " + this.range[n]);
            return this.range[n];
        }
    }

    public double[] intersectRange(double d, double d2) throws IllegalArgumentException {
        double[] dArray = new double[]{this.range[0], this.range[1]};
        double[] dArray2 = new double[]{d, d2};
        if (d2 < d) {
            dArray2[0] = d2;
            dArray2[1] = d;
        }
        if (dArray2[0] > this.range[1]) {
            throw new IllegalArgumentException("incoming range [" + d + ", " + d2 + "] does not intersect range[" + this.range[0] + "," + this.range[1] + "].");
        }
        dArray[0] = dArray2[0] > this.range[0] ? dArray2[0] : this.range[0];
        if (dArray2[1] < this.range[0]) {
            throw new IllegalArgumentException("incoming range [" + d + ", " + d2 + "] does not intersect range[" + this.range[0] + "," + this.range[1] + "].");
        }
        dArray[1] = dArray2[1] < this.range[1] ? dArray2[1] : this.range[1];
        return dArray;
    }

    protected double rangeTest(double d) throws IllegalArgumentException {
        if (d < this.range[0] || d > this.range[1]) {
            throw new IllegalArgumentException("value [" + d + "] outside of range[" + this.range[0] + "," + this.range[1] + "].");
        }
        return d;
    }

    protected String unitTest(String string) throws IllegalArgumentException {
        String string2 = new String(string);
        string2 = string2.trim();
        string2 = string2.toLowerCase();
        int n = 1;
        while (n < this.recognizedUnits.length) {
            if (string2.equalsIgnoreCase(this.recognizedUnits[n])) {
                return string2;
            }
            ++n;
        }
        throw new IllegalArgumentException("Unit \"" + string2 + "\" not recognized.");
    }
}

