/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.convert;

import java.util.StringTokenizer;
import tmap_30.convert.Convert;

public class ConvertLongitude
extends Convert {
    public static final int M180_180 = 0;
    public static final int ZERO_360 = 1;
    public static final int E_W = 2;
    public static final int SPACE_E_W = 3;
    public static final int SPACE_EAST_WEST = 4;
    private String[] recognizedUnits = new String[]{"deg", "degrees"};

    public void setOutputStyle(int n) {
        this.outputStyle = n;
    }

    public void setRange(double d, double d2) throws IllegalArgumentException {
        double d3 = d;
        double d4 = d2;
        if (d3 > 0.0 && d4 > 360.0) {
            System.out.println("ConvertLongitude: setRange(" + d + ", " + d2 + ") subtracting 360 to fit within internal [-360:360] range.");
            d3 -= 360.0;
            d4 -= 360.0;
        } else if (d3 < -360.0 && d4 < 0.0) {
            System.out.println("ConvertLongitude: setRange(" + d + ", " + d2 + ") adding 360 to fit within internal [-360:360] range.");
            d3 += 360.0;
            d4 += 360.0;
        }
        if (d3 < -360.0 || d3 > 360.0) {
            d3 %= 360.0;
        }
        if (d4 < -360.0 || d4 > 360.0) {
            d4 %= 360.0;
        }
        if (Math.abs(d2 - d) > 360.0) {
            if (d3 < -180.0) {
                d3 += 360.0;
            }
            if (d4 < -180.0) {
                d4 += 360.0;
            }
            if (d3 > 180.0) {
                d3 -= 360.0;
            }
            if (d4 > 180.0) {
                d4 -= 360.0;
            }
        } else if (Math.abs(d2 - d) == 360.0 && d4 < d3) {
            this.range[0] = d4;
            this.range[1] = d3;
        }
        this.range[0] = d3;
        this.range[1] = d4;
    }

    public double toDouble(String string) throws IllegalArgumentException {
        double d = 0.0;
        int n = 1;
        String string2 = new String(string);
        string2 = string2.trim();
        if ((string2 = string2.toUpperCase()).endsWith("E")) {
            n = 1;
            string2 = string2.substring(0, string2.length() - 1).trim();
        } else if (string2.endsWith("W")) {
            n = -1;
            string2 = string2.substring(0, string2.length() - 1).trim();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " +-.0123456789", false);
        if (stringTokenizer.countTokens() > 0) {
            throw new IllegalArgumentException("Bad character in string: \"" + string + "\".");
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ", false);
        switch (stringTokenizer2.countTokens()) {
            case 1: {
                if (string2.length() > 4 && string2.indexOf(46) == -1) {
                    String string3 = string2.substring(0, string2.length() - 4);
                    String string4 = string2.substring(string2.length() - 4, string2.length() - 2);
                    String string5 = string2.substring(string2.length() - 2, string2.length());
                    try {
                        d = Double.valueOf(string3);
                        d += Double.valueOf(string4) / 60.0;
                        d += Double.valueOf(string5) / 3600.0;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(numberFormatException.toString());
                    }
                }
                try {
                    d = Double.valueOf(string2);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.toString());
                }
            }
            case 2: {
                String string6 = stringTokenizer2.nextToken();
                String string7 = stringTokenizer2.nextToken();
                try {
                    d = Double.valueOf(string6);
                    d += Double.valueOf(string7) / 60.0;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.toString());
                }
            }
            case 3: {
                String string8 = stringTokenizer2.nextToken();
                String string9 = stringTokenizer2.nextToken();
                String string10 = stringTokenizer2.nextToken();
                try {
                    d = Double.valueOf(string8);
                    d += Double.valueOf(string9) / 60.0;
                    d += Double.valueOf(string10) / 3600.0;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.toString());
                }
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        d *= (double)n;
        try {
            d = this.rangeTest(d);
        }
        finally {
            Object var12_20 = null;
        }
        return d;
    }

    public String toString(double d) {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            d = this.rangeTest(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("toString(" + d + "," + "): " + illegalArgumentException);
        }
        if (d < 0.0) {
            switch (this.outputStyle) {
                case 1: {
                    stringBuffer.append(d + 360.0);
                    break;
                }
                case 2: {
                    stringBuffer.append(-d);
                    stringBuffer.append("W");
                    break;
                }
                case 3: {
                    stringBuffer.append(-d);
                    stringBuffer.append(" W");
                    break;
                }
                case 4: {
                    stringBuffer.append(-d);
                    stringBuffer.append(" West");
                    break;
                }
                default: {
                    stringBuffer.append(d);
                    break;
                }
            }
        } else if (d > 180.0) {
            switch (this.outputStyle) {
                case 1: {
                    stringBuffer.append(d);
                    break;
                }
                case 2: {
                    stringBuffer.append(-(d -= 360.0));
                    stringBuffer.append("W");
                    break;
                }
                case 3: {
                    stringBuffer.append(-(d -= 360.0));
                    stringBuffer.append(" W");
                    break;
                }
                case 4: {
                    stringBuffer.append(-(d -= 360.0));
                    stringBuffer.append(" West");
                    break;
                }
                default: {
                    stringBuffer.append(d);
                    break;
                }
            }
        } else {
            switch (this.outputStyle) {
                case 1: {
                    stringBuffer.append(d);
                    break;
                }
                case 2: {
                    stringBuffer.append(d);
                    stringBuffer.append("E");
                    break;
                }
                case 3: {
                    stringBuffer.append(d);
                    stringBuffer.append(" E");
                    break;
                }
                case 4: {
                    stringBuffer.append(d);
                    stringBuffer.append(" East");
                    break;
                }
                default: {
                    stringBuffer.append(d);
                    break;
                }
            }
        }
        return stringBuffer.toString();
    }

    public double getNearestValue(double d) {
        try {
            return this.rangeTest(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("getNearestValue(" + d + "): " + illegalArgumentException);
            if (this.range[0] < this.range[1]) {
                if (d < this.range[0]) {
                    return this.range[0];
                }
                return this.range[1];
            }
            if (d > this.range[0]) {
                return this.range[0];
            }
            return this.range[1];
        }
    }

    public double[] intersectRange(double d, double d2) throws IllegalArgumentException {
        double d3 = d;
        double d4 = d2;
        double d5 = this.range[0];
        double d6 = this.range[1];
        double[] dArray = new double[]{d5, d6};
        if (d3 < -360.0 || d3 > 360.0) {
            d3 %= 360.0;
        }
        if (d4 < -360.0 || d4 > 360.0) {
            d4 %= 360.0;
        }
        if (Math.abs(d4 - d3) == 360.0) {
            return dArray;
        }
        if (Math.abs(d6 - d5) == 360.0) {
            try {
                dArray[0] = this.rangeTest(d3);
                dArray[1] = this.rangeTest(d4);
                return dArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("This should never happen! " + illegalArgumentException.toString());
            }
        }
        if (d3 > 180.0) {
            d3 -= 360.0;
        } else if (d3 < -180.0) {
            d3 += 360.0;
        }
        if (d4 > 180.0) {
            d4 -= 360.0;
        } else if (d4 < -180.0) {
            d4 += 360.0;
        }
        if (d5 > 180.0) {
            d5 -= 360.0;
        } else if (d5 < -180.0) {
            d5 += 360.0;
        }
        if (d6 > 180.0) {
            d6 -= 360.0;
        } else if (d6 < -180.0) {
            d6 += 360.0;
        }
        if (d6 < d5) {
            d6 += 360.0;
        }
        if (d4 < d3) {
            d4 += 360.0;
        }
        if (d3 > d6) {
            d3 -= 360.0;
            d4 -= 360.0;
        } else if (d4 < d5) {
            d3 += 360.0;
            d4 += 360.0;
        }
        if (d3 > d6 || d4 < d5) {
            throw new IllegalArgumentException("incoming range [" + d + ", " + d2 + "] does not intersect range[" + this.range[0] + "," + this.range[1] + "].");
        }
        if (d3 > d5) {
            try {
                dArray[0] = this.rangeTest(d3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("This should never happen! " + illegalArgumentException.toString());
            }
        } else {
            dArray[0] = this.range[0];
        }
        if (d4 < d6) {
            try {
                dArray[1] = this.rangeTest(d4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("This should never happen! " + illegalArgumentException.toString());
            }
        } else {
            dArray[1] = this.range[1];
        }
        return dArray;
    }

    protected double rangeTest(double d) throws IllegalArgumentException {
        double d2 = d;
        double d3 = d;
        double d4 = this.range[0];
        double d5 = this.range[1];
        boolean bl = false;
        if (d4 == d5) {
            bl = true;
        }
        if (d2 < -360.0 || d2 > 360.0) {
            d2 %= 360.0;
        }
        if (d3 < -360.0 || d3 > 360.0) {
            d3 %= 360.0;
        }
        if (d3 > 180.0) {
            d3 -= 360.0;
        } else if (d3 < -180.0) {
            d3 += 360.0;
        }
        if (d4 > 180.0) {
            d4 -= 360.0;
        } else if (d4 < -180.0) {
            d4 += 360.0;
        }
        if (d5 > 180.0) {
            d5 -= 360.0;
        } else if (d5 < -180.0) {
            d5 += 360.0;
        }
        if (d5 == d4 && !bl) {
            d5 += 360.0;
        }
        if (d5 < d4) {
            d5 += 360.0;
        }
        if (d3 < d4) {
            d3 += 360.0;
        }
        if (d3 < d4 || d3 > d5) {
            throw new IllegalArgumentException("value [" + d + "] outside of range[" + this.range[0] + "," + this.range[1] + "].");
        }
        if (this.range[1] < this.range[0]) {
            if (d2 < this.range[0] - 360.0) {
                d2 += 360.0;
            } else if (d2 > this.range[1] + 360.0) {
                d2 -= 360.0;
            }
        } else if (d2 < this.range[0]) {
            d2 += 360.0;
        } else if (d2 > this.range[1]) {
            d2 -= 360.0;
        }
        return d2;
    }

    public ConvertLongitude() {
        this.setRange(-180.0, 180.0);
    }

    public ConvertLongitude(int n) {
        this();
        this.outputStyle = n;
    }
}

