/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import tmap_30.map.MapGrid;

public abstract class MapRegion
extends Rectangle {
    public double user_X;
    public double user_Y;
    public MapGrid grid;
    protected Polygon sensitiveArea;
    protected Rectangle canvas_clipRect;
    protected Color color;
    public boolean visible = true;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        return stringBuffer.toString();
    }

    public MapGrid getGrid() {
        return this.grid;
    }

    public void setGrid(MapGrid mapGrid) {
        this.grid = mapGrid;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
        if (this.grid != null) {
            this.user_X = this.grid.pixelToUser_X(n);
            this.user_Y = this.grid.pixelToUser_Y(n2);
        } else {
            System.out.println("MapRegion.setLocation: grid = null");
        }
    }

    public void setUserLocation() {
        if (this.grid != null) {
            this.x = this.grid.userToPixel_X(this.user_X);
            this.y = this.grid.userToPixel_Y(this.user_Y);
        } else {
            System.out.println("MapRegion.setUserLocation(): grid = null");
        }
    }

    public void setUserLocation(double d, double d2) {
        this.user_X = d;
        this.user_Y = d2;
        if (this.grid != null) {
            this.x = this.grid.userToPixel_X(d);
            this.y = this.grid.userToPixel_Y(d2);
        } else {
            System.out.println("MapRegion.setUserLocation(x,y): grid = null");
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public abstract void draw(Graphics var1);

    public int mouseMove(int n, int n2) {
        return 0;
    }

    public void mouseDown(int n, int n2) {
    }

    public void mouseUp(int n, int n2) {
    }

    public MapRegion() {
    }

    public MapRegion(int n, int n2, Color color) {
        this.color = color;
        this.setLocation(n, n2);
    }

    public MapRegion(int n, int n2, Color color, MapGrid mapGrid) {
        this.color = color;
        this.grid = mapGrid;
        this.setLocation(n, n2);
    }

    public MapRegion(Rectangle rectangle, Color color, MapGrid mapGrid) {
        this(rectangle.x, rectangle.y, color, mapGrid);
    }

    public MapRegion(int n, int n2, int n3, int n4, Color color) {
        this(n, n2, color);
        this.width = n3;
        this.height = n4;
    }

    public MapRegion(int n, int n2, int n3, int n4, Color color, MapGrid mapGrid) {
        this.width = n3;
        this.height = n4;
        this.color = color;
        this.grid = mapGrid;
        this.setLocation(n, n2);
    }

    public MapRegion(double d, double d2, Color color) {
        this.color = color;
        this.setUserLocation(d, d2);
    }

    public MapRegion(double d, double d2, int n, int n2, Color color) {
        this(d, d2, color);
        this.width = n;
        this.height = n2;
    }

    public MapRegion(double d, double d2, Color color, MapGrid mapGrid) {
        this.color = color;
        this.grid = mapGrid;
        this.setUserLocation(d, d2);
    }

    public MapRegion(double d, double d2, int n, int n2, Color color, MapGrid mapGrid) {
        this.width = n;
        this.height = n2;
        this.color = color;
        this.grid = mapGrid;
        this.setUserLocation(d, d2);
    }
}

