/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import tmap_30.convert.Convert;
import tmap_30.convert.ConvertLength;
import tmap_30.convert.ConvertLongitude;
import tmap_30.map.MapConstants;
import tmap_30.map.MapGrid;
import tmap_30.map.ToolHandle;

public abstract class MapTool
extends Rectangle
implements MapConstants {
    static final int NW = 0;
    static final int N = 1;
    static final int NE = 2;
    static final int E = 3;
    static final int SE = 4;
    static final int S = 5;
    static final int SW = 6;
    static final int W = 7;
    static final int C = 8;
    boolean pan_down = false;
    boolean pan_down_fast = false;
    boolean pan_left = false;
    boolean pan_left_fast = false;
    boolean pan_right = false;
    boolean pan_right_fast = false;
    boolean pan_up = false;
    boolean pan_up_fast = false;
    protected boolean left_edge_scroll = true;
    protected boolean right_edge_scroll = true;
    protected boolean top_edge_scroll = true;
    protected boolean bottom_edge_scroll = true;
    public double[] user_X = new double[3];
    public double[] user_Y = new double[3];
    public double[] range_X = new double[2];
    public double[] range_Y = new double[2];
    public double delta_X = 0.0;
    public double delta_Y = 0.0;
    protected boolean drawHandles = false;
    protected boolean snap_X = false;
    protected boolean snap_Y = false;
    public boolean needsRange_X = true;
    public boolean needsRange_Y = true;
    public MapGrid grid;
    protected Rectangle boundingRect;
    protected Rectangle canvas_clipRect;
    protected Color color;
    public boolean visible = true;
    public boolean master = false;
    protected boolean active = false;
    protected ToolHandle[] handle;
    protected int numHandles = 9;
    protected int selectedHandle;
    protected int mouseDownHandle = 0;
    boolean snapMid_X = true;
    boolean snapMid_Y = true;
    int hw = 5;
    int hh = 5;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(this.numHandles + " handles");
        if (this.active) {
            stringBuffer.append(", tool is active");
        } else {
            stringBuffer.append(", tool is inactive");
        }
        stringBuffer.append(", selected handle = " + this.selectedHandle);
        return stringBuffer.toString();
    }

    public boolean is_active() {
        return this.active;
    }

    public void setSnapping(boolean bl, boolean bl2) {
        this.snap_X = bl;
        this.snap_Y = bl2;
    }

    public boolean getSnap_X() {
        return this.snap_X;
    }

    public boolean getSnap_Y() {
        return this.snap_Y;
    }

    public MapGrid getGrid() {
        return this.grid;
    }

    public void setGrid(MapGrid mapGrid) {
        this.grid = mapGrid;
    }

    public void setRange_X(double d, double d2) {
        this.range_X[0] = d;
        this.range_X[1] = d2;
    }

    public void setRange_Y(double d, double d2) {
        this.range_Y[0] = d;
        this.range_Y[1] = d2;
    }

    public void setDelta_X(double d) {
        this.delta_X = d;
    }

    public double getDelta_X() {
        return this.delta_X;
    }

    public void setDelta_Y(double d) {
        this.delta_Y = d;
    }

    public double getDelta_Y() {
        return this.delta_Y;
    }

    public void intersect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = super.intersection(rectangle);
        this.setBounds(rectangle2);
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.saveHandles();
    }

    public void setUserLocation(double d, double d2) {
        this.setLocation(this.grid.userToPixel_X(d), this.grid.userToPixel_Y(d2));
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.saveHandles();
    }

    public void setUserBounds(double d, double d2, double d3, double d4) {
        int n = 0;
        int n2 = 0;
        if (d4 < this.grid.domain_Y[0]) {
            d4 = this.grid.domain_Y[0];
        }
        if (d4 > this.grid.domain_Y[1]) {
            d4 = this.grid.domain_Y[1];
        }
        if (d3 < this.grid.domain_Y[0]) {
            d3 = this.grid.domain_Y[0];
        }
        if (d3 > this.grid.domain_Y[1]) {
            d3 = this.grid.domain_Y[1];
        }
        if (this.grid.modulo_X) {
            while (d < this.grid.domain_X[0]) {
                d += this.grid.x_factor;
            }
            while (d > this.grid.domain_X[1]) {
                d -= this.grid.x_factor;
            }
            while (d2 < this.grid.domain_X[0]) {
                d2 += this.grid.x_factor;
            }
            while (d2 > this.grid.domain_X[1]) {
                d2 -= this.grid.x_factor;
            }
        } else {
            if (d < this.grid.domain_X[0]) {
                d = this.grid.domain_X[0];
            }
            if (d > this.grid.domain_X[1]) {
                d = this.grid.domain_X[1];
            }
            if (d2 < this.grid.domain_X[0]) {
                d2 = this.grid.x_factor;
            }
            if (d2 > this.grid.domain_X[1]) {
                d2 = this.grid.domain_X[1];
            }
        }
        if (this.grid.x_type == 0 && this.needsRange_X && d == d2) {
            d2 = d + 360.0;
        }
        if (d2 < d) {
            if (this.grid.x_type != 0) {
                System.out.println("ERROR in MapTool.java:setUserBounds(): " + d2 + " < " + d);
            }
            n = this.grid.modulo_X ? (int)((this.grid.x_factor - (d - d2)) * ((double)(this.grid.imageRect.width - 1) / this.grid.x_factor)) : (int)((d - d2) * ((double)(this.grid.imageRect.width - 1) / this.grid.x_factor));
        } else {
            n = (int)((d2 - d) * ((double)(this.grid.imageRect.width - 1) / this.grid.x_factor));
        }
        n2 = this.grid.userToPixel_Y(d3) - this.grid.userToPixel_Y(d4);
        this.setBounds(this.grid.userToPixel_X(d), this.grid.userToPixel_Y(d4), n, n2);
        this.setUser_XY(d, d2, d3, d4);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        int n = 0;
        this.color = color;
        n = 0;
        while (n < this.numHandles) {
            this.handle[n].setColor(color);
            ++n;
        }
    }

    public Rectangle getRectangle() {
        Rectangle rectangle = new Rectangle(this.x, this.y, this.width, this.height);
        return rectangle;
    }

    protected void saveHandles() {
        this.handle = new ToolHandle[this.numHandles];
        this.handle[0] = new ToolHandle(this.x - this.hw / 2, this.y - this.hh / 2, this.hw, this.hh, this.color, 0);
        this.handle[1] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y - this.hh / 2, this.hw, this.hh, this.color, 1);
        this.handle[2] = new ToolHandle(this.x + this.width - this.hw / 2, this.y - this.hh / 2, this.hw, this.hh, this.color, 2);
        this.handle[3] = new ToolHandle(this.x + this.width - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 3);
        this.handle[4] = new ToolHandle(this.x + this.width - this.hw / 2, this.y + this.height - this.hh / 2, this.hw, this.hh, this.color, 4);
        this.handle[5] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height - this.hh / 2, this.hw, this.hh, this.color, 5);
        this.handle[6] = new ToolHandle(this.x - this.hw / 2, this.y + this.height - this.hh / 2, this.hw, this.hh, this.color, 6);
        this.handle[7] = new ToolHandle(this.x - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 7);
        this.handle[8] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 8);
    }

    public int check_for_zero_range() {
        int n;
        int n2 = 0;
        if (this.width == 0 && this.needsRange_X) {
            ++n2;
            if (this.snap_X) {
                n = this.grid.snap_X(this.x, 0, 1);
                if (n > this.grid.userToPixel_X(this.range_X[1])) {
                    n = this.grid.snap_X(this.x, 0, -1);
                }
                if (n < this.grid.userToPixel_X(this.range_X[0])) {
                    n = this.x;
                }
                if (n < this.x) {
                    this.width = this.x - n;
                    this.x = n;
                } else if (n > this.x) {
                    this.width = n - this.x;
                }
            } else if (this.x == this.boundingRect.x + this.boundingRect.width) {
                --this.x;
                this.width = 1;
            } else {
                this.width = 1;
            }
        }
        if (this.height == 0 && this.needsRange_Y) {
            n2 += 2;
            if (this.snap_Y) {
                n = this.grid.snap_Y(this.y, 0, 1);
                if (n < this.grid.userToPixel_Y(this.range_Y[1])) {
                    n = this.grid.snap_Y(this.y, 0, -1);
                }
                if (n > this.grid.userToPixel_Y(this.range_Y[0])) {
                    n = this.y;
                }
                if (n < this.y) {
                    this.height = this.y - n;
                    this.y = n;
                } else if (n > this.y) {
                    this.height = n - this.y;
                }
            } else if (this.y == this.boundingRect.y + this.boundingRect.height) {
                --this.y;
                this.height = 1;
            } else {
                this.height = 1;
            }
        }
        return n2;
    }

    public void applyClipRect(Rectangle rectangle) {
        this.applyClipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void applyClipRect(int n, int n2, int n3, int n4) {
        this.canvas_clipRect = new Rectangle(n, n2, n3, n4);
        int n5 = this.grid.userToPixel_X(this.range_X[0]);
        int n6 = this.grid.userToPixel_X(this.range_X[1]);
        int n7 = this.grid.userToPixel_Y(this.range_Y[1]);
        int n8 = this.grid.userToPixel_Y(this.range_Y[0]);
        int n9 = n;
        int n10 = n + n3;
        int n11 = n2;
        int n12 = n2 + n4;
        int n13 = n9;
        int n14 = n10;
        if (!this.grid.modulo_X) {
            if (n9 > n5) {
                n13 = n9;
                this.left_edge_scroll = true;
            } else {
                n13 = n5;
                this.left_edge_scroll = false;
            }
            if (n10 < n6) {
                n14 = n10;
                this.right_edge_scroll = true;
            } else {
                n14 = n6;
                this.right_edge_scroll = false;
            }
        } else if (Math.abs(this.range_X[1] - this.range_X[0]) < Math.abs(this.grid.domain_X[1] - this.grid.domain_X[0])) {
            if (n9 > n5) {
                n13 = n9;
                this.left_edge_scroll = true;
            } else {
                n13 = n5;
                this.left_edge_scroll = false;
            }
            if (n10 < n6) {
                n14 = n10;
                this.right_edge_scroll = true;
            } else {
                n14 = n6;
                this.right_edge_scroll = false;
            }
            if (this.range_X[1] - this.range_X[0] < 0.0 || n6 < n5) {
                if (n13 > n10) {
                    n13 = n9;
                    this.left_edge_scroll = true;
                }
                if (n14 < n9) {
                    n14 = n10;
                    this.right_edge_scroll = true;
                }
            }
        } else {
            n13 = n9;
            this.left_edge_scroll = true;
            n14 = n10;
            this.right_edge_scroll = true;
        }
        int n15 = n11;
        int n16 = n12;
        if (n11 > n7) {
            n15 = n11;
            this.top_edge_scroll = true;
        } else {
            n15 = n7;
            this.top_edge_scroll = false;
        }
        if (n12 < n8) {
            n16 = n12;
            this.bottom_edge_scroll = true;
        } else {
            n16 = n8;
            this.bottom_edge_scroll = false;
        }
        int n17 = n14 - n13;
        int n18 = n16 - n15;
        this.boundingRect = new Rectangle(n13, n15, n17, n18);
    }

    public void handle_reshape(int n, int n2) {
        boolean bl = false;
        if (this.snap_X) {
            if ((n = this.grid.snap_X(n, 0)) > this.boundingRect.x + this.boundingRect.width) {
                n = this.grid.snap_X(n, 0, -1);
            } else if (n < this.boundingRect.x) {
                n = this.grid.snap_X(n, 0, 1);
            }
        }
        if (n > this.x + this.width) {
            switch (this.selectedHandle) {
                case 2: 
                case 3: 
                case 4: {
                    this.width = n - this.x;
                    break;
                }
                case 0: 
                case 6: 
                case 7: {
                    bl = true;
                    this.x += this.width;
                    this.width = n - this.x;
                    break;
                }
            }
        } else if (n < this.x) {
            switch (this.selectedHandle) {
                case 2: 
                case 3: 
                case 4: {
                    bl = true;
                    this.width = this.x - n;
                    this.x = n;
                    break;
                }
                case 0: 
                case 6: 
                case 7: {
                    this.width += this.x - n;
                    this.x = n;
                    break;
                }
            }
        } else {
            switch (this.selectedHandle) {
                case 2: 
                case 3: 
                case 4: {
                    this.width = n - this.x;
                    break;
                }
                case 0: 
                case 6: 
                case 7: {
                    this.width += this.x - n;
                    this.x = n;
                    break;
                }
            }
        }
        if (bl) {
            if (this.selectedHandle == 2) {
                this.selectedHandle = 0;
            } else if (this.selectedHandle == 3) {
                this.selectedHandle = 7;
            } else if (this.selectedHandle == 4) {
                this.selectedHandle = 6;
            } else if (this.selectedHandle == 0) {
                this.selectedHandle = 2;
            } else if (this.selectedHandle == 7) {
                this.selectedHandle = 3;
            } else if (this.selectedHandle == 6) {
                this.selectedHandle = 4;
            }
            bl = false;
        }
        if (this.snap_Y) {
            if ((n2 = this.grid.snap_Y(n2, 0)) > this.boundingRect.y + this.boundingRect.height) {
                n2 = this.grid.snap_Y(n2, 0, 1);
            } else if (n2 < this.boundingRect.y) {
                n2 = this.grid.snap_Y(n2, 0, -1);
            }
        }
        if (n2 > this.y + this.height) {
            switch (this.selectedHandle) {
                case 0: 
                case 1: 
                case 2: {
                    bl = true;
                    this.y += this.height;
                    this.height = n2 - this.y;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.height = n2 - this.y;
                    break;
                }
            }
        } else if (n2 < this.y) {
            switch (this.selectedHandle) {
                case 0: 
                case 1: 
                case 2: {
                    this.height += this.y - n2;
                    this.y = n2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    bl = true;
                    this.height = this.y - n2;
                    this.y = n2;
                    break;
                }
            }
        } else {
            switch (this.selectedHandle) {
                case 0: 
                case 1: 
                case 2: {
                    this.height += this.y - n2;
                    this.y = n2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.height = n2 - this.y;
                    break;
                }
            }
        }
        if (bl) {
            if (this.selectedHandle == 0) {
                this.selectedHandle = 6;
            } else if (this.selectedHandle == 1) {
                this.selectedHandle = 5;
            } else if (this.selectedHandle == 2) {
                this.selectedHandle = 4;
            } else if (this.selectedHandle == 6) {
                this.selectedHandle = 0;
            } else if (this.selectedHandle == 5) {
                this.selectedHandle = 1;
            } else if (this.selectedHandle == 4) {
                this.selectedHandle = 2;
            }
            bl = false;
        }
    }

    public void setUser_XY() {
        this.setUser_X();
        this.setUser_Y();
    }

    public void setUser_XY(double d, double d2, double d3, double d4) {
        this.setUser_X(d, d2);
        this.setUser_Y(d3, d4);
    }

    public void setUser_X() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Convert convert = new ConvertLongitude();
        if (this.grid.x_type != 0) {
            convert = new ConvertLength();
        }
        this.user_X[0] = this.grid.pixelToUser_X(this.x);
        this.user_X[1] = this.grid.pixelToUser_X(this.x + this.width);
        this.user_X[2] = this.grid.pixelToUser_X(this.x + this.width / 2 + 1);
        if (this.snap_X) {
            this.user_X[0] = this.grid.snapUser_X(this.user_X[0], 0, 0);
            this.user_X[1] = this.grid.snapUser_X(this.user_X[1], 0, 0);
            this.user_X[2] = this.grid.snapUser_X(this.user_X[2], 0, 0);
        }
        convert.setRange(this.range_X[0], this.range_X[1]);
        this.user_X[0] = convert.getNearestValue(this.user_X[0], 0);
        this.user_X[1] = convert.getNearestValue(this.user_X[1], 1);
        if (this.grid.modulo_X && this.grid.x_type == 0 && this.user_X[1] == this.user_X[0] && this.width > 0) {
            this.user_X[1] = this.user_X[0] + (this.grid.domain_X[1] - this.grid.domain_X[0]);
        }
        d = this.user_X[0];
        d2 = this.user_X[1];
        if (this.grid.modulo_X && this.grid.x_type == 0) {
            if (d < 0.0) {
                d += 360.0;
            }
            if (d2 < 0.0) {
                d2 += 360.0;
            }
            if (d2 < d) {
                d2 += 360.0;
            }
        }
        if (this.grid.rangeToPixels_X(d3 = d2 - d) < this.width / 2) {
            this.user_X[1] = this.user_X[0] + (this.grid.domain_X[1] - this.grid.domain_X[0]);
        }
    }

    public void setUser_Y() {
        this.user_Y[1] = this.grid.pixelToUser_Y(this.y);
        this.user_Y[0] = this.grid.pixelToUser_Y(this.y + this.height);
        this.user_Y[2] = this.grid.pixelToUser_Y(this.y + this.height / 2 + 1);
        if (this.snap_Y) {
            this.user_Y[0] = this.grid.snapUser_Y(this.user_Y[0], 0);
            this.user_Y[1] = this.grid.snapUser_Y(this.user_Y[1], 0);
            this.user_Y[2] = this.grid.snapUser_Y(this.user_Y[2], 0);
        }
        if (this.user_Y[0] < this.range_Y[0]) {
            this.user_Y[0] = this.range_Y[0];
        }
        if (this.user_Y[1] > this.range_Y[1]) {
            this.user_Y[1] = this.range_Y[1];
        }
    }

    public void setUser_X(double d, double d2) {
        Convert convert = new ConvertLongitude();
        if (this.grid.x_type != 0) {
            convert = new ConvertLength();
        }
        this.user_X[0] = d;
        this.user_X[1] = d2;
        if (d2 >= d) {
            this.user_X[2] = d + (d2 - d) / 2.0;
        } else if (this.grid.x_type != 0) {
            System.out.println("ERROR in set_user_values: non-modulo_X and hi(" + d2 + ") < lo (" + d + ")");
        } else {
            this.user_X[2] = d + (d2 + 360.0 - d) / 2.0;
        }
        convert.setRange(this.range_X[0], this.range_X[1]);
        this.user_X[0] = convert.getNearestValue(this.user_X[0]);
        this.user_X[1] = convert.getNearestValue(this.user_X[1]);
        this.user_X[2] = convert.getNearestValue(this.user_X[2]);
    }

    public void setUser_Y(double d, double d2) {
        this.user_Y[0] = d;
        this.user_Y[1] = d2;
        this.user_Y[2] = d + (d2 - d) / 2.0;
    }

    public void adjustWidthHeight() {
    }

    public abstract void draw(Graphics var1);

    public int mouseMove(int n, int n2) {
        int n3 = 0;
        n3 = 0;
        while (n3 < this.numHandles) {
            if (this.handle[n3].contains(n, n2) && this.handle[n3].get_type() == 8) {
                return 13;
            }
            ++n3;
        }
        return 0;
    }

    public void mouseDown(int n, int n2) {
        int n3 = 0;
        n3 = 0;
        while (n3 < this.numHandles) {
            if (this.handle[n3].contains(n, n2)) {
                this.active = true;
                this.selectedHandle = this.handle[n3].get_type();
                if (this.selectedHandle == 8) break;
            }
            ++n3;
        }
        this.applyClipRect(this.canvas_clipRect);
        if (!this.active) {
            if (this.snap_X) {
                n = this.grid.snap_X(n, 0);
            }
            if (this.snap_Y) {
                n2 = this.grid.snap_Y(n2, 0);
            }
            n = n < this.boundingRect.x ? this.boundingRect.x : n;
            n = n > this.boundingRect.x + this.boundingRect.width ? this.boundingRect.x + this.boundingRect.width : n;
            n2 = n2 < this.boundingRect.y ? this.boundingRect.y : n2;
            n2 = n2 > this.boundingRect.y + this.boundingRect.height ? this.boundingRect.y + this.boundingRect.height : n2;
            this.x = n;
            this.y = n2;
            this.width = 0;
            this.height = 0;
            this.active = true;
            this.selectedHandle = this.mouseDownHandle;
            this.saveHandles();
        }
    }

    public void mouseDrag(int n, int n2) {
        if (this.active) {
            this.applyClipRect(this.canvas_clipRect);
            n = n < this.boundingRect.x ? this.boundingRect.x : n;
            n = n > this.boundingRect.x + this.boundingRect.width ? this.boundingRect.x + this.boundingRect.width : n;
            n2 = n2 < this.boundingRect.y ? this.boundingRect.y : n2;
            int n3 = n2 = n2 > this.boundingRect.y + this.boundingRect.height ? this.boundingRect.y + this.boundingRect.height : n2;
            if (this.selectedHandle == 8) {
                this.bump_against_sides(n, n2);
            } else {
                this.handle_reshape(n, n2);
            }
            this.saveHandles();
            this.setUser_XY();
        }
    }

    public void mouseUp(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        double d = 0.0;
        if (this.active) {
            if (this.selectedHandle == 8) {
                this.applyClipRect(this.canvas_clipRect);
                this.adjustWidthHeight();
                if (this.x < this.boundingRect.x) {
                    this.x = this.boundingRect.x;
                } else if (this.x > this.boundingRect.x + this.boundingRect.width) {
                    this.x = this.boundingRect.x + this.boundingRect.width - this.width;
                }
                if (this.y < this.boundingRect.y) {
                    this.y = this.boundingRect.y;
                } else if (this.y > this.boundingRect.y + this.boundingRect.height) {
                    this.y = this.boundingRect.y + this.boundingRect.height - this.height;
                }
                if (this.snap_X) {
                    d = this.grid.pixelToUser_X(this.x + this.width) - this.grid.pixelToUser_X(this.x);
                    if ((int)(d / this.grid.delta_X) % 2 == 1 && this.snapMid_X) {
                        n3 = n = this.grid.snap_X(n, 1);
                        while (n + this.width / 2 > this.boundingRect.x + this.boundingRect.width) {
                            n = this.grid.snap_X(--n3, 1);
                        }
                        while (n - this.width / 2 < this.boundingRect.x) {
                            n = this.grid.snap_X(++n3, 1);
                        }
                        this.x = n - this.width / 2;
                    } else {
                        n3 = n = this.grid.snap_X(n, 0);
                        while (n + this.width / 2 > this.boundingRect.x + this.boundingRect.width) {
                            n = this.grid.snap_X(--n3, 0);
                        }
                        while (n - this.width / 2 < this.boundingRect.x) {
                            n = this.grid.snap_X(++n3, 0);
                        }
                        this.x = n - this.width / 2;
                    }
                }
                if (this.snap_Y) {
                    d = this.grid.pixelToUser_Y(this.y + this.height) - this.grid.pixelToUser_Y(this.y);
                    if ((int)((d = Math.abs(d)) / this.grid.delta_Y) % 2 == 1 && this.snapMid_Y) {
                        n3 = n2 = this.grid.snap_Y(n2, 1);
                        while (n2 + this.height / 2 > this.boundingRect.y + this.boundingRect.height) {
                            n2 = this.grid.snap_Y(--n3, 1);
                        }
                        while (n2 - this.height / 2 < this.boundingRect.y) {
                            n2 = this.grid.snap_Y(++n3, 1);
                        }
                        this.y = n2 - this.height / 2;
                    } else {
                        n3 = n2 = this.grid.snap_Y(n2, 0);
                        while (n2 + this.height / 2 > this.boundingRect.y + this.boundingRect.height) {
                            n2 = this.grid.snap_Y(--n3, 0);
                        }
                        while (n2 - this.height / 2 < this.boundingRect.y) {
                            n2 = this.grid.snap_Y(++n3, 0);
                        }
                        this.y = n2 - this.height / 2;
                    }
                }
            }
            this.check_for_zero_range();
            this.active = false;
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.pan_up = false;
            this.pan_down = false;
            this.pan_up_fast = false;
            this.pan_down_fast = false;
            this.saveHandles();
            this.setUser_XY();
        }
    }

    public void bump_against_sides(int n, int n2) {
        double d = 0.0;
        if (this.snap_X) {
            d = this.grid.pixelToUser_X(this.x + this.width) - this.grid.pixelToUser_X(this.x);
            n = (int)(d / this.grid.delta_X) % 2 == 1 && this.snapMid_X ? this.grid.snap_X(n, 1) : this.grid.snap_X(n, 0);
        }
        if (this.snap_Y) {
            d = this.grid.pixelToUser_Y(this.y + this.height) - this.grid.pixelToUser_Y(this.y);
            n2 = (int)((d = Math.abs(d)) / this.grid.delta_Y) % 2 == 1 && this.snapMid_Y ? this.grid.snap_Y(n2, 1) : this.grid.snap_Y(n2, 0);
        }
        if (n - this.width / 2 < this.boundingRect.x) {
            this.pan_right = false;
            this.pan_right_fast = false;
            if (this.left_edge_scroll) {
                this.pan_left = true;
                this.pan_left_fast = n < this.boundingRect.x + 2;
            } else {
                this.pan_left = false;
                this.pan_left_fast = false;
            }
            this.x = this.boundingRect.x;
        } else if (n - this.width / 2 + this.width > this.boundingRect.x + this.boundingRect.width) {
            this.pan_left = false;
            this.pan_left_fast = false;
            if (this.right_edge_scroll) {
                this.pan_right = true;
                this.pan_right_fast = n > this.boundingRect.x + this.boundingRect.width - 2;
            } else {
                this.pan_right = false;
                this.pan_right_fast = false;
            }
            this.x = this.boundingRect.x + this.boundingRect.width - this.width;
        } else {
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.x = n - this.width / 2;
        }
        if (n2 - this.height / 2 < this.boundingRect.y) {
            this.pan_down = false;
            this.pan_down_fast = false;
            if (this.top_edge_scroll) {
                this.pan_up = true;
                this.pan_up_fast = n2 < this.boundingRect.y + 2;
            } else {
                this.pan_up = false;
                this.pan_up_fast = false;
            }
            this.y = this.boundingRect.y;
        } else if (n2 - this.height / 2 + this.height > this.boundingRect.y + this.boundingRect.height) {
            this.pan_up = false;
            this.pan_up_fast = false;
            if (this.bottom_edge_scroll) {
                this.pan_down = true;
                this.pan_down_fast = n2 > this.boundingRect.y + this.boundingRect.height - 2;
            } else {
                this.pan_down = false;
                this.pan_down = false;
            }
            this.y = this.boundingRect.y + this.boundingRect.height - this.height;
        } else {
            this.pan_down = false;
            this.pan_up = false;
            this.pan_down_fast = false;
            this.pan_up_fast = false;
            this.y = n2 - this.height / 2;
        }
    }

    public MapTool() {
    }

    public MapTool(int n, int n2, int n3, int n4, Color color) {
        this.setBounds(n, n2, n3, n4);
        this.setColor(color);
    }

    public MapTool(Rectangle rectangle, Color color) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }

    public MapTool(int n, int n2, Color color) {
        this(0, 0, n, n2, color);
    }

    public MapTool(Point point, Dimension dimension, Color color) {
        this(point.x, point.y, dimension.width, dimension.height, color);
    }

    public MapTool(Point point, Color color) {
        this(point.x, point.y, 0, 0, color);
    }

    public MapTool(Dimension dimension, Color color) {
        this(0, 0, dimension.width, dimension.height, color);
    }
}

