/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import tmap_30.map.MapTool;
import tmap_30.map.ToolHandle;

public class PTTool
extends MapTool {
    public void draw(Graphics graphics) {
        if (this.visible) {
            int n = 0;
            graphics.setColor(this.color);
            graphics.drawLine(this.x + this.width / 2, this.y + this.height / 2 - this.hh, this.x + this.width / 2, this.y + this.height / 2 + this.hh);
            graphics.drawLine(this.x + this.width / 2 - this.hw, this.y + this.height / 2, this.x + this.width / 2 + this.hw, this.y + this.height / 2);
            if (this.drawHandles) {
                n = 0;
                while (n < this.numHandles) {
                    this.handle[n].draw(graphics);
                    ++n;
                }
            }
        }
    }

    protected void saveHandles() {
        this.handle = new ToolHandle[this.numHandles];
        this.handle[0] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 8);
    }

    public void adjustWidthHeight() {
        if (this.x + this.width / 2 < this.boundingRect.x) {
            this.width = 0;
            this.x = this.boundingRect.x;
        } else if (this.x < this.boundingRect.x) {
            this.width = 2 * (this.x + this.width / 2 - this.boundingRect.x);
            this.x = this.boundingRect.x;
        } else if (this.x + this.width / 2 > this.boundingRect.x + this.boundingRect.width) {
            this.width = 0;
            this.x = this.boundingRect.x + this.boundingRect.width;
        } else if (this.x + this.width > this.boundingRect.x + this.boundingRect.width) {
            this.width = 2 * (this.boundingRect.x + this.boundingRect.width - (this.x + this.width / 2));
            this.x = this.boundingRect.x + this.boundingRect.width - this.width;
        }
        if (this.y + this.height / 2 < this.boundingRect.y) {
            this.height = 0;
            this.y = this.boundingRect.y;
        } else if (this.y < this.boundingRect.y) {
            this.height = 2 * (this.y + this.height / 2 - this.boundingRect.y);
            this.y = this.boundingRect.y;
        } else if (this.y + this.height / 2 > this.boundingRect.y + this.boundingRect.height) {
            this.height = 0;
            this.y = this.boundingRect.y + this.boundingRect.height;
        } else if (this.y + this.height > this.boundingRect.y + this.boundingRect.height) {
            this.height = 2 * (this.boundingRect.y + this.boundingRect.height - (this.y + this.height / 2));
            this.y = this.boundingRect.y + this.boundingRect.height - this.height;
        }
    }

    public void bump_against_sides(int n, int n2) {
        if (n < this.boundingRect.x + this.hw / 2) {
            this.pan_right = false;
            this.pan_right_fast = false;
            if (this.left_edge_scroll) {
                this.pan_left = true;
                this.pan_left_fast = n == this.boundingRect.x;
            } else {
                this.pan_left = false;
                this.pan_left_fast = false;
            }
            this.x = this.boundingRect.x;
            this.width = 0;
        } else if (n > this.boundingRect.x + this.boundingRect.width - this.hw / 2) {
            this.pan_left = false;
            this.pan_left_fast = false;
            if (this.right_edge_scroll) {
                this.pan_right = true;
                this.pan_right_fast = n == this.boundingRect.x + this.boundingRect.width;
            } else {
                this.pan_right = false;
                this.pan_right_fast = false;
            }
            this.x = this.boundingRect.x + this.boundingRect.width;
            this.width = 0;
        } else {
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.x = n - this.width / 2;
        }
        if (n2 < this.boundingRect.y + this.hh / 2) {
            this.pan_down = false;
            this.pan_down_fast = false;
            if (this.top_edge_scroll) {
                this.pan_up = true;
                this.pan_up_fast = n2 == this.boundingRect.y;
            } else {
                this.pan_up = false;
                this.pan_up_fast = false;
            }
            this.y = this.boundingRect.y;
            this.height = 0;
        } else if (n2 > this.boundingRect.y + this.boundingRect.height - this.hh / 2) {
            this.pan_up = false;
            this.pan_up_fast = false;
            if (this.bottom_edge_scroll) {
                this.pan_down = true;
                this.pan_down_fast = n2 == this.boundingRect.y + this.boundingRect.height;
            } else {
                this.pan_down = false;
                this.pan_down = false;
            }
            this.y = this.boundingRect.y + this.boundingRect.height;
            this.height = 0;
        } else {
            this.pan_down = false;
            this.pan_up = false;
            this.pan_down_fast = false;
            this.pan_up_fast = false;
            this.y = n2 - this.height / 2;
        }
    }

    public void mouseUp(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        double d = 0.0;
        if (this.active && (this.range_X[0] != this.range_X[1] || this.range_Y[0] != this.range_Y[1])) {
            super.mouseUp(n, n2);
        }
    }

    public int mouseMove(int n, int n2) {
        if (this.range_X[0] != this.range_X[1] || this.range_Y[0] != this.range_Y[1]) {
            return super.mouseMove(n, n2);
        }
        return 0;
    }

    public void mouseDown(int n, int n2) {
        if (this.range_X[0] != this.range_X[1] || this.range_Y[0] != this.range_Y[1]) {
            super.mouseDown(n, n2);
        }
    }

    public PTTool(int n, int n2, int n3, int n4, Color color) {
        this.numHandles = 1;
        this.mouseDownHandle = 8;
        this.snapMid_X = false;
        this.snapMid_Y = false;
        this.needsRange_X = false;
        this.needsRange_Y = false;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.color = color;
        this.saveHandles();
    }

    public PTTool(Rectangle rectangle, Color color) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }
}

