/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import tmap_30.map.MapTool;
import tmap_30.map.ToolHandle;

public class XnormalTool
extends MapTool {
    public void draw(Graphics graphics) {
        if (this.visible) {
            int n = 0;
            graphics.setColor(this.color);
            graphics.drawLine(this.x, this.y + this.height / 2, this.x + this.width, this.y + this.height / 2);
            if (this.drawHandles) {
                n = 0;
                while (n < this.numHandles) {
                    this.handle[n].draw(graphics);
                    ++n;
                }
            }
        }
    }

    protected void saveHandles() {
        this.handle = new ToolHandle[this.numHandles];
        this.handle[0] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 8);
    }

    public void adjustWidthHeight() {
        if (this.y + this.height / 2 < this.boundingRect.y) {
            this.height = 0;
            this.y = this.boundingRect.y;
        } else if (this.y < this.boundingRect.y) {
            this.height = 2 * (this.y + this.height / 2 - this.boundingRect.y);
            this.y = this.boundingRect.y;
        } else if (this.y + this.height / 2 > this.boundingRect.y + this.boundingRect.height) {
            this.height = 0;
            this.y = this.boundingRect.y + this.boundingRect.height;
        } else if (this.y + this.height > this.boundingRect.y + this.boundingRect.height) {
            this.height = 2 * (this.boundingRect.y + this.boundingRect.height - (this.y + this.height / 2));
            this.y = this.boundingRect.y + this.boundingRect.height - this.height;
        }
    }

    public void bump_against_sides(int n, int n2) {
        if (n2 < this.boundingRect.y + this.hh / 2) {
            this.pan_down = false;
            this.pan_down_fast = false;
            if (this.top_edge_scroll) {
                this.pan_up = true;
                this.pan_up_fast = n2 == this.boundingRect.y;
            } else {
                this.pan_up = false;
                this.pan_up_fast = false;
            }
            this.y = this.boundingRect.y;
            this.height = 0;
        } else if (n2 > this.boundingRect.y + this.boundingRect.height - this.hh / 2) {
            this.pan_up = false;
            this.pan_up_fast = false;
            if (this.bottom_edge_scroll) {
                this.pan_down = true;
                this.pan_down_fast = n2 == this.boundingRect.y + this.boundingRect.height;
            } else {
                this.pan_down = false;
                this.pan_down = false;
            }
            this.y = this.boundingRect.y + this.boundingRect.height;
            this.height = 0;
        } else {
            this.pan_down = false;
            this.pan_up = false;
            this.pan_down_fast = false;
            this.pan_up_fast = false;
            this.y = n2 - this.height / 2;
        }
    }

    public void mouseDown(int n, int n2) {
        int n3 = 0;
        n3 = 0;
        while (n3 < this.numHandles) {
            if (this.handle[n3].contains(n, n2)) {
                this.active = true;
                this.selectedHandle = this.handle[n3].get_type();
                if (this.selectedHandle == 8) break;
            }
            ++n3;
        }
    }

    public void mouseUp(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        double d = 0.0;
        if (this.active) {
            this.adjustWidthHeight();
            if (this.x < this.boundingRect.x) {
                this.x = this.boundingRect.x;
            } else if (this.x > this.boundingRect.x + this.boundingRect.width) {
                this.x = this.boundingRect.x + this.boundingRect.width - this.width;
            }
            if (this.y < this.boundingRect.y) {
                this.y = this.boundingRect.y;
            } else if (this.y > this.boundingRect.y + this.boundingRect.height) {
                this.y = this.boundingRect.y + this.boundingRect.height - this.height;
            }
            if (this.snap_X) {
                // empty if block
            }
            if (this.snap_Y) {
                d = this.grid.pixelToUser_Y(this.y + this.height) - this.grid.pixelToUser_Y(this.y);
                if ((int)((d = Math.abs(d)) / this.grid.delta_Y) % 2 == 1 && this.snapMid_Y) {
                    n3 = n2 = this.grid.snap_Y(n2, 1);
                    while (n2 + this.height / 2 > this.boundingRect.y + this.boundingRect.height) {
                        n2 = this.grid.snap_Y(--n3, 1);
                    }
                    while (n2 - this.height / 2 < this.boundingRect.y) {
                        n2 = this.grid.snap_Y(++n3, 1);
                    }
                    this.y = n2 - this.height / 2;
                } else {
                    n3 = n2 = this.grid.snap_Y(n2, 0);
                    while (n2 + this.height / 2 > this.boundingRect.y + this.boundingRect.height) {
                        n2 = this.grid.snap_Y(--n3, 0);
                    }
                    while (n2 - this.height / 2 < this.boundingRect.y) {
                        n2 = this.grid.snap_Y(++n3, 0);
                    }
                    this.y = n2 - this.height / 2;
                }
            }
            this.check_for_zero_range();
            this.active = false;
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.pan_up = false;
            this.pan_down = false;
            this.pan_up_fast = false;
            this.pan_down_fast = false;
            this.saveHandles();
            this.setUser_XY();
        }
    }

    public XnormalTool(int n, int n2, int n3, int n4, Color color) {
        this.numHandles = 1;
        this.mouseDownHandle = 8;
        this.snapMid_Y = false;
        this.needsRange_Y = false;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.color = color;
        this.saveHandles();
    }

    public XnormalTool(Rectangle rectangle, Color color) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }
}

