/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import tmap_30.map.MapTool;
import tmap_30.map.ToolHandle;

public class YTool
extends MapTool {
    public void draw(Graphics graphics) {
        if (this.visible) {
            int n = 0;
            graphics.setColor(this.color);
            graphics.drawLine(this.x + this.width / 2, this.y, this.x + this.width / 2, this.y + this.height);
            if (this.drawHandles) {
                n = 0;
                while (n < this.numHandles) {
                    this.handle[n].draw(graphics);
                    ++n;
                }
            }
        }
    }

    public void adjustWidthHeight() {
        if (this.x + this.width / 2 < this.boundingRect.x) {
            this.width = 0;
            this.x = this.boundingRect.x;
        } else if (this.x < this.boundingRect.x) {
            this.width = 2 * (this.x + this.width / 2 - this.boundingRect.x);
            this.x = this.boundingRect.x;
        } else if (this.x + this.width / 2 > this.boundingRect.x + this.boundingRect.width) {
            this.width = 0;
            this.x = this.boundingRect.x + this.boundingRect.width;
        } else if (this.x + this.width > this.boundingRect.x + this.boundingRect.width) {
            this.width = 2 * (this.boundingRect.x + this.boundingRect.width - (this.x + this.width / 2));
            this.x = this.boundingRect.x + this.boundingRect.width - this.width;
        }
    }

    protected void saveHandles() {
        this.handle = new ToolHandle[this.numHandles];
        this.handle[0] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y - this.hh / 2, this.hw, this.hh, this.color, 1);
        this.handle[1] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 8);
        this.handle[2] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height - this.hh / 2, this.hw, this.hh, this.color, 5);
    }

    public void bump_against_sides(int n, int n2) {
        if (n < this.boundingRect.x + this.hw / 2) {
            this.pan_right = false;
            this.pan_right_fast = false;
            if (this.left_edge_scroll) {
                this.pan_left = true;
                this.pan_left_fast = n == this.boundingRect.x;
            } else {
                this.pan_left = false;
                this.pan_left_fast = false;
            }
            this.x = this.boundingRect.x;
            this.width = 0;
        } else if (n > this.boundingRect.x + this.boundingRect.width - this.hw / 2) {
            this.pan_left = false;
            this.pan_left_fast = false;
            if (this.right_edge_scroll) {
                this.pan_right = true;
                this.pan_right_fast = n == this.boundingRect.x + this.boundingRect.width;
            } else {
                this.pan_right = false;
                this.pan_right_fast = false;
            }
            this.x = this.boundingRect.x + this.boundingRect.width;
            this.width = 0;
        } else {
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.x = n - this.width / 2;
        }
        if (n2 - this.height / 2 < this.boundingRect.y) {
            this.pan_down = false;
            this.pan_down_fast = false;
            if (this.top_edge_scroll) {
                this.pan_up = true;
                this.pan_up_fast = n2 < this.boundingRect.y + 2;
            } else {
                this.pan_up = false;
                this.pan_up_fast = false;
            }
            this.y = this.boundingRect.y;
        } else if (n2 - this.height / 2 + this.height > this.boundingRect.y + this.boundingRect.height) {
            this.pan_up = false;
            this.pan_up_fast = false;
            if (this.bottom_edge_scroll) {
                this.pan_down = true;
                this.pan_down_fast = n2 > this.boundingRect.y + this.boundingRect.height - 2;
            } else {
                this.pan_down = false;
                this.pan_down = false;
            }
            this.y = this.boundingRect.y + this.boundingRect.height - this.height;
        } else {
            this.pan_down = false;
            this.pan_up = false;
            this.pan_down_fast = false;
            this.pan_up_fast = false;
            this.y = n2 - this.height / 2;
        }
    }

    public YTool(int n, int n2, int n3, int n4, Color color) {
        this.numHandles = 3;
        this.mouseDownHandle = 5;
        this.snapMid_X = false;
        this.needsRange_X = false;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.color = color;
        this.saveHandles();
    }

    public YTool(Rectangle rectangle, Color color) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }
}

