/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import tmap_30.map.MapTool;
import tmap_30.map.ToolHandle;

public class YnormalTool
extends MapTool {
    public void draw(Graphics graphics) {
        if (this.visible) {
            int n = 0;
            graphics.setColor(this.color);
            graphics.drawLine(this.x + this.width / 2, this.y, this.x + this.width / 2, this.y + this.height);
            if (this.drawHandles) {
                n = 0;
                while (n < this.numHandles) {
                    this.handle[n].draw(graphics);
                    ++n;
                }
            }
        }
    }

    public void adjustWidthHeight() {
        if (this.x + this.width / 2 < this.boundingRect.x) {
            this.width = 0;
            this.x = this.boundingRect.x;
        } else if (this.x < this.boundingRect.x) {
            this.width = 2 * (this.x + this.width / 2 - this.boundingRect.x);
            this.x = this.boundingRect.x;
        } else if (this.x + this.width / 2 > this.boundingRect.x + this.boundingRect.width) {
            this.width = 0;
            this.x = this.boundingRect.x + this.boundingRect.width;
        } else if (this.x + this.width > this.boundingRect.x + this.boundingRect.width) {
            this.width = 2 * (this.boundingRect.x + this.boundingRect.width - (this.x + this.width / 2));
            this.x = this.boundingRect.x + this.boundingRect.width - this.width;
        }
    }

    protected void saveHandles() {
        this.handle = new ToolHandle[this.numHandles];
        this.handle[0] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 8);
    }

    public void bump_against_sides(int n, int n2) {
        if (n < this.boundingRect.x + this.hw / 2) {
            this.pan_right = false;
            this.pan_right_fast = false;
            if (this.left_edge_scroll) {
                this.pan_left = true;
                this.pan_left_fast = n == this.boundingRect.x;
            } else {
                this.pan_left = false;
                this.pan_left_fast = false;
            }
            this.x = this.boundingRect.x;
            this.width = 0;
        } else if (n > this.boundingRect.x + this.boundingRect.width - this.hw / 2) {
            this.pan_left = false;
            this.pan_left_fast = false;
            if (this.right_edge_scroll) {
                this.pan_right = true;
                this.pan_right_fast = n == this.boundingRect.x + this.boundingRect.width;
            } else {
                this.pan_right = false;
                this.pan_right_fast = false;
            }
            this.x = this.boundingRect.x + this.boundingRect.width;
            this.width = 0;
        } else {
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.x = n - this.width / 2;
        }
    }

    public void mouseDown(int n, int n2) {
        int n3 = 0;
        n3 = 0;
        while (n3 < this.numHandles) {
            if (this.handle[n3].contains(n, n2)) {
                this.active = true;
                this.selectedHandle = this.handle[n3].get_type();
                if (this.selectedHandle == 8) break;
            }
            ++n3;
        }
    }

    public void mouseUp(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        double d = 0.0;
        if (this.active) {
            this.adjustWidthHeight();
            if (this.x < this.boundingRect.x) {
                this.x = this.boundingRect.x;
            } else if (this.x > this.boundingRect.x + this.boundingRect.width) {
                this.x = this.boundingRect.x + this.boundingRect.width - this.width;
            }
            if (this.y < this.boundingRect.y) {
                this.y = this.boundingRect.y;
            } else if (this.y > this.boundingRect.y + this.boundingRect.height) {
                this.y = this.boundingRect.y + this.boundingRect.height - this.height;
            }
            if (this.snap_X) {
                d = this.grid.pixelToUser_X(this.x + this.width) - this.grid.pixelToUser_X(this.x);
                if ((int)(d / this.grid.delta_X) % 2 == 1 && this.snapMid_X) {
                    n3 = n = this.grid.snap_X(n, 1);
                    while (n + this.width / 2 > this.boundingRect.x + this.boundingRect.width) {
                        n = this.grid.snap_X(--n3, 1);
                    }
                    while (n - this.width / 2 < this.boundingRect.x) {
                        n = this.grid.snap_X(++n3, 1);
                    }
                    this.x = n - this.width / 2;
                } else {
                    n3 = n = this.grid.snap_X(n, 0);
                    while (n + this.width / 2 > this.boundingRect.x + this.boundingRect.width) {
                        n = this.grid.snap_X(--n3, 0);
                    }
                    while (n - this.width / 2 < this.boundingRect.x) {
                        n = this.grid.snap_X(++n3, 0);
                    }
                    this.x = n - this.width / 2;
                }
            }
            if (this.snap_Y) {
                // empty if block
            }
            this.check_for_zero_range();
            this.active = false;
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.pan_up = false;
            this.pan_down = false;
            this.pan_up_fast = false;
            this.pan_down_fast = false;
            this.saveHandles();
            this.setUser_XY();
        }
    }

    public YnormalTool(int n, int n2, int n3, int n4, Color color) {
        this.numHandles = 1;
        this.mouseDownHandle = 8;
        this.snapMid_X = false;
        this.needsRange_X = false;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.color = color;
        this.saveHandles();
    }

    public YnormalTool(Rectangle rectangle, Color color) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }
}

