/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.test;

import opendap.dap.DAP2Exception;
import opendap.dap.DefaultFactory;
import opendap.dap.Server.CEEvaluator;
import opendap.dap.Server.ClauseFactory;
import opendap.dap.Server.ServerDDS;
import opendap.dap.parser.ExprParser;
import opendap.dap.parser.ExprParserTokenManager;
import opendap.dap.parser.ParseException;
import opendap.dap.parser.SimpleCharStream;
import opendap.dap.parser.Token;
import opendap.util.Getopts;
import opendap.util.InvalidSwitch;

public class expr_test {
    private static final String prompt = "expr-test: ";

    private static void usage() {
        System.err.println("usage: expr-test [s] [p]");
        System.err.println(" s: Test the scanner.");
        System.err.println(" p: Test the parser; reads from stdin and prints the");
        System.err.println("    internal structure to stdout.");
    }

    public static void main(String[] args) {
        boolean parser_test = false;
        boolean scanner_test = false;
        try {
            Getopts opts = new Getopts("sp", args);
            if (opts.getSwitch((Character)new Character((char)'p')).set) {
                parser_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'s')).set) {
                scanner_test = true;
            }
        }
        catch (InvalidSwitch e) {
            expr_test.usage();
            System.exit(1);
        }
        if (!parser_test && !scanner_test) {
            expr_test.usage();
            System.exit(1);
        }
        if (scanner_test) {
            expr_test.test_scanner();
        }
        if (parser_test) {
            expr_test.test_parser();
        }
    }

    private static void test_scanner() {
        SimpleCharStream jj_input_stream = new SimpleCharStream(System.in, 1, 1);
        ExprParserTokenManager token_source = new ExprParserTokenManager(jj_input_stream);
        System.out.print(prompt);
        System.out.flush();
        while (true) {
            Token tok = token_source.getNextToken();
            if (tok.kind == 0) break;
            switch (tok.kind) {
                case 5: {
                    System.out.println("Equal");
                    break;
                }
                case 6: {
                    System.out.println("Not equal");
                    break;
                }
                case 7: {
                    System.out.println("Greater than");
                    break;
                }
                case 8: {
                    System.out.println("Greater than or equal");
                    break;
                }
                case 9: {
                    System.out.println("Less than");
                    break;
                }
                case 10: {
                    System.out.println("Less than or equal");
                    break;
                }
                case 11: {
                    System.out.println("Regular expression");
                    break;
                }
                case 12: {
                    System.out.println("Left Bracket");
                    break;
                }
                case 13: {
                    System.out.println("Right Bracket");
                    break;
                }
                case 14: {
                    System.out.println("Colon");
                    break;
                }
                case 15: {
                    System.out.println("Comma");
                    break;
                }
                case 16: {
                    System.out.println("Ampersand");
                    break;
                }
                case 17: {
                    System.out.println("Left Parenthesis");
                    break;
                }
                case 18: {
                    System.out.println("Right Parenthesis");
                    break;
                }
                case 19: {
                    System.out.println("Left Brace");
                    break;
                }
                case 20: {
                    System.out.println("Right Brace");
                    break;
                }
                case 22: {
                    System.out.println("WORD: " + tok.image);
                    break;
                }
                default: {
                    System.out.println("Error: Unrecognized input");
                }
            }
            System.out.print(prompt);
            System.out.flush();
        }
    }

    private static void test_parser() {
        ExprParser expr = new ExprParser(System.in);
        try {
            DefaultFactory factory = new DefaultFactory();
            ServerDDS dds = new ServerDDS("ThisIsATestDDS", factory);
            CEEvaluator ceEval = new CEEvaluator(dds);
            expr.constraint_expression(ceEval, factory, new ClauseFactory());
            System.out.println("Status from parser: 1");
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
            System.out.println("Status from parser: 0");
        }
        catch (DAP2Exception de) {
            System.out.println(de.getMessage());
            System.out.println("Status from parser: 0");
        }
    }
}

